/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.datastorage.temporal.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DisplayExpression
implements Serializable {
    private static final String VAR_ESCAPE = "$";
    private static final String VAR_START = "{";
    private static final String VAR_END = "}";
    private static final String VAR_DEFAULT = ":";
    public static final String PLACEHOLDER_START = "${";
    public static final String PLACEHOLDER_END = "}";
    public static final String PLACEHOLDER_DEFAULT_DELIMITER = ":";
    private static final String PLACEHOLDER_REGEX = "\\$\\{(.+?)(:.*)?}";
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(.+?)(:.*)?}");
    private String value;

    public DisplayExpression(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map<String, String> getPlaceholders() {
        if (this.value == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(this.value);
        while (matcher.find()) {
            placeholders.put(matcher.group(1), matcher.group(2) == null ? "" : matcher.group(2).substring(":".length()));
        }
        return placeholders;
    }

    public static DisplayExpression ofField(String field) {
        if (field == null) {
            return null;
        }
        return new DisplayExpression(DisplayExpression.toPlaceholder(field));
    }

    public static DisplayExpression ofFields(String ... field) {
        if (field == null) {
            return null;
        }
        String expression = Stream.of(field).map(DisplayExpression::toPlaceholder).collect(Collectors.joining(" "));
        return new DisplayExpression(expression);
    }

    public static String toPlaceholder(String field) {
        return field == null ? null : PLACEHOLDER_START + field + "}";
    }

    public static String toPlaceholder(String field, String defaultValue) {
        return field == null ? null : PLACEHOLDER_START + field + ":" + defaultValue + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplayExpression that = (DisplayExpression)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        return "DisplayExpression{value='" + this.value + '\'' + '}';
    }
}

