/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.dao;

import java.io.Serializable;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.Transactional;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.api.Sorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.i_novus.platform.datastorage.temporal.enums.DiffReturnTypeEnum;
import ru.i_novus.platform.datastorage.temporal.enums.DiffStatusEnum;
import ru.i_novus.platform.datastorage.temporal.enums.ReferenceDisplayType;
import ru.i_novus.platform.datastorage.temporal.model.DataDifference;
import ru.i_novus.platform.datastorage.temporal.model.Field;
import ru.i_novus.platform.datastorage.temporal.model.FieldValue;
import ru.i_novus.platform.datastorage.temporal.model.Reference;
import ru.i_novus.platform.datastorage.temporal.model.criteria.CompareDataCriteria;
import ru.i_novus.platform.datastorage.temporal.model.criteria.FieldSearchCriteria;
import ru.i_novus.platform.datastorage.temporal.model.criteria.SearchTypeEnum;
import ru.i_novus.platform.datastorage.temporal.model.criteria.StorageCopyRequest;
import ru.i_novus.platform.datastorage.temporal.model.criteria.StorageDataCriteria;
import ru.i_novus.platform.datastorage.temporal.model.value.DiffRowValue;
import ru.i_novus.platform.datastorage.temporal.model.value.ReferenceFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.RowValue;
import ru.i_novus.platform.datastorage.temporal.model.value.TreeFieldValue;
import ru.i_novus.platform.datastorage.temporal.util.CollectionUtils;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.DataDao;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.QueryConstants;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.QueryWithParams;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.StorageConstants;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.BooleanField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.DateField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.FieldValuePartEnum;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.FloatField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.IntegerField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.ReferenceField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.StringField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.TreeField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.CompareUtil;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.QueryUtil;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StorageUtils;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StringUtils;

public class DataDaoImpl
implements DataDao {
    private static final Logger logger = LoggerFactory.getLogger(DataDaoImpl.class);
    private static final LocalDateTime PG_MAX_TIMESTAMP = LocalDateTime.of(294276, 12, 31, 23, 59);
    private static final Pattern SEARCH_DATE_PATTERN = Pattern.compile("([0-9]{2})\\.([0-9]{2})\\.([0-9]{4})");
    private final EntityManager entityManager;

    public DataDaoImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public List<RowValue> getData(StorageDataCriteria criteria) {
        String storageCode = criteria.getStorageCode();
        String schemaName = this.getStorageCodeSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        List<Field> fields = this.makeOutputFields(criteria, schemaName);
        EnumSet<FieldValuePartEnum> valueParts = EnumSet.allOf(FieldValuePartEnum.class);
        String sqlFields = QueryUtil.toSelectedFields("d", fields, valueParts);
        String sqlFormat = "SELECT %1$s \n  FROM %2$s as %3$s ";
        String sql = String.format("SELECT %1$s \n  FROM %2$s as %3$s ", sqlFields, StorageUtils.escapeTableName(schemaName, tableName), "d");
        QueryWithParams queryWithParams = new QueryWithParams(sql);
        QueryWithParams where = this.getCriteriaWhereClause(criteria, "d");
        if (!StringUtils.isNullOrEmpty(where.getSql())) {
            queryWithParams.concat(" WHERE ");
            queryWithParams.concat(where);
        }
        queryWithParams.concat(this.sortingsToOrderBy(criteria, "d", schemaName));
        Query query = queryWithParams.createQuery(this.entityManager);
        if (criteria.hasPageAndSize()) {
            query.setFirstResult(criteria.getOffset()).setMaxResults(criteria.getSize());
        }
        List list = query.getResultList();
        return this.makeResultRowValues(list, fields, valueParts, criteria, schemaName);
    }

    protected List<Field> makeOutputFields(StorageDataCriteria criteria, String schemaName) {
        ArrayList<Field> fields = new ArrayList<Field>(criteria.getFields());
        fields.add(0, new IntegerField("SYS_RECORDID"));
        if (!QueryUtil.hasField("SYS_HASH", fields)) {
            fields.add(1, new StringField("SYS_HASH"));
        }
        return fields;
    }

    protected List<RowValue> makeResultRowValues(List<Object> list, List<Field> fields, Set<FieldValuePartEnum> valueParts, StorageDataCriteria criteria, String schemaName) {
        return !CollectionUtils.isNullOrEmpty(list) ? QueryUtil.toRowValues(fields, valueParts, list) : Collections.emptyList();
    }

    @Override
    public BigInteger getDataCount(StorageDataCriteria criteria) {
        String storageCode = criteria.getStorageCode();
        String schemaName = this.getStorageCodeSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String sqlFormat = "  FROM %s as %s\n";
        String sql = "SELECT count(*) \n" + String.format("  FROM %s as %s\n", StorageUtils.escapeTableName(schemaName, tableName), "d");
        QueryWithParams queryWithParams = new QueryWithParams(sql);
        QueryWithParams where = this.getCriteriaWhereClause(criteria, "d");
        if (!StringUtils.isNullOrEmpty(where.getSql())) {
            queryWithParams.concat(" WHERE ");
            queryWithParams.concat(where);
        }
        return (BigInteger)queryWithParams.createQuery(this.entityManager).getSingleResult();
    }

    @Override
    public boolean hasData(String storageCode) {
        StorageDataCriteria criteria = new StorageDataCriteria(storageCode, null, null, Collections.emptyList(), Collections.emptySet(), null);
        criteria.setCount(Integer.valueOf(1));
        criteria.setPage(1);
        criteria.setSize(1);
        List<RowValue> data = this.getData(criteria);
        return !CollectionUtils.isNullOrEmpty(data);
    }

    @Override
    public RowValue getRowData(String storageCode, List<String> fieldNames, Object systemId) {
        String schemaName = this.getStorageCodeSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        List<Field> fields = this.columnDataTypesToFields(this.getColumnDataTypes(storageCode), fieldNames);
        EnumSet<FieldValuePartEnum> valueParts = EnumSet.allOf(FieldValuePartEnum.class);
        String sqlFields = QueryUtil.toSelectedFields(null, fields, valueParts);
        String sql = String.format(" SELECT %1$s FROM %2$s.%3$s WHERE %4$s = %5$s ", sqlFields, schemaName, StringUtils.addDoubleQuotes(tableName), StringUtils.addDoubleQuotes("SYS_RECORDID"), "?");
        List list = this.entityManager.createNativeQuery(sql).setParameter(1, systemId).getResultList();
        if (CollectionUtils.isNullOrEmpty((Collection)list)) {
            return null;
        }
        RowValue row = QueryUtil.toRowValues(fields, valueParts, list).get(0);
        row.setSystemId(systemId);
        return row;
    }

    @Override
    public List<RowValue> getRowData(String storageCode, List<String> fieldNames, List<Object> systemIds) {
        String schemaName = this.getStorageCodeSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        List<Field> fields = this.columnDataTypesToFields(this.getColumnDataTypes(storageCode), fieldNames);
        EnumSet<FieldValuePartEnum> valueParts = EnumSet.allOf(FieldValuePartEnum.class);
        String sqlFields = QueryUtil.toSelectedFields(null, fields, valueParts);
        String sql = String.format(" SELECT %1$s FROM %2$s.%3$s WHERE %4$s = %5$s ", sqlFields, schemaName, StringUtils.addDoubleQuotes(tableName), StringUtils.addDoubleQuotes("SYS_RECORDID"), String.format("ANY(%s\\:\\:bigint[])", "?"));
        Query query = this.entityManager.createNativeQuery(sql);
        query.setParameter(1, (Object)QueryUtil.valuesToDbArray(systemIds));
        List list = query.getResultList();
        return !CollectionUtils.isNullOrEmpty((Collection)list) ? QueryUtil.toRowValues(fields, valueParts, list) : Collections.emptyList();
    }

    private List<Field> columnDataTypesToFields(Map<String, String> dataTypes, List<String> fieldNames) {
        ArrayList<Field> fields = new ArrayList<Field>(fieldNames.size());
        fields.add(new IntegerField("SYS_RECORDID"));
        fields.add(new StringField("SYS_HASH"));
        for (Map.Entry<String, String> entry : dataTypes.entrySet()) {
            String fieldName = entry.getKey();
            if (!fieldNames.contains(fieldName)) continue;
            fields.add(QueryUtil.getField(fieldName, entry.getValue()));
        }
        return fields;
    }

    @Override
    public List<String> findExistentHashes(String storageCode, LocalDateTime bdate, LocalDateTime edate, List<String> hashList) {
        String sqlFormat = "SELECT %1$s \n  FROM %2$s as %3$s ";
        String sql = String.format("SELECT %1$s \n  FROM %2$s as %3$s ", StringUtils.addDoubleQuotes("SYS_HASH"), StorageUtils.escapeStorageTableName(storageCode), "d") + " WHERE true \n";
        QueryWithParams queryWithParams = new QueryWithParams(sql);
        queryWithParams.concat(this.getWhereByDates(bdate, edate, "d"));
        queryWithParams.concat(this.getWhereByHashList(hashList, "d"));
        return queryWithParams.createQuery(this.entityManager).getResultList();
    }

    @Override
    public boolean storageStructureEquals(String storageCode1, String storageCode2) {
        Map<String, String> dataTypes1 = this.getColumnDataTypes(storageCode1);
        Map<String, String> dataTypes2 = this.getColumnDataTypes(storageCode2);
        return dataTypes1.equals(dataTypes2);
    }

    @Override
    public Map<String, String> getColumnDataTypes(String storageCode) {
        List nameTypes = this.entityManager.createNativeQuery("SELECT column_name, data_type \n  FROM information_schema.columns \n WHERE true \n  AND table_schema = :schemaName \n  AND table_name = :tableName \n").setParameter("schemaName", (Object)StorageUtils.toSchemaName(storageCode)).setParameter("tableName", (Object)StorageUtils.toTableName(storageCode)).getResultList();
        List<String> systemFieldNames = this.getSystemFieldNames();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object[] nameType : nameTypes) {
            String fieldName = (String)nameType[0];
            if (systemFieldNames.contains(fieldName)) continue;
            map.put(fieldName, (String)nameType[1]);
        }
        return map;
    }

    private QueryWithParams getCriteriaWhereClause(StorageDataCriteria criteria, String alias) {
        StorageDataCriteria whereCriteria = new StorageDataCriteria(criteria);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)criteria.getHashList())) {
            whereCriteria.setFieldFilters(null);
            whereCriteria.setSystemIds(null);
        }
        return this.getWhereClause(whereCriteria, alias);
    }

    private QueryWithParams getWhereClause(StorageDataCriteria criteria, String alias) {
        QueryWithParams query = new QueryWithParams(" true ");
        query.concat(this.getWhereByDates(criteria.getBdate(), criteria.getEdate(), alias));
        query.concat(this.getWhereByFts(criteria.getCommonFilter(), alias));
        query.concat(this.getWhereByFilters(criteria.getFieldFilters(), alias));
        query.concat(this.getWhereByHashList(criteria.getHashList(), alias));
        query.concat(this.getWhereBySystemIds(criteria.getSystemIds(), alias));
        return query;
    }

    private QueryWithParams getWhereByDates(LocalDateTime publishDate, LocalDateTime closeDate, String alias) {
        if (publishDate == null) {
            return null;
        }
        Object sql = "";
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sqlByPublishDate = " AND date_trunc('second', %1$s.%2$s) <= :bdate \n AND (date_trunc('second', %1$s.%3$s) > :bdate OR %1$s.%3$s is null) \n";
        sql = (String)sql + String.format(sqlByPublishDate, alias, StringUtils.addDoubleQuotes("SYS_PUBLISHTIME"), StringUtils.addDoubleQuotes("SYS_CLOSETIME"));
        params.put("bdate", publishDate.truncatedTo(ChronoUnit.SECONDS));
        String sqlByCloseDate = " AND (date_trunc('second', %1$s.%2$s) >= :edate OR %1$s.%2$s is null) \n";
        sql = (String)sql + String.format(sqlByCloseDate, alias, StringUtils.addDoubleQuotes("SYS_CLOSETIME"));
        closeDate = closeDate == null ? PG_MAX_TIMESTAMP : closeDate;
        params.put("edate", closeDate.truncatedTo(ChronoUnit.SECONDS));
        return new QueryWithParams((String)sql, params);
    }

    private QueryWithParams getWhereByFts(String search, String alias) {
        String string = search = search != null ? search.trim() : "";
        if (StringUtils.isNullOrEmpty(search)) {
            return null;
        }
        Object sql = "";
        HashMap<String, Object> params = new HashMap<String, Object>();
        String escapedFtsColumn = StorageUtils.escapeFieldName(alias, "FTS");
        if (SEARCH_DATE_PATTERN.matcher(search).matches()) {
            sql = (String)sql + " AND (" + escapedFtsColumn + " @@ to_tsquery(:search) or " + escapedFtsColumn + " @@ to_tsquery(:reverseSearch) ) ";
            String[] dateArr = search.split("\\.");
            String reverseSearch = dateArr[2] + "-" + dateArr[1] + "-" + dateArr[0];
            params.put("search", search.trim());
            params.put("reverseSearch", reverseSearch);
        } else {
            String formattedSearch = search.toLowerCase().replace(":", "\\:").replace("/", "\\/").replace(" ", "+");
            sql = (String)sql + " AND (" + escapedFtsColumn + " @@ to_tsquery(:formattedSearch||':*') or " + escapedFtsColumn + " @@ to_tsquery('ru', :formattedSearch||':*') or " + escapedFtsColumn + " @@ to_tsquery('ru', :original||':*')) ";
            params.put("formattedSearch", "'" + formattedSearch + "'");
            params.put("original", "'''" + search + "'''");
        }
        return new QueryWithParams((String)sql, params);
    }

    private QueryWithParams getWhereByFilters(Set<List<FieldSearchCriteria>> fieldFilters, String alias) {
        if (CollectionUtils.isNullOrEmpty(fieldFilters)) {
            return null;
        }
        Object sql = "";
        HashMap<String, Object> params = new HashMap<String, Object>();
        fieldFilters = this.prepareFilters(fieldFilters);
        AtomicInteger index = new AtomicInteger(0);
        if (!"".equals(sql = (String)sql + fieldFilters.stream().map(list -> {
            if (org.springframework.util.CollectionUtils.isEmpty((Collection)list)) {
                return null;
            }
            ArrayList filters = new ArrayList();
            list.forEach(searchCriteria -> this.toWhereClauseByFilter((FieldSearchCriteria)searchCriteria, index.getAndIncrement(), alias, filters, params));
            if (filters.isEmpty()) {
                return null;
            }
            return " true " + String.join((CharSequence)" \n", filters);
        }).filter(Objects::nonNull).collect(Collectors.joining(" OR ")))) {
            sql = " AND (" + (String)sql + ")";
        }
        return new QueryWithParams((String)sql, params);
    }

    private void toWhereClauseByFilter(FieldSearchCriteria searchCriteria, int index, String alias, List<String> filters, Map<String, Object> params) {
        Field field = searchCriteria.getField();
        List values = searchCriteria.getValues();
        String fieldName = field.getName();
        String escapedFieldName = StorageUtils.escapeFieldName(alias, fieldName);
        if (values == null || values.get(0) == null || SearchTypeEnum.IS_NULL.equals((Object)searchCriteria.getType())) {
            filters.add(" AND " + escapedFieldName + " IS NULL");
            return;
        }
        if (SearchTypeEnum.IS_NOT_NULL.equals((Object)searchCriteria.getType())) {
            filters.add(" AND " + escapedFieldName + " IS NOT NULL");
            return;
        }
        String indexedFieldName = fieldName + index;
        if (field instanceof IntegerField || field instanceof FloatField || field instanceof DateField) {
            filters.add(" AND " + escapedFieldName + " IN (:" + indexedFieldName + ")");
            params.put(indexedFieldName, values);
        } else if (field instanceof ReferenceField) {
            filters.add(" AND " + escapedFieldName + "->>" + StringUtils.addSingleQuotes("value") + " IN (:" + indexedFieldName + ")");
            params.put(indexedFieldName, values.stream().map(Object::toString).collect(Collectors.toList()));
        } else if (field instanceof TreeField) {
            if (SearchTypeEnum.LESS.equals((Object)searchCriteria.getType())) {
                filters.add(" AND " + escapedFieldName + "@> (CAST(:" + indexedFieldName + " AS ltree[]))");
                params.put(indexedFieldName, QueryUtil.valuesToDbArray(values));
            }
        } else if (field instanceof BooleanField) {
            if (values.size() == 1) {
                String isValue = Boolean.TRUE.equals(values.get(0)) ? " IS TRUE " : " IS NOT TRUE";
                filters.add(" AND " + escapedFieldName + isValue);
            }
        } else if (field instanceof StringField) {
            if (SearchTypeEnum.LIKE.equals((Object)searchCriteria.getType()) && values.size() == 1) {
                filters.add(" AND lower(" + escapedFieldName + ") LIKE :" + indexedFieldName);
                String value = ((Serializable)values.get(0)).toString().trim().toLowerCase();
                params.put(indexedFieldName, "%" + value + "%");
            } else {
                filters.add(" AND " + escapedFieldName + " IN (:" + indexedFieldName + ")");
                params.put(indexedFieldName, values);
            }
        } else {
            params.put(indexedFieldName, values);
        }
    }

    private Set<List<FieldSearchCriteria>> prepareFilters(Set<List<FieldSearchCriteria>> filters) {
        HashSet<List<FieldSearchCriteria>> set = new HashSet<List<FieldSearchCriteria>>();
        for (List<FieldSearchCriteria> list : filters) {
            set.add(this.groupBySearchType(list));
        }
        return set;
    }

    private List<FieldSearchCriteria> groupBySearchType(List<FieldSearchCriteria> list) {
        EnumMap<SearchTypeEnum, Map> typedGroup = new EnumMap<SearchTypeEnum, Map>(SearchTypeEnum.class);
        for (FieldSearchCriteria criteria : list) {
            Map typedMap = typedGroup.computeIfAbsent(criteria.getType(), k -> new HashMap());
            FieldSearchCriteria typedCriteria = (FieldSearchCriteria)typedMap.get(criteria.getField().getName());
            if (typedCriteria == null) {
                criteria.setValues(new ArrayList(criteria.getValues()));
                typedMap.put(criteria.getField().getName(), criteria);
                continue;
            }
            List typedValues = typedCriteria.getValues();
            typedValues.addAll(criteria.getValues());
        }
        return typedGroup.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private QueryWithParams getWhereByHashList(List<String> hashList, String alias) {
        String sql;
        if (CollectionUtils.isNullOrEmpty(hashList)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String escapedColumn = StorageUtils.escapeFieldName(alias, "SYS_HASH");
        if (hashList.size() > 1) {
            sql = " AND (" + escapedColumn + " = " + String.format("ANY(%s\\:\\:text[])", ":hashList") + ")";
            params.put("hashList", QueryUtil.stringsToDbArray(hashList));
        } else {
            sql = " AND (" + escapedColumn + " = :hashItem)";
            params.put("hashItem", hashList.get(0));
        }
        return new QueryWithParams(sql, params);
    }

    private QueryWithParams getWhereBySystemIds(List<Long> systemIds, String alias) {
        String sql;
        if (CollectionUtils.isNullOrEmpty(systemIds)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String escapedColumn = StorageUtils.escapeFieldName(alias, "SYS_RECORDID");
        if (systemIds.size() > 1) {
            sql = " AND (" + escapedColumn + " = " + String.format("ANY(%s\\:\\:bigint[])", ":systemIds") + ")";
            params.put("systemIds", QueryUtil.valuesToDbArray(systemIds));
        } else {
            sql = " AND (" + escapedColumn + " = :systemId)";
            params.put("systemId", systemIds.get(0));
        }
        return new QueryWithParams(sql, params);
    }

    protected String sortingsToOrderBy(StorageDataCriteria criteria, String alias, String schemaName) {
        return this.sortingsToOrderBy(criteria.getSortings(), alias);
    }

    private String sortingsToOrderBy(List<Sorting> sortings, String alias) {
        Object result = " ORDER BY ";
        if (!CollectionUtils.isNullOrEmpty(sortings)) {
            result = (String)result + sortings.stream().filter(sorting -> sorting != null && sorting.getField() != null).map(sorting -> this.toOrderBy((Sorting)sorting, alias)).collect(Collectors.joining(",")) + ",";
        }
        return (String)result + this.toPrimaryOrderBy(alias);
    }

    private String toOrderBy(Sorting sorting, String alias) {
        return " " + StorageUtils.escapeFieldName(alias, sorting.getField()) + " " + sorting.getDirection().toString();
    }

    protected String getDefaultOrderBy(String alias) {
        return " ORDER BY " + this.toPrimaryOrderBy(alias);
    }

    private String toPrimaryOrderBy(String alias) {
        return " " + StorageUtils.escapeFieldName(alias, "SYS_RECORDID");
    }

    @Override
    public BigInteger countData(String storageCode) {
        String sql = "SELECT count(*) \n  FROM " + StorageUtils.escapeStorageTableName(storageCode);
        return (BigInteger)this.entityManager.createNativeQuery(sql).getSingleResult();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean schemaExists(String schemaName) {
        Boolean result = (Boolean)this.entityManager.createNativeQuery("SELECT EXISTS(\nSELECT * \n  FROM information_schema.schemata \n WHERE true \n  AND schema_name = :schemaName \n)").setParameter("schemaName", (Object)schemaName).getSingleResult();
        return result != null && result != false;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public List<String> findExistentSchemas(List<String> schemaNames) {
        if (CollectionUtils.isNullOrEmpty(schemaNames)) {
            return Collections.emptyList();
        }
        String condition = String.format("ANY(%s\\:\\:text[])", ":schemaName");
        String sql = "SELECT schema_name \n  FROM information_schema.schemata \n WHERE true \n  AND schema_name = " + condition;
        Query query = this.entityManager.createNativeQuery(sql);
        query.setParameter("schemaName", (Object)QueryUtil.stringsToDbArray(schemaNames));
        List<String> list = query.getResultList();
        return !CollectionUtils.isNullOrEmpty((Collection)list) ? list : Collections.emptyList();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public List<String> findExistentTableSchemas(List<String> schemaNames, String tableName) {
        if (CollectionUtils.isNullOrEmpty(schemaNames)) {
            return Collections.emptyList();
        }
        String condition = String.format("ANY(%s\\:\\:text[])", ":schemaName");
        String sql = "SELECT table_schema \n  FROM information_schema.tables \n WHERE true \n  AND table_name = :tableName \n  AND table_schema = " + condition;
        Query query = this.entityManager.createNativeQuery(sql);
        query.setParameter("tableName", (Object)tableName);
        query.setParameter("schemaName", (Object)QueryUtil.stringsToDbArray(schemaNames));
        List<String> list = query.getResultList();
        return !CollectionUtils.isNullOrEmpty((Collection)list) ? list : Collections.emptyList();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean storageExists(String storageCode) {
        Boolean result = (Boolean)this.entityManager.createNativeQuery("SELECT EXISTS(\nSELECT * \n  FROM information_schema.tables \n WHERE true \n  AND table_schema = :schemaName \n  AND table_name = :tableName \n)").setParameter("schemaName", (Object)StorageUtils.toSchemaName(storageCode)).setParameter("tableName", (Object)StorageUtils.toTableName(storageCode)).getSingleResult();
        return result != null && result != false;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean storageFieldExists(String storageCode, String fieldName) {
        Boolean result = (Boolean)this.entityManager.createNativeQuery("SELECT EXISTS(\nSELECT * \n  FROM information_schema.columns \n WHERE true \n  AND table_schema = :schemaName \n  AND table_name = :tableName \n  AND column_name = :columnName \n)").setParameter("schemaName", (Object)StorageUtils.toSchemaName(storageCode)).setParameter("tableName", (Object)StorageUtils.toTableName(storageCode)).setParameter("columnName", (Object)fieldName).getSingleResult();
        return result != null && result != false;
    }

    @Override
    @Transactional
    public void createSchema(String schemaName) {
        if (StorageUtils.isDefaultSchema(schemaName)) {
            return;
        }
        if (!StorageUtils.isValidSchemaName(schemaName)) {
            throw new IllegalArgumentException("schema.name.is.invalid");
        }
        String ddl = String.format("CREATE SCHEMA IF NOT EXISTS %s;", schemaName);
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @Transactional
    public void createDraftTable(String storageCode, List<Field> fields) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        if (this.storageExists(storageCode)) {
            throw new IllegalArgumentException("table.already.exists");
        }
        Object tableFields = "";
        if (!CollectionUtils.isNullOrEmpty(fields)) {
            tableFields = fields.stream().map(f -> StringUtils.addDoubleQuotes(f.getName()) + " " + f.getType()).collect(Collectors.joining(", \n")) + ", \n";
        }
        String ddl = String.format("CREATE TABLE %1$s.%2$s (  \"SYS_RECORDID\" bigserial NOT NULL,  %3$s  \"FTS\" tsvector,  \"SYS_HASH\" char(32) UNIQUE,  CONSTRAINT \"%4$s_pkey\" PRIMARY KEY (\"SYS_RECORDID\"));", schemaName, StringUtils.addDoubleQuotes(tableName), tableFields, tableName);
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void dropTable(String storageCode) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        if (StringUtils.isNullOrEmpty(tableName)) {
            logger.error("Dropping table name is empty");
            return;
        }
        this.dropTriggers(storageCode);
        this.dropTableFunctions(storageCode);
        String ddl = String.format("DROP TABLE IF EXISTS %1$s.%2$s", schemaName, StringUtils.addDoubleQuotes(tableName));
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    protected void createTableSequence(String storageCode) {
        String ddl = String.format("CREATE SEQUENCE %s start 1", StorageUtils.escapeStorageSequenceName(storageCode));
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void updateTableSequence(String storageCode) {
        String sqlSelect = String.format("SELECT max(%3$s) FROM %1$s.%2$s", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(storageCode)), StringUtils.addDoubleQuotes("SYS_RECORDID"));
        String sql = String.format("DO $$\nBEGIN \n    if EXISTS(\n       SELECT * FROM pg_class \n        WHERE relkind = 'S' AND oid\\:\\:regclass\\:\\:text = '%1$s' \n       ) then\n       PERFORM setval('%1$s', (%2$s)); \n    end if;\nEND$$;", StorageUtils.escapeStorageSequenceName(storageCode), sqlSelect);
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    protected void dropTableSequence(String storageCode) {
        String ddl = String.format("DROP SEQUENCE IF EXISTS %s CASCADE", StorageUtils.escapeStorageSequenceName(storageCode));
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @Transactional
    public void createTriggers(String storageCode, List<String> fieldNames) {
        this.createHashTrigger(storageCode, fieldNames);
        this.createFtsTrigger(storageCode, fieldNames);
    }

    protected void createHashTrigger(String storageCode, List<String> fieldNames) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String alias = "NEW.";
        String tableFields = fieldNames.stream().map(QueryUtil::getClearedFieldName).collect(Collectors.joining(", "));
        String expression = String.format("md5(ROW(%s)||'')", fieldNames.stream().map(field -> "NEW." + field).collect(Collectors.joining(", ")));
        String triggerBody = "NEW." + StringUtils.addDoubleQuotes("SYS_HASH") + " = " + expression;
        String ddl = String.format("CREATE OR REPLACE FUNCTION %1$s.%3$s()\n  RETURNS trigger AS\n$BODY$\n  BEGIN\n    %6$s\n    RETURN NEW;\n  END;\n$BODY$ LANGUAGE plpgsql;\n\nCREATE TRIGGER %4$s \n  BEFORE INSERT OR UPDATE OF %5$s\n  ON %1$s.\"%2$s\"\n  FOR EACH ROW\n  EXECUTE PROCEDURE %1$s.%3$s();", schemaName, tableName, StorageUtils.escapeTableFunctionName(tableName, "hash_tf"), "hash_tg", tableFields, triggerBody + ";");
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    protected void createFtsTrigger(String storageCode, List<String> fieldNames) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String alias = "NEW.";
        String tableFields = fieldNames.stream().map(QueryUtil::getClearedFieldName).collect(Collectors.joining(", "));
        String expression = fieldNames.stream().map(field -> "coalesce( to_tsvector('ru', NEW." + field + "\\:\\:text),'')").collect(Collectors.joining(" || ' ' || "));
        String triggerBody = "NEW." + StringUtils.addDoubleQuotes("FTS") + " = " + expression;
        String ddl = String.format("CREATE OR REPLACE FUNCTION %1$s.%3$s()\n  RETURNS trigger AS\n$BODY$\n  BEGIN\n    %6$s\n    RETURN NEW;\n  END;\n$BODY$ LANGUAGE plpgsql;\n\nCREATE TRIGGER %4$s \n  BEFORE INSERT OR UPDATE OF %5$s\n  ON %1$s.\"%2$s\"\n  FOR EACH ROW\n  EXECUTE PROCEDURE %1$s.%3$s();", schemaName, tableName, StorageUtils.escapeTableFunctionName(tableName, "fts_vector_tf"), "fts_vector_tg", tableFields, triggerBody + ";");
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void dropTriggers(String storageCode) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String escapedTableName = StringUtils.addDoubleQuotes(tableName);
        String dropHashTrigger = String.format("DROP TRIGGER IF EXISTS %1$s ON %2$s.%3$s;", "hash_tg", schemaName, escapedTableName);
        this.entityManager.createNativeQuery(dropHashTrigger).executeUpdate();
        String dropFtsTrigger = String.format("DROP TRIGGER IF EXISTS %1$s ON %2$s.%3$s;", "fts_vector_tg", schemaName, escapedTableName);
        this.entityManager.createNativeQuery(dropFtsTrigger).executeUpdate();
    }

    @Override
    @Transactional
    public void enableTriggers(String storageCode) {
        String ddl = String.format("ALTER TABLE %1$s %2$s TRIGGER ALL;", StorageUtils.escapeStorageTableName(storageCode), "ENABLE");
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @Transactional
    public void disableTriggers(String storageCode) {
        String ddl = String.format("ALTER TABLE %1$s %2$s TRIGGER ALL;", StorageUtils.escapeStorageTableName(storageCode), "DISABLE");
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void dropTableFunctions(String storageCode) {
        this.dropTableFunction(storageCode, "hash_tf");
        this.dropTableFunction(storageCode, "fts_vector_tf");
    }

    protected void dropTableFunction(String storageCode, String functionName) {
        String ddl = String.format("DROP FUNCTION IF EXISTS %1$s.%2$s;", StorageUtils.toSchemaName(storageCode), StorageUtils.escapeTableFunctionName(StorageUtils.toTableName(storageCode), functionName));
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @Transactional
    public void updateHashRows(String storageCode, List<String> fieldNames) {
        String expression = String.format("md5(ROW(%s)||'')", String.join((CharSequence)", ", fieldNames));
        String ddlAssign = StringUtils.addDoubleQuotes("SYS_HASH") + " = " + expression;
        String ddl = String.format("UPDATE %1$s.%2$s SET %3$s;", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(storageCode)), ddlAssign);
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @Transactional
    public void updateFtsRows(String storageCode, List<String> fieldNames) {
        String expression = fieldNames.stream().map(field -> "coalesce( to_tsvector('ru', " + field + "\\:\\:text),'')").collect(Collectors.joining(" || ' ' || "));
        String ddlAssign = StringUtils.addDoubleQuotes("FTS") + " = " + expression;
        String ddl = String.format("UPDATE %1$s.%2$s SET %3$s;", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(storageCode)), ddlAssign);
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void createFieldIndex(String storageCode, String fieldName) {
        String indexName = StorageUtils.escapeTableIndexName(StorageUtils.toTableName(storageCode), fieldName.toLowerCase());
        this.createFieldsIndex(storageCode, indexName, Collections.singletonList(fieldName));
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void createFieldsIndex(String storageCode, String indexName, List<String> fieldNames) {
        String expression = fieldNames.stream().map(StringUtils::addDoubleQuotes).collect(Collectors.joining(","));
        String ddl = String.format("CREATE INDEX IF NOT EXISTS %1$s ON %2$s.%3$s %4$s(%5$s);", indexName, StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(storageCode)), "", expression);
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void createHashIndex(String storageCode) {
        String tableName = StorageUtils.toTableName(storageCode);
        String ddl = String.format("CREATE INDEX IF NOT EXISTS %1$s ON %2$s.%3$s %4$s(%5$s);", StringUtils.addDoubleQuotes(tableName + "_sys_hash_ix"), StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(tableName), "", StringUtils.addDoubleQuotes("SYS_HASH"));
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void createFtsIndex(String storageCode) {
        String tableName = StorageUtils.toTableName(storageCode);
        String ddl = String.format("CREATE INDEX IF NOT EXISTS %1$s ON %2$s.%3$s %4$s(%5$s);", StorageUtils.escapeTableIndexName(tableName, "fts"), StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(tableName), "USING gin", StringUtils.addDoubleQuotes("FTS"));
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void createLtreeIndex(String storageCode, String fieldName) {
        String tableName = StorageUtils.toTableName(storageCode);
        String ddl = String.format("CREATE INDEX IF NOT EXISTS %1$s ON %2$s.%3$s %4$s(%5$s);", StorageUtils.escapeTableIndexName(tableName, fieldName.toLowerCase()), StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(tableName), "USING gist", StringUtils.addDoubleQuotes(fieldName));
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @Transactional
    public void copyTable(String sourceCode, String targetCode) {
        String sourceSchema = StorageUtils.toSchemaName(sourceCode);
        String sourceTable = StorageUtils.toTableName(sourceCode);
        if (StringUtils.isNullOrEmpty(sourceTable)) {
            throw new IllegalArgumentException("source.table.name.is.empty");
        }
        String targetSchema = StorageUtils.toSchemaName(targetCode);
        String targetTable = StorageUtils.toTableName(targetCode);
        if (StringUtils.isNullOrEmpty(targetTable)) {
            throw new IllegalArgumentException("target.table.name.is.empty");
        }
        String ddlCopyTable = String.format("CREATE TABLE %1$s.%2$s AS SELECT * FROM %3$s.%4$s WITH NO DATA;", targetSchema, StringUtils.addDoubleQuotes(targetTable), sourceSchema, StringUtils.addDoubleQuotes(sourceTable));
        this.entityManager.createNativeQuery(ddlCopyTable).executeUpdate();
        this.copyIndexes(sourceCode, targetCode);
        this.createHashIndex(targetCode);
        this.addPrimaryKey(targetCode);
        this.addTableSequence(targetCode);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    private void copyIndexes(String sourceCode, String targetCode) {
        String sourceSchema = StorageUtils.toSchemaName(sourceCode);
        String sourceTable = StorageUtils.toTableName(sourceCode);
        String notLikeIndexes = "%" + StringUtils.addDoubleQuotes("SYS_HASH") + "%";
        String sql = "SELECT indexdef \n  FROM pg_indexes \n WHERE schemaname = :schemaName \n   AND tablename = :tableName \n   AND NOT indexdef LIKE :notLikeIndexes \n";
        List ddlIndexes = this.entityManager.createNativeQuery(sql).setParameter("schemaName", (Object)sourceSchema).setParameter("tableName", (Object)sourceTable).setParameter("notLikeIndexes", (Object)notLikeIndexes).getResultList();
        String targetSchema = StorageUtils.toSchemaName(targetCode);
        String targetTable = StorageUtils.toTableName(targetCode);
        for (String ddlIndex : ddlIndexes) {
            String ddl = ddlIndex.replace(sourceSchema + "." + sourceTable, targetSchema + "." + targetTable).replace(StorageUtils.escapeTableName(sourceSchema, sourceTable), StorageUtils.escapeTableName(targetSchema, targetTable)).replace(sourceTable, targetTable);
            this.entityManager.createNativeQuery(ddl).executeUpdate();
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    private void addPrimaryKey(String storageCode) {
        String ddlAddPrimaryKey = String.format("ALTER TABLE %1$s.%2$s ADD PRIMARY KEY (%3$s);", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(storageCode)), StringUtils.addDoubleQuotes("SYS_RECORDID"));
        this.entityManager.createNativeQuery(ddlAddPrimaryKey).executeUpdate();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    protected void addTableSequence(String storageCode) {
        this.createTableSequence(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String ddlAlterColumn = String.format("ALTER TABLE %1$s.%2$s \n  ALTER COLUMN %3$s SET DEFAULT nextval('%1$s.%4$s');", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(tableName), StringUtils.addDoubleQuotes("SYS_RECORDID"), StorageUtils.escapeSequenceName(tableName));
        this.entityManager.createNativeQuery(ddlAlterColumn).executeUpdate();
    }

    @Override
    @Transactional
    public void addVersionedInformation(String storageCode) {
        this.addColumn(storageCode, "SYS_PUBLISHTIME", "timestamp without time zone", "'-infinity'");
        this.addColumn(storageCode, "SYS_CLOSETIME", "timestamp without time zone", "'infinity'");
        this.createFieldsIndex(storageCode, StorageUtils.escapeTableIndexName(StorageUtils.toTableName(storageCode), "SYSDATE"), Arrays.asList("SYS_PUBLISHTIME", "SYS_CLOSETIME"));
    }

    @Override
    @Transactional
    public void addColumn(String storageCode, String name, String type, String defaultValue) {
        Object condition = defaultValue != null ? "DEFAULT " + defaultValue : "";
        String ddl = String.format("ALTER TABLE %1$s.%2$s ADD COLUMN %3$s %4$s %5$s;", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(storageCode)), StringUtils.addDoubleQuotes(name), type, condition);
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void alterDataType(String storageCode, String fieldName, String oldType, String newType) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String escapedFieldName = StringUtils.addDoubleQuotes(fieldName);
        String using = QueryUtil.useFieldNameByType(escapedFieldName, oldType, newType);
        String ddl = String.format("ALTER TABLE %1$s.%2$s ALTER COLUMN %3$s SET DATA TYPE %4$s USING %5$s", schemaName, StringUtils.addDoubleQuotes(tableName), escapedFieldName, newType, using);
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void deleteColumn(String storageCode, String name) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String ddl = String.format("ALTER TABLE %1$s.%2$s DROP COLUMN %3$s CASCADE;", schemaName, StringUtils.addDoubleQuotes(tableName), StringUtils.addDoubleQuotes(name));
        this.entityManager.createNativeQuery(ddl).executeUpdate();
    }

    @Override
    @Transactional
    public List<String> insertData(String storageCode, List<RowValue> data) {
        if (org.springframework.util.CollectionUtils.isEmpty(data)) {
            return Collections.emptyList();
        }
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        List fieldValues = data.get(0).getFieldValues();
        String insertKeys = fieldValues.stream().map(fieldValue -> StringUtils.addDoubleQuotes(fieldValue.getField())).collect(Collectors.joining(","));
        List substList = data.stream().map(rowValue -> rowValue.getFieldValues().stream().map(fieldValue -> this.toInsertValueSubst(schemaName, (FieldValue)fieldValue)).collect(Collectors.joining(","))).collect(Collectors.toList());
        ArrayList<String> hashes = new ArrayList<String>(substList.size());
        int batchSize = 500;
        int firstIndex = 0;
        int nextIndex = batchSize;
        while (firstIndex < substList.size()) {
            int valueCount = Math.min(nextIndex, substList.size());
            List<String> batchHashes = this.insertData(schemaName, tableName, insertKeys, substList.subList(firstIndex, valueCount), data.subList(firstIndex, valueCount));
            hashes.addAll(batchHashes);
            firstIndex = nextIndex;
            nextIndex = firstIndex + batchSize;
        }
        return hashes;
    }

    private String toInsertValueSubst(String schemaName, FieldValue fieldValue) {
        if (fieldValue.getValue() == null) {
            return "null";
        }
        if (fieldValue instanceof ReferenceFieldValue) {
            return this.getReferenceValuationSelect(schemaName, (ReferenceFieldValue)fieldValue, "?");
        }
        if (fieldValue instanceof TreeFieldValue) {
            return "?\\:\\:ltree";
        }
        return "?";
    }

    private List<String> insertData(String schemaName, String tableName, String insertKeys, List<String> subst, List<RowValue> data) {
        String insertSubsts = subst.stream().collect(Collectors.joining("),(", "(", ")"));
        String sql = String.format("INSERT INTO %1$s.%2$s (%3$s) \n", schemaName, StringUtils.addDoubleQuotes(tableName), insertKeys) + String.format("VALUES %s \n", insertSubsts) + "RETURNING " + StringUtils.addDoubleQuotes("SYS_HASH");
        Query query = this.entityManager.createNativeQuery(sql);
        int i = 1;
        for (RowValue rowValue : data) {
            for (FieldValue fieldValue : rowValue.getFieldValues()) {
                Serializable parameter = QueryUtil.toQueryParameter(fieldValue);
                if (parameter == null) continue;
                query.setParameter(i++, (Object)parameter);
            }
        }
        return query.getResultList();
    }

    private String getReferenceValuationSelect(String schemaName, ReferenceFieldValue fieldValue, String valueSubst) {
        String sqlExpression;
        Reference refValue = (Reference)fieldValue.getValue();
        if (refValue.getValue() == null && "null".equals(valueSubst)) {
            return "null";
        }
        ReferenceDisplayType displayType = QueryUtil.getReferenceDisplayType(refValue);
        if (displayType == null) {
            return "(select jsonb_build_object('value', ?))";
        }
        switch (displayType) {
            case DISPLAY_EXPRESSION: {
                sqlExpression = QueryUtil.sqlDisplayExpression(refValue.getDisplayExpression(), "d");
                break;
            }
            case DISPLAY_FIELD: {
                sqlExpression = QueryUtil.sqlFieldExpression(refValue.getDisplayField(), "d");
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown.reference.dipslay.type");
            }
        }
        QueryWithParams whereByDate = this.getWhereByDates(refValue.getDate(), null, "d");
        String sqlDateValue = QueryUtil.formatDateTime(refValue.getDate());
        String sqlByDate = whereByDate == null || StringUtils.isNullOrEmpty(whereByDate.getSql()) ? "" : whereByDate.getSql().replace(":bdate", QueryUtil.toTimestampWithoutTimeZone(sqlDateValue)).replace(":edate", QueryUtil.toTimestampWithoutTimeZone("'-infinity'"));
        String refStorageCode = StorageUtils.toStorageCode(schemaName, refValue.getStorageCode());
        String sql = String.format(QueryConstants.REFERENCE_VALUATION_SELECT_EXPRESSION, schemaName, StringUtils.addDoubleQuotes(refValue.getStorageCode()), "d", StringUtils.addDoubleQuotes(refValue.getKeyField()), sqlExpression, valueSubst, this.getFieldType(refStorageCode, refValue.getKeyField()), sqlByDate);
        return "(" + sql + ")";
    }

    @Override
    @Transactional
    public String updateData(String storageCode, RowValue rowValue) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String updateKeys = rowValue.getFieldValues().stream().map(fieldValue -> {
            String quotedFieldName = StringUtils.addDoubleQuotes(fieldValue.getField());
            String substValue = this.toUpdateValueSubst(schemaName, (FieldValue)fieldValue);
            return quotedFieldName + " = " + substValue;
        }).collect(Collectors.joining(","));
        String condition = StorageUtils.escapeFieldName("b", "SYS_RECORDID") + " = ?";
        String sql = String.format("UPDATE %1$s.%2$s as %3$s SET %4$s WHERE %5$s \n", schemaName, StringUtils.addDoubleQuotes(tableName), "b", updateKeys, condition) + "RETURNING " + StringUtils.addDoubleQuotes("SYS_HASH");
        Query query = this.entityManager.createNativeQuery(sql);
        int i = 1;
        for (FieldValue fieldValue2 : rowValue.getFieldValues()) {
            Serializable parameter = QueryUtil.toQueryParameter(fieldValue2);
            if (parameter == null) continue;
            query.setParameter(i++, (Object)parameter);
        }
        query.setParameter(i, rowValue.getSystemId());
        return (String)query.getSingleResult();
    }

    private String toUpdateValueSubst(String schemaName, FieldValue fieldValue) {
        if (QueryUtil.isFieldValueNull(fieldValue)) {
            return "null";
        }
        if (fieldValue instanceof ReferenceFieldValue) {
            return this.getReferenceValuationSelect(schemaName, (ReferenceFieldValue)fieldValue, "?");
        }
        if (fieldValue instanceof TreeFieldValue) {
            return "?\\:\\:ltree";
        }
        return "?";
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public void deleteData(String storageCode) {
        String tableName = StorageUtils.toTableName(storageCode);
        String sql = String.format("DELETE FROM %1$s.%2$s \n", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(tableName));
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public List<String> deleteData(String storageCode, List<Object> systemIds) {
        if (CollectionUtils.isNullOrEmpty(systemIds)) {
            return Collections.emptyList();
        }
        StorageDataCriteria criteria = new StorageDataCriteria(storageCode, null, null, null);
        criteria.setSystemIds(QueryUtil.toLongSystemIds(systemIds));
        return this.deleteTableData(criteria);
    }

    protected List<String> deleteTableData(StorageDataCriteria criteria) {
        QueryWithParams where = this.getWhereClause(criteria, null);
        if (StringUtils.isNullOrEmpty(where.getSql())) {
            return Collections.emptyList();
        }
        String schemaName = this.getStorageCodeSchemaName(criteria.getStorageCode());
        String tableName = StorageUtils.toTableName(criteria.getStorageCode());
        String sql = String.format("DELETE FROM %1$s.%2$s \n", schemaName, StringUtils.addDoubleQuotes(tableName)) + " WHERE " + where.getSql() + "RETURNING " + StringUtils.addDoubleQuotes("SYS_HASH");
        Query query = this.entityManager.createNativeQuery(sql);
        where.fillQueryParameters(query);
        return query.getResultList();
    }

    @Override
    @Transactional
    public void deleteEmptyRows(String draftCode) {
        List<String> fieldNames = this.getEscapedFieldNames(draftCode);
        if (org.springframework.util.CollectionUtils.isEmpty(fieldNames)) {
            this.deleteData(draftCode);
            return;
        }
        String condition = fieldNames.stream().map(s -> s + " IS NULL").collect(Collectors.joining(" AND "));
        String sql = String.format("DELETE FROM %1$s.%2$s \n", StorageUtils.toSchemaName(draftCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(draftCode))) + " WHERE " + condition;
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    @Transactional
    public void updateReferenceInRows(String storageCode, ReferenceFieldValue fieldValue, List<Object> systemIds) {
        if (QueryUtil.getReferenceDisplayType((Reference)fieldValue.getValue()) == null) {
            return;
        }
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String escapedFieldName = StringUtils.addDoubleQuotes(fieldValue.getField());
        String oldFieldExpression = QueryUtil.sqlFieldExpression(fieldValue.getField(), "b");
        String oldFieldValue = String.format("(case when %1$s is null then null else %1$s->>'value' end)", oldFieldExpression);
        String key = escapedFieldName + " = " + this.getReferenceValuationSelect(schemaName, fieldValue, oldFieldValue);
        String condition = StorageUtils.escapeFieldName("b", "SYS_RECORDID") + " = " + String.format("ANY(%s\\:\\:bigint[])", "?");
        String sql = String.format("UPDATE %1$s.%2$s as %3$s SET %4$s WHERE %5$s \n", schemaName, StringUtils.addDoubleQuotes(tableName), "b", key, condition);
        Query query = this.entityManager.createNativeQuery(sql);
        String ids = systemIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        query.setParameter(1, (Object)("{" + ids + "}"));
        query.executeUpdate();
    }

    @Override
    public BigInteger countReferenceInRefRows(String storageCode, ReferenceFieldValue fieldValue) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        if (QueryUtil.getReferenceDisplayType((Reference)fieldValue.getValue()) == null) {
            return BigInteger.ZERO;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("versionTable", StorageUtils.escapeTableName(schemaName, tableName));
        map.put("versionAlias", "v");
        map.put("refFieldName", StringUtils.addDoubleQuotes(fieldValue.getField()));
        String sql = StringUtils.substitute("SELECT count(*) \n  FROM ${versionTable} AS ${versionAlias} \n WHERE true \n   AND ${versionAlias}.${refFieldName} is not null \n   AND (${versionAlias}.${refFieldName} -> 'value') is not null \n", map);
        BigInteger count = (BigInteger)this.entityManager.createNativeQuery(sql).getSingleResult();
        if (logger.isDebugEnabled()) {
            logger.debug("countReferenceInRefRows method count: {}, sql: {}", (Object)count, (Object)sql);
        }
        return count;
    }

    @Override
    @Transactional
    public void updateReferenceInRefRows(String storageCode, ReferenceFieldValue fieldValue, int offset, int limit) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String oldFieldExpression = StorageUtils.escapeFieldName("b", fieldValue.getField());
        String oldFieldValue = String.format("(case when %1$s is null then null else %1$s->>'value' end)", oldFieldExpression);
        String updateKey = StringUtils.addDoubleQuotes(fieldValue.getField()) + " = " + this.getReferenceValuationSelect(schemaName, fieldValue, oldFieldValue);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("versionTable", StorageUtils.escapeTableName(schemaName, tableName));
        map.put("versionAlias", "v");
        map.put("refFieldName", StringUtils.addDoubleQuotes(fieldValue.getField()));
        map.put("limit", "" + limit);
        map.put("offset", "" + offset);
        String select = StringUtils.substitute("\nSELECT ${versionAlias}.\"SYS_RECORDID\" \n  FROM ${versionTable} AS ${versionAlias} \n WHERE true \n   AND ${versionAlias}.${refFieldName} is not null \n   AND (${versionAlias}.${refFieldName} -> 'value') is not null \n ORDER BY ${versionAlias}.\"SYS_RECORDID\" \n LIMIT ${limit} \nOFFSET ${offset} \n", map);
        String condition = StorageUtils.escapeFieldName("b", "SYS_RECORDID") + " IN (" + select + ")";
        String sql = String.format("UPDATE %1$s.%2$s as %3$s SET %4$s WHERE %5$s \n", schemaName, StringUtils.addDoubleQuotes(tableName), "b", updateKey, condition);
        if (logger.isDebugEnabled()) {
            logger.debug("updateReferenceInRefRows method sql: {}", (Object)sql);
        }
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    private List<String> getFieldNames(String storageCode, String sqlSelect) {
        List results = this.entityManager.createNativeQuery(sqlSelect).setParameter("schemaName", (Object)StorageUtils.toSchemaName(storageCode)).setParameter("tableName", (Object)StorageUtils.toTableName(storageCode)).getResultList();
        Collections.sort(results);
        return results;
    }

    @Override
    public List<String> getSystemFieldNames() {
        return StorageConstants.systemFieldNames();
    }

    @Override
    public List<String> getEscapedFieldNames(String storageCode) {
        String sql = "SELECT '\"' || column_name || '\"' \n  FROM information_schema.columns \n WHERE true \n  AND table_schema = :schemaName \n  AND table_name = :tableName \n" + String.format("  AND column_name NOT IN (%s)", this.getSystemFieldNamesText());
        return this.getFieldNames(storageCode, sql);
    }

    @Override
    public List<String> getAllEscapedFieldNames(String storageCode) {
        return this.getFieldNames(storageCode, "SELECT '\"' || column_name || '\"' \n  FROM information_schema.columns \n WHERE true \n  AND table_schema = :schemaName \n  AND table_name = :tableName \n");
    }

    @Override
    public List<String> getHashUsedFieldNames(String storageCode) {
        String sql = QueryConstants.SELECT_HASH_USED_FIELD_NAMES + String.format("  AND column_name NOT IN (%s)", this.getSystemFieldNamesText());
        return this.getFieldNames(storageCode, sql);
    }

    private String getSystemFieldNamesText() {
        return this.getSystemFieldNames().stream().map(StringUtils::addSingleQuotes).collect(Collectors.joining(", "));
    }

    @Override
    public List<String> getAllCommonFieldNames(String storageCode1, String storageCode2) {
        List<String> fieldNames1 = this.getAllEscapedFieldNames(storageCode1);
        List<String> fieldNames2 = this.getAllEscapedFieldNames(storageCode2);
        fieldNames2.removeIf(fieldName2 -> !fieldNames1.contains(fieldName2));
        return fieldNames2;
    }

    @Override
    public String getFieldType(String storageCode, String fieldName) {
        return this.entityManager.createNativeQuery("SELECT data_type \n  FROM information_schema.columns \n WHERE true \n  AND table_schema = :schemaName \n  AND table_name = :tableName \n  AND column_name = :columnName \n").setParameter("schemaName", (Object)StorageUtils.toSchemaName(storageCode)).setParameter("tableName", (Object)StorageUtils.toTableName(storageCode)).setParameter("columnName", (Object)fieldName).getSingleResult().toString();
    }

    @Override
    public boolean isFieldNotNull(String storageCode, String fieldName) {
        String sql = String.format("SELECT EXISTS(SELECT * FROM %1$s.%2$s AS d WHERE d.%3$s IS NOT NULL);", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(storageCode)), StringUtils.addDoubleQuotes(fieldName));
        return (Boolean)this.entityManager.createNativeQuery(sql).getSingleResult();
    }

    @Override
    public boolean isFieldContainNullValues(String storageCode, String fieldName) {
        String sql = String.format("SELECT EXISTS(SELECT * FROM %1$s.%2$s AS d WHERE d.%3$s IS NULL);", StorageUtils.toSchemaName(storageCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(storageCode)), StringUtils.addDoubleQuotes(fieldName));
        return (Boolean)this.entityManager.createNativeQuery(sql).getSingleResult();
    }

    @Override
    public boolean isUnique(String storageCode, List<String> fieldNames, LocalDateTime publishTime) {
        String schemaName = StorageUtils.toSchemaName(storageCode);
        String tableName = StorageUtils.toTableName(storageCode);
        String fields = fieldNames.stream().map(fieldName -> StringUtils.addDoubleQuotes(fieldName) + "\\:\\:text").collect(Collectors.joining(", "));
        String groupBy = IntStream.rangeClosed(1, fieldNames.size()).mapToObj(String::valueOf).collect(Collectors.joining(", "));
        QueryWithParams whereByDate = this.getWhereByDates(publishTime, null, "d");
        String sqlByDate = whereByDate == null || StringUtils.isNullOrEmpty(whereByDate.getSql()) ? "" : whereByDate.getSql();
        String sql = "SELECT " + fields + ", count(*) \n  FROM " + StorageUtils.escapeTableName(schemaName, tableName) + " AS d \n WHERE true \n" + sqlByDate + " GROUP BY " + groupBy + " \nHAVING count(*) > 1";
        Query query = this.entityManager.createNativeQuery(sql);
        if (whereByDate != null) {
            whereByDate.fillQueryParameters(query);
        }
        return query.getResultList().isEmpty();
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRED)
    public void copyTableData(StorageCopyRequest request) {
        String sourceTable = StorageUtils.escapeStorageTableName(request.getStorageCode());
        String targetTable = StorageUtils.escapeStorageTableName(request.getPurposeCode());
        HashMap<String, String> mapSelect = new HashMap<String, String>();
        mapSelect.put("sourceTable", sourceTable);
        mapSelect.put("sourceAlias", "d");
        mapSelect.put("sourceColumns", StorageUtils.aliasColumnName("d", "*"));
        Object sqlSelect = StringUtils.substitute("SELECT ${sourceColumns} \n  FROM ${sourceTable} AS ${sourceAlias} \n", mapSelect);
        QueryWithParams where = this.getWhereClause((StorageDataCriteria)request, "d");
        if (!StringUtils.isNullOrEmpty(where.getSql())) {
            sqlSelect = (String)sqlSelect + " WHERE " + where.getBindedSql() + " \n";
        }
        sqlSelect = (String)sqlSelect + this.getDefaultOrderBy("d");
        List<String> fieldNames = request.getEscapedFieldNames();
        if (CollectionUtils.isNullOrEmpty((Collection)fieldNames)) {
            fieldNames = this.getAllCommonFieldNames(request.getStorageCode(), request.getPurposeCode());
        }
        HashMap<String, String> mapInsert = new HashMap<String, String>();
        mapInsert.put("targetTable", targetTable);
        mapInsert.put("strColumns", QueryUtil.toStrColumns(fieldNames));
        mapInsert.put("rowColumns", QueryUtil.toAliasColumns(fieldNames, "row."));
        String sqlInsert = StringUtils.substitute("INSERT INTO ${targetTable}(${strColumns})\nVALUES(${rowColumns});", mapInsert);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("offset", "" + request.getOffset());
        map.put("limit", "" + request.getSize());
        map.put("sqlSelect", (String)sqlSelect);
        map.put("sqlInsert", sqlInsert);
        String sql = StringUtils.substitute("DO $$\nDECLARE tbl_cursor refcursor;\n  row record;\n  i int;\n\nBEGIN \n    OPEN tbl_cursor FOR \n    ${sqlSelect};\n\n    MOVE FORWARD ${offset} FROM tbl_cursor;\n    i \\:= 0;\n    while i < ${limit} loop \n       FETCH FROM tbl_cursor INTO row;\n       EXIT WHEN NOT FOUND;\n\n       ${sqlInsert}\n\n       i \\:= i + 1;\n    end loop;\n    CLOSE tbl_cursor;\nEND$$;", map);
        if (logger.isDebugEnabled()) {
            logger.debug("copyTableData with method sql: {}", (Object)sql);
        }
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void insertAllDataFromDraft(String draftCode, String targetCode, List<String> fieldNames, int offset, int limit, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        String strColumns = QueryUtil.toStrColumns(fieldNames);
        String rowColumns = QueryUtil.toAliasColumns(fieldNames, "row.");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("offset", "" + offset);
        map.put("limit", "" + limit);
        map.put("draftTable", StorageUtils.escapeStorageTableName(draftCode));
        map.put("draftAlias", "d");
        map.put("targetTable", StorageUtils.escapeStorageTableName(targetCode));
        map.put("targetSequence", StorageUtils.escapeStorageSequenceName(targetCode));
        map.put("strColumns", strColumns);
        map.put("rowColumns", rowColumns);
        map.put("publishTime", QueryUtil.formatDateTime(publishTime));
        map.put("closeTime", QueryUtil.formatDateTime(closeTime));
        String sql = StringUtils.substitute("DO $$\nDECLARE tbl_cursor refcursor;\n  row ${draftTable}%rowtype;\n  i int;\n\nBEGIN \n    OPEN tbl_cursor FOR \n    SELECT ${draftAlias}.* FROM ${draftTable} AS ${draftAlias} \n    ORDER BY ${draftAlias}.\"SYS_RECORDID\";\n\n    MOVE FORWARD ${offset} FROM tbl_cursor;\n    i \\:= 0;\n    while i < ${limit} loop \n       FETCH FROM tbl_cursor INTO row;\n       EXIT WHEN NOT FOUND;\n\n       row.\"SYS_RECORDID\" \\:= nextval('${targetSequence}');\n       INSERT INTO ${targetTable}(\"SYS_RECORDID\", ${strColumns}, \"SYS_PUBLISHTIME\", \"SYS_CLOSETIME\")\n       VALUES(row.\"SYS_RECORDID\", ${rowColumns}, to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, coalesce(to_timestamp('${closeTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, 'infinity'));\n\n       i \\:= i + 1;\n    end loop;\n    CLOSE tbl_cursor;\nEND$$;", map);
        if (logger.isDebugEnabled()) {
            logger.debug("insertDataFromDraft method sql: {}", (Object)sql);
        }
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    public BigInteger countActualDataFromVersion(String versionTable, String draftTable, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("draftTable", StorageUtils.escapeTableName("data", draftTable));
        map.put("draftAlias", "d");
        map.put("versionTable", StorageUtils.escapeTableName("data", versionTable));
        map.put("versionAlias", "v");
        map.put("publishTime", QueryUtil.formatDateTime(publishTime));
        map.put("closeTime", QueryUtil.formatDateTime(closeTime));
        String sql = StringUtils.substitute(QueryConstants.COUNT_ACTUAL_VAL_FROM_VERSION_WITH_CLOSE_TIME, map);
        return (BigInteger)this.entityManager.createNativeQuery(sql).getSingleResult();
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void insertActualDataFromVersion(String targetTable, String versionTable, String draftTable, Map<String, String> typedNames, int offset, int limit, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        String strColumns = QueryUtil.toStrColumns(typedNames);
        String typedColumns = QueryUtil.toTypedColumns(typedNames);
        String draftColumns = QueryUtil.toAliasColumns(typedNames, "d.");
        String rowColumns = QueryUtil.toAliasColumns(typedNames, "row.");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("draftColumns", draftColumns);
        map.put("draftTable", StorageUtils.escapeTableName("data", draftTable));
        map.put("draftAlias", "d");
        map.put("versionTable", StorageUtils.escapeTableName("data", versionTable));
        map.put("versionAlias", "v");
        map.put("publishTime", QueryUtil.formatDateTime(publishTime));
        map.put("closeTime", QueryUtil.formatDateTime(closeTime));
        map.put("offset", "" + offset);
        map.put("limit", "" + limit);
        map.put("targetTable", StorageUtils.escapeTableName("data", targetTable));
        map.put("targetSequence", StorageUtils.escapeSchemaSequenceName("data", targetTable));
        map.put("strColumns", strColumns);
        map.put("typedColumns", typedColumns);
        map.put("rowColumns", rowColumns);
        String sql = StringUtils.substitute(QueryConstants.INSERT_ACTUAL_VAL_FROM_VERSION_WITH_CLOSE_TIME, map);
        if (logger.isDebugEnabled()) {
            logger.debug("insertActualDataFromVersion with sql: {}", (Object)sql);
        }
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    public BigInteger countOldDataFromVersion(String versionTable, String draftTable, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        String sql = String.format("SELECT count(*) \n  FROM data.%1$s v \n WHERE NOT (\n       v.\"SYS_CLOSETIME\" IS NULL AND (to_timestamp('%3$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone >= v.\"SYS_PUBLISHTIME\" OR \n                                        to_timestamp('%3$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone < v.\"SYS_PUBLISHTIME\" AND \n                                        ('%4$s' = 'null' OR to_timestamp('%4$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone >= v.\"SYS_PUBLISHTIME\"))\n       OR \n       v.\"SYS_CLOSETIME\" IS NOT NULL AND (v.\"SYS_PUBLISHTIME\" = to_timestamp('%4$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone OR \n                                            v.\"SYS_CLOSETIME\" = to_timestamp('%3$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone OR \n                                            '%4$s' = 'null' AND to_timestamp('%3$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone < v.\"SYS_CLOSETIME\" OR \n                                            (to_timestamp('%3$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, to_timestamp('%4$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone)\n                                            OVERLAPS \n                                            (v.\"SYS_PUBLISHTIME\", v.\"SYS_CLOSETIME\"))\n       );", StringUtils.addDoubleQuotes(versionTable), StringUtils.addDoubleQuotes(draftTable), QueryUtil.formatDateTime(publishTime), QueryUtil.formatDateTime(closeTime));
        return (BigInteger)this.entityManager.createNativeQuery(sql).getSingleResult();
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void insertOldDataFromVersion(String targetTable, String versionTable, String draftTable, List<String> fieldNames, int offset, int limit, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        String strColumns = QueryUtil.toStrColumns(fieldNames);
        String rowColumns = QueryUtil.toAliasColumns(fieldNames, "row.");
        String sql = String.format("DO $$DECLARE tbl_cursor refcursor;\n  row record;\n  i int;\n\nBEGIN \n    OPEN tbl_cursor FOR \n    SELECT \"SYS_RECORDID\", %7$s, \"FTS\", \"SYS_HASH\", \"SYS_PUBLISHTIME\", \"SYS_CLOSETIME\" \n      FROM data.%2$s v \n     WHERE NOT (\n           v.\"SYS_CLOSETIME\" IS NULL AND (to_timestamp('%9$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone >= v.\"SYS_PUBLISHTIME\" OR \n                                            to_timestamp('%9$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone < v.\"SYS_PUBLISHTIME\" AND \n                                            ('%10$s' = 'null' OR to_timestamp('%10$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone >= v.\"SYS_PUBLISHTIME\"))\n           OR \n           v.\"SYS_CLOSETIME\" IS NOT NULL AND (v.\"SYS_PUBLISHTIME\" = to_timestamp('%10$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone OR \n                                                v.\"SYS_CLOSETIME\" = to_timestamp('%9$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone OR \n                                                '%10$s' = 'null' AND to_timestamp('%9$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone < v.\"SYS_CLOSETIME\" OR \n                                                (to_timestamp('%9$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, to_timestamp('%10$s', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone)\n                                                OVERLAPS \n                                                (v.\"SYS_PUBLISHTIME\", v.\"SYS_CLOSETIME\"))\n           )\n     ORDER BY v.\"SYS_RECORDID\";\n\n    MOVE FORWARD %4$s FROM tbl_cursor;\n    i \\:= 0;\n    while i < %5$s loop \n       FETCH FROM tbl_cursor INTO row;\n       EXIT WHEN NOT FOUND;\n\n       row.\"SYS_RECORDID\" \\:= nextval('data.%6$s');\n       INSERT INTO data.%1$s(\"SYS_RECORDID\", %7$s, \"FTS\", \"SYS_HASH\", \"SYS_PUBLISHTIME\", \"SYS_CLOSETIME\") \n       VALUES (row.\"SYS_RECORDID\", %8$s, row.\"FTS\", row.\"SYS_HASH\", row.\"SYS_PUBLISHTIME\", row.\"SYS_CLOSETIME\");\n\n       i \\:= i + 1;\n    end loop;\n    CLOSE tbl_cursor;\nEND$$;", StringUtils.addDoubleQuotes(targetTable), StringUtils.addDoubleQuotes(versionTable), StringUtils.addDoubleQuotes(draftTable), offset, limit, StorageUtils.escapeSequenceName(targetTable), strColumns, rowColumns, QueryUtil.formatDateTime(publishTime), QueryUtil.formatDateTime(closeTime));
        if (logger.isDebugEnabled()) {
            logger.debug("insertOldDataFromVersion with sql: {}", (Object)sql);
        }
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    public BigInteger countClosedNowDataFromVersion(String versionTable, String draftTable, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("draftTable", StorageUtils.escapeTableName("data", draftTable));
        map.put("versionTable", StorageUtils.escapeTableName("data", versionTable));
        map.put("publishTime", QueryUtil.formatDateTime(publishTime));
        map.put("closeTime", QueryUtil.formatDateTime(closeTime));
        String sql = StringUtils.substitute("SELECT count(*) \nFROM ${versionTable} AS v\n WHERE (coalesce(to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, '-infinity'),\n        coalesce(to_timestamp('${closeTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, 'infinity'))\n       OVERLAPS \n       (v.\"SYS_PUBLISHTIME\", v.\"SYS_CLOSETIME\")\n   AND NOT exists(SELECT 1 FROM ${draftTable} AS d WHERE d.\"SYS_HASH\" = v.\"SYS_HASH\");", map);
        return (BigInteger)this.entityManager.createNativeQuery(sql).getSingleResult();
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void insertClosedNowDataFromVersion(String targetTable, String versionTable, String draftTable, Map<String, String> typedNames, int offset, int limit, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        String strColumns = QueryUtil.toStrColumns(typedNames);
        String typedColumns = QueryUtil.toTypedColumns(typedNames);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("targetTable", StorageUtils.escapeTableName("data", targetTable));
        map.put("draftTable", StorageUtils.escapeTableName("data", draftTable));
        map.put("versionTable", StorageUtils.escapeTableName("data", versionTable));
        map.put("publishTime", QueryUtil.formatDateTime(publishTime));
        map.put("closeTime", QueryUtil.formatDateTime(closeTime));
        map.put("strColumns", strColumns);
        map.put("offset", "" + offset);
        map.put("limit", "" + limit);
        map.put("typedColumns", typedColumns);
        map.put("sequenceName", StorageUtils.escapeSchemaSequenceName("data", targetTable));
        String sql = StringUtils.substitute("DO $$\nDECLARE tbl_cursor refcursor;\n  row record;\n  i int;\n\nBEGIN \n    OPEN tbl_cursor FOR \n    SELECT \"SYS_RECORDID\", ${strColumns}, \"FTS\", \"SYS_HASH\", \"SYS_PUBLISHTIME\", \"SYS_CLOSETIME\" \n      FROM ${versionTable} AS v \n     WHERE (coalesce(to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, '-infinity'),\n            coalesce(to_timestamp('${closeTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, 'infinity'))\n           OVERLAPS\n           (v.\"SYS_PUBLISHTIME\", v.\"SYS_CLOSETIME\")\n       AND NOT exists(SELECT 1 FROM ${draftTable} AS d WHERE d.\"SYS_HASH\" = v.\"SYS_HASH\")\n     ORDER BY v.\"SYS_RECORDID\";\n    MOVE FORWARD ${offset} FROM tbl_cursor;\n    i \\:= 0;\n    while i < ${limit} loop\n       FETCH FROM tbl_cursor INTO row;\n       EXIT WHEN NOT FOUND;\n\n       INSERT INTO ${targetTable}(\"SYS_RECORDID\", ${strColumns}, \"FTS\", \"SYS_HASH\", \"SYS_PUBLISHTIME\", \"SYS_CLOSETIME\")\n       SELECT \"SYS_RECORDID\", ${strColumns}, \"FTS\", \"SYS_HASH\", \"SYS_PUBLISHTIME\", \"SYS_CLOSETIME\" \n         FROM data.closed_now_records('\"SYS_RECORDID\", ${strColumns}, \"FTS\", \"SYS_HASH\",\n                   \"SYS_PUBLISHTIME\", \"SYS_CLOSETIME\"'\\:\\:text, row.\"SYS_RECORDID\", '${versionTable}'\\:\\:text,\n                   to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone,\n                   to_timestamp('${closeTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone,\n                   '${sequenceName}'\\:\\:text)\n              t(\"SYS_RECORDID\" bigint, ${typedColumns}, \"FTS\" tsvector, \"SYS_HASH\" character(32),\n                \"SYS_PUBLISHTIME\" timestamp without time zone, \"SYS_CLOSETIME\" timestamp without time zone);\n\n       i \\:= i + 1;\n    end loop;\n    CLOSE tbl_cursor;\nEND$$;", map);
        if (logger.isDebugEnabled()) {
            logger.debug("insertClosedNowDataFromVersion with sql: {}", (Object)sql);
        }
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    public BigInteger countNewValFromDraft(String draftTable, String versionTable, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("draftTable", StorageUtils.escapeTableName("data", draftTable));
        map.put("versionTable", StorageUtils.escapeTableName("data", versionTable));
        map.put("publishTime", QueryUtil.formatDateTime(publishTime));
        map.put("closeTime", QueryUtil.formatDateTime(closeTime));
        String sql = StringUtils.substitute("SELECT count(*) \n    FROM ${draftTable} d \n   WHERE NOT exists(\n         SELECT 1 \n           FROM ${versionTable} v \n          WHERE v.\"SYS_HASH\" = d.\"SYS_HASH\" \n            AND ( (coalesce(to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, '-infinity'),\n                   coalesce(to_timestamp('${closeTime}',   'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone,  'infinity'))\n                  OVERLAPS \n                  (coalesce(v.\"SYS_PUBLISHTIME\", '-infinity'), coalesce(v.\"SYS_CLOSETIME\", 'infinity'))\n               OR (coalesce(to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, '-infinity') =\n                   coalesce(v.\"SYS_CLOSETIME\", 'infinity')) )\n         )", map);
        return (BigInteger)this.entityManager.createNativeQuery(sql).getSingleResult();
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void insertNewDataFromDraft(String targetTable, String versionTable, String draftTable, List<String> fieldNames, int offset, int limit, LocalDateTime publishTime, LocalDateTime closeTime) {
        closeTime = closeTime == null ? PG_MAX_TIMESTAMP : closeTime;
        String strColumns = QueryUtil.toStrColumns(fieldNames);
        String rowColumns = QueryUtil.toAliasColumns(fieldNames, "row.");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fields", strColumns);
        map.put("draftTable", StorageUtils.escapeTableName("data", draftTable));
        map.put("versionTable", StorageUtils.escapeTableName("data", versionTable));
        map.put("publishTime", QueryUtil.formatDateTime(publishTime));
        map.put("closeTime", QueryUtil.formatDateTime(closeTime));
        map.put("limit", "" + limit);
        map.put("offset", "" + offset);
        map.put("sequenceName", StorageUtils.escapeSchemaSequenceName("data", targetTable));
        map.put("targetTable", StorageUtils.escapeTableName("data", targetTable));
        map.put("rowFields", rowColumns);
        String sql = StringUtils.substitute("DO $$\nDECLARE tbl_cursor refcursor;\n   row record;\n   i int;\n\nBEGIN \n    OPEN tbl_cursor FOR \n    SELECT \"SYS_RECORDID\", ${fields}, \"FTS\", \"SYS_HASH\"\n      FROM ${draftTable} d \n     WHERE NOT exists(\n           SELECT 1 FROM ${versionTable} v \n            WHERE v.\"SYS_HASH\" = d.\"SYS_HASH\"\n              AND ( (coalesce(to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, '-infinity'),\n                     coalesce(to_timestamp('${closeTime}',   'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone,  'infinity'))\n                    OVERLAPS \n                    (coalesce( v.\"SYS_PUBLISHTIME\", '-infinity'), coalesce(v.\"SYS_CLOSETIME\", 'infinity'))\n                 OR (coalesce(to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, '-infinity') =\n                     coalesce(v.\"SYS_CLOSETIME\", 'infinity')) )\n           )\n     ORDER BY d.\"SYS_RECORDID\"; \n    MOVE FORWARD ${offset} FROM tbl_cursor;\n    i \\:= 0;\n    while i < ${limit} loop \n       FETCH FROM tbl_cursor INTO row;\n       EXIT WHEN NOT FOUND;\n\n       row.\"SYS_RECORDID\" \\:= nextval('${sequenceName}');\n       INSERT INTO ${targetTable} (\"SYS_RECORDID\", ${fields}, \"FTS\", \"SYS_HASH\", \"SYS_PUBLISHTIME\", \"SYS_CLOSETIME\")\n       VALUES (row.\"SYS_RECORDID\", ${rowFields}, row.\"FTS\", row.\"SYS_HASH\", to_timestamp('${publishTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone, case when '${closeTime}' = 'null' then null\\:\\:timestamp without time zone else to_timestamp('${closeTime}', 'YYYY-MM-DD HH24:MI:SS')\\:\\:timestamp without time zone end);\n\n       i \\:= i + 1;\n    end loop;\n    CLOSE tbl_cursor;\nEND$$;", map);
        if (logger.isDebugEnabled()) {
            logger.debug("insertNewDataFromDraft with sql: {}", (Object)sql);
        }
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void deletePointRows(String targetCode) {
        String condition = StringUtils.addDoubleQuotes("SYS_PUBLISHTIME") + " = " + StringUtils.addDoubleQuotes("SYS_CLOSETIME");
        String sql = String.format("DELETE FROM %1$s.%2$s \n", StorageUtils.toSchemaName(targetCode), StringUtils.addDoubleQuotes(StorageUtils.toTableName(targetCode))) + " WHERE " + condition;
        if (logger.isDebugEnabled()) {
            logger.debug("deletePointRows method sql: {}", (Object)sql);
        }
        this.entityManager.createNativeQuery(sql).executeUpdate();
    }

    @Override
    public DataDifference getDataDifference(CompareDataCriteria criteria) {
        List nonPrimaryFields = criteria.getFields().stream().map(Field::getName).filter(name -> !criteria.getPrimaryFields().contains(name)).collect(Collectors.toList());
        String oldAlias = "t1";
        String oldStorageCode = criteria.getStorageCode();
        String oldSchemaName = StorageUtils.toSchemaName(oldStorageCode);
        String oldTableName = StorageUtils.toTableName(oldStorageCode);
        String newAlias = "t2";
        String newStorageCode = criteria.getNewStorageCode() != null ? criteria.getNewStorageCode() : oldStorageCode;
        String newSchemaName = StorageUtils.toSchemaName(newStorageCode);
        String newTableName = StorageUtils.toTableName(newStorageCode);
        EnumSet<FieldValuePartEnum> valueParts = EnumSet.noneOf(FieldValuePartEnum.class);
        String oldDataFields = QueryUtil.toSelectedFields(oldAlias, criteria.getFields(), valueParts);
        String newDataFields = QueryUtil.toSelectedFields(newAlias, criteria.getFields(), valueParts);
        String dataSelectFormat = "SELECT %1$s AS sysId1 \n %2$s\n, %3$s AS sysId2 \n %4$s \n";
        String dataSelect = String.format(dataSelectFormat, StorageUtils.escapeFieldName(oldAlias, "SYS_RECORDID"), StringUtils.isNullOrEmpty(oldDataFields) ? "" : ", " + oldDataFields, StorageUtils.escapeFieldName(newAlias, "SYS_RECORDID"), StringUtils.isNullOrEmpty(newDataFields) ? "" : ", " + newDataFields);
        String primaryEquality = criteria.getPrimaryFields().stream().map(field -> StorageUtils.escapeFieldName(oldAlias, field) + " = " + StorageUtils.escapeFieldName(newAlias, field)).collect(Collectors.joining(" AND ")) + " \n";
        HashMap<String, Object> params = new HashMap<String, Object>();
        String oldPrimaryValuesFilter = this.makeFieldValuesFilter(oldAlias, params, criteria.getPrimaryFieldsFilters());
        String newPrimaryValuesFilter = this.makeFieldValuesFilter(newAlias, params, criteria.getPrimaryFieldsFilters());
        String nonPrimaryFieldsInequality = org.springframework.util.CollectionUtils.isEmpty(nonPrimaryFields) ? " AND false " : " AND (" + nonPrimaryFields.stream().map(field -> StorageUtils.escapeFieldName(oldAlias, field) + " is distinct from " + StorageUtils.escapeFieldName(newAlias, field)).collect(Collectors.joining(" OR ")) + ") ";
        String oldPrimaryIsNull = criteria.getPrimaryFields().stream().map(field -> StorageUtils.escapeFieldName(oldAlias, field) + " is null ").collect(Collectors.joining(" AND "));
        String newPrimaryIsNull = criteria.getPrimaryFields().stream().map(field -> StorageUtils.escapeFieldName(newAlias, field) + " is null ").collect(Collectors.joining(" AND "));
        String datesFilterFormat = " and date_trunc('second', %1$s) <= :%2$s\\:\\:timestamp without time zone \n and date_trunc('second', %3$s) >= :%4$s\\:\\:timestamp without time zone \n";
        String oldVersionDateFilter = "";
        if (criteria.getOldPublishDate() != null || criteria.getOldCloseDate() != null) {
            oldVersionDateFilter = String.format(" and date_trunc('second', %1$s) <= :%2$s\\:\\:timestamp without time zone \n and date_trunc('second', %3$s) >= :%4$s\\:\\:timestamp without time zone \n", StorageUtils.escapeFieldName(oldAlias, "SYS_PUBLISHTIME"), "oldPublishDate", StorageUtils.escapeFieldName(oldAlias, "SYS_CLOSETIME"), "oldCloseDate");
            params.put("oldPublishDate", QueryUtil.truncateDateTo(criteria.getOldPublishDate(), ChronoUnit.SECONDS, "'-infinity'"));
            params.put("oldCloseDate", QueryUtil.truncateDateTo(criteria.getOldCloseDate(), ChronoUnit.SECONDS, PG_MAX_TIMESTAMP));
        }
        String newVersionDateFilter = "";
        if (criteria.getNewPublishDate() != null || criteria.getNewCloseDate() != null) {
            newVersionDateFilter = String.format(" and date_trunc('second', %1$s) <= :%2$s\\:\\:timestamp without time zone \n and date_trunc('second', %3$s) >= :%4$s\\:\\:timestamp without time zone \n", StorageUtils.escapeFieldName(newAlias, "SYS_PUBLISHTIME"), "newPublishDate", StorageUtils.escapeFieldName(newAlias, "SYS_CLOSETIME"), "newCloseDate");
            params.put("newPublishDate", QueryUtil.truncateDateTo(criteria.getNewPublishDate(), ChronoUnit.SECONDS, "'-infinity'"));
            params.put("newCloseDate", QueryUtil.truncateDateTo(criteria.getNewCloseDate(), ChronoUnit.SECONDS, PG_MAX_TIMESTAMP));
        }
        String joinType = this.diffReturnTypeToJoinType(criteria.getReturnType());
        String fromJoinFormat = "  FROM %1$s AS %2$s \n  %3$s JOIN %4$s AS %5$s \n    ON %6$s";
        String fromJoin = String.format("  FROM %1$s AS %2$s \n  %3$s JOIN %4$s AS %5$s \n    ON %6$s", StorageUtils.escapeTableName(oldSchemaName, oldTableName), oldAlias, joinType, StorageUtils.escapeTableName(newSchemaName, newTableName), newAlias, primaryEquality);
        String sql = fromJoin + " AND (true " + oldPrimaryValuesFilter + " OR true " + newPrimaryValuesFilter + ")" + oldVersionDateFilter + newVersionDateFilter + " WHERE ";
        if (criteria.getStatus() == null) {
            sql = sql + oldPrimaryIsNull + newVersionDateFilter + " OR " + newPrimaryIsNull + oldVersionDateFilter + " OR (" + primaryEquality + nonPrimaryFieldsInequality + ") ";
        } else if (DiffStatusEnum.UPDATED.equals((Object)criteria.getStatus())) {
            sql = sql + primaryEquality + nonPrimaryFieldsInequality;
        } else if (DiffStatusEnum.INSERTED.equals((Object)criteria.getStatus())) {
            sql = sql + oldPrimaryIsNull + newVersionDateFilter;
        } else if (DiffStatusEnum.DELETED.equals((Object)criteria.getStatus())) {
            sql = sql + newPrimaryIsNull + oldVersionDateFilter;
        }
        QueryWithParams countQueryWithParams = new QueryWithParams("SELECT count(*) \n" + sql, params);
        Query countQuery = countQueryWithParams.createQuery(this.entityManager);
        BigInteger count = (BigInteger)countQuery.getSingleResult();
        if (Boolean.TRUE.equals(criteria.getCountOnly())) {
            return new DataDifference(new CollectionPage(count.intValue(), null, (Criteria)criteria));
        }
        String orderBy = " ORDER BY " + criteria.getPrimaryFields().stream().map(field -> StorageUtils.escapeFieldName(newAlias, field)).collect(Collectors.joining(", ")) + ", " + criteria.getPrimaryFields().stream().map(field -> StorageUtils.escapeFieldName(oldAlias, field)).collect(Collectors.joining(", ")) + ", " + StorageUtils.escapeFieldName(newAlias, "SYS_RECORDID") + ", " + StorageUtils.escapeFieldName(oldAlias, "SYS_RECORDID");
        QueryWithParams dataQueryWithParams = new QueryWithParams(dataSelect + sql + orderBy, params);
        Query dataQuery = dataQueryWithParams.createQuery(this.entityManager).setFirstResult(criteria.getOffset()).setMaxResults(criteria.getSize());
        List resultList = dataQuery.getResultList();
        List<DiffRowValue> diffRowValues = CompareUtil.toDiffRowValues(criteria.getFields(), resultList, criteria);
        return new DataDifference(new CollectionPage(count.intValue(), diffRowValues, (Criteria)criteria));
    }

    private String diffReturnTypeToJoinType(DiffReturnTypeEnum typeEnum) {
        switch (typeEnum) {
            case NEW: {
                return "RIGHT";
            }
            case OLD: {
                return "LEFT";
            }
        }
        return "FULL";
    }

    private String makeFieldValuesFilter(String alias, Map<String, Object> params, Set<List<FieldSearchCriteria>> fieldFilters) {
        QueryWithParams query = this.getWhereByFilters(fieldFilters, alias);
        if (query == null || StringUtils.isNullOrEmpty(query.getSql())) {
            return "";
        }
        if (!CollectionUtils.isNullOrEmpty(query.getParams())) {
            params.putAll(query.getParams());
        }
        return query.getSql();
    }

    protected String getSchemaName(String schemaName) {
        return StorageUtils.getSchemaNameOrDefault(schemaName);
    }

    protected String getTableSchemaName(String schemaName, String tableName) {
        return !StringUtils.isNullOrEmpty(tableName) ? this.getSchemaName(schemaName) : "data";
    }

    private String getStorageCodeSchemaName(String storageCode) {
        return this.getTableSchemaName(StorageUtils.toSchemaName(storageCode), StorageUtils.toTableName(storageCode));
    }
}

