/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.dao;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import ru.i_novus.platform.datastorage.temporal.util.CollectionUtils;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.QueryUtil;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StringUtils;

public class QueryWithParams {
    private String sql;
    private Map<String, Object> params;

    public QueryWithParams() {
        this("", null);
    }

    public QueryWithParams(String sql) {
        this(sql, null);
    }

    public QueryWithParams(String sql, Map<String, Object> params) {
        this.sql = sql;
        this.params = params;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void concat(String sql) {
        if (StringUtils.isNullOrEmpty(sql)) {
            return;
        }
        this.sql = this.sql + " " + sql;
    }

    public void concat(Map<String, Object> params) {
        if (CollectionUtils.isNullOrEmpty(params)) {
            return;
        }
        if (this.params == null) {
            this.params = new HashMap<String, Object>(params);
        } else {
            this.params.putAll(params);
        }
    }

    public void concat(String sql, Map<String, Object> params) {
        this.concat(sql);
        this.concat(params);
    }

    public void concat(QueryWithParams queryWithParams) {
        if (queryWithParams == null) {
            return;
        }
        this.concat(queryWithParams.getSql(), queryWithParams.getParams());
    }

    public String getBindedSql() {
        if (StringUtils.isNullOrEmpty(this.sql)) {
            return null;
        }
        if (CollectionUtils.isNullOrEmpty(this.params)) {
            return this.sql;
        }
        String result = this.sql;
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            result = result.replace(":" + entry.getKey(), this.paramToString(entry.getValue()));
        }
        return result;
    }

    private String paramToString(Object param) {
        if (param == null) {
            return "null";
        }
        if (param instanceof Number) {
            return param.toString();
        }
        if (param instanceof LocalDateTime) {
            return QueryUtil.toTimestampWithoutTimeZone(QueryUtil.formatDateTime((LocalDateTime)param));
        }
        return StringUtils.addSingleQuotes(param.toString());
    }

    public Query createQuery(EntityManager entityManager) {
        Query query = entityManager.createNativeQuery(this.getSql());
        this.fillQueryParameters(query);
        return query;
    }

    public void fillQueryParameters(Query query) {
        if (this.getParams() == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : this.getParams().entrySet()) {
            query = query.setParameter(entry.getKey(), entry.getValue());
        }
    }
}

