/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.dao;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StringUtils;

public class StorageConstants {
    private static final String SCHEMA_NAME_REGEX = "[a-z][a-z\\d_]{0,62}";
    public static final Pattern SCHEMA_NAME_PATTERN = Pattern.compile("[a-z][a-z\\d_]{0,62}");
    public static final String CODE_SEPARATOR = ".";
    public static final String NAME_SEPARATOR = ".";
    public static final String NAME_CONNECTOR = "_";
    public static final String DATA_SCHEMA_NAME = "data";
    public static final String TABLE_SEQUENCE_SUFFIX = "_seq";
    public static final String TABLE_INDEX_SUFFIX = "_idx";
    public static final String SYS_PRIMARY_COLUMN = "SYS_RECORDID";
    public static final String SYS_PUBLISHTIME = "SYS_PUBLISHTIME";
    public static final String SYS_CLOSETIME = "SYS_CLOSETIME";
    public static final String SYS_HASH = "SYS_HASH";
    public static final String SYS_PATH = "SYS_PATH";
    public static final String SYS_FTS = "FTS";
    private static final List<String> SYS_FIELD_NAMES = Arrays.asList("SYS_RECORDID", "SYS_HASH", "SYS_PATH", "FTS", "SYS_PUBLISHTIME", "SYS_CLOSETIME");
    private static final List<String> VERSIONED_SYS_FIELD_NAMES = Arrays.asList("SYS_PUBLISHTIME", "SYS_CLOSETIME");
    private static final List<String> ESCAPED_VERSIONED_SYS_FIELD_NAMES = VERSIONED_SYS_FIELD_NAMES.stream().map(StringUtils::addDoubleQuotes).collect(Collectors.toList());
    private static final List<String> TRIGGERED_SYS_FIELD_NAMES = Arrays.asList("SYS_HASH", "FTS");
    private static final List<String> ESCAPED_TRIGGERED_SYS_FIELD_NAMES = TRIGGERED_SYS_FIELD_NAMES.stream().map(StringUtils::addDoubleQuotes).collect(Collectors.toList());
    public static final String REFERENCE_VALUE_NAME = "value";
    public static final String REFERENCE_DISPLAY_VALUE_NAME = "displayValue";
    public static final String REFERENCE_HASH_NAME = "hash";

    private StorageConstants() {
    }

    public static List<String> systemFieldNames() {
        return SYS_FIELD_NAMES;
    }

    public static List<String> versionedFieldNames() {
        return VERSIONED_SYS_FIELD_NAMES;
    }

    public static List<String> escapedVersionedFieldNames() {
        return ESCAPED_VERSIONED_SYS_FIELD_NAMES;
    }

    public static List<String> escapedTriggeredFieldNames() {
        return ESCAPED_TRIGGERED_SYS_FIELD_NAMES;
    }
}

