/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.service;

import java.math.BigInteger;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.PersistenceException;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.i_novus.components.common.exception.CodifiedException;
import ru.i_novus.platform.datastorage.temporal.exception.ListCodifiedException;
import ru.i_novus.platform.datastorage.temporal.exception.NotUniqueException;
import ru.i_novus.platform.datastorage.temporal.model.Field;
import ru.i_novus.platform.datastorage.temporal.model.criteria.StorageCopyRequest;
import ru.i_novus.platform.datastorage.temporal.model.value.ReferenceFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.RowValue;
import ru.i_novus.platform.datastorage.temporal.service.DraftDataService;
import ru.i_novus.platform.datastorage.temporal.util.CollectionUtils;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.DataDao;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.StorageConstants;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.BooleanField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.TreeField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.QueryUtil;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StorageUtils;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StringUtils;

public class DraftDataServiceImpl
implements DraftDataService {
    private static final Logger logger = LoggerFactory.getLogger(DraftDataServiceImpl.class);
    private final DataDao dataDao;

    public DraftDataServiceImpl(DataDao dataDao) {
        this.dataDao = dataDao;
    }

    @Transactional
    public String createDraft(List<Field> fields) {
        return this.createDraft(null, fields);
    }

    @Transactional
    public String createDraft(String schemaName, List<Field> fields) {
        String draftCode = StorageUtils.generateStorageName();
        this.createDraftTable(StorageUtils.toStorageCode(schemaName, draftCode), fields);
        return draftCode;
    }

    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public String applyDraft(String baseStorageCode, String draftCode, LocalDateTime publishTime) {
        return this.applyDraft(baseStorageCode, draftCode, publishTime, null);
    }

    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public String applyDraft(String baseStorageCode, String draftCode, LocalDateTime publishTime, LocalDateTime closeTime) {
        if (!this.storageExists(draftCode)) {
            throw new IllegalArgumentException("draft.table.does.not.exist");
        }
        String targetCode = this.createVersionTable(draftCode);
        List<String> fieldNames = this.dataDao.getEscapedFieldNames(draftCode);
        if (!StringUtils.isNullOrEmpty(baseStorageCode) && this.dataDao.storageStructureEquals(baseStorageCode, draftCode)) {
            this.insertActualDataFromVersion(baseStorageCode, draftCode, targetCode, fieldNames, publishTime, closeTime);
            this.insertOldDataFromVersion(baseStorageCode, draftCode, targetCode, fieldNames, publishTime, closeTime);
            this.insertClosedNowDataFromVersion(baseStorageCode, draftCode, targetCode, fieldNames, publishTime, closeTime);
            this.insertNewDataFromDraft(baseStorageCode, draftCode, targetCode, fieldNames, publishTime, closeTime);
            this.dataDao.deletePointRows(targetCode);
        } else {
            this.insertAllDataFromDraft(draftCode, targetCode, fieldNames, publishTime, closeTime);
        }
        return targetCode;
    }

    public boolean storageExists(String storageCode) {
        return this.dataDao.storageExists(storageCode);
    }

    public void addRows(String draftCode, List<RowValue> rowValues) {
        this.insertData(draftCode, rowValues);
    }

    protected List<String> insertData(String draftCode, List<RowValue> rowValues) {
        try {
            return this.dataDao.insertData(draftCode, rowValues);
        }
        catch (PersistenceException pe) {
            throw this.transformException(pe);
        }
    }

    public void updateRows(String draftCode, List<RowValue> rowValues) {
        this.updateData(draftCode, rowValues);
    }

    protected List<String> updateData(String draftCode, List<RowValue> rowValues) {
        this.validateUpdateData(rowValues);
        ArrayList<String> hashes = new ArrayList<String>(rowValues.size());
        rowValues.forEach(rowValue -> {
            String hash = this.dataDao.updateData(draftCode, (RowValue)rowValue);
            hashes.add(hash);
        });
        return hashes;
    }

    private void validateUpdateData(List<RowValue> rowValues) {
        ArrayList<CodifiedException> exceptions = new ArrayList<CodifiedException>();
        if (rowValues.stream().anyMatch(rowValue -> rowValue.getSystemId() == null)) {
            exceptions.add(new CodifiedException("nsi.core.data.loader.fieldIsRequired", new Object[]{"SYS_RECORDID"}));
        }
        if (!exceptions.isEmpty()) {
            throw new ListCodifiedException(exceptions);
        }
    }

    public void deleteRows(String draftCode, List<Object> systemIds) {
        this.deleteData(draftCode, systemIds);
    }

    protected List<String> deleteData(String draftCode, List<Object> systemIds) {
        return this.dataDao.deleteData(draftCode, systemIds);
    }

    public void deleteAllRows(String draftCode) {
        this.dataDao.deleteData(draftCode);
    }

    public void loadData(String draftCode, String sourceCode, LocalDateTime onDate) {
        this.loadData(draftCode, sourceCode, onDate, null);
    }

    public void loadData(String draftCode, String sourceCode, LocalDateTime fromDate, LocalDateTime toDate) {
        List<String> draftFieldNames = this.dataDao.getAllEscapedFieldNames(draftCode);
        List<String> sourceFieldNames = this.dataDao.getAllEscapedFieldNames(sourceCode);
        List<String> versionedFieldNames = StorageConstants.escapedVersionedFieldNames();
        sourceFieldNames.removeIf(versionedFieldNames::contains);
        if (!draftFieldNames.equals(sourceFieldNames)) {
            throw new CodifiedException("nsi.core.data.loader.structure.notEqual", new Object[0]);
        }
        this.copyTableData(sourceCode, draftCode, draftFieldNames, fromDate, toDate);
        this.dataDao.updateTableSequence(draftCode);
    }

    public void copyAllData(String sourceCode, String targetCode) {
        List<String> fieldNames = this.dataDao.getAllCommonFieldNames(sourceCode, targetCode);
        this.copyTableData(sourceCode, targetCode, fieldNames, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTableData(String sourceCode, String targetCode, List<String> fieldNames, LocalDateTime fromDate, LocalDateTime toDate) {
        boolean isTriggersRedundant;
        BigInteger count = this.dataDao.countData(sourceCode);
        if (BigInteger.ZERO.equals(count)) {
            return;
        }
        if (this.dataDao.hasData(targetCode)) {
            throw new CodifiedException("target.table.is.not.empty", new Object[0]);
        }
        boolean bl = isTriggersRedundant = CollectionUtils.isNullOrEmpty(fieldNames) || fieldNames.containsAll(StorageConstants.escapedTriggeredFieldNames());
        if (isTriggersRedundant) {
            this.dataDao.disableTriggers(targetCode);
        }
        try {
            StorageCopyRequest request = new StorageCopyRequest(sourceCode, targetCode, fromDate, toDate, null);
            request.setEscapedFieldNames(fieldNames);
            request.setCount(Integer.valueOf(count.intValue()));
            request.setSize(1000);
            int pageCount = request.getPageCount();
            for (int page = 0; page < pageCount; ++page) {
                request.setPage(page + 1);
                this.dataDao.copyTableData(request);
            }
        }
        finally {
            if (isTriggersRedundant) {
                this.dataDao.enableTriggers(targetCode);
            }
        }
    }

    public void updateReferenceInRows(String storageCode, ReferenceFieldValue fieldValue, List<Object> systemIds) {
        this.dataDao.updateReferenceInRows(storageCode, fieldValue, systemIds);
    }

    public void updateReferenceInRefRows(String storageCode, ReferenceFieldValue fieldValue, LocalDateTime publishTime, LocalDateTime closeTime) {
        BigInteger count = this.dataDao.countReferenceInRefRows(storageCode, fieldValue);
        for (int i = 0; i < count.intValue(); i += 1000) {
            this.dataDao.updateReferenceInRefRows(storageCode, fieldValue, i, 1000);
        }
    }

    @Transactional
    public void addField(String draftCode, Field field) {
        if (this.dataDao.getSystemFieldNames().contains(field.getName())) {
            throw new CodifiedException("nsi.core.data.field.sysConflict", new Object[0]);
        }
        List<String> fieldNames = this.dataDao.getEscapedFieldNames(draftCode);
        if (fieldNames.contains(StringUtils.addDoubleQuotes(field.getName()))) {
            throw new CodifiedException("nsi.core.data.loader.field.duplicate", new Object[0]);
        }
        this.dataDao.dropTriggers(draftCode);
        String defaultValue = field instanceof BooleanField ? "false" : null;
        this.dataDao.addColumn(draftCode, field.getName(), field.getType(), defaultValue);
        fieldNames = this.dataDao.getHashUsedFieldNames(draftCode);
        this.dataDao.createTriggers(draftCode, fieldNames);
        this.dataDao.updateHashRows(draftCode, fieldNames);
    }

    @Transactional
    public void updateField(String draftCode, Field field) {
        String newType;
        String oldType = this.dataDao.getFieldType(draftCode, field.getName());
        if (oldType.equals(newType = field.getType())) {
            return;
        }
        try {
            this.dataDao.dropTriggers(draftCode);
            this.dataDao.alterDataType(draftCode, field.getName(), oldType, newType);
            List<String> fieldNames = this.dataDao.getHashUsedFieldNames(draftCode);
            this.dataDao.createTriggers(draftCode, fieldNames);
        }
        catch (PersistenceException pe) {
            throw new CodifiedException("nsi.core.data.loader.incompatibleNewDataType", (Throwable)pe, new Object[]{field.getName()});
        }
    }

    @Transactional
    public void deleteField(String draftCode, String fieldName) {
        List<String> fieldNames = this.dataDao.getEscapedFieldNames(draftCode);
        if (!fieldNames.contains(StringUtils.addDoubleQuotes(fieldName))) {
            throw new CodifiedException("nsi.core.data.field.notExists", new Object[0]);
        }
        this.dataDao.dropTriggers(draftCode);
        this.dataDao.deleteColumn(draftCode, fieldName);
        this.dataDao.deleteEmptyRows(draftCode);
        fieldNames = this.dataDao.getHashUsedFieldNames(draftCode);
        if (CollectionUtils.isNullOrEmpty(fieldNames)) {
            return;
        }
        this.dataDao.createTriggers(draftCode, fieldNames);
        try {
            this.dataDao.updateHashRows(draftCode, fieldNames);
        }
        catch (PersistenceException pe) {
            throw this.transformException(pe);
        }
        this.dataDao.updateFtsRows(draftCode, fieldNames);
    }

    public boolean isFieldNotEmpty(String storageCode, String fieldName) {
        return this.dataDao.isFieldNotNull(storageCode, fieldName);
    }

    public boolean isFieldContainEmptyValues(String storageCode, String fieldName) {
        return this.dataDao.isFieldContainNullValues(storageCode, fieldName);
    }

    public boolean isFieldUnique(String storageCode, String fieldName, LocalDateTime publishTime) {
        return this.dataDao.isUnique(storageCode, Collections.singletonList(fieldName), publishTime);
    }

    public boolean isUnique(String storageCode, List<String> fieldNames) {
        return this.dataDao.isUnique(storageCode, fieldNames, null);
    }

    private void createDraftTable(String draftCode, List<Field> fields) {
        List<String> systemFieldNames = this.dataDao.getSystemFieldNames();
        if (fields.stream().anyMatch(field -> systemFieldNames.contains(field.getName()))) {
            throw new CodifiedException("nsi.core.data.field.sysConflict", new Object[0]);
        }
        logger.debug("creating table with name: {}", (Object)draftCode);
        this.dataDao.createDraftTable(draftCode, fields);
        if (!fields.isEmpty()) {
            List<String> fieldNames = fields.stream().map(QueryUtil::getHashUsedFieldName).collect(Collectors.toList());
            Collections.sort(fieldNames);
            this.dataDao.createTriggers(draftCode, fieldNames);
            for (Field field2 : fields) {
                String fieldName = field2.getName();
                if (field2 instanceof TreeField) {
                    this.dataDao.createLtreeIndex(draftCode, fieldName);
                    continue;
                }
                if (!Boolean.TRUE.equals(field2.getSearchEnabled())) continue;
                this.dataDao.createFieldIndex(draftCode, fieldName);
            }
        }
        this.dataDao.createFtsIndex(draftCode);
    }

    private String createVersionTable(String draftCode) {
        String versionName = StorageUtils.generateStorageName();
        String versionCode = StorageUtils.toStorageCode(StorageUtils.toSchemaName(draftCode), versionName);
        this.dataDao.copyTable(draftCode, versionCode);
        this.dataDao.addVersionedInformation(versionCode);
        List<String> fieldNames = this.dataDao.getHashUsedFieldNames(versionName);
        this.dataDao.createTriggers(versionName, fieldNames);
        return versionCode;
    }

    private void insertAllDataFromDraft(String draftCode, String targetCode, List<String> fieldNames, LocalDateTime publishTime, LocalDateTime closeTime) {
        fieldNames.add(StringUtils.addDoubleQuotes("FTS"));
        BigInteger count = this.dataDao.countData(draftCode);
        for (int offset = 0; offset < count.intValue(); offset += 1000) {
            this.dataDao.insertAllDataFromDraft(draftCode, targetCode, fieldNames, offset, 1000, publishTime, closeTime);
        }
    }

    private void insertActualDataFromVersion(String versionCode, String draftCode, String targetCode, List<String> fieldNames, LocalDateTime publishTime, LocalDateTime closeTime) {
        Map<String, String> dataTypes = this.dataDao.getColumnDataTypes(versionCode);
        LinkedHashMap<String, String> typedNames = new LinkedHashMap<String, String>();
        fieldNames.forEach(column -> typedNames.put((String)column, (String)dataTypes.get(column.replace("\"", ""))));
        BigInteger count = this.dataDao.countActualDataFromVersion(versionCode, draftCode, publishTime, closeTime);
        for (int offset = 0; offset < count.intValue(); offset += 1000) {
            this.dataDao.insertActualDataFromVersion(targetCode, versionCode, draftCode, typedNames, offset, 1000, publishTime, closeTime);
        }
    }

    private void insertOldDataFromVersion(String versionCode, String draftCode, String targetCode, List<String> fieldNames, LocalDateTime publishTime, LocalDateTime closeTime) {
        BigInteger count = this.dataDao.countOldDataFromVersion(versionCode, draftCode, publishTime, closeTime);
        for (int offset = 0; offset < count.intValue(); offset += 1000) {
            this.dataDao.insertOldDataFromVersion(targetCode, versionCode, draftCode, fieldNames, offset, 1000, publishTime, closeTime);
        }
    }

    private void insertClosedNowDataFromVersion(String versionCode, String draftCode, String targetCode, List<String> fieldNames, LocalDateTime publishTime, LocalDateTime closeTime) {
        Map<String, String> dataTypes = this.dataDao.getColumnDataTypes(versionCode);
        LinkedHashMap<String, String> typedNames = new LinkedHashMap<String, String>();
        fieldNames.forEach(column -> typedNames.put((String)column, (String)dataTypes.get(column.replace("\"", ""))));
        BigInteger count = this.dataDao.countClosedNowDataFromVersion(versionCode, draftCode, publishTime, closeTime);
        for (int offset = 0; offset < count.intValue(); offset += 1000) {
            this.dataDao.insertClosedNowDataFromVersion(targetCode, versionCode, draftCode, typedNames, offset, 1000, publishTime, closeTime);
        }
    }

    private void insertNewDataFromDraft(String versionCode, String draftCode, String targetCode, List<String> fieldNames, LocalDateTime publishTime, LocalDateTime closeTime) {
        BigInteger count = this.dataDao.countNewValFromDraft(draftCode, versionCode, publishTime, closeTime);
        for (int offset = 0; offset < count.intValue(); offset += 1000) {
            this.dataDao.insertNewDataFromDraft(targetCode, versionCode, draftCode, fieldNames, offset, 1000, publishTime, closeTime);
        }
    }

    private RuntimeException transformException(PersistenceException exception) {
        SQLException sqlException = Optional.of(exception).map(Throwable::getCause).map(Throwable::getCause).filter(e -> e instanceof SQLException).orElse(null);
        String uniqueViolationErrorCode = "23505";
        if (sqlException != null && "23505".equals(sqlException.getSQLState())) {
            return new NotUniqueException("nsi.core.data.loader.not.unique.row", new Object[0]);
        }
        return exception;
    }
}

