/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.service;

import ru.i_novus.platform.datastorage.temporal.enums.FieldType;
import ru.i_novus.platform.datastorage.temporal.model.Field;
import ru.i_novus.platform.datastorage.temporal.service.FieldFactory;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.BooleanField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.DateField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.FloatField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.IntegerField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.ReferenceField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.StringField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.TreeField;

public class FieldFactoryImpl
implements FieldFactory {
    public Field createField(String name, FieldType type) {
        switch (type) {
            case BOOLEAN: {
                return new BooleanField(name);
            }
            case DATE: {
                return new DateField(name);
            }
            case FLOAT: {
                return new FloatField(name);
            }
            case INTEGER: {
                return new IntegerField(name);
            }
            case REFERENCE: {
                ReferenceField ref = new ReferenceField(name);
                ref.setSearchEnabled(true);
                return ref;
            }
            case TREE: {
                TreeField tree = new TreeField(name);
                tree.setSearchEnabled(true);
                return tree;
            }
        }
        return new StringField(name);
    }

    public Field createUniqueField(String name, FieldType type) {
        Field field = this.createField(name, type);
        field.setUnique(Boolean.valueOf(true));
        return field;
    }

    public Field createSearchField(String name, FieldType type) {
        Field field = this.createField(name, type);
        field.setSearchEnabled(Boolean.valueOf(true));
        return field;
    }
}

