/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.service;

import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.api.Criteria;
import ru.i_novus.platform.datastorage.temporal.model.criteria.StorageDataCriteria;
import ru.i_novus.platform.datastorage.temporal.model.value.RowValue;
import ru.i_novus.platform.datastorage.temporal.service.SearchDataService;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.DataDao;

public class SearchDataServiceImpl
implements SearchDataService {
    private final DataDao dataDao;

    public SearchDataServiceImpl(DataDao dataDao) {
        this.dataDao = dataDao;
    }

    public CollectionPage<RowValue> getPagedData(StorageDataCriteria criteria) {
        Integer count = criteria.getCount();
        if (count == null) {
            BigInteger dataCount = this.dataDao.getDataCount(criteria);
            count = dataCount.intValue();
            criteria.setCount(count);
        }
        if (count == 0) {
            return new CollectionPage(count.intValue(), Collections.emptyList(), (Criteria)criteria);
        }
        List<RowValue> data = this.dataDao.getData(criteria);
        return new CollectionPage(criteria.getCount().intValue(), data, (Criteria)criteria);
    }

    public List<RowValue> getData(StorageDataCriteria criteria) {
        criteria.makeUnpaged();
        return this.dataDao.getData(criteria);
    }

    public boolean hasData(String storageCode) {
        return this.dataDao.hasData(storageCode);
    }

    public RowValue findRow(String storageCode, List<String> fields, Object systemId) {
        return this.dataDao.getRowData(storageCode, fields, systemId);
    }

    public List<RowValue> findRows(String storageCode, List<String> fields, List<Object> systemIds) {
        return this.dataDao.getRowData(storageCode, fields, systemIds);
    }

    public List<String> findExistentHashes(String storageCode, LocalDateTime bdate, LocalDateTime edate, List<String> hashList) {
        return this.dataDao.findExistentHashes(storageCode, bdate, edate, hashList);
    }
}

