/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.service;

import java.util.List;
import javax.transaction.Transactional;
import ru.i_novus.platform.datastorage.temporal.model.Field;
import ru.i_novus.platform.datastorage.temporal.service.DraftDataService;
import ru.i_novus.platform.datastorage.temporal.service.StorageService;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.DataDao;

public class StorageServiceImpl
implements StorageService {
    private final DataDao dataDao;
    private final DraftDataService draftDataService;

    public StorageServiceImpl(DataDao dataDao, DraftDataService draftDataService) {
        this.dataDao = dataDao;
        this.draftDataService = draftDataService;
    }

    @Transactional
    public String createStorage(List<Field> fields) {
        return this.createStorage(null, fields);
    }

    @Transactional
    public String createStorage(String schemaName, List<Field> fields) {
        String draftCode = this.draftDataService.createDraft(schemaName, fields);
        List<String> fieldNames = this.dataDao.getHashUsedFieldNames(draftCode);
        if (!fieldNames.isEmpty()) {
            this.dataDao.dropTriggers(draftCode);
        }
        this.dataDao.addVersionedInformation(draftCode);
        if (!fieldNames.isEmpty()) {
            this.dataDao.createTriggers(draftCode, fieldNames);
        }
        return draftCode;
    }
}

