/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import ru.i_novus.platform.datastorage.temporal.enums.DiffStatusEnum;
import ru.i_novus.platform.datastorage.temporal.model.Field;
import ru.i_novus.platform.datastorage.temporal.model.criteria.CompareDataCriteria;
import ru.i_novus.platform.datastorage.temporal.model.value.DiffFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.DiffRowValue;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.QueryUtil;

public class CompareUtil {
    private CompareUtil() {
        throw new UnsupportedOperationException();
    }

    public static List<DiffRowValue> toDiffRowValues(List<Field> fields, List<Object[]> dataList, CompareDataCriteria criteria) {
        ArrayList<DiffRowValue> result = new ArrayList<DiffRowValue>();
        if (dataList.isEmpty()) {
            return result;
        }
        List primaryFields = criteria.getPrimaryFields();
        for (Object[] row : dataList) {
            int i = 1;
            ArrayList<DiffFieldValue> fieldValues = new ArrayList<DiffFieldValue>();
            DiffStatusEnum rowStatus = null;
            for (Field field : fields) {
                DiffFieldValue fieldValue = new DiffFieldValue();
                fieldValue.setField(field);
                fieldValue.setOldValue(QueryUtil.toValueByField(field, row[i]));
                fieldValue.setNewValue(QueryUtil.toValueByField(field, row[row.length / 2 + i]));
                if (primaryFields.contains(field.getName())) {
                    rowStatus = CompareUtil.diffFieldValueToStatusEnum(fieldValue, rowStatus);
                }
                fieldValues.add(fieldValue);
                ++i;
            }
            for (DiffFieldValue fieldValue : fieldValues) {
                CompareUtil.fillDiffFieldValueByStatus(fieldValue, rowStatus);
            }
            result.add(new DiffRowValue(fieldValues, rowStatus));
        }
        return result;
    }

    private static void fillDiffFieldValueByStatus(DiffFieldValue fieldValue, DiffStatusEnum rowStatus) {
        if (DiffStatusEnum.INSERTED.equals((Object)rowStatus)) {
            fieldValue.setStatus(DiffStatusEnum.INSERTED);
        } else if (DiffStatusEnum.DELETED.equals((Object)rowStatus)) {
            fieldValue.setStatus(DiffStatusEnum.DELETED);
        } else {
            Object oldValue = fieldValue.getOldValue();
            Object newValue = fieldValue.getNewValue();
            if (oldValue == null && newValue == null) {
                return;
            }
            if (!Objects.equals(oldValue, newValue)) {
                fieldValue.setStatus(DiffStatusEnum.UPDATED);
            } else {
                fieldValue.setOldValue(null);
            }
        }
    }

    private static DiffStatusEnum diffFieldValueToStatusEnum(DiffFieldValue value, DiffStatusEnum defaultValue) {
        if (value.getOldValue() == null) {
            return DiffStatusEnum.INSERTED;
        }
        if (value.getNewValue() == null) {
            return DiffStatusEnum.DELETED;
        }
        if (value.getOldValue().equals(value.getNewValue())) {
            return DiffStatusEnum.UPDATED;
        }
        return defaultValue;
    }
}

