/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.text.StringSubstitutor;
import ru.i_novus.platform.datastorage.temporal.enums.ReferenceDisplayType;
import ru.i_novus.platform.datastorage.temporal.model.DisplayExpression;
import ru.i_novus.platform.datastorage.temporal.model.Field;
import ru.i_novus.platform.datastorage.temporal.model.FieldValue;
import ru.i_novus.platform.datastorage.temporal.model.LongRowValue;
import ru.i_novus.platform.datastorage.temporal.model.Reference;
import ru.i_novus.platform.datastorage.temporal.model.value.ReferenceFieldValue;
import ru.i_novus.platform.datastorage.temporal.model.value.RowValue;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.QueryConstants;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.BooleanField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.DateField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.FieldValuePartEnum;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.FloatField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.IntegerField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.ReferenceField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.StringField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.model.TreeField;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StorageUtils;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StringUtils;

public class QueryUtil {
    private QueryUtil() {
    }

    public static List<RowValue> toRowValues(List<Field> fields, Set<FieldValuePartEnum> valueParts, List<Object> data) {
        ArrayList<RowValue> result = new ArrayList<RowValue>(data.size());
        for (Object row : data) {
            LongRowValue rowValue = new LongRowValue();
            if (row instanceof Object[]) {
                QueryUtil.addToRowValue((Object[])row, fields, valueParts, rowValue);
            } else {
                rowValue.getFieldValues().add(QueryUtil.toFieldValue(fields.get(0), row));
            }
            result.add((RowValue)rowValue);
        }
        return result;
    }

    private static void addToRowValue(Object[] row, List<Field> fields, Set<FieldValuePartEnum> valueParts, LongRowValue rowValue) {
        Iterator<Field> fieldIterator = fields.iterator();
        AtomicInteger next = new AtomicInteger(0);
        while (next.get() < row.length) {
            QueryUtil.addNextFieldValue(next, row, fieldIterator.next(), valueParts, rowValue);
        }
    }

    private static void addNextFieldValue(AtomicInteger index, Object[] row, Field field, Set<FieldValuePartEnum> valueParts, LongRowValue rowValue) {
        int i = index.get();
        Object value = row[i];
        if (i == 0) {
            rowValue.setSystemId(value != null ? Long.valueOf(Long.parseLong(value.toString())) : null);
            index.incrementAndGet();
            return;
        }
        if (i == 1 && "SYS_HASH".equals(field.getName())) {
            rowValue.setHash(StringUtils.stringFrom(value));
            index.incrementAndGet();
            return;
        }
        if (field instanceof ReferenceField) {
            value = QueryUtil.getNextReference(index, row, value, valueParts);
        }
        rowValue.getFieldValues().add(QueryUtil.toFieldValue(field, value));
        index.incrementAndGet();
    }

    private static Reference getNextReference(AtomicInteger index, Object[] row, Object value, Set<FieldValuePartEnum> valueParts) {
        Object hash = null;
        if (valueParts.contains((Object)FieldValuePartEnum.REFERENCE_HASH)) {
            int i = index.incrementAndGet();
            hash = i < row.length ? row[i] : null;
        }
        Object displayValue = null;
        if (valueParts.contains((Object)FieldValuePartEnum.REFERENCE_DISPLAY_VALUE)) {
            int i = index.incrementAndGet();
            displayValue = i < row.length ? row[i] : null;
        }
        return new Reference(StringUtils.stringFrom(hash), StringUtils.stringFrom(value), StringUtils.stringFrom(displayValue));
    }

    public static String getHashUsedFieldName(Field field) {
        Object name = StringUtils.addDoubleQuotes(field.getName());
        if ("jsonb".equals(field.getType())) {
            name = (String)name + "->>" + StringUtils.addSingleQuotes("value");
        }
        return name;
    }

    public static String getClearedFieldName(String fieldName) {
        int closeQuoteIndex = fieldName.indexOf(34, 1);
        return fieldName.substring(0, closeQuoteIndex + 1);
    }

    private static FieldValue toFieldValue(Field field, Object value) {
        return field.valueOf(QueryUtil.toValueByField(field, value));
    }

    public static Object toValueByField(Field field, Object value) {
        if (value == null) {
            return null;
        }
        if (field instanceof DateField) {
            return ((Date)value).toLocalDate();
        }
        if (field instanceof IntegerField) {
            return new BigInteger(value.toString());
        }
        if (field instanceof BooleanField || field instanceof FloatField || field instanceof ReferenceField) {
            return value;
        }
        return value.toString();
    }

    public static String toStrColumns(List<String> fieldNames) {
        return fieldNames.stream().filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    public static String toAliasColumns(List<String> fieldNames, String alias) {
        return fieldNames.stream().filter(Objects::nonNull).map(s -> alias + s).collect(Collectors.joining(", "));
    }

    public static String toStrColumns(Map<String, String> typedNames) {
        return typedNames.keySet().stream().filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    public static String toTypedColumns(Map<String, String> typedNames) {
        return typedNames.keySet().stream().filter(Objects::nonNull).map(name -> name + " " + (String)typedNames.get(name)).collect(Collectors.joining(", "));
    }

    public static String toAliasColumns(Map<String, String> typedNames, String alias) {
        return typedNames.keySet().stream().filter(Objects::nonNull).map(s -> alias + s).collect(Collectors.joining(", "));
    }

    public static Serializable toQueryParameter(FieldValue fieldValue) {
        if (fieldValue.getValue() == null) {
            return null;
        }
        if (fieldValue instanceof ReferenceFieldValue) {
            Reference refValue = (Reference)((ReferenceFieldValue)fieldValue).getValue();
            return refValue.getValue();
        }
        return fieldValue.getValue();
    }

    public static boolean isFieldValueNull(FieldValue<?> fieldValue) {
        return fieldValue.getValue() == null || fieldValue.getValue().equals("null");
    }

    public static boolean hasField(String fieldName, List<Field> fields) {
        return fields.stream().anyMatch(field -> fieldName.equals(field.getName()));
    }

    public static Field findField(String fieldName, List<Field> fields) {
        return fields.stream().filter(field -> fieldName.equals(field.getName())).findFirst().orElse(null);
    }

    public static String toSelectedFields(String alias, List<Field> fields, Set<FieldValuePartEnum> valueParts) {
        if (alias == null) {
            alias = "";
        }
        ArrayList<String> selectedFields = new ArrayList<String>();
        for (Field field : fields) {
            QueryUtil.toSelectedField(alias, field, fields.indexOf(field), valueParts, selectedFields);
        }
        return String.join((CharSequence)", ", selectedFields);
    }

    private static void toSelectedField(String alias, Field<?> field, int index, Set<FieldValuePartEnum> valueParts, List<String> selectedFields) {
        Object selectedField = StorageUtils.escapeFieldName(alias, field.getName());
        if (field instanceof ReferenceField) {
            String queryValue = (String)selectedField + "->>" + StringUtils.addSingleQuotes("value") + " AS " + QueryUtil.sqlFieldAlias(field, index, alias, "value");
            selectedFields.add(queryValue);
            if (valueParts.contains((Object)FieldValuePartEnum.REFERENCE_HASH)) {
                String queryHash = (String)selectedField + "->>" + StringUtils.addSingleQuotes("hash") + " AS " + QueryUtil.sqlFieldAlias(field, index, alias, "hash");
                selectedFields.add(queryHash);
            }
            if (valueParts.contains((Object)FieldValuePartEnum.REFERENCE_DISPLAY_VALUE)) {
                String queryDisplayValue = (String)selectedField + "->>" + StringUtils.addSingleQuotes("displayValue") + " AS " + QueryUtil.sqlFieldAlias(field, index, alias, "displayValue");
                selectedFields.add(queryDisplayValue);
            }
        } else {
            if (field instanceof TreeField) {
                selectedField = (String)selectedField + "\\:\\:text";
            }
            selectedField = (String)selectedField + " AS " + QueryUtil.sqlFieldAlias(field, index, alias);
            selectedFields.add((String)selectedField);
        }
    }

    private static String sqlFieldAlias(Field<?> field, int index, String prefix) {
        return StringUtils.addDoubleQuotes(prefix + field.getName() + index);
    }

    private static String sqlFieldAlias(Field<?> field, int index, String prefix, String suffix) {
        return StringUtils.addDoubleQuotes(prefix + field.getName() + index + "." + suffix);
    }

    public static boolean isVarcharType(String type) {
        return "character varying".equals(type) || "character varying".equals(type);
    }

    public static Field getField(String name, String type) {
        switch (type) {
            case "boolean": {
                return new BooleanField(name);
            }
            case "date": {
                return new DateField(name);
            }
            case "numeric": {
                return new FloatField(name);
            }
            case "bigint": {
                return new IntegerField(name);
            }
            case "jsonb": {
                return new ReferenceField(name);
            }
        }
        return new StringField(name);
    }

    public static String useFieldNameByType(String fieldName, String oldType, String newType) {
        if ("date".equals(oldType) && QueryUtil.isVarcharType(newType)) {
            return "to_char(" + fieldName + ", 'DD.MM.YYYY')";
        }
        if ("date".equals(newType) && "character varying".equals(oldType)) {
            return "to_date(" + fieldName + ", 'DD.MM.YYYY')";
        }
        if ("jsonb".equals(oldType)) {
            return "(" + fieldName + "->>" + StringUtils.addSingleQuotes("value") + ")\\:\\:varchar\\:\\:" + newType;
        }
        if ("jsonb".equals(newType)) {
            return String.format("nullif(jsonb_build_object(%1$s, %2$s), jsonb_build_object(%1$s, null))", StringUtils.addSingleQuotes("value"), fieldName);
        }
        if (QueryUtil.isVarcharType(oldType) || QueryUtil.isVarcharType(newType)) {
            return fieldName + "\\:\\:" + newType;
        }
        return fieldName + "\\:\\:varchar\\:\\:" + newType;
    }

    public static ReferenceDisplayType getReferenceDisplayType(Reference reference) {
        DisplayExpression displayExpression = reference.getDisplayExpression();
        if (displayExpression != null && displayExpression.getValue() != null) {
            return ReferenceDisplayType.DISPLAY_EXPRESSION;
        }
        if (reference.getDisplayField() != null) {
            return ReferenceDisplayType.DISPLAY_FIELD;
        }
        return null;
    }

    public static String sqlFieldExpression(String displayField, String tableAlias) {
        return StorageUtils.escapeFieldName(tableAlias, displayField);
    }

    public static String sqlDisplayExpression(DisplayExpression displayExpression, String tableAlias) {
        String valueFormat = "' || coalesce(%1$s\\:\\:text, '%2$s') || '";
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry e : displayExpression.getPlaceholders().entrySet()) {
            String value = e.getValue() == null ? "" : (String)e.getValue();
            value = String.format("' || coalesce(%1$s\\:\\:text, '%2$s') || '", StorageUtils.escapeFieldName(tableAlias, (String)e.getKey()), value);
            map.put((String)e.getKey(), value);
        }
        String escapedDisplayExpression = QueryUtil.escapeSql(displayExpression.getValue());
        String displayValue = QueryUtil.createDisplayExpressionSubstitutor(map).replace(escapedDisplayExpression);
        return StringUtils.addSingleQuotes(displayValue);
    }

    public static String escapeSql(String str) {
        return str == null ? null : str.replace("'", "''");
    }

    public static List<Long> toLongSystemIds(List<Object> systemIds) {
        return systemIds.stream().map(systemId -> (Long)systemId).collect(Collectors.toList());
    }

    public static String valuesToDbArray(List<?> values) {
        return values.stream().map(String::valueOf).collect(Collectors.joining(",", "{", "}"));
    }

    public static String stringsToDbArray(List<String> values) {
        return "{" + String.join((CharSequence)",", values) + "}";
    }

    public static StringSubstitutor createDisplayExpressionSubstitutor(Map<String, Object> map) {
        StringSubstitutor substitutor = new StringSubstitutor(map, "${", "}");
        substitutor.setValueDelimiter(":");
        return substitutor;
    }

    public static String formatDateTime(LocalDateTime localDateTime) {
        return localDateTime != null ? localDateTime.format(QueryConstants.DATETIME_FORMATTER) : null;
    }

    public static String toTimestamp(String value) {
        switch (value) {
            case "'-infinity'": 
            case "'infinity'": {
                return value;
            }
        }
        return String.format("to_timestamp(%s, 'YYYY-MM-DD HH24:MI:SS')", StringUtils.addSingleQuotes(value));
    }

    public static String toTimestampWithoutTimeZone(String value) {
        return value != null ? QueryUtil.toTimestamp(value) + "\\:\\:timestamp without time zone" : "null";
    }

    public static Object truncateDateTo(LocalDateTime date, ChronoUnit unit, Object defaultValue) {
        return date != null ? date.truncatedTo(unit) : defaultValue;
    }
}

