/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.pg_impl.util;

import java.util.UUID;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.StorageConstants;
import ru.i_novus.platform.versioned_data_storage.pg_impl.util.StringUtils;

public class StorageUtils {
    private StorageUtils() {
    }

    public static String toSchemaName(String storageCode) {
        if (StringUtils.isNullOrEmpty(storageCode)) {
            return "data";
        }
        int separatorIndex = storageCode.indexOf(".");
        if (separatorIndex > 0) {
            return storageCode.substring(0, separatorIndex);
        }
        return "data";
    }

    public static String toTableName(String storageCode) {
        if (StringUtils.isNullOrEmpty(storageCode)) {
            return "";
        }
        int separatorIndex = storageCode.indexOf(".");
        if (separatorIndex >= 0) {
            return storageCode.substring(separatorIndex + 1);
        }
        return storageCode;
    }

    public static String toStorageCode(String schemaName, String tableName) {
        return StorageUtils.isDefaultSchema(schemaName) ? tableName : schemaName + "." + tableName;
    }

    public static boolean isDefaultSchema(String schemaName) {
        return StringUtils.isNullOrEmpty(schemaName) || "data".equals(schemaName);
    }

    public static boolean isValidSchemaName(String schemaName) {
        return StorageConstants.SCHEMA_NAME_PATTERN.matcher(schemaName).matches();
    }

    public static String getSchemaNameOrDefault(String schemaName) {
        return StringUtils.isNullOrEmpty(schemaName) ? "data" : schemaName;
    }

    public static String escapeTableName(String schemaName, String tableName) {
        return StorageUtils.getSchemaNameOrDefault(schemaName) + "." + StringUtils.addDoubleQuotes(tableName);
    }

    public static String escapeStorageTableName(String storageCode) {
        return StorageUtils.escapeTableName(StorageUtils.toSchemaName(storageCode), StorageUtils.toTableName(storageCode));
    }

    public static String aliasColumnName(String tableAlias, String fieldName) {
        return tableAlias + "." + fieldName;
    }

    public static String escapeFieldName(String tableAlias, String fieldName) {
        String escapedFieldName = StringUtils.addDoubleQuotes(fieldName);
        return StringUtils.isNullOrEmpty(tableAlias) ? escapedFieldName : StorageUtils.aliasColumnName(tableAlias, escapedFieldName);
    }

    public static String tableSequenceName(String tableName) {
        return tableName + "_SYS_RECORDID_seq";
    }

    public static String escapeSequenceName(String tableName) {
        return StringUtils.addDoubleQuotes(StorageUtils.tableSequenceName(tableName));
    }

    public static String escapeSchemaSequenceName(String schemaName, String tableName) {
        return StorageUtils.getSchemaNameOrDefault(schemaName) + "." + StorageUtils.escapeSequenceName(tableName);
    }

    public static String escapeStorageSequenceName(String storageCode) {
        return StorageUtils.escapeSchemaSequenceName(StorageUtils.toSchemaName(storageCode), StorageUtils.toTableName(storageCode));
    }

    public static String escapeTableIndexName(String tableName, String indexName) {
        return StringUtils.addDoubleQuotes(tableName + "_" + indexName + "_idx");
    }

    public static String escapeTableFunctionName(String tableName, String functionName) {
        return StringUtils.addDoubleQuotes(tableName + "_" + functionName);
    }

    public static String generateStorageName() {
        return UUID.randomUUID().toString();
    }
}

