/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.platform.versioned_data_storage.config;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import ru.i_novus.platform.datastorage.temporal.service.CompareDataService;
import ru.i_novus.platform.datastorage.temporal.service.DraftDataService;
import ru.i_novus.platform.datastorage.temporal.service.DropDataService;
import ru.i_novus.platform.datastorage.temporal.service.FieldFactory;
import ru.i_novus.platform.datastorage.temporal.service.SearchDataService;
import ru.i_novus.platform.datastorage.temporal.service.StorageService;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.DataDao;
import ru.i_novus.platform.versioned_data_storage.pg_impl.dao.DataDaoImpl;
import ru.i_novus.platform.versioned_data_storage.pg_impl.service.CompareDataServiceImpl;
import ru.i_novus.platform.versioned_data_storage.pg_impl.service.DraftDataServiceImpl;
import ru.i_novus.platform.versioned_data_storage.pg_impl.service.DropDataServiceImpl;
import ru.i_novus.platform.versioned_data_storage.pg_impl.service.FieldFactoryImpl;
import ru.i_novus.platform.versioned_data_storage.pg_impl.service.SearchDataServiceImpl;
import ru.i_novus.platform.versioned_data_storage.pg_impl.service.StorageServiceImpl;

@Configuration
public class VersionedDataStorageConfig {
    @PersistenceContext
    private EntityManager entityManager;

    @Bean
    public DataDao dataDao() {
        return new DataDaoImpl(this.entityManager);
    }

    @Bean
    public SearchDataService getSearchDataService() {
        return new SearchDataServiceImpl(this.dataDao());
    }

    @Bean
    public DraftDataService getDraftDataService() {
        return new DraftDataServiceImpl(this.dataDao());
    }

    @Bean
    public DropDataService getDropDataService() {
        return new DropDataServiceImpl(this.dataDao());
    }

    @Bean
    public CompareDataService getCompareDataService() {
        return new CompareDataServiceImpl(this.dataDao());
    }

    @Bean
    public StorageService getStorageService() {
        return new StorageServiceImpl(this.dataDao(), this.getDraftDataService());
    }

    @Bean
    public FieldFactory getFieldFactory() {
        return new FieldFactoryImpl();
    }
}

