/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.loader.client.loader;

import java.net.URI;
import java.util.List;
import net.n2oapp.platform.loader.client.ClientLoader;
import net.n2oapp.platform.loader.client.LoadingException;
import net.n2oapp.platform.loader.client.RestClientLoader;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestOperations;
import ru.i_novus.ms.rdm.loader.client.loader.RefBookDataModel;
import ru.i_novus.ms.rdm.loader.client.loader.RefBookDataUtil;

public class RefBookDataClientLoader
extends RestClientLoader<MultiValueMap<String, Object>>
implements ClientLoader {
    public RefBookDataClientLoader(RestOperations restTemplate) {
        super(restTemplate);
    }

    public RefBookDataClientLoader(RestOperations restTemplate, String endpointPattern) {
        super(restTemplate, endpointPattern);
    }

    public void load(URI server, String subject, String target, Resource file) {
        List<RefBookDataModel> models = RefBookDataUtil.toRefBookDataModels(file);
        String url = this.getUrl(server, subject, target);
        MultiValueMap<String, String> headers = this.getHeaders();
        models.forEach(model -> this.load(url, this.getData((RefBookDataModel)model), headers));
    }

    private MultiValueMap<String, Object> getData(RefBookDataModel model) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        if (!StringUtils.isEmpty((Object)model.getCode())) {
            body.add((Object)"code", (Object)model.getCode());
        }
        if (!StringUtils.isEmpty((Object)model.getName())) {
            body.add((Object)"name", (Object)model.getName());
        }
        if (!StringUtils.isEmpty((Object)model.getStructure())) {
            body.add((Object)"structure", (Object)model.getStructure());
        }
        if (!StringUtils.isEmpty((Object)model.getData())) {
            body.add((Object)"data", (Object)model.getData());
        }
        if (model.getFile() != null) {
            body.add((Object)"file", (Object)model.getFile());
        }
        return body;
    }

    protected MultiValueMap<String, String> getHeaders() {
        LinkedMultiValueMap headers = new LinkedMultiValueMap(1);
        headers.add((Object)"Content-Type", (Object)"multipart/form-data");
        return headers;
    }

    protected MultiValueMap<String, Object> getData(Resource file) {
        return null;
    }

    private void load(String url, MultiValueMap<String, Object> data, MultiValueMap<String, String> headers) {
        HttpEntity request = new HttpEntity(data, headers);
        ResponseEntity response = this.getRestTemplate().postForEntity(url, (Object)request, String.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new LoadingException("Loading failed status " + response.getStatusCodeValue() + " response " + (String)response.getBody());
        }
    }
}

