/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.loader.client.loader;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.loader.client.loader.RefBookDataModel;

public class RefBookDataUtil {
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    private RefBookDataUtil() {
    }

    public static List<RefBookDataModel> toRefBookDataModels(Resource file) {
        if (file == null || StringUtils.isEmpty((Object)file.getFilename())) {
            return Collections.emptyList();
        }
        String extension = RefBookDataUtil.getExtension(file.getFilename());
        if (!"json".equals(extension)) {
            return List.of(new RefBookDataModel(null, null, null, file));
        }
        return RefBookDataUtil.toRefBookDataModels(RefBookDataUtil.fromFile(file));
    }

    private static String getExtension(String filename) {
        int lastIndex = filename.lastIndexOf(46);
        return lastIndex >= 0 ? filename.substring(lastIndex + 1) : null;
    }

    private static JsonNode fromFile(Resource file) {
        try {
            return jsonMapper.readTree(file.getInputStream());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Cannot deserialize json from file.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read file.", e);
        }
    }

    private static List<RefBookDataModel> toRefBookDataModels(JsonNode rootNode) {
        if (rootNode == null || rootNode.isEmpty()) {
            return Collections.emptyList();
        }
        if (!rootNode.isArray()) {
            RefBookDataModel model = RefBookDataUtil.toRefBookDataModel(rootNode);
            return model != null ? List.of(model) : Collections.emptyList();
        }
        ArrayList<RefBookDataModel> result = new ArrayList<RefBookDataModel>(rootNode.size());
        for (JsonNode jsonNode : rootNode) {
            RefBookDataModel model = RefBookDataUtil.toRefBookDataModel(jsonNode);
            if (model == null) continue;
            result.add(RefBookDataUtil.toRefBookDataModel(jsonNode));
        }
        return result;
    }

    private static RefBookDataModel toRefBookDataModel(JsonNode jsonNode) {
        String code = RefBookDataUtil.getByKey(jsonNode, "code", JsonNode::asText);
        String filePath = RefBookDataUtil.getByKey(jsonNode, "file", JsonNode::asText);
        if (!StringUtils.isEmpty((Object)filePath)) {
            return new RefBookDataModel(code, RefBookDataUtil.getByKey(jsonNode, "name", JsonNode::asText), RefBookDataUtil.getByKey(jsonNode, "structure", RefBookDataUtil::asJsonString), (Resource)new ClassPathResource(filePath));
        }
        if (StringUtils.isEmpty((Object)code)) {
            return null;
        }
        return new RefBookDataModel(code, RefBookDataUtil.getByKey(jsonNode, "name", JsonNode::asText), RefBookDataUtil.getByKey(jsonNode, "structure", RefBookDataUtil::asJsonString), RefBookDataUtil.getByKey(jsonNode, "data", RefBookDataUtil::asJsonString));
    }

    private static String asJsonString(JsonNode value) {
        try {
            return jsonMapper.writeValueAsString((Object)value);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private static <T> T getByKey(JsonNode node, String key, Function<JsonNode, T> valueExtractor) {
        JsonNode valueJson = node.get(key);
        return valueJson == null ? null : (T)valueExtractor.apply(valueJson);
    }
}

