/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.n2o.api.criteria;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.api.Direction;
import net.n2oapp.criteria.api.Sorting;
import org.apache.commons.lang3.BooleanUtils;
import ru.i_novus.ms.rdm.api.util.json.JsonUtil;
import ru.i_novus.ms.rdm.n2o.api.util.DataRecordUtils;

public class DataCriteria
extends Criteria {
    private Integer versionId;
    private Integer optLockValue;
    private String localeCode;
    private Map<String, Serializable> filter;
    private Boolean hasDataConflict;

    public DataCriteria() {
    }

    public DataCriteria(Integer versionId, Integer optLockValue, Map<String, Serializable> filter, Boolean hasDataConflict) {
        this.versionId = versionId;
        this.optLockValue = optLockValue;
        this.filter = filter;
        this.hasDataConflict = hasDataConflict;
    }

    public DataCriteria(DataCriteria criteria) {
        super((Criteria)criteria);
        this.versionId = criteria.getVersionId();
        this.optLockValue = criteria.getOptLockValue();
        this.localeCode = criteria.getLocaleCode();
        this.filter = criteria.getFilter();
        this.hasDataConflict = criteria.getHasDataConflict();
    }

    public Integer getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Integer versionId) {
        this.versionId = versionId;
    }

    public Integer getOptLockValue() {
        return this.optLockValue;
    }

    public void setOptLockValue(Integer optLockValue) {
        this.optLockValue = optLockValue;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    public Map<String, Serializable> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<String, Serializable> filter) {
        this.filter = filter;
    }

    public Boolean getHasDataConflict() {
        return this.hasDataConflict;
    }

    public void setHasDataConflict(Boolean hasDataConflict) {
        this.hasDataConflict = hasDataConflict;
    }

    public void setSorting(Sorting sorting) {
        if (sorting == null) {
            return;
        }
        super.setSorting(this.toSorting(sorting.getField(), sorting.getDirection()));
    }

    public void setSorting(Map<String, String> sorting) {
        if (sorting == null) {
            return;
        }
        sorting.entrySet().stream().findFirst().ifPresent(e -> this.setSorting(this.toSorting((String)e.getKey(), this.toDirection((String)e.getValue()))));
    }

    private Sorting toSorting(String fieldName, Direction direction) {
        return new Sorting(DataRecordUtils.deletePrefix(fieldName), direction);
    }

    private Direction toDirection(String value) {
        return value == null || "ASC".equalsIgnoreCase(value) ? Direction.ASC : Direction.DESC;
    }

    public boolean isHasDataConflict() {
        return BooleanUtils.isTrue((Boolean)this.hasDataConflict) && this.localeCode == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!this.superEquals(o)) {
            return false;
        }
        DataCriteria that = (DataCriteria)((Object)o);
        return Objects.equals(this.versionId, that.versionId) && Objects.equals(this.optLockValue, that.optLockValue) && Objects.equals(this.localeCode, that.localeCode) && Objects.equals(this.filter, that.filter) && Objects.equals(this.hasDataConflict, that.hasDataConflict);
    }

    private boolean superEquals(Object o) {
        if (!(o instanceof Criteria)) {
            return false;
        }
        Criteria that = (Criteria)o;
        return Objects.equals(this.getPage(), that.getPage()) && Objects.equals(this.getSize(), that.getSize()) && Objects.equals(this.getCount(), that.getCount());
    }

    public int hashCode() {
        return Objects.hash(this.superHashCode(), this.versionId, this.optLockValue, this.localeCode, this.filter, this.hasDataConflict);
    }

    private int superHashCode() {
        return Objects.hash(this.getPage(), this.getSize(), this.getCount());
    }

    public String toString() {
        return JsonUtil.toJsonString((Object)((Object)this));
    }
}

