/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.fnsi.sync.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import ru.i_novus.ms.fnsi.sync.impl.FnsiErrorException;
import ru.i_novus.ms.rdm.sync.api.model.AttributeTypeEnum;
import ru.i_novus.ms.rdm.sync.api.model.DataCriteria;
import ru.i_novus.ms.rdm.sync.api.model.RefBook;
import ru.i_novus.ms.rdm.sync.api.model.RefBookStructure;
import ru.i_novus.ms.rdm.sync.api.model.RowDiff;
import ru.i_novus.ms.rdm.sync.api.model.RowDiffStatusEnum;
import ru.i_novus.ms.rdm.sync.api.model.VersionsDiff;
import ru.i_novus.ms.rdm.sync.api.model.VersionsDiffCriteria;
import ru.i_novus.ms.rdm.sync.api.service.SyncSourceService;

public class FnsiSyncSourceService
implements SyncSourceService {
    private static final Logger logger = LoggerFactory.getLogger(FnsiSyncSourceService.class);
    private final RestTemplate restTemplate;
    private final String fnsiUrl;
    private final String userKey;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");

    public FnsiSyncSourceService(RestTemplate restTemplate, String fnsiUrl, String userKey) {
        this.restTemplate = restTemplate;
        this.fnsiUrl = fnsiUrl;
        this.userKey = userKey;
    }

    public RefBook getRefBook(String code) {
        JsonNode response = this.requestRefBook(code);
        JsonNode listRefBookNodes = response.get("list");
        if (listRefBookNodes.isEmpty()) {
            return null;
        }
        JsonNode refBookNode = listRefBookNodes.get(0);
        RefBook refBook = new RefBook();
        refBook.setLastPublishDate(LocalDateTime.parse(refBookNode.get("publishDate").asText(), formatter));
        refBook.setLastVersion(refBookNode.get("version").asText());
        refBook.setCode(code);
        RefBookStructure refBookStructure = this.getRefBookStructure(code, refBook.getLastVersion());
        refBook.setStructure(refBookStructure);
        return refBook;
    }

    public Page<Map<String, Object>> getData(DataCriteria dataCriteria) {
        RefBook refBook = this.getRefBook(dataCriteria.getCode());
        JsonNode jsonNode = this.requestData(dataCriteria.getCode(), dataCriteria.getPageNumber() + 1, dataCriteria.getPageSize());
        ArrayList data = new ArrayList();
        jsonNode.get("list").elements().forEachRemaining(itemNode -> {
            LinkedHashMap row = new LinkedHashMap();
            itemNode.elements().forEachRemaining(cellNode -> {
                String value = cellNode.get("value").asText();
                if (!"null".equals(value.trim())) {
                    String column = cellNode.get("column").asText();
                    AttributeTypeEnum attributeTypeEnum = (AttributeTypeEnum)refBook.getStructure().getAttributesAndTypes().get(column);
                    try {
                        row.put(column, attributeTypeEnum.castValue(value));
                    }
                    catch (Exception e) {
                        logger.error("cannot add value = {} to column {}", (Object)value, (Object)column);
                        throw e;
                    }
                }
            });
            data.add(row);
        });
        return new PageImpl(data, (Pageable)dataCriteria, (long)jsonNode.get("total").asInt());
    }

    public VersionsDiff getDiff(VersionsDiffCriteria criteria) {
        LocalDateTime fromDate = null;
        LocalDateTime toDate = null;
        Iterator versionNodeIterator = this.requestVersions(criteria.getRefBookCode()).get("list").elements();
        while (versionNodeIterator.hasNext() && (fromDate == null || toDate == null)) {
            JsonNode versionNode = (JsonNode)versionNodeIterator.next();
            if (versionNode.get("version").asText().equals(criteria.getOldVersion())) {
                fromDate = LocalDateTime.parse(versionNode.get("publishDate").asText(), formatter);
                continue;
            }
            if (!versionNode.get("version").asText().equals(criteria.getNewVersion())) continue;
            toDate = LocalDateTime.parse(versionNode.get("publishDate").asText(), formatter);
        }
        JsonNode jsonNode = this.requestDiff(criteria.getRefBookCode(), fromDate, toDate, criteria.getPageNumber() + 1);
        if ("ERROR".equals(jsonNode.get("result").asText().trim())) {
            return this.getErrorDiff(jsonNode);
        }
        if (!"null".equals(jsonNode.get("fields").asText().trim())) {
            return VersionsDiff.structureChangedInstance();
        }
        JsonNode diffsNode = jsonNode.get("data").get("list");
        ArrayList rowDiffList = new ArrayList();
        RefBookStructure refBookStructure = this.getRefBookStructure(criteria.getRefBookCode(), criteria.getNewVersion());
        diffsNode.elements().forEachRemaining(diffNode -> {
            Map attributesAndTypes = refBookStructure.getAttributesAndTypes();
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (Map.Entry entry : attributesAndTypes.entrySet()) {
                JsonNode nodeValue = diffNode.get((String)entry.getKey());
                if (nodeValue.asText().trim().equals("null")) continue;
                row.put((String)entry.getKey(), ((AttributeTypeEnum)entry.getValue()).castValue(nodeValue.asText()));
            }
            RowDiff rowDiff = new RowDiff(this.getRowDiffStatusEnum(diffNode.get("operation").asText()), row);
            rowDiffList.add(rowDiff);
        });
        return VersionsDiff.dataChangedInstance((Page)new PageImpl(rowDiffList));
    }

    private VersionsDiff getErrorDiff(JsonNode jsonNode) {
        if ("03x0002".equals(jsonNode.get("resultCode").asText().trim())) {
            return VersionsDiff.dataChangedInstance((Page)Page.empty());
        }
        throw new FnsiErrorException(jsonNode.get("resultCode").asText("resultText"));
    }

    private RowDiffStatusEnum getRowDiffStatusEnum(String fnsiOperation) {
        switch (fnsiOperation) {
            case "UPDATE": {
                return RowDiffStatusEnum.UPDATED;
            }
            case "DELETE": {
                return RowDiffStatusEnum.DELETED;
            }
            case "INSERT": {
                return RowDiffStatusEnum.INSERTED;
            }
        }
        throw new UnsupportedOperationException("cannot get diff status from" + fnsiOperation + "operation");
    }

    private JsonNode requestDiff(String oid, LocalDateTime fromDate, LocalDateTime toDate, int page) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        return this.request(Map.of("userKey", this.userKey, "identifier", oid, "date1", dtf.format(fromDate), "date2", dtf.format(toDate), "page", page, "size", 200), "/rest/compare");
    }

    private JsonNode requestVersions(String oid) {
        return this.request(Map.of("userKey", this.userKey, "identifier", oid, "page", 1, "size", 200), "/rest/versions");
    }

    private JsonNode requestRefBook(String oid) {
        return this.request(Map.of("userKey", this.userKey, "identifier", oid, "page", 1, "size", 200), "/rest/searchDictionary");
    }

    private JsonNode requestStructure(String oid, String version) {
        return this.request(Map.of("userKey", this.userKey, "identifier", oid, "version", version), "/rest/passport");
    }

    private JsonNode requestData(String oid, int page, int size) {
        return this.request(Map.of("userKey", this.userKey, "identifier", oid, "page", page, "size", size), "/rest/data");
    }

    private JsonNode request(Map<String, Object> queryParams, String path) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Accept", "application/json");
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.fnsiUrl + path));
        for (Map.Entry<String, Object> param : queryParams.entrySet()) {
            builder = builder.queryParam(param.getKey(), new Object[]{param.getValue()});
        }
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String url = builder.toUriString();
        try {
            JsonNode body = (JsonNode)this.restTemplate.exchange(new URI(url), HttpMethod.GET, entity, JsonNode.class).getBody();
            if (body == null) {
                throw new FnsiErrorException("response from " + url + " is empty");
            }
            return body;
        }
        catch (URISyntaxException e) {
            logger.error("cannot create uri ", (Throwable)e);
            throw new IllegalArgumentException("invalid uri " + url, e);
        }
    }

    private RefBookStructure getRefBookStructure(String code, String lastVersion) {
        JsonNode structureNode = this.requestStructure(code, lastVersion);
        RefBookStructure refBookStructure = new RefBookStructure();
        refBookStructure.setPrimaries(structureNode.findValues("keys").stream().map(jsonnode -> jsonnode.get(0).get("field").asText()).collect(Collectors.toList()));
        Iterator fields = structureNode.get("fields").elements();
        HashMap attributesAndTypes = new HashMap();
        fields.forEachRemaining(jsonNode -> attributesAndTypes.put(jsonNode.get("field").asText(), this.getAttrType(jsonNode.get("dataType").asText())));
        refBookStructure.setAttributesAndTypes(attributesAndTypes);
        refBookStructure.setReferences(Collections.emptyList());
        return refBookStructure;
    }

    private AttributeTypeEnum getAttrType(String fnsiDataType) {
        switch (fnsiDataType) {
            case "INTEGER": {
                return AttributeTypeEnum.INTEGER;
            }
            case "VARCHAR": {
                return AttributeTypeEnum.STRING;
            }
            case "DATETIME": {
                return AttributeTypeEnum.DATE;
            }
        }
        return null;
    }
}

