/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.admin.api.model.mapping;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import ru.i_novus.ms.rdm.sync.admin.api.model.mapping.FieldToFieldMapping;
import ru.i_novus.ms.rdm.sync.admin.api.model.mapping.SyncMappingTypeEnum;
import ru.i_novus.ms.rdm.sync.admin.api.model.mapping.SyncToFieldMapping;

public class SyncStructureMapping {
    private final SyncMappingTypeEnum type;
    private List<SyncToFieldMapping> fieldMappings;

    private SyncStructureMapping(SyncMappingTypeEnum type) {
        this.type = type;
    }

    public SyncStructureMapping() {
        this(SyncMappingTypeEnum.NONE);
    }

    public SyncStructureMapping(List<SyncToFieldMapping> fieldMappings) {
        this(SyncMappingTypeEnum.LIST);
        this.fieldMappings = fieldMappings;
    }

    public SyncMappingTypeEnum getType() {
        return this.type;
    }

    public List<SyncToFieldMapping> getFieldMappings() {
        return this.fieldMappings;
    }

    public void setFieldMappings(List<SyncToFieldMapping> fieldMappings) {
        if (!this.isNone()) {
            this.fieldMappings = fieldMappings;
        }
    }

    public boolean isNone() {
        return SyncMappingTypeEnum.NONE.equals((Object)this.type);
    }

    public List<String> getOldFieldNames() {
        if (this.isNone() || StringUtils.isEmpty(this.fieldMappings)) {
            return Collections.emptyList();
        }
        return this.fieldMappings.stream().filter(fieldMapping -> fieldMapping instanceof FieldToFieldMapping).map(fieldMapping -> ((FieldToFieldMapping)fieldMapping).getOldField()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getNewFieldName(String oldFieldName) {
        if (this.isNone()) {
            return oldFieldName;
        }
        if (StringUtils.isEmpty((Object)oldFieldName) || CollectionUtils.isEmpty(this.fieldMappings)) {
            return null;
        }
        return this.fieldMappings.stream().filter(fieldMapping -> {
            if (!(fieldMapping instanceof FieldToFieldMapping)) {
                return false;
            }
            String name = ((FieldToFieldMapping)fieldMapping).getOldField();
            return !StringUtils.isEmpty((Object)name) && oldFieldName.equals(name);
        }).map(SyncToFieldMapping::getNewField).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public SyncToFieldMapping getNewFieldMapping(String newFieldName) {
        if (this.isNone() || StringUtils.isEmpty((Object)newFieldName) || CollectionUtils.isEmpty(this.fieldMappings)) {
            return null;
        }
        return this.fieldMappings.stream().filter(fieldMapping -> newFieldName.equals(fieldMapping.getNewField())).findFirst().orElse(null);
    }

    public static SyncStructureMapping getNoneStructureMapping() {
        return new SyncStructureMapping(SyncMappingTypeEnum.NONE);
    }
}

