/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.admin.api.model.refbook;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import ru.i_novus.ms.rdm.sync.admin.api.model.refbook.SyncField;
import ru.i_novus.ms.rdm.sync.admin.api.utils.JsonUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SyncStructure
implements Serializable {
    public static final SyncStructure EMPTY = new SyncStructure();
    private List<SyncField> fields;

    public SyncStructure() {
        this.fields = new ArrayList<SyncField>(0);
    }

    public SyncStructure(List<SyncField> fields) {
        this.fields = SyncStructure.getOrCreateList(fields);
    }

    public SyncStructure(SyncStructure structure) {
        this.fields = SyncStructure.copyList(structure.fields, SyncField::new);
    }

    public List<SyncField> getFields() {
        return this.fields;
    }

    public void setFields(List<SyncField> fields) {
        this.fields = SyncStructure.getOrCreateList(fields);
    }

    public SyncField getField(String code) {
        if (CollectionUtils.isEmpty(this.fields)) {
            return null;
        }
        return this.fields.stream().filter(field -> field.getCode().equals(code)).findAny().orElse(null);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.fields);
    }

    private static <T> List<T> getOrCreateList(List<T> list) {
        return list == null ? new ArrayList(0) : list;
    }

    private static <T> List<T> copyList(List<T> values, UnaryOperator<T> copy) {
        if (CollectionUtils.isEmpty(values)) {
            return new ArrayList(0);
        }
        return values.stream().map(copy).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyncStructure that = (SyncStructure)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return JsonUtil.toJsonString(this);
    }
}

