/*
 * Decompiled with CFR 0.152.
 */
package ru.i_novus.ms.rdm.sync.admin.api.utils;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import ru.i_novus.ms.rdm.sync.admin.api.model.AbstractCriteria;

public class PageIterator<T, C extends AbstractCriteria>
implements Iterator<Page<? extends T>> {
    private final Function<? super C, Page<? extends T>> pageSource;
    private final C criteria;
    private int currentPage;
    private Page<? extends T> nextPage;

    public PageIterator(Function<? super C, Page<? extends T>> pageSource, C criteria) {
        this.pageSource = pageSource;
        this.criteria = criteria;
        this.currentPage = criteria.getPageNumber() - 1;
    }

    protected C getCriteria() {
        return this.criteria;
    }

    @Override
    public boolean hasNext() {
        this.nextPage = this.getNextPage();
        List content = this.nextPage.getContent();
        return !content.isEmpty();
    }

    @Override
    public Page<? extends T> next() {
        Object result;
        if (this.nextPage != null) {
            result = this.nextPage;
            this.nextPage = null;
        } else {
            result = this.getNextPage();
        }
        ++this.currentPage;
        return result;
    }

    protected Page<? extends T> getNextPage() {
        this.criteria.setPageNumber(this.currentPage + 1);
        return this.pageSource.apply(this.criteria);
    }
}

