/*
 * Decompiled with CFR 0.152.
 */
package ru.vyarus.java.generics.resolver.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.vyarus.java.generics.resolver.context.AbstractGenericsContext;
import ru.vyarus.java.generics.resolver.context.ConstructorGenericsContext;
import ru.vyarus.java.generics.resolver.context.GenericDeclarationScope;
import ru.vyarus.java.generics.resolver.context.GenericsInfo;
import ru.vyarus.java.generics.resolver.context.GenericsInfoFactory;
import ru.vyarus.java.generics.resolver.context.MethodGenericsContext;
import ru.vyarus.java.generics.resolver.error.WrongGenericsContextException;
import ru.vyarus.java.generics.resolver.util.GenericInfoUtils;
import ru.vyarus.java.generics.resolver.util.GenericsUtils;
import ru.vyarus.java.generics.resolver.util.TypeToStringUtils;
import ru.vyarus.java.generics.resolver.util.TypeUtils;
import ru.vyarus.java.generics.resolver.util.map.PrintableGenericsMap;

public class GenericsContext
extends AbstractGenericsContext {
    public static final String CURRENT_POSITION_MARKER = "    <-- current";
    private static final PrintableGenericsMap PRINTABLE_GENERICS = new PrintableGenericsMap();
    protected Class<?> ownerType;
    protected Map<String, Type> ownerGenerics;
    protected Map<String, Type> allTypeGenerics;
    private final GenericsContext root;

    public GenericsContext(GenericsInfo genericsInfo, Class<?> type) {
        this(genericsInfo, type, null);
    }

    public GenericsContext(GenericsInfo genericsInfo, Class<?> type, GenericsContext root) {
        super(genericsInfo, type);
        this.separateOwnerGenerics();
        this.root = root;
    }

    public Class<?> ownerClass() {
        return this.ownerType;
    }

    public GenericsContext rootContext() {
        return this.root;
    }

    public boolean isInlying() {
        return this.root != null;
    }

    public Map<String, Type> ownerGenericsMap() {
        return this.ownerGenerics.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, Type>(this.ownerGenerics);
    }

    public String toString() {
        return this.genericsInfo.toStringHierarchy(new TypeContextWriter());
    }

    @Override
    public GenericDeclarationScope getGenericsScope() {
        return GenericDeclarationScope.CLASS;
    }

    @Override
    public GenericDeclaration getGenericsSource() {
        return this.currentClass();
    }

    @Override
    public GenericsContext type(Class<?> type) {
        return type == this.currentType ? this : new GenericsContext(this.genericsInfo, TypeUtils.wrapPrimitive(type), this.root);
    }

    @Override
    public MethodGenericsContext method(Method method) {
        GenericsContext context = this.switchContext(method.getDeclaringClass(), String.format("Method '%s'", TypeToStringUtils.toStringMethod(method, PRINTABLE_GENERICS)));
        return new MethodGenericsContext(context.genericsInfo, method, this.root);
    }

    @Override
    public ConstructorGenericsContext constructor(Constructor constructor) {
        GenericsContext context = this.switchContext(constructor.getDeclaringClass(), String.format("Constructor '%s'", TypeToStringUtils.toStringConstructor(constructor, PRINTABLE_GENERICS)));
        return new ConstructorGenericsContext(context.genericsInfo, constructor, this.root);
    }

    @Override
    public GenericsContext inlyingType(Type type) {
        GenericsContext root = this.chooseContext(type);
        Class<?> target = TypeUtils.wrapPrimitive(root.resolveClass(type));
        GenericsInfo generics = target.getTypeParameters().length > 0 || this.couldRequireKnownOuterGenerics(root, type) ? GenericInfoUtils.create(root, type, this.genericsInfo.getIgnoredTypes()) : GenericsInfoFactory.create(target, this.genericsInfo.getIgnoredTypes());
        return new GenericsContext(generics, target, root);
    }

    @Override
    public GenericsContext inlyingTypeAs(Type type, Class<?> asType) {
        GenericsContext root = this.chooseContext(type);
        Class<?> target = TypeUtils.wrapPrimitive(root.resolveClass(type));
        GenericsInfo generics = target.getTypeParameters().length > 0 || this.couldRequireKnownOuterGenerics(root, type) || this.couldRequireKnownOuterGenerics(root, asType) ? GenericInfoUtils.create(root, type, asType, this.genericsInfo.getIgnoredTypes()) : GenericsInfoFactory.create(asType, this.genericsInfo.getIgnoredTypes());
        return new GenericsContext(generics, asType, root);
    }

    @Override
    public GenericsContext chooseContext(Type type) {
        TypeVariable var;
        if (!(type instanceof Class) && (var = GenericsUtils.findIncompatibleVariable(type, this.currentType, this.getGenericsScope(), this.getGenericsSource())) != null) {
            Class<?> target;
            GenericDeclarationScope scope = GenericDeclarationScope.from(var.getGenericDeclaration());
            if (scope != null && (target = this.genericsInfo.findContextByDeclarationType(GenericsUtils.getDeclarationClass(var))) != null) {
                GenericsContext context;
                switch (scope) {
                    case METHOD: {
                        context = this.method((Method)var.getGenericDeclaration());
                        break;
                    }
                    case CONSTRUCTOR: {
                        context = this.constructor((Constructor)var.getGenericDeclaration());
                        break;
                    }
                    default: {
                        context = this.type(target);
                    }
                }
                return context;
            }
            throw new WrongGenericsContextException(type, var, this.currentType, this.genericsInfo);
        }
        return this;
    }

    @Override
    protected GenericsContext switchContext(Class target, String msgPrefix) {
        try {
            return this.type(target);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format(msgPrefix + " declaration type %s is not present in current hierarchy:%n%s", target.getSimpleName(), this.genericsInfo.toString()), ex);
        }
    }

    @Override
    protected Map<String, Type> contextGenerics() {
        return this.allTypeGenerics;
    }

    private void separateOwnerGenerics() {
        this.ownerType = (Class)TypeUtils.getOuter(this.currentType);
        this.ownerGenerics = GenericsUtils.extractOwnerGenerics(this.currentType, this.typeGenerics);
        if (this.ownerGenerics.isEmpty()) {
            this.allTypeGenerics = this.typeGenerics;
        } else {
            this.allTypeGenerics = new LinkedHashMap<String, Type>(this.typeGenerics);
            for (String key : this.ownerGenerics.keySet()) {
                this.typeGenerics.remove(key);
            }
        }
    }

    private boolean couldRequireKnownOuterGenerics(GenericsContext root, Type type) {
        Type outer = TypeUtils.getOuter(type);
        return outer != null && this.genericsInfo.getComposingTypes().contains(root.resolveClass(outer));
    }

    class TypeContextWriter
    extends RootContextAwareTypeWriter {
        TypeContextWriter() {
        }

        @Override
        public String write(Class<?> type, Map<String, Type> generics, Class<?> owner, Map<String, Type> ownerGenerics, String shift) {
            String res = super.write(type, generics, owner, ownerGenerics, shift);
            String pointer = type == GenericsContext.this.currentType ? GenericsContext.CURRENT_POSITION_MARKER : "";
            return res + pointer;
        }
    }

    public abstract class RootContextAwareTypeWriter
    extends GenericsInfo.DefaultTypeWriter {
        @Override
        public String write(Class<?> type, Map<String, Type> generics, Class<?> owner, Map<String, Type> ownerGenerics, String shift) {
            String res = super.write(type, generics, owner, ownerGenerics, shift);
            if (GenericsContext.this.root != null && type == GenericsContext.this.genericsInfo.getRootClass()) {
                res = res + String.format("  resolved in context of %s", TypeToStringUtils.toStringWithGenerics(GenericsContext.this.rootContext().genericsInfo.getRootClass(), GenericsContext.this.rootContext().genericsMap()));
            }
            return res;
        }
    }
}

