/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.knn;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import org.apache.spark.ml.knn.Empty$;
import org.apache.spark.ml.knn.KNN;
import org.apache.spark.ml.knn.Leaf;
import org.apache.spark.ml.knn.Leaf$;
import org.apache.spark.ml.knn.MetricTree;
import org.apache.spark.ml.knn.SpillTree;
import org.apache.spark.ml.knn.Tree;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class HybridTree$ {
    public static final HybridTree$ MODULE$;

    static {
        new HybridTree$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tree build(IndexedSeq<KNN.RowWithVector> data, int leafSize, double tau, double rho, long seed) {
        Tree tree;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        int size = data.size();
        if (size == 0) {
            tree = Empty$.MODULE$;
            return tree;
        } else if (size <= leafSize) {
            tree = Leaf$.MODULE$.apply(data);
            return tree;
        } else {
            KNN.VectorWithNorm leftPivot;
            XORShiftRandom rand = new XORShiftRandom(seed);
            KNN.VectorWithNorm randomPivot = ((KNN.RowWithVector)data.apply(rand.nextInt(size))).vector();
            KNN.VectorWithNorm vectorWithNorm = leftPivot = ((KNN.RowWithVector)data.maxBy((Function1)new Serializable(randomPivot){
                public static final long serialVersionUID = 0L;
                private final KNN.VectorWithNorm randomPivot$3;

                public final double apply(KNN.RowWithVector v) {
                    return this.randomPivot$3.fastSquaredDistance(v.vector());
                }
                {
                    this.randomPivot$3 = randomPivot$3;
                }
            }, (Ordering)Ordering.Double$.MODULE$)).vector();
            KNN.VectorWithNorm vectorWithNorm2 = randomPivot;
            if (!(vectorWithNorm != null ? !((Object)vectorWithNorm).equals(vectorWithNorm2) : vectorWithNorm2 != null)) {
                tree = new Leaf(data, randomPivot, 0.0);
                return tree;
            } else {
                ObjectRef dataWithDistance$lzy = ObjectRef.zero();
                ObjectRef leftPartition$lzy = ObjectRef.zero();
                ObjectRef rightPartition$lzy = ObjectRef.zero();
                KNN.VectorWithNorm rightPivot = ((KNN.RowWithVector)data.maxBy((Function1)new Serializable(leftPivot){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm leftPivot$3;

                    public final double apply(KNN.RowWithVector v) {
                        return this.leftPivot$3.fastSquaredDistance(v.vector());
                    }
                    {
                        this.leftPivot$3 = leftPivot$3;
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).vector();
                KNN.VectorWithNorm pivot = new KNN.VectorWithNorm(Vectors$.MODULE$.fromBreeze((Vector)((ImmutableNumericOps)leftPivot.vector().asBreeze().$plus((Object)rightPivot.vector().asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd())).$div((Object)BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv())));
                double radius = package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)data.map((Function1)new Serializable(pivot){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm pivot$3;

                    public final double apply(KNN.RowWithVector v) {
                        return this.pivot$3.fastSquaredDistance(v.vector());
                    }
                    {
                        this.pivot$3 = pivot$3;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$)));
                if (rho <= 0.0 || (double)this.leftPartition$1(data, tau, leftPivot, rightPivot, dataWithDistance$lzy, leftPartition$lzy, bitmap$0).size() > (double)size * rho || (double)this.rightPartition$1(data, tau, leftPivot, rightPivot, dataWithDistance$lzy, rightPartition$lzy, bitmap$0).size() > (double)size * rho) {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = data.partition((Function1)new Serializable(leftPivot, rightPivot){
                        public static final long serialVersionUID = 0L;
                        private final KNN.VectorWithNorm leftPivot$3;
                        private final KNN.VectorWithNorm rightPivot$3;

                        public final boolean apply(KNN.RowWithVector v) {
                            return this.leftPivot$3.fastSquaredDistance(v.vector()) < this.rightPivot$3.fastSquaredDistance(v.vector());
                        }
                        {
                            this.leftPivot$3 = leftPivot$3;
                            this.rightPivot$3 = rightPivot$3;
                        }
                    });
                    if (tuple22 == null) throw new MatchError((Object)tuple22);
                    IndexedSeq leftPartition2 = (IndexedSeq)tuple22._1();
                    IndexedSeq rightPartition2 = (IndexedSeq)tuple22._2();
                    Tuple2 tuple23 = tuple2 = new Tuple2((Object)leftPartition2, (Object)rightPartition2);
                    IndexedSeq leftPartition3 = (IndexedSeq)tuple23._1();
                    IndexedSeq rightPartition3 = (IndexedSeq)tuple23._2();
                    tree = new MetricTree(this.build((IndexedSeq<KNN.RowWithVector>)leftPartition3, leafSize, tau, rho, rand.nextLong()), leftPivot, this.build((IndexedSeq<KNN.RowWithVector>)rightPartition3, leafSize, tau, rho, rand.nextLong()), rightPivot, pivot, radius);
                    return tree;
                } else {
                    tree = new SpillTree(this.build((IndexedSeq<KNN.RowWithVector>)this.leftPartition$1(data, tau, leftPivot, rightPivot, dataWithDistance$lzy, leftPartition$lzy, bitmap$0), leafSize, tau, rho, rand.nextLong()), leftPivot, this.build((IndexedSeq<KNN.RowWithVector>)this.rightPartition$1(data, tau, leftPivot, rightPivot, dataWithDistance$lzy, rightPartition$lzy, bitmap$0), leafSize, tau, rho, rand.nextLong()), rightPivot, pivot, radius, tau, this.leftPartition$1(data, tau, leftPivot, rightPivot, dataWithDistance$lzy, leftPartition$lzy, bitmap$0).size() + this.rightPartition$1(data, tau, leftPivot, rightPivot, dataWithDistance$lzy, rightPartition$lzy, bitmap$0).size() - size);
                }
            }
        }
        return tree;
    }

    public int build$default$2() {
        return 1;
    }

    public double build$default$4() {
        return 0.7;
    }

    public long build$default$5() {
        return 0L;
    }

    private final IndexedSeq dataWithDistance$lzycompute$1(IndexedSeq data$1, KNN.VectorWithNorm leftPivot$3, KNN.VectorWithNorm rightPivot$3, ObjectRef dataWithDistance$lzy$1, VolatileByteRef bitmap$0$2) {
        HybridTree$ hybridTree$ = this;
        synchronized (hybridTree$) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                dataWithDistance$lzy$1.elem = (IndexedSeq)data$1.map((Function1)new Serializable(leftPivot$3, rightPivot$3){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm leftPivot$3;
                    private final KNN.VectorWithNorm rightPivot$3;

                    public final Tuple3<KNN.RowWithVector, Object, Object> apply(KNN.RowWithVector v) {
                        return new Tuple3((Object)v, (Object)BoxesRunTime.boxToDouble((double)this.leftPivot$3.fastDistance(v.vector())), (Object)BoxesRunTime.boxToDouble((double)this.rightPivot$3.fastDistance(v.vector())));
                    }
                    {
                        this.leftPivot$3 = leftPivot$3;
                        this.rightPivot$3 = rightPivot$3;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (IndexedSeq)dataWithDistance$lzy$1.elem;
        }
    }

    private final IndexedSeq dataWithDistance$1(IndexedSeq data$1, KNN.VectorWithNorm leftPivot$3, KNN.VectorWithNorm rightPivot$3, ObjectRef dataWithDistance$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.dataWithDistance$lzycompute$1(data$1, leftPivot$3, rightPivot$3, dataWithDistance$lzy$1, bitmap$0$2) : (IndexedSeq)dataWithDistance$lzy$1.elem;
    }

    private final IndexedSeq leftPartition$lzycompute$1(IndexedSeq data$1, double tau$1, KNN.VectorWithNorm leftPivot$3, KNN.VectorWithNorm rightPivot$3, ObjectRef dataWithDistance$lzy$1, ObjectRef leftPartition$lzy$1, VolatileByteRef bitmap$0$2) {
        HybridTree$ hybridTree$ = this;
        synchronized (hybridTree$) {
            if ((byte)(bitmap$0$2.elem & 2) == 0) {
                leftPartition$lzy$1.elem = (IndexedSeq)((TraversableLike)this.dataWithDistance$1(data$1, leftPivot$3, rightPivot$3, dataWithDistance$lzy$1, bitmap$0$2).filter((Function1)new Serializable(tau$1){
                    public static final long serialVersionUID = 0L;
                    private final double tau$1;

                    public final boolean apply(Tuple3<KNN.RowWithVector, Object, Object> x0$4) {
                        Tuple3<KNN.RowWithVector, Object, Object> tuple3 = x0$4;
                        if (tuple3 != null) {
                            double right;
                            double left = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            boolean bl = left - (right = BoxesRunTime.unboxToDouble((Object)tuple3._3())) <= this.tau$1;
                            return bl;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        this.tau$1 = tau$1;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final KNN.RowWithVector apply(Tuple3<KNN.RowWithVector, Object, Object> x$9) {
                        return (KNN.RowWithVector)x$9._1();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 2);
            }
            return (IndexedSeq)leftPartition$lzy$1.elem;
        }
    }

    private final IndexedSeq leftPartition$1(IndexedSeq data$1, double tau$1, KNN.VectorWithNorm leftPivot$3, KNN.VectorWithNorm rightPivot$3, ObjectRef dataWithDistance$lzy$1, ObjectRef leftPartition$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 2) == 0 ? this.leftPartition$lzycompute$1(data$1, tau$1, leftPivot$3, rightPivot$3, dataWithDistance$lzy$1, leftPartition$lzy$1, bitmap$0$2) : (IndexedSeq)leftPartition$lzy$1.elem;
    }

    private final IndexedSeq rightPartition$lzycompute$1(IndexedSeq data$1, double tau$1, KNN.VectorWithNorm leftPivot$3, KNN.VectorWithNorm rightPivot$3, ObjectRef dataWithDistance$lzy$1, ObjectRef rightPartition$lzy$1, VolatileByteRef bitmap$0$2) {
        HybridTree$ hybridTree$ = this;
        synchronized (hybridTree$) {
            if ((byte)(bitmap$0$2.elem & 4) == 0) {
                rightPartition$lzy$1.elem = (IndexedSeq)((TraversableLike)this.dataWithDistance$1(data$1, leftPivot$3, rightPivot$3, dataWithDistance$lzy$1, bitmap$0$2).filter((Function1)new Serializable(tau$1){
                    public static final long serialVersionUID = 0L;
                    private final double tau$1;

                    public final boolean apply(Tuple3<KNN.RowWithVector, Object, Object> x0$5) {
                        Tuple3<KNN.RowWithVector, Object, Object> tuple3 = x0$5;
                        if (tuple3 != null) {
                            double left = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            double right = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            boolean bl = right - left <= this.tau$1;
                            return bl;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        this.tau$1 = tau$1;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final KNN.RowWithVector apply(Tuple3<KNN.RowWithVector, Object, Object> x$10) {
                        return (KNN.RowWithVector)x$10._1();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 4);
            }
            return (IndexedSeq)rightPartition$lzy$1.elem;
        }
    }

    private final IndexedSeq rightPartition$1(IndexedSeq data$1, double tau$1, KNN.VectorWithNorm leftPivot$3, KNN.VectorWithNorm rightPivot$3, ObjectRef dataWithDistance$lzy$1, ObjectRef rightPartition$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 4) == 0 ? this.rightPartition$lzycompute$1(data$1, tau$1, leftPivot$3, rightPivot$3, dataWithDistance$lzy$1, rightPartition$lzy$1, bitmap$0$2) : (IndexedSeq)rightPartition$lzy$1.elem;
    }

    private HybridTree$() {
        MODULE$ = this;
    }
}

