/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.knn;

import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.knn.KNN;
import org.apache.spark.ml.knn.KNN$;
import org.apache.spark.ml.knn.KNNModelParams;
import org.apache.spark.ml.knn.KNNModelParams$;
import org.apache.spark.ml.knn.KNNModelParams$$anonfun$4$;
import org.apache.spark.ml.knn.Tree;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.mllib.rdd.MLPairRDDFunctions$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class KNNModelParams$class {
    public static String getNeighborsCol(KNNModelParams $this) {
        return (String)$this.$($this.neighborsCol());
    }

    public static String getDistanceCol(KNNModelParams $this) {
        return (String)$this.$($this.distanceCol());
    }

    public static int getK(KNNModelParams $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.k()));
    }

    public static double getMaxDistance(KNNModelParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.maxDistance()));
    }

    public static double getBufferSize(KNNModelParams $this) {
        return BoxesRunTime.unboxToDouble((Object)$this.$((Param)$this.bufferSize()));
    }

    public static RDD transform(KNNModelParams $this, RDD data, Broadcast topTree, RDD subTrees) {
        RDD searchData = RDD$.MODULE$.rddToPairRDDFunctions(data.zipWithIndex().flatMap((Function1)new Serializable($this, topTree){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KNNModelParams $outer;
            private final Broadcast topTree$1;

            public final Seq<Tuple2<Object, Tuple2<KNN.VectorWithNorm, Object>>> apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector vector = (Vector)tuple2._1();
                    long index = tuple2._2$mcJ$sp();
                    KNN.VectorWithNorm vectorWithNorm = new KNN.VectorWithNorm(vector);
                    Seq idx = (Seq)KNN$.MODULE$.searchIndices(vectorWithNorm, (Tree)this.topTree$1.value(), BoxesRunTime.unboxToDouble((Object)this.$outer.$((Param)this.$outer.bufferSize())), KNN$.MODULE$.searchIndices$default$4()).map((Function1)new Serializable(this, index, vectorWithNorm){
                        public static final long serialVersionUID = 0L;
                        private final long index$1;
                        private final KNN.VectorWithNorm vectorWithNorm$1;

                        public final Tuple2<Object, Tuple2<KNN.VectorWithNorm, Object>> apply(int i) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new Tuple2((Object)this.vectorWithNorm$1, (Object)BoxesRunTime.boxToLong((long)this.index$1)));
                        }
                        {
                            this.index$1 = index$1;
                            this.vectorWithNorm$1 = vectorWithNorm$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Predef$.MODULE$.assert(idx.nonEmpty(), (Function0)new Serializable(this, vector, index){
                        public static final long serialVersionUID = 0L;
                        private final Vector vector$1;
                        private final long index$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"indices must be non-empty: ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.vector$1, BoxesRunTime.boxToLong((long)this.index$1)}));
                        }
                        {
                            this.vector$1 = vector$1;
                            this.index$1 = index$1;
                        }
                    });
                    Seq seq = idx;
                    return seq;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topTree$1 = topTree$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new HashPartitioner(subTrees.partitions().length));
        RDD results = searchData.zipPartitions(subTrees, (Function2)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KNNModelParams $outer;

            public final Iterator<Tuple2<Object, Tuple2<Row, Object>>> apply(Iterator<Tuple2<Object, Tuple2<KNN.VectorWithNorm, Object>>> childData, Iterator<Tree> trees) {
                Tree tree = (Tree)trees.next();
                Predef$.MODULE$.assert(!trees.hasNext());
                return childData.flatMap((Function1)new Serializable(this, tree){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KNNModelParams$.anonfun.4 $outer;
                    private final Tree tree$1;

                    public final Iterable<Tuple2<Object, Tuple2<Row, Object>>> apply(Tuple2<Object, Tuple2<KNN.VectorWithNorm, Object>> x0$2) {
                        Tuple2 tuple2;
                        Tuple2<Object, Tuple2<KNN.VectorWithNorm, Object>> tuple22 = x0$2;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                            KNN.VectorWithNorm point = (KNN.VectorWithNorm)tuple2._1();
                            long i = tuple2._2$mcJ$sp();
                            Iterable iterable = (Iterable)this.tree$1.query(point, BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$ml$knn$KNNModelParams$$anonfun$$$outer().$((Param)this.$outer.org$apache$spark$ml$knn$KNNModelParams$$anonfun$$$outer().k()))).collect((PartialFunction)new Serializable(this, i){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ KNNModelParams$$anonfun$4$.anonfun.apply.5 $outer;
                                private final long i$1;

                                /*
                                 * Enabled aggressive block sorting
                                 */
                                public final <A1 extends Tuple2<KNN.RowWithVector, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Object object;
                                    A1 A1 = x1;
                                    if (A1 != null) {
                                        KNN.RowWithVector neighbor = (KNN.RowWithVector)A1._1();
                                        double distance = A1._2$mcD$sp();
                                        if (distance <= BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$ml$knn$KNNModelParams$$anonfun$$anonfun$$$outer().org$apache$spark$ml$knn$KNNModelParams$$anonfun$$$outer().$((Param)this.$outer.org$apache$spark$ml$knn$KNNModelParams$$anonfun$$anonfun$$$outer().org$apache$spark$ml$knn$KNNModelParams$$anonfun$$$outer().maxDistance()))) {
                                            object = new Tuple2((Object)BoxesRunTime.boxToLong((long)this.i$1), (Object)new Tuple2((Object)neighbor.row(), (Object)BoxesRunTime.boxToDouble((double)distance)));
                                            return (B1)object;
                                        }
                                    }
                                    object = function1.apply(x1);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Tuple2<KNN.RowWithVector, Object> x1) {
                                    double distance;
                                    Tuple2<KNN.RowWithVector, Object> tuple2 = x1;
                                    boolean bl = tuple2 != null && (distance = tuple2._2$mcD$sp()) <= BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$ml$knn$KNNModelParams$$anonfun$$anonfun$$$outer().org$apache$spark$ml$knn$KNNModelParams$$anonfun$$$outer().$((Param)this.$outer.org$apache$spark$ml$knn$KNNModelParams$$anonfun$$anonfun$$$outer().org$apache$spark$ml$knn$KNNModelParams$$anonfun$$$outer().maxDistance()));
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.i$1 = i$1;
                                }
                            }, Iterable$.MODULE$.canBuildFrom());
                            return iterable;
                        }
                        throw new MatchError(tuple22);
                    }

                    public /* synthetic */ KNNModelParams$.anonfun.4 org$apache$spark$ml$knn$KNNModelParams$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tree$1 = tree$1;
                    }
                });
            }

            public /* synthetic */ KNNModelParams org$apache$spark$ml$knn$KNNModelParams$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tree.class), ClassTag$.MODULE$.apply(Tuple2.class));
        return MLPairRDDFunctions$.MODULE$.fromPairRDD(results, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class)).topByKey(BoxesRunTime.unboxToInt((Object)$this.$((Param)$this.k())), package$.MODULE$.Ordering().by((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Row, Object> x$1) {
                return -x$1._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Row, Object>[]> apply(Tuple2<Object, Tuple2<Row, Object>[]> x0$3) {
                Tuple2<Object, Tuple2<Row, Object>[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    long i = tuple2._1$mcJ$sp();
                    Tuple2[] seq = (Tuple2[])tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)i), (Object)seq);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static RDD transform(KNNModelParams $this, Dataset dataset, Broadcast topTree, RDD subTrees) {
        return $this.transform((RDD<Vector>)dataset.select((String)$this.$($this.featuresCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(Row x$2) {
                return (Vector)x$2.getAs(0);
            }
        }, ClassTag$.MODULE$.apply(Vector.class)), (Broadcast<Tree>)topTree, (RDD<Tree>)subTrees);
    }

    public static void $init$(KNNModelParams $this) {
        $this.org$apache$spark$ml$knn$KNNModelParams$_setter_$neighborsCol_$eq(new Param((Identifiable)$this, "neighborsCol", "column names for returned neighbors"));
        $this.org$apache$spark$ml$knn$KNNModelParams$_setter_$distanceCol_$eq(new Param((Identifiable)$this, "distanceCol", "column that includes each neighbors' distance as an additional column"));
        $this.org$apache$spark$ml$knn$KNNModelParams$_setter_$k_$eq(new IntParam((Identifiable)$this, "k", "number of neighbors to find", ParamValidators$.MODULE$.gt(0.0)));
        $this.org$apache$spark$ml$knn$KNNModelParams$_setter_$maxDistance_$eq(new DoubleParam((Identifiable)$this, "maxNeighbors", "maximum distance to find neighbors", ParamValidators$.MODULE$.gt(0.0)));
        $this.org$apache$spark$ml$knn$KNNModelParams$_setter_$bufferSize_$eq(new DoubleParam((Identifiable)$this, "bufferSize", "size of buffer used to construct spill trees and top-level tree search", ParamValidators$.MODULE$.gtEq(-1.0)));
    }
}

