/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.knn;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import org.apache.spark.ml.knn.Empty$;
import org.apache.spark.ml.knn.KNN;
import org.apache.spark.ml.knn.Leaf;
import org.apache.spark.ml.knn.Leaf$;
import org.apache.spark.ml.knn.MetricTree;
import org.apache.spark.ml.knn.Tree;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class MetricTree$
implements Serializable {
    public static final MetricTree$ MODULE$;

    static {
        new MetricTree$();
    }

    public Tree build(IndexedSeq<KNN.RowWithVector> data, int leafSize, long seed) {
        Tuple2 tuple2;
        block6: {
            Tree tree;
            block3: {
                Tuple2 tuple22;
                KNN.VectorWithNorm leftPivot;
                XORShiftRandom rand;
                block5: {
                    int size;
                    block4: {
                        block2: {
                            size = data.size();
                            if (size != 0) break block2;
                            tree = Empty$.MODULE$;
                            break block3;
                        }
                        if (size > leafSize) break block4;
                        tree = Leaf$.MODULE$.apply(data);
                        break block3;
                    }
                    rand = new XORShiftRandom(seed);
                    KNN.VectorWithNorm randomPivot = ((KNN.RowWithVector)data.apply(rand.nextInt(size))).vector();
                    KNN.VectorWithNorm vectorWithNorm = leftPivot = ((KNN.RowWithVector)data.maxBy((Function1)new Serializable(randomPivot){
                        public static final long serialVersionUID = 0L;
                        private final KNN.VectorWithNorm randomPivot$1;

                        public final double apply(KNN.RowWithVector v) {
                            return this.randomPivot$1.fastSquaredDistance(v.vector());
                        }
                        {
                            this.randomPivot$1 = randomPivot$1;
                        }
                    }, (Ordering)Ordering.Double$.MODULE$)).vector();
                    KNN.VectorWithNorm vectorWithNorm2 = randomPivot;
                    if (vectorWithNorm != null ? !((Object)vectorWithNorm).equals(vectorWithNorm2) : vectorWithNorm2 != null) break block5;
                    tree = new Leaf(data, randomPivot, 0.0);
                    break block3;
                }
                KNN.VectorWithNorm rightPivot = ((KNN.RowWithVector)data.maxBy((Function1)new Serializable(leftPivot){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm leftPivot$1;

                    public final double apply(KNN.RowWithVector v) {
                        return this.leftPivot$1.fastSquaredDistance(v.vector());
                    }
                    {
                        this.leftPivot$1 = leftPivot$1;
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).vector();
                KNN.VectorWithNorm pivot = new KNN.VectorWithNorm(Vectors$.MODULE$.fromBreeze((Vector)((ImmutableNumericOps)leftPivot.vector().asBreeze().$plus((Object)rightPivot.vector().asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd())).$div((Object)BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv())));
                double radius = package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)data.map((Function1)new Serializable(pivot){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm pivot$1;

                    public final double apply(KNN.RowWithVector v) {
                        return this.pivot$1.fastSquaredDistance(v.vector());
                    }
                    {
                        this.pivot$1 = pivot$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$)));
                tuple2 = data.partition((Function1)new Serializable(leftPivot, rightPivot){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm leftPivot$1;
                    private final KNN.VectorWithNorm rightPivot$1;

                    public final boolean apply(KNN.RowWithVector v) {
                        return this.leftPivot$1.fastSquaredDistance(v.vector()) < this.rightPivot$1.fastSquaredDistance(v.vector());
                    }
                    {
                        this.leftPivot$1 = leftPivot$1;
                        this.rightPivot$1 = rightPivot$1;
                    }
                });
                if (tuple2 == null) break block6;
                IndexedSeq leftPartition2 = (IndexedSeq)tuple2._1();
                IndexedSeq rightPartition2 = (IndexedSeq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftPartition2, (Object)rightPartition2);
                IndexedSeq leftPartition3 = (IndexedSeq)tuple23._1();
                IndexedSeq rightPartition3 = (IndexedSeq)tuple23._2();
                tree = new MetricTree(this.build((IndexedSeq<KNN.RowWithVector>)leftPartition3, leafSize, rand.nextLong()), leftPivot, this.build((IndexedSeq<KNN.RowWithVector>)rightPartition3, leafSize, rand.nextLong()), rightPivot, pivot, radius);
            }
            return tree;
        }
        throw new MatchError((Object)tuple2);
    }

    public int build$default$2() {
        return 1;
    }

    public long build$default$3() {
        return 0L;
    }

    public MetricTree apply(Tree leftChild, KNN.VectorWithNorm leftPivot, Tree rightChild, KNN.VectorWithNorm rightPivot, KNN.VectorWithNorm pivot, double radius) {
        return new MetricTree(leftChild, leftPivot, rightChild, rightPivot, pivot, radius);
    }

    public Option<Tuple6<Tree, KNN.VectorWithNorm, Tree, KNN.VectorWithNorm, KNN.VectorWithNorm, Object>> unapply(MetricTree x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.leftChild(), (Object)x$0.leftPivot(), (Object)x$0.rightChild(), (Object)x$0.rightPivot(), (Object)x$0.pivot(), (Object)BoxesRunTime.boxToDouble((double)x$0.radius())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MetricTree$() {
        MODULE$ = this;
    }
}

