/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.knn;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import org.apache.spark.ml.knn.Empty$;
import org.apache.spark.ml.knn.KNN;
import org.apache.spark.ml.knn.Leaf;
import org.apache.spark.ml.knn.Leaf$;
import org.apache.spark.ml.knn.SpillTree;
import org.apache.spark.ml.knn.Tree;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.Tuple8;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class SpillTree$
implements Serializable {
    public static final SpillTree$ MODULE$;

    static {
        new SpillTree$();
    }

    public Tree build(IndexedSeq<KNN.RowWithVector> data, int leafSize, double tau, long seed) {
        Tree tree;
        int size = data.size();
        if (size == 0) {
            tree = Empty$.MODULE$;
        } else if (size <= leafSize) {
            tree = Leaf$.MODULE$.apply(data);
        } else {
            KNN.VectorWithNorm leftPivot;
            XORShiftRandom rand = new XORShiftRandom(seed);
            KNN.VectorWithNorm randomPivot = ((KNN.RowWithVector)data.apply(rand.nextInt(size))).vector();
            KNN.VectorWithNorm vectorWithNorm = leftPivot = ((KNN.RowWithVector)data.maxBy((Function1)new Serializable(randomPivot){
                public static final long serialVersionUID = 0L;
                private final KNN.VectorWithNorm randomPivot$2;

                public final double apply(KNN.RowWithVector v) {
                    return this.randomPivot$2.fastSquaredDistance(v.vector());
                }
                {
                    this.randomPivot$2 = randomPivot$2;
                }
            }, (Ordering)Ordering.Double$.MODULE$)).vector();
            KNN.VectorWithNorm vectorWithNorm2 = randomPivot;
            if (!(vectorWithNorm != null ? !((Object)vectorWithNorm).equals(vectorWithNorm2) : vectorWithNorm2 != null)) {
                tree = new Leaf(data, randomPivot, 0.0);
            } else {
                KNN.VectorWithNorm rightPivot = ((KNN.RowWithVector)data.maxBy((Function1)new Serializable(leftPivot){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm leftPivot$2;

                    public final double apply(KNN.RowWithVector v) {
                        return this.leftPivot$2.fastSquaredDistance(v.vector());
                    }
                    {
                        this.leftPivot$2 = leftPivot$2;
                    }
                }, (Ordering)Ordering.Double$.MODULE$)).vector();
                KNN.VectorWithNorm pivot = new KNN.VectorWithNorm(Vectors$.MODULE$.fromBreeze((Vector)((ImmutableNumericOps)leftPivot.vector().asBreeze().$plus((Object)rightPivot.vector().asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd())).$div((Object)BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv())));
                double radius = package$.MODULE$.sqrt(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)data.map((Function1)new Serializable(pivot){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm pivot$2;

                    public final double apply(KNN.RowWithVector v) {
                        return this.pivot$2.fastSquaredDistance(v.vector());
                    }
                    {
                        this.pivot$2 = pivot$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$)));
                IndexedSeq dataWithDistance2 = (IndexedSeq)data.map((Function1)new Serializable(leftPivot, rightPivot){
                    public static final long serialVersionUID = 0L;
                    private final KNN.VectorWithNorm leftPivot$2;
                    private final KNN.VectorWithNorm rightPivot$2;

                    public final Tuple3<KNN.RowWithVector, Object, Object> apply(KNN.RowWithVector v) {
                        return new Tuple3((Object)v, (Object)BoxesRunTime.boxToDouble((double)this.leftPivot$2.fastDistance(v.vector())), (Object)BoxesRunTime.boxToDouble((double)this.rightPivot$2.fastDistance(v.vector())));
                    }
                    {
                        this.leftPivot$2 = leftPivot$2;
                        this.rightPivot$2 = rightPivot$2;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq leftPartition2 = (IndexedSeq)((TraversableLike)dataWithDistance2.filter((Function1)new Serializable(tau){
                    public static final long serialVersionUID = 0L;
                    private final double tau$2;

                    public final boolean apply(Tuple3<KNN.RowWithVector, Object, Object> x0$2) {
                        Tuple3<KNN.RowWithVector, Object, Object> tuple3 = x0$2;
                        if (tuple3 != null) {
                            double right;
                            double left = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            boolean bl = left - (right = BoxesRunTime.unboxToDouble((Object)tuple3._3())) <= this.tau$2;
                            return bl;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        this.tau$2 = tau$2;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final KNN.RowWithVector apply(Tuple3<KNN.RowWithVector, Object, Object> x$7) {
                        return (KNN.RowWithVector)x$7._1();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq rightPartition2 = (IndexedSeq)((TraversableLike)dataWithDistance2.filter((Function1)new Serializable(tau){
                    public static final long serialVersionUID = 0L;
                    private final double tau$2;

                    public final boolean apply(Tuple3<KNN.RowWithVector, Object, Object> x0$3) {
                        Tuple3<KNN.RowWithVector, Object, Object> tuple3 = x0$3;
                        if (tuple3 != null) {
                            double left = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            double right = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            boolean bl = right - left <= this.tau$2;
                            return bl;
                        }
                        throw new MatchError(tuple3);
                    }
                    {
                        this.tau$2 = tau$2;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final KNN.RowWithVector apply(Tuple3<KNN.RowWithVector, Object, Object> x$8) {
                        return (KNN.RowWithVector)x$8._1();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                tree = new SpillTree(this.build((IndexedSeq<KNN.RowWithVector>)leftPartition2, leafSize, tau, rand.nextLong()), leftPivot, this.build((IndexedSeq<KNN.RowWithVector>)rightPartition2, leafSize, tau, rand.nextLong()), rightPivot, pivot, radius, tau, leftPartition2.size() + rightPartition2.size() - size);
            }
        }
        return tree;
    }

    public int build$default$2() {
        return 1;
    }

    public long build$default$4() {
        return 0L;
    }

    public SpillTree apply(Tree leftChild, KNN.VectorWithNorm leftPivot, Tree rightChild, KNN.VectorWithNorm rightPivot, KNN.VectorWithNorm pivot, double radius, double tau, int bufferSize) {
        return new SpillTree(leftChild, leftPivot, rightChild, rightPivot, pivot, radius, tau, bufferSize);
    }

    public Option<Tuple8<Tree, KNN.VectorWithNorm, Tree, KNN.VectorWithNorm, KNN.VectorWithNorm, Object, Object, Object>> unapply(SpillTree x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.leftChild(), (Object)x$0.leftPivot(), (Object)x$0.rightChild(), (Object)x$0.rightPivot(), (Object)x$0.pivot(), (Object)BoxesRunTime.boxToDouble((double)x$0.radius()), (Object)BoxesRunTime.boxToDouble((double)x$0.tau()), (Object)BoxesRunTime.boxToInteger((int)x$0.bufferSize())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SpillTree$() {
        MODULE$ = this;
    }
}

