/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appconfig;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.appconfig.Action;
import software.amazon.awscdk.services.appconfig.ExtensionAttributes;
import software.amazon.awscdk.services.appconfig.ExtensionProps;
import software.amazon.awscdk.services.appconfig.IExtension;
import software.amazon.awscdk.services.appconfig.Parameter;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appconfig.Extension")
public class Extension
extends Resource
implements IExtension {
    protected Extension(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Extension(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Extension(@NotNull Construct scope, @NotNull String id, @NotNull ExtensionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IExtension fromExtensionArn(@NotNull Construct scope, @NotNull String id, @NotNull String extensionArn) {
        return (IExtension)JsiiObject.jsiiStaticCall(Extension.class, (String)"fromExtensionArn", (NativeType)NativeType.forClass(IExtension.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(extensionArn, "extensionArn is required")});
    }

    @NotNull
    public static IExtension fromExtensionAttributes(@NotNull Construct scope, @NotNull String id, @NotNull ExtensionAttributes attrs) {
        return (IExtension)JsiiObject.jsiiStaticCall(Extension.class, (String)"fromExtensionAttributes", (NativeType)NativeType.forClass(IExtension.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public String getExtensionArn() {
        return (String)Kernel.get((Object)this, (String)"extensionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return (String)Kernel.get((Object)this, (String)"extensionId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public Number getExtensionVersionNumber() {
        return (Number)Kernel.get((Object)this, (String)"extensionVersionNumber", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public List<Action> getActions() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"actions", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Action.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public Number getLatestVersionNumber() {
        return (Number)Kernel.get((Object)this, (String)"latestVersionNumber", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public List<Parameter> getParameters() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Parameter.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Extension> {
        private final Construct scope;
        private final String id;
        private final ExtensionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ExtensionProps.Builder();
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder extensionName(String extensionName) {
            this.props.extensionName(extensionName);
            return this;
        }

        public Builder latestVersionNumber(Number latestVersionNumber) {
            this.props.latestVersionNumber(latestVersionNumber);
            return this;
        }

        public Builder parameters(List<? extends Parameter> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder actions(List<? extends Action> actions) {
            this.props.actions(actions);
            return this;
        }

        public Extension build() {
            return new Extension(this.scope, this.id, this.props.build());
        }
    }
}

