/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.bedrock;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.bedrock.CfnFlow;
import software.amazon.awscdk.services.bedrock.CfnFlowProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow")
public class CfnFlow
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFlow.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFlow(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlow(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFlow(@NotNull Construct scope, @NotNull String id, @NotNull CfnFlowProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUpdatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrUpdatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrValidations() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrValidations", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrVersion() {
        return (String)Kernel.get((Object)this, (String)"attrVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"executionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setExecutionRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"executionRoleArn", (Object)Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getCustomerEncryptionKeyArn() {
        return (String)Kernel.get((Object)this, (String)"customerEncryptionKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setCustomerEncryptionKeyArn(@Nullable String value) {
        Kernel.set((Object)this, (String)"customerEncryptionKeyArn", (Object)value);
    }

    @Nullable
    public Object getDefinition() {
        return Kernel.get((Object)this, (String)"definition", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinition(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"definition", (Object)value);
    }

    public void setDefinition(@Nullable FlowDefinitionProperty value) {
        Kernel.set((Object)this, (String)"definition", (Object)value);
    }

    @Nullable
    public Object getDefinitionS3Location() {
        return Kernel.get((Object)this, (String)"definitionS3Location", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinitionS3Location(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"definitionS3Location", (Object)value);
    }

    public void setDefinitionS3Location(@Nullable S3LocationProperty value) {
        Kernel.set((Object)this, (String)"definitionS3Location", (Object)value);
    }

    @Nullable
    public String getDefinitionString() {
        return (String)Kernel.get((Object)this, (String)"definitionString", (NativeType)NativeType.forClass(String.class));
    }

    public void setDefinitionString(@Nullable String value) {
        Kernel.set((Object)this, (String)"definitionString", (Object)value);
    }

    @Nullable
    public Object getDefinitionSubstitutions() {
        return Kernel.get((Object)this, (String)"definitionSubstitutions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDefinitionSubstitutions(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"definitionSubstitutions", (Object)value);
    }

    public void setDefinitionSubstitutions(@Nullable Map<String, Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException("Expected " + "value" + ".keySet()" + " to contain class String; received " + value.keySet().toArray()[0].getClass());
            }
            for (Map.Entry<String, Object> __item_ac66f0 : value.entrySet()) {
                Object __val_ac66f0 = __item_ac66f0.getValue();
                if (__val_ac66f0 instanceof String || __val_ac66f0 instanceof Number || __val_ac66f0 instanceof Boolean || __val_ac66f0 instanceof IResolvable || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(\"" + __item_ac66f0.getKey() + "\")" + " to be one of: java.lang.String, java.lang.Number, java.lang.Boolean, software.amazon.awscdk.IResolvable; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"definitionSubstitutions", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Nullable
    public Object getTestAliasTags() {
        return Kernel.get((Object)this, (String)"testAliasTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTestAliasTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"testAliasTags", (Object)value);
    }

    public void setTestAliasTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"testAliasTags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFlow> {
        private final Construct scope;
        private final String id;
        private final CfnFlowProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFlowProps.Builder();
        }

        public Builder executionRoleArn(String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder customerEncryptionKeyArn(String customerEncryptionKeyArn) {
            this.props.customerEncryptionKeyArn(customerEncryptionKeyArn);
            return this;
        }

        public Builder definition(IResolvable definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder definition(FlowDefinitionProperty definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder definitionS3Location(IResolvable definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }

        public Builder definitionS3Location(S3LocationProperty definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }

        public Builder definitionString(String definitionString) {
            this.props.definitionString(definitionString);
            return this;
        }

        public Builder definitionSubstitutions(IResolvable definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        public Builder definitionSubstitutions(Map<String, ? extends Object> definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder testAliasTags(IResolvable testAliasTags) {
            this.props.testAliasTags(testAliasTags);
            return this;
        }

        public Builder testAliasTags(Map<String, String> testAliasTags) {
            this.props.testAliasTags(testAliasTags);
            return this;
        }

        public CfnFlow build() {
            return new CfnFlow(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.TextPromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TextPromptTemplateConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getText();

        @Nullable
        default public Object getInputVariables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TextPromptTemplateConfigurationProperty> {
            String text;
            Object inputVariables;

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder inputVariables(IResolvable inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            public Builder inputVariables(List<? extends Object> inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            public TextPromptTemplateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeServiceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageFlowNodeServiceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageFlowNodeServiceConfigurationProperty> {
            Object s3;

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(StorageFlowNodeS3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            public StorageFlowNodeServiceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeS3ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageFlowNodeS3ConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageFlowNodeS3ConfigurationProperty> {
            String bucketName;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public StorageFlowNodeS3ConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getServiceConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageFlowNodeConfigurationProperty> {
            Object serviceConfiguration;

            public Builder serviceConfiguration(IResolvable serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            public Builder serviceConfiguration(StorageFlowNodeServiceConfigurationProperty serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            public StorageFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.S3LocationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LocationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucket();

        @NotNull
        public String getKey();

        @Nullable
        default public String getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LocationProperty> {
            String bucket;
            String key;
            String version;

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public S3LocationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeServiceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetrievalFlowNodeServiceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetrievalFlowNodeServiceConfigurationProperty> {
            Object s3;

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(RetrievalFlowNodeS3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            public RetrievalFlowNodeServiceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeS3ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetrievalFlowNodeS3ConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetrievalFlowNodeS3ConfigurationProperty> {
            String bucketName;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public RetrievalFlowNodeS3ConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetrievalFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getServiceConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetrievalFlowNodeConfigurationProperty> {
            Object serviceConfiguration;

            public Builder serviceConfiguration(IResolvable serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            public Builder serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            public RetrievalFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.PromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptTemplateConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getText();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptTemplateConfigurationProperty> {
            Object text;

            public Builder text(IResolvable text) {
                this.text = text;
                return this;
            }

            public Builder text(TextPromptTemplateConfigurationProperty text) {
                this.text = text;
                return this;
            }

            public PromptTemplateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.PromptModelInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptModelInferenceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxTokens() {
            return null;
        }

        @Nullable
        default public List<String> getStopSequences() {
            return null;
        }

        @Nullable
        default public Number getTemperature() {
            return null;
        }

        @Nullable
        default public Number getTopP() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptModelInferenceConfigurationProperty> {
            Number maxTokens;
            List<String> stopSequences;
            Number temperature;
            Number topP;

            public Builder maxTokens(Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder stopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder temperature(Number temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder topP(Number topP) {
                this.topP = topP;
                return this;
            }

            public PromptModelInferenceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.PromptInputVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptInputVariableProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptInputVariableProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public PromptInputVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.PromptInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptInferenceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getText();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptInferenceConfigurationProperty> {
            Object text;

            public Builder text(IResolvable text) {
                this.text = text;
                return this;
            }

            public Builder text(PromptModelInferenceConfigurationProperty text) {
                this.text = text;
                return this;
            }

            public PromptInferenceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptFlowNodeSourceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInline() {
            return null;
        }

        @Nullable
        default public Object getResource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptFlowNodeSourceConfigurationProperty> {
            Object inline;
            Object resource;

            public Builder inline(IResolvable inline) {
                this.inline = inline;
                return this;
            }

            public Builder inline(PromptFlowNodeInlineConfigurationProperty inline) {
                this.inline = inline;
                return this;
            }

            public Builder resource(IResolvable resource) {
                this.resource = resource;
                return this;
            }

            public Builder resource(PromptFlowNodeResourceConfigurationProperty resource) {
                this.resource = resource;
                return this;
            }

            public PromptFlowNodeSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeResourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptFlowNodeResourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getPromptArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptFlowNodeResourceConfigurationProperty> {
            String promptArn;

            public Builder promptArn(String promptArn) {
                this.promptArn = promptArn;
                return this;
            }

            public PromptFlowNodeResourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeInlineConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptFlowNodeInlineConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getModelId();

        @NotNull
        public Object getTemplateConfiguration();

        @NotNull
        public String getTemplateType();

        @Nullable
        default public Object getInferenceConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptFlowNodeInlineConfigurationProperty> {
            String modelId;
            Object templateConfiguration;
            String templateType;
            Object inferenceConfiguration;

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public Builder templateConfiguration(IResolvable templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            public Builder templateConfiguration(PromptTemplateConfigurationProperty templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            public Builder templateType(String templateType) {
                this.templateType = templateType;
                return this;
            }

            public Builder inferenceConfiguration(IResolvable inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            public Builder inferenceConfiguration(PromptInferenceConfigurationProperty inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            public PromptFlowNodeInlineConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSourceConfiguration();

        @Nullable
        default public Object getGuardrailConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptFlowNodeConfigurationProperty> {
            Object sourceConfiguration;
            Object guardrailConfiguration;

            public Builder sourceConfiguration(IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder sourceConfiguration(PromptFlowNodeSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder guardrailConfiguration(IResolvable guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            public Builder guardrailConfiguration(GuardrailConfigurationProperty guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            public PromptFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.LexFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LexFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBotAliasArn();

        @NotNull
        public String getLocaleId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LexFlowNodeConfigurationProperty> {
            String botAliasArn;
            String localeId;

            public Builder botAliasArn(String botAliasArn) {
                this.botAliasArn = botAliasArn;
                return this;
            }

            public Builder localeId(String localeId) {
                this.localeId = localeId;
                return this;
            }

            public LexFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.LambdaFunctionFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaFunctionFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLambdaArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaFunctionFlowNodeConfigurationProperty> {
            String lambdaArn;

            public Builder lambdaArn(String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            public LambdaFunctionFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.KnowledgeBaseFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KnowledgeBaseFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getKnowledgeBaseId();

        @Nullable
        default public Object getGuardrailConfiguration() {
            return null;
        }

        @Nullable
        default public String getModelId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KnowledgeBaseFlowNodeConfigurationProperty> {
            String knowledgeBaseId;
            Object guardrailConfiguration;
            String modelId;

            public Builder knowledgeBaseId(String knowledgeBaseId) {
                this.knowledgeBaseId = knowledgeBaseId;
                return this;
            }

            public Builder guardrailConfiguration(IResolvable guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            public Builder guardrailConfiguration(GuardrailConfigurationProperty guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public KnowledgeBaseFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.GuardrailConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GuardrailConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getGuardrailIdentifier() {
            return null;
        }

        @Nullable
        default public String getGuardrailVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GuardrailConfigurationProperty> {
            String guardrailIdentifier;
            String guardrailVersion;

            public Builder guardrailIdentifier(String guardrailIdentifier) {
                this.guardrailIdentifier = guardrailIdentifier;
                return this;
            }

            public Builder guardrailVersion(String guardrailVersion) {
                this.guardrailVersion = guardrailVersion;
                return this;
            }

            public GuardrailConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowValidationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowValidationProperty
    extends JsiiSerializable {
        @NotNull
        public String getMessage();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowValidationProperty> {
            String message;

            public Builder message(String message) {
                this.message = message;
                return this;
            }

            public FlowValidationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowNodeProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        @Nullable
        default public Object getConfiguration() {
            return null;
        }

        @Nullable
        default public Object getInputs() {
            return null;
        }

        @Nullable
        default public Object getOutputs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowNodeProperty> {
            String name;
            String type;
            Object configuration;
            Object inputs;
            Object outputs;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder configuration(IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder configuration(FlowNodeConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder inputs(IResolvable inputs) {
                this.inputs = inputs;
                return this;
            }

            public Builder inputs(List<? extends Object> inputs) {
                this.inputs = inputs;
                return this;
            }

            public Builder outputs(IResolvable outputs) {
                this.outputs = outputs;
                return this;
            }

            public Builder outputs(List<? extends Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            public FlowNodeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowNodeOutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowNodeOutputProperty> {
            String name;
            String type;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FlowNodeOutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowNodeInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @NotNull
        public String getName();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowNodeInputProperty> {
            String expression;
            String name;
            String type;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FlowNodeInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowNodeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAgent() {
            return null;
        }

        @Nullable
        default public Object getCollector() {
            return null;
        }

        @Nullable
        default public Object getCondition() {
            return null;
        }

        @Nullable
        default public Object getInput() {
            return null;
        }

        @Nullable
        default public Object getIterator() {
            return null;
        }

        @Nullable
        default public Object getKnowledgeBase() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunction() {
            return null;
        }

        @Nullable
        default public Object getLex() {
            return null;
        }

        @Nullable
        default public Object getOutput() {
            return null;
        }

        @Nullable
        default public Object getPrompt() {
            return null;
        }

        @Nullable
        default public Object getRetrieval() {
            return null;
        }

        @Nullable
        default public Object getStorage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowNodeConfigurationProperty> {
            Object agent;
            Object collector;
            Object condition;
            Object input;
            Object iterator;
            Object knowledgeBase;
            Object lambdaFunction;
            Object lex;
            Object output;
            Object prompt;
            Object retrieval;
            Object storage;

            public Builder agent(IResolvable agent) {
                this.agent = agent;
                return this;
            }

            public Builder agent(AgentFlowNodeConfigurationProperty agent) {
                this.agent = agent;
                return this;
            }

            public Builder collector(Object collector) {
                this.collector = collector;
                return this;
            }

            public Builder condition(IResolvable condition) {
                this.condition = condition;
                return this;
            }

            public Builder condition(ConditionFlowNodeConfigurationProperty condition) {
                this.condition = condition;
                return this;
            }

            public Builder input(Object input) {
                this.input = input;
                return this;
            }

            public Builder iterator(Object iterator) {
                this.iterator = iterator;
                return this;
            }

            public Builder knowledgeBase(IResolvable knowledgeBase) {
                this.knowledgeBase = knowledgeBase;
                return this;
            }

            public Builder knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty knowledgeBase) {
                this.knowledgeBase = knowledgeBase;
                return this;
            }

            public Builder lambdaFunction(IResolvable lambdaFunction) {
                this.lambdaFunction = lambdaFunction;
                return this;
            }

            public Builder lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty lambdaFunction) {
                this.lambdaFunction = lambdaFunction;
                return this;
            }

            public Builder lex(IResolvable lex) {
                this.lex = lex;
                return this;
            }

            public Builder lex(LexFlowNodeConfigurationProperty lex) {
                this.lex = lex;
                return this;
            }

            public Builder output(Object output) {
                this.output = output;
                return this;
            }

            public Builder prompt(IResolvable prompt) {
                this.prompt = prompt;
                return this;
            }

            public Builder prompt(PromptFlowNodeConfigurationProperty prompt) {
                this.prompt = prompt;
                return this;
            }

            public Builder retrieval(IResolvable retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            public Builder retrieval(RetrievalFlowNodeConfigurationProperty retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            public Builder storage(IResolvable storage) {
                this.storage = storage;
                return this;
            }

            public Builder storage(StorageFlowNodeConfigurationProperty storage) {
                this.storage = storage;
                return this;
            }

            public FlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConnections() {
            return null;
        }

        @Nullable
        default public Object getNodes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowDefinitionProperty> {
            Object connections;
            Object nodes;

            public Builder connections(IResolvable connections) {
                this.connections = connections;
                return this;
            }

            public Builder connections(List<? extends Object> connections) {
                this.connections = connections;
                return this;
            }

            public Builder nodes(IResolvable nodes) {
                this.nodes = nodes;
                return this;
            }

            public Builder nodes(List<? extends Object> nodes) {
                this.nodes = nodes;
                return this;
            }

            public FlowDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowDataConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowDataConnectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSourceOutput();

        @NotNull
        public String getTargetInput();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowDataConnectionConfigurationProperty> {
            String sourceOutput;
            String targetInput;

            public Builder sourceOutput(String sourceOutput) {
                this.sourceOutput = sourceOutput;
                return this;
            }

            public Builder targetInput(String targetInput) {
                this.targetInput = targetInput;
                return this;
            }

            public FlowDataConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowConnectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowConnectionProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getSource();

        @NotNull
        public String getTarget();

        @NotNull
        public String getType();

        @Nullable
        default public Object getConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowConnectionProperty> {
            String name;
            String source;
            String target;
            String type;
            Object configuration;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder configuration(IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder configuration(FlowConnectionConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            public FlowConnectionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowConnectionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConditional() {
            return null;
        }

        @Nullable
        default public Object getData() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowConnectionConfigurationProperty> {
            Object conditional;
            Object data;

            public Builder conditional(IResolvable conditional) {
                this.conditional = conditional;
                return this;
            }

            public Builder conditional(FlowConditionalConnectionConfigurationProperty conditional) {
                this.conditional = conditional;
                return this;
            }

            public Builder data(IResolvable data) {
                this.data = data;
                return this;
            }

            public Builder data(FlowDataConnectionConfigurationProperty data) {
                this.data = data;
                return this;
            }

            public FlowConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowConditionalConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowConditionalConnectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCondition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowConditionalConnectionConfigurationProperty> {
            String condition;

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public FlowConditionalConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.FlowConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowConditionProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getExpression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowConditionProperty> {
            String name;
            String expression;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public FlowConditionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.ConditionFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConditions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionFlowNodeConfigurationProperty> {
            Object conditions;

            public Builder conditions(IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            public Builder conditions(List<? extends Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            public ConditionFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlow.AgentFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AgentFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAgentAliasArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AgentFlowNodeConfigurationProperty> {
            String agentAliasArn;

            public Builder agentAliasArn(String agentAliasArn) {
                this.agentAliasArn = agentAliasArn;
                return this;
            }

            public AgentFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

