/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront.origins;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudfront.CfnDistribution;
import software.amazon.awscdk.services.cloudfront.IOrigin;
import software.amazon.awscdk.services.cloudfront.OriginBase;
import software.amazon.awscdk.services.cloudfront.origins.FunctionUrlOriginProps;
import software.amazon.awscdk.services.cloudfront.origins.FunctionUrlOriginWithOACProps;
import software.amazon.awscdk.services.lambda.IFunctionUrl;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudfront_origins.FunctionUrlOrigin")
public class FunctionUrlOrigin
extends OriginBase {
    protected FunctionUrlOrigin(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FunctionUrlOrigin(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FunctionUrlOrigin(@NotNull IFunctionUrl lambdaFunctionUrl, @Nullable FunctionUrlOriginProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(lambdaFunctionUrl, "lambdaFunctionUrl is required"), props});
    }

    public FunctionUrlOrigin(@NotNull IFunctionUrl lambdaFunctionUrl) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(lambdaFunctionUrl, "lambdaFunctionUrl is required")});
    }

    @NotNull
    public static IOrigin withOriginAccessControl(@NotNull IFunctionUrl lambdaFunctionUrl, @Nullable FunctionUrlOriginWithOACProps props) {
        return (IOrigin)JsiiObject.jsiiStaticCall(FunctionUrlOrigin.class, (String)"withOriginAccessControl", (NativeType)NativeType.forClass(IOrigin.class), (Object[])new Object[]{Objects.requireNonNull(lambdaFunctionUrl, "lambdaFunctionUrl is required"), props});
    }

    @NotNull
    public static IOrigin withOriginAccessControl(@NotNull IFunctionUrl lambdaFunctionUrl) {
        return (IOrigin)JsiiObject.jsiiStaticCall(FunctionUrlOrigin.class, (String)"withOriginAccessControl", (NativeType)NativeType.forClass(IOrigin.class), (Object[])new Object[]{Objects.requireNonNull(lambdaFunctionUrl, "lambdaFunctionUrl is required")});
    }

    @Override
    @Nullable
    protected CfnDistribution.CustomOriginConfigProperty renderCustomOriginConfig() {
        return (CfnDistribution.CustomOriginConfigProperty)Kernel.call((Object)this, (String)"renderCustomOriginConfig", (NativeType)NativeType.forClass(CfnDistribution.CustomOriginConfigProperty.class), (Object[])new Object[0]);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FunctionUrlOrigin> {
        private final IFunctionUrl lambdaFunctionUrl;
        private FunctionUrlOriginProps.Builder props;

        public static Builder create(IFunctionUrl lambdaFunctionUrl) {
            return new Builder(lambdaFunctionUrl);
        }

        private Builder(IFunctionUrl lambdaFunctionUrl) {
            this.lambdaFunctionUrl = lambdaFunctionUrl;
        }

        public Builder connectionAttempts(Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        public Builder connectionTimeout(Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        public Builder customHeaders(Map<String, String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        public Builder originAccessControlId(String originAccessControlId) {
            this.props().originAccessControlId(originAccessControlId);
            return this;
        }

        public Builder originId(String originId) {
            this.props().originId(originId);
            return this;
        }

        public Builder originShieldEnabled(Boolean originShieldEnabled) {
            this.props().originShieldEnabled(originShieldEnabled);
            return this;
        }

        public Builder originShieldRegion(String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        public Builder originPath(String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        public Builder keepaliveTimeout(Duration keepaliveTimeout) {
            this.props().keepaliveTimeout(keepaliveTimeout);
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.props().readTimeout(readTimeout);
            return this;
        }

        public FunctionUrlOrigin build() {
            return new FunctionUrlOrigin(this.lambdaFunctionUrl, this.props != null ? this.props.build() : null);
        }

        private FunctionUrlOriginProps.Builder props() {
            if (this.props == null) {
                this.props = new FunctionUrlOriginProps.Builder();
            }
            return this.props;
        }
    }
}

