/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudwatch.ConcreteWidget;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.TableLayout;
import software.amazon.awscdk.services.cloudwatch.TableSummaryProps;
import software.amazon.awscdk.services.cloudwatch.TableThreshold;
import software.amazon.awscdk.services.cloudwatch.TableWidgetProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudwatch.TableWidget")
public class TableWidget
extends ConcreteWidget {
    protected TableWidget(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableWidget(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public TableWidget(@NotNull TableWidgetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(props, "props is required")});
    }

    public void addMetric(@NotNull IMetric metric) {
        Kernel.call((Object)this, (String)"addMetric", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(metric, "metric is required")});
    }

    @Override
    @NotNull
    public List<Object> toJson() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"toJson", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[0]));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TableWidget> {
        private final TableWidgetProps.Builder props = new TableWidgetProps.Builder();

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder height(Number height) {
            this.props.height(height);
            return this;
        }

        public Builder region(String region) {
            this.props.region(region);
            return this;
        }

        public Builder title(String title) {
            this.props.title(title);
            return this;
        }

        public Builder width(Number width) {
            this.props.width(width);
            return this;
        }

        public Builder end(String end) {
            this.props.end(end);
            return this;
        }

        public Builder fullPrecision(Boolean fullPrecision) {
            this.props.fullPrecision(fullPrecision);
            return this;
        }

        public Builder layout(TableLayout layout) {
            this.props.layout(layout);
            return this;
        }

        public Builder liveData(Boolean liveData) {
            this.props.liveData(liveData);
            return this;
        }

        public Builder metrics(List<? extends IMetric> metrics) {
            this.props.metrics(metrics);
            return this;
        }

        public Builder period(Duration period) {
            this.props.period(period);
            return this;
        }

        public Builder setPeriodToTimeRange(Boolean setPeriodToTimeRange) {
            this.props.setPeriodToTimeRange(setPeriodToTimeRange);
            return this;
        }

        public Builder showUnitsInLabel(Boolean showUnitsInLabel) {
            this.props.showUnitsInLabel(showUnitsInLabel);
            return this;
        }

        public Builder start(String start) {
            this.props.start(start);
            return this;
        }

        public Builder statistic(String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        public Builder summary(TableSummaryProps summary) {
            this.props.summary(summary);
            return this;
        }

        public Builder thresholds(List<? extends TableThreshold> thresholds) {
            this.props.thresholds(thresholds);
            return this;
        }

        public TableWidget build() {
            return new TableWidget(this.props.build());
        }
    }
}

