/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.datazone;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.datazone.CfnDataSource;
import software.amazon.awscdk.services.datazone.CfnDataSourceProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource")
public class CfnDataSource
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDataSource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDataSource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataSource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDataSource(@NotNull Construct scope, @NotNull String id, @NotNull CfnDataSourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrDomainId() {
        return (String)Kernel.get((Object)this, (String)"attrDomainId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEnvironmentId() {
        return (String)Kernel.get((Object)this, (String)"attrEnvironmentId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrLastRunAssetCount() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrLastRunAssetCount", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrLastRunAt() {
        return (String)Kernel.get((Object)this, (String)"attrLastRunAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastRunStatus() {
        return (String)Kernel.get((Object)this, (String)"attrLastRunStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrProjectId() {
        return (String)Kernel.get((Object)this, (String)"attrProjectId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUpdatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrUpdatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getDomainIdentifier() {
        return (String)Kernel.get((Object)this, (String)"domainIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomainIdentifier(@NotNull String value) {
        Kernel.set((Object)this, (String)"domainIdentifier", (Object)Objects.requireNonNull(value, "domainIdentifier is required"));
    }

    @NotNull
    public String getEnvironmentIdentifier() {
        return (String)Kernel.get((Object)this, (String)"environmentIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setEnvironmentIdentifier(@NotNull String value) {
        Kernel.set((Object)this, (String)"environmentIdentifier", (Object)Objects.requireNonNull(value, "environmentIdentifier is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getProjectIdentifier() {
        return (String)Kernel.get((Object)this, (String)"projectIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setProjectIdentifier(@NotNull String value) {
        Kernel.set((Object)this, (String)"projectIdentifier", (Object)Objects.requireNonNull(value, "projectIdentifier is required"));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getAssetFormsInput() {
        return Kernel.get((Object)this, (String)"assetFormsInput", (NativeType)NativeType.forClass(Object.class));
    }

    public void setAssetFormsInput(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"assetFormsInput", (Object)value);
    }

    public void setAssetFormsInput(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof FormInputProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.datazone.CfnDataSource.FormInputProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"assetFormsInput", value);
    }

    @Nullable
    public Object getConfiguration() {
        return Kernel.get((Object)this, (String)"configuration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"configuration", (Object)value);
    }

    public void setConfiguration(@Nullable DataSourceConfigurationInputProperty value) {
        Kernel.set((Object)this, (String)"configuration", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getEnableSetting() {
        return (String)Kernel.get((Object)this, (String)"enableSetting", (NativeType)NativeType.forClass(String.class));
    }

    public void setEnableSetting(@Nullable String value) {
        Kernel.set((Object)this, (String)"enableSetting", (Object)value);
    }

    @Nullable
    public Object getPublishOnImport() {
        return Kernel.get((Object)this, (String)"publishOnImport", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPublishOnImport(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"publishOnImport", (Object)value);
    }

    public void setPublishOnImport(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"publishOnImport", (Object)value);
    }

    @Nullable
    public Object getRecommendation() {
        return Kernel.get((Object)this, (String)"recommendation", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRecommendation(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"recommendation", (Object)value);
    }

    public void setRecommendation(@Nullable RecommendationConfigurationProperty value) {
        Kernel.set((Object)this, (String)"recommendation", (Object)value);
    }

    @Nullable
    public Object getSchedule() {
        return Kernel.get((Object)this, (String)"schedule", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSchedule(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"schedule", (Object)value);
    }

    public void setSchedule(@Nullable ScheduleConfigurationProperty value) {
        Kernel.set((Object)this, (String)"schedule", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.FormInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FormInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getFormName();

        @Nullable
        default public String getContent() {
            return null;
        }

        @Nullable
        default public String getTypeIdentifier() {
            return null;
        }

        @Nullable
        default public String getTypeRevision() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FormInputProperty> {
            String formName;
            String content;
            String typeIdentifier;
            String typeRevision;

            public Builder formName(String formName) {
                this.formName = formName;
                return this;
            }

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder typeIdentifier(String typeIdentifier) {
                this.typeIdentifier = typeIdentifier;
                return this;
            }

            public Builder typeRevision(String typeRevision) {
                this.typeRevision = typeRevision;
                return this;
            }

            public FormInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDataSource> {
        private final Construct scope;
        private final String id;
        private final CfnDataSourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDataSourceProps.Builder();
        }

        public Builder domainIdentifier(String domainIdentifier) {
            this.props.domainIdentifier(domainIdentifier);
            return this;
        }

        public Builder environmentIdentifier(String environmentIdentifier) {
            this.props.environmentIdentifier(environmentIdentifier);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder projectIdentifier(String projectIdentifier) {
            this.props.projectIdentifier(projectIdentifier);
            return this;
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder assetFormsInput(IResolvable assetFormsInput) {
            this.props.assetFormsInput(assetFormsInput);
            return this;
        }

        public Builder assetFormsInput(List<? extends Object> assetFormsInput) {
            this.props.assetFormsInput(assetFormsInput);
            return this;
        }

        public Builder configuration(IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }

        public Builder configuration(DataSourceConfigurationInputProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder enableSetting(String enableSetting) {
            this.props.enableSetting(enableSetting);
            return this;
        }

        public Builder publishOnImport(Boolean publishOnImport) {
            this.props.publishOnImport(publishOnImport);
            return this;
        }

        public Builder publishOnImport(IResolvable publishOnImport) {
            this.props.publishOnImport(publishOnImport);
            return this;
        }

        public Builder recommendation(IResolvable recommendation) {
            this.props.recommendation(recommendation);
            return this;
        }

        public Builder recommendation(RecommendationConfigurationProperty recommendation) {
            this.props.recommendation(recommendation);
            return this;
        }

        public Builder schedule(IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder schedule(ScheduleConfigurationProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public CfnDataSource build() {
            return new CfnDataSource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.ScheduleConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSchedule() {
            return null;
        }

        @Nullable
        default public String getTimezone() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleConfigurationProperty> {
            String schedule;
            String timezone;

            public Builder schedule(String schedule) {
                this.schedule = schedule;
                return this;
            }

            public Builder timezone(String timezone) {
                this.timezone = timezone;
                return this;
            }

            public ScheduleConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.RelationalFilterConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RelationalFilterConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabaseName();

        @Nullable
        default public Object getFilterExpressions() {
            return null;
        }

        @Nullable
        default public String getSchemaName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RelationalFilterConfigurationProperty> {
            String databaseName;
            Object filterExpressions;
            String schemaName;

            public Builder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            public Builder filterExpressions(IResolvable filterExpressions) {
                this.filterExpressions = filterExpressions;
                return this;
            }

            public Builder filterExpressions(List<? extends Object> filterExpressions) {
                this.filterExpressions = filterExpressions;
                return this;
            }

            public Builder schemaName(String schemaName) {
                this.schemaName = schemaName;
                return this;
            }

            public RelationalFilterConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftStorageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftStorageProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getRedshiftClusterSource() {
            return null;
        }

        @Nullable
        default public Object getRedshiftServerlessSource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftStorageProperty> {
            Object redshiftClusterSource;
            Object redshiftServerlessSource;

            public Builder redshiftClusterSource(IResolvable redshiftClusterSource) {
                this.redshiftClusterSource = redshiftClusterSource;
                return this;
            }

            public Builder redshiftClusterSource(RedshiftClusterStorageProperty redshiftClusterSource) {
                this.redshiftClusterSource = redshiftClusterSource;
                return this;
            }

            public Builder redshiftServerlessSource(IResolvable redshiftServerlessSource) {
                this.redshiftServerlessSource = redshiftServerlessSource;
                return this;
            }

            public Builder redshiftServerlessSource(RedshiftServerlessStorageProperty redshiftServerlessSource) {
                this.redshiftServerlessSource = redshiftServerlessSource;
                return this;
            }

            public RedshiftStorageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftServerlessStorageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftServerlessStorageProperty
    extends JsiiSerializable {
        @NotNull
        public String getWorkgroupName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftServerlessStorageProperty> {
            String workgroupName;

            public Builder workgroupName(String workgroupName) {
                this.workgroupName = workgroupName;
                return this;
            }

            public RedshiftServerlessStorageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftRunConfigurationInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftRunConfigurationInputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRedshiftCredentialConfiguration();

        @NotNull
        public Object getRedshiftStorage();

        @NotNull
        public Object getRelationalFilterConfigurations();

        @Nullable
        default public String getDataAccessRole() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftRunConfigurationInputProperty> {
            Object redshiftCredentialConfiguration;
            Object redshiftStorage;
            Object relationalFilterConfigurations;
            String dataAccessRole;

            public Builder redshiftCredentialConfiguration(IResolvable redshiftCredentialConfiguration) {
                this.redshiftCredentialConfiguration = redshiftCredentialConfiguration;
                return this;
            }

            public Builder redshiftCredentialConfiguration(RedshiftCredentialConfigurationProperty redshiftCredentialConfiguration) {
                this.redshiftCredentialConfiguration = redshiftCredentialConfiguration;
                return this;
            }

            public Builder redshiftStorage(IResolvable redshiftStorage) {
                this.redshiftStorage = redshiftStorage;
                return this;
            }

            public Builder redshiftStorage(RedshiftStorageProperty redshiftStorage) {
                this.redshiftStorage = redshiftStorage;
                return this;
            }

            public Builder relationalFilterConfigurations(IResolvable relationalFilterConfigurations) {
                this.relationalFilterConfigurations = relationalFilterConfigurations;
                return this;
            }

            public Builder relationalFilterConfigurations(List<? extends Object> relationalFilterConfigurations) {
                this.relationalFilterConfigurations = relationalFilterConfigurations;
                return this;
            }

            public Builder dataAccessRole(String dataAccessRole) {
                this.dataAccessRole = dataAccessRole;
                return this;
            }

            public RedshiftRunConfigurationInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftCredentialConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftCredentialConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretManagerArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftCredentialConfigurationProperty> {
            String secretManagerArn;

            public Builder secretManagerArn(String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            public RedshiftCredentialConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.RedshiftClusterStorageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RedshiftClusterStorageProperty
    extends JsiiSerializable {
        @NotNull
        public String getClusterName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RedshiftClusterStorageProperty> {
            String clusterName;

            public Builder clusterName(String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            public RedshiftClusterStorageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.RecommendationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RecommendationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableBusinessNameGeneration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RecommendationConfigurationProperty> {
            Object enableBusinessNameGeneration;

            public Builder enableBusinessNameGeneration(Boolean enableBusinessNameGeneration) {
                this.enableBusinessNameGeneration = enableBusinessNameGeneration;
                return this;
            }

            public Builder enableBusinessNameGeneration(IResolvable enableBusinessNameGeneration) {
                this.enableBusinessNameGeneration = enableBusinessNameGeneration;
                return this;
            }

            public RecommendationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.GlueRunConfigurationInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GlueRunConfigurationInputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getRelationalFilterConfigurations();

        @Nullable
        default public Object getAutoImportDataQualityResult() {
            return null;
        }

        @Nullable
        default public String getDataAccessRole() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GlueRunConfigurationInputProperty> {
            Object relationalFilterConfigurations;
            Object autoImportDataQualityResult;
            String dataAccessRole;

            public Builder relationalFilterConfigurations(IResolvable relationalFilterConfigurations) {
                this.relationalFilterConfigurations = relationalFilterConfigurations;
                return this;
            }

            public Builder relationalFilterConfigurations(List<? extends Object> relationalFilterConfigurations) {
                this.relationalFilterConfigurations = relationalFilterConfigurations;
                return this;
            }

            public Builder autoImportDataQualityResult(Boolean autoImportDataQualityResult) {
                this.autoImportDataQualityResult = autoImportDataQualityResult;
                return this;
            }

            public Builder autoImportDataQualityResult(IResolvable autoImportDataQualityResult) {
                this.autoImportDataQualityResult = autoImportDataQualityResult;
                return this;
            }

            public Builder dataAccessRole(String dataAccessRole) {
                this.dataAccessRole = dataAccessRole;
                return this;
            }

            public GlueRunConfigurationInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.FilterExpressionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterExpressionProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterExpressionProperty> {
            String expression;
            String type;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FilterExpressionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_datazone.CfnDataSource.DataSourceConfigurationInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataSourceConfigurationInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getGlueRunConfiguration() {
            return null;
        }

        @Nullable
        default public Object getRedshiftRunConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataSourceConfigurationInputProperty> {
            Object glueRunConfiguration;
            Object redshiftRunConfiguration;

            public Builder glueRunConfiguration(IResolvable glueRunConfiguration) {
                this.glueRunConfiguration = glueRunConfiguration;
                return this;
            }

            public Builder glueRunConfiguration(GlueRunConfigurationInputProperty glueRunConfiguration) {
                this.glueRunConfiguration = glueRunConfiguration;
                return this;
            }

            public Builder redshiftRunConfiguration(IResolvable redshiftRunConfiguration) {
                this.redshiftRunConfiguration = redshiftRunConfiguration;
                return this;
            }

            public Builder redshiftRunConfiguration(RedshiftRunConfigurationInputProperty redshiftRunConfiguration) {
                this.redshiftRunConfiguration = redshiftRunConfiguration;
                return this;
            }

            public DataSourceConfigurationInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

