/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.docdb;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.docdb.BackupProps;
import software.amazon.awscdk.services.docdb.DatabaseClusterProps;
import software.amazon.awscdk.services.docdb.IClusterParameterGroup;
import software.amazon.awscdk.services.docdb.Login;
import software.amazon.awscdk.services.docdb.StorageType;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.logs.RetentionDays;
import software.amazon.awscdk.services.rds.CaCertificate;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_docdb.DatabaseClusterProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DatabaseClusterProps
extends JsiiSerializable {
    @NotNull
    public InstanceType getInstanceType();

    @NotNull
    public Login getMasterUser();

    @NotNull
    public IVpc getVpc();

    @Nullable
    default public BackupProps getBackup() {
        return null;
    }

    @Nullable
    default public CaCertificate getCaCertificate() {
        return null;
    }

    @Nullable
    default public RetentionDays getCloudWatchLogsRetention() {
        return null;
    }

    @Nullable
    default public IRole getCloudWatchLogsRetentionRole() {
        return null;
    }

    @Nullable
    default public Boolean getCopyTagsToSnapshot() {
        return null;
    }

    @Nullable
    default public String getDbClusterName() {
        return null;
    }

    @Nullable
    default public Boolean getDeletionProtection() {
        return null;
    }

    @Nullable
    default public Boolean getEnablePerformanceInsights() {
        return null;
    }

    @Nullable
    default public String getEngineVersion() {
        return null;
    }

    @Nullable
    default public Boolean getExportAuditLogsToCloudWatch() {
        return null;
    }

    @Nullable
    default public Boolean getExportProfilerLogsToCloudWatch() {
        return null;
    }

    @Nullable
    default public String getInstanceIdentifierBase() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getInstanceRemovalPolicy() {
        return null;
    }

    @Nullable
    default public Number getInstances() {
        return null;
    }

    @Nullable
    default public IKey getKmsKey() {
        return null;
    }

    @Nullable
    default public IClusterParameterGroup getParameterGroup() {
        return null;
    }

    @Nullable
    default public Number getPort() {
        return null;
    }

    @Nullable
    default public String getPreferredMaintenanceWindow() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getSecurityGroupRemovalPolicy() {
        return null;
    }

    @Nullable
    default public Boolean getStorageEncrypted() {
        return null;
    }

    @Nullable
    default public StorageType getStorageType() {
        return null;
    }

    @Nullable
    default public SubnetSelection getVpcSubnets() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<DatabaseClusterProps> {
        InstanceType instanceType;
        Login masterUser;
        IVpc vpc;
        BackupProps backup;
        CaCertificate caCertificate;
        RetentionDays cloudWatchLogsRetention;
        IRole cloudWatchLogsRetentionRole;
        Boolean copyTagsToSnapshot;
        String dbClusterName;
        Boolean deletionProtection;
        Boolean enablePerformanceInsights;
        String engineVersion;
        Boolean exportAuditLogsToCloudWatch;
        Boolean exportProfilerLogsToCloudWatch;
        String instanceIdentifierBase;
        RemovalPolicy instanceRemovalPolicy;
        Number instances;
        IKey kmsKey;
        IClusterParameterGroup parameterGroup;
        Number port;
        String preferredMaintenanceWindow;
        RemovalPolicy removalPolicy;
        ISecurityGroup securityGroup;
        RemovalPolicy securityGroupRemovalPolicy;
        Boolean storageEncrypted;
        StorageType storageType;
        SubnetSelection vpcSubnets;

        public Builder instanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public Builder masterUser(Login masterUser) {
            this.masterUser = masterUser;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder backup(BackupProps backup) {
            this.backup = backup;
            return this;
        }

        public Builder caCertificate(CaCertificate caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        public Builder cloudWatchLogsRetention(RetentionDays cloudWatchLogsRetention) {
            this.cloudWatchLogsRetention = cloudWatchLogsRetention;
            return this;
        }

        public Builder cloudWatchLogsRetentionRole(IRole cloudWatchLogsRetentionRole) {
            this.cloudWatchLogsRetentionRole = cloudWatchLogsRetentionRole;
            return this;
        }

        public Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public Builder dbClusterName(String dbClusterName) {
            this.dbClusterName = dbClusterName;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public Builder exportAuditLogsToCloudWatch(Boolean exportAuditLogsToCloudWatch) {
            this.exportAuditLogsToCloudWatch = exportAuditLogsToCloudWatch;
            return this;
        }

        public Builder exportProfilerLogsToCloudWatch(Boolean exportProfilerLogsToCloudWatch) {
            this.exportProfilerLogsToCloudWatch = exportProfilerLogsToCloudWatch;
            return this;
        }

        public Builder instanceIdentifierBase(String instanceIdentifierBase) {
            this.instanceIdentifierBase = instanceIdentifierBase;
            return this;
        }

        public Builder instanceRemovalPolicy(RemovalPolicy instanceRemovalPolicy) {
            this.instanceRemovalPolicy = instanceRemovalPolicy;
            return this;
        }

        public Builder instances(Number instances) {
            this.instances = instances;
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public Builder parameterGroup(IClusterParameterGroup parameterGroup) {
            this.parameterGroup = parameterGroup;
            return this;
        }

        public Builder port(Number port) {
            this.port = port;
            return this;
        }

        public Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder securityGroupRemovalPolicy(RemovalPolicy securityGroupRemovalPolicy) {
            this.securityGroupRemovalPolicy = securityGroupRemovalPolicy;
            return this;
        }

        public Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        public DatabaseClusterProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

