/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs.patterns;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.certificatemanager.ICertificate;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ecs.CapacityProviderStrategy;
import software.amazon.awscdk.services.ecs.CloudMapOptions;
import software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker;
import software.amazon.awscdk.services.ecs.DeploymentController;
import software.amazon.awscdk.services.ecs.Ec2TaskDefinition;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.PlacementConstraint;
import software.amazon.awscdk.services.ecs.PlacementStrategy;
import software.amazon.awscdk.services.ecs.PropagatedTagSource;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedEc2ServiceProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceBaseProps;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedServiceRecordType;
import software.amazon.awscdk.services.ecs.patterns.ApplicationLoadBalancedTaskImageOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocolVersion;
import software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType;
import software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy;
import software.amazon.awscdk.services.route53.IHostedZone;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecs_patterns.ApplicationLoadBalancedEc2ServiceProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface ApplicationLoadBalancedEc2ServiceProps
extends JsiiSerializable,
ApplicationLoadBalancedServiceBaseProps {
    @Nullable
    default public Number getCpu() {
        return null;
    }

    @Nullable
    default public Number getMemoryLimitMiB() {
        return null;
    }

    @Nullable
    default public Number getMemoryReservationMiB() {
        return null;
    }

    @Nullable
    default public List<PlacementConstraint> getPlacementConstraints() {
        return null;
    }

    @Nullable
    default public List<PlacementStrategy> getPlacementStrategies() {
        return null;
    }

    @Nullable
    default public Ec2TaskDefinition getTaskDefinition() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ApplicationLoadBalancedEc2ServiceProps> {
        Number cpu;
        Number memoryLimitMiB;
        Number memoryReservationMiB;
        List<PlacementConstraint> placementConstraints;
        List<PlacementStrategy> placementStrategies;
        Ec2TaskDefinition taskDefinition;
        List<CapacityProviderStrategy> capacityProviderStrategies;
        ICertificate certificate;
        DeploymentCircuitBreaker circuitBreaker;
        CloudMapOptions cloudMapOptions;
        ICluster cluster;
        DeploymentController deploymentController;
        Number desiredCount;
        String domainName;
        IHostedZone domainZone;
        Boolean enableEcsManagedTags;
        Boolean enableExecuteCommand;
        Duration healthCheckGracePeriod;
        Duration idleTimeout;
        IpAddressType ipAddressType;
        Number listenerPort;
        IApplicationLoadBalancer loadBalancer;
        String loadBalancerName;
        Number maxHealthyPercent;
        Number minHealthyPercent;
        Boolean openListener;
        PropagatedTagSource propagateTags;
        ApplicationProtocol protocol;
        ApplicationProtocolVersion protocolVersion;
        Boolean publicLoadBalancer;
        ApplicationLoadBalancedServiceRecordType recordType;
        Boolean redirectHttp;
        String serviceName;
        SslPolicy sslPolicy;
        ApplicationProtocol targetProtocol;
        ApplicationLoadBalancedTaskImageOptions taskImageOptions;
        IVpc vpc;

        public Builder cpu(Number cpu) {
            this.cpu = cpu;
            return this;
        }

        public Builder memoryLimitMiB(Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        public Builder memoryReservationMiB(Number memoryReservationMiB) {
            this.memoryReservationMiB = memoryReservationMiB;
            return this;
        }

        public Builder placementConstraints(List<? extends PlacementConstraint> placementConstraints) {
            this.placementConstraints = placementConstraints;
            return this;
        }

        public Builder placementStrategies(List<? extends PlacementStrategy> placementStrategies) {
            this.placementStrategies = placementStrategies;
            return this;
        }

        public Builder taskDefinition(Ec2TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder capacityProviderStrategies(List<? extends CapacityProviderStrategy> capacityProviderStrategies) {
            this.capacityProviderStrategies = capacityProviderStrategies;
            return this;
        }

        public Builder certificate(ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        public Builder circuitBreaker(DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        public Builder cloudMapOptions(CloudMapOptions cloudMapOptions) {
            this.cloudMapOptions = cloudMapOptions;
            return this;
        }

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder deploymentController(DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public Builder desiredCount(Number desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public Builder domainZone(IHostedZone domainZone) {
            this.domainZone = domainZone;
            return this;
        }

        public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public Builder healthCheckGracePeriod(Duration healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public Builder idleTimeout(Duration idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        public Builder listenerPort(Number listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public Builder loadBalancer(IApplicationLoadBalancer loadBalancer) {
            this.loadBalancer = loadBalancer;
            return this;
        }

        public Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public Builder maxHealthyPercent(Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        public Builder minHealthyPercent(Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        public Builder openListener(Boolean openListener) {
            this.openListener = openListener;
            return this;
        }

        public Builder propagateTags(PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public Builder protocol(ApplicationProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder protocolVersion(ApplicationProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder publicLoadBalancer(Boolean publicLoadBalancer) {
            this.publicLoadBalancer = publicLoadBalancer;
            return this;
        }

        public Builder recordType(ApplicationLoadBalancedServiceRecordType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder redirectHttp(Boolean redirectHttp) {
            this.redirectHttp = redirectHttp;
            return this;
        }

        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder sslPolicy(SslPolicy sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public Builder targetProtocol(ApplicationProtocol targetProtocol) {
            this.targetProtocol = targetProtocol;
            return this;
        }

        public Builder taskImageOptions(ApplicationLoadBalancedTaskImageOptions taskImageOptions) {
            this.taskImageOptions = taskImageOptions;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public ApplicationLoadBalancedEc2ServiceProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

