/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.elasticloadbalancingv2.HealthCheck;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroupMetrics;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkTargetGroupProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.Protocol;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetGroupBase;
import software.amazon.awscdk.services.elasticloadbalancingv2.TargetType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_elasticloadbalancingv2.NetworkTargetGroup")
public class NetworkTargetGroup
extends TargetGroupBase
implements INetworkTargetGroup {
    protected NetworkTargetGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkTargetGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkTargetGroup(@NotNull Construct scope, @NotNull String id, @NotNull NetworkTargetGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static INetworkTargetGroup fromTargetGroupAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TargetGroupAttributes attrs) {
        return (INetworkTargetGroup)JsiiObject.jsiiStaticCall(NetworkTargetGroup.class, (String)"fromTargetGroupAttributes", (NativeType)NativeType.forClass(INetworkTargetGroup.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    public void addTarget(INetworkLoadBalancerTarget ... targets) {
        Kernel.call((Object)this, (String)"addTarget", (NativeType)NativeType.VOID, (Object[])Arrays.stream(targets).toArray(Object[]::new));
    }

    @Deprecated
    @NotNull
    public Metric metricHealthyHostCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricHealthyHostCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricHealthyHostCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricHealthyHostCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricUnHealthyHostCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricUnHealthyHostCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricUnHealthyHostCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricUnHealthyHostCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    public void registerListener(@NotNull INetworkListener listener) {
        Kernel.call((Object)this, (String)"registerListener", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(listener, "listener is required")});
    }

    @Override
    @NotNull
    protected List<String> validateTargetGroup() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"validateTargetGroup", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public String getFirstLoadBalancerFullName() {
        return (String)Kernel.get((Object)this, (String)"firstLoadBalancerFullName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public INetworkTargetGroupMetrics getMetrics() {
        return (INetworkTargetGroupMetrics)Kernel.get((Object)this, (String)"metrics", (NativeType)NativeType.forClass(INetworkTargetGroupMetrics.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NetworkTargetGroup> {
        private final Construct scope;
        private final String id;
        private final NetworkTargetGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new NetworkTargetGroupProps.Builder();
        }

        public Builder crossZoneEnabled(Boolean crossZoneEnabled) {
            this.props.crossZoneEnabled(crossZoneEnabled);
            return this;
        }

        public Builder deregistrationDelay(Duration deregistrationDelay) {
            this.props.deregistrationDelay(deregistrationDelay);
            return this;
        }

        public Builder healthCheck(HealthCheck healthCheck) {
            this.props.healthCheck(healthCheck);
            return this;
        }

        public Builder targetGroupName(String targetGroupName) {
            this.props.targetGroupName(targetGroupName);
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.props.targetType(targetType);
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder port(Number port) {
            this.props.port(port);
            return this;
        }

        public Builder connectionTermination(Boolean connectionTermination) {
            this.props.connectionTermination(connectionTermination);
            return this;
        }

        public Builder preserveClientIp(Boolean preserveClientIp) {
            this.props.preserveClientIp(preserveClientIp);
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        public Builder proxyProtocolV2(Boolean proxyProtocolV2) {
            this.props.proxyProtocolV2(proxyProtocolV2);
            return this;
        }

        public Builder targets(List<? extends INetworkLoadBalancerTarget> targets) {
            this.props.targets(targets);
            return this;
        }

        public NetworkTargetGroup build() {
            return new NetworkTargetGroup(this.scope, this.id, this.props.build());
        }
    }
}

