/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.RuleTargetInput;
import software.amazon.awscdk.services.events.targets.SfnStateMachineProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.awscdk.services.stepfunctions.IStateMachine;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_events_targets.SfnStateMachine")
public class SfnStateMachine
extends JsiiObject
implements IRuleTarget {
    protected SfnStateMachine(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SfnStateMachine(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SfnStateMachine(@NotNull IStateMachine machine, @Nullable SfnStateMachineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(machine, "machine is required"), props});
    }

    public SfnStateMachine(@NotNull IStateMachine machine) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(machine, "machine is required")});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule _rule, @Nullable String _id) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_rule, "_rule is required"), _id});
    }

    @Override
    @NotNull
    public RuleTargetConfig bind(@NotNull IRule _rule) {
        return (RuleTargetConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(RuleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_rule, "_rule is required")});
    }

    @NotNull
    public IStateMachine getMachine() {
        return (IStateMachine)Kernel.get((Object)this, (String)"machine", (NativeType)NativeType.forClass(IStateMachine.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SfnStateMachine> {
        private final IStateMachine machine;
        private SfnStateMachineProps.Builder props;

        public static Builder create(IStateMachine machine) {
            return new Builder(machine);
        }

        private Builder(IStateMachine machine) {
            this.machine = machine;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        public Builder input(RuleTargetInput input) {
            this.props().input(input);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public SfnStateMachine build() {
            return new SfnStateMachine(this.machine, this.props != null ? this.props.build() : null);
        }

        private SfnStateMachineProps.Builder props() {
            if (this.props == null) {
                this.props = new SfnStateMachineProps.Builder();
            }
            return this.props;
        }
    }
}

