/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.mediaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.mediaconnect.CfnBridge;
import software.amazon.awscdk.services.mediaconnect.CfnBridgeProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge")
public class CfnBridge
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnBridge.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnBridge(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBridge(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnBridge(@NotNull Construct scope, @NotNull String id, @NotNull CfnBridgeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrBridgeArn() {
        return (String)Kernel.get((Object)this, (String)"attrBridgeArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrBridgeState() {
        return (String)Kernel.get((Object)this, (String)"attrBridgeState", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getPlacementArn() {
        return (String)Kernel.get((Object)this, (String)"placementArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setPlacementArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"placementArn", (Object)Objects.requireNonNull(value, "placementArn is required"));
    }

    @NotNull
    public Object getSources() {
        return Kernel.get((Object)this, (String)"sources", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSources(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"sources", (Object)Objects.requireNonNull(value, "sources is required"));
    }

    public void setSources(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof BridgeSourceProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeSourceProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"sources", Objects.requireNonNull(value, "sources is required"));
    }

    @Nullable
    public Object getEgressGatewayBridge() {
        return Kernel.get((Object)this, (String)"egressGatewayBridge", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEgressGatewayBridge(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"egressGatewayBridge", (Object)value);
    }

    public void setEgressGatewayBridge(@Nullable EgressGatewayBridgeProperty value) {
        Kernel.set((Object)this, (String)"egressGatewayBridge", (Object)value);
    }

    @Nullable
    public Object getIngressGatewayBridge() {
        return Kernel.get((Object)this, (String)"ingressGatewayBridge", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIngressGatewayBridge(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ingressGatewayBridge", (Object)value);
    }

    public void setIngressGatewayBridge(@Nullable IngressGatewayBridgeProperty value) {
        Kernel.set((Object)this, (String)"ingressGatewayBridge", (Object)value);
    }

    @Nullable
    public Object getOutputs() {
        return Kernel.get((Object)this, (String)"outputs", (NativeType)NativeType.forClass(Object.class));
    }

    public void setOutputs(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"outputs", (Object)value);
    }

    public void setOutputs(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof BridgeOutputProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.mediaconnect.CfnBridge.BridgeOutputProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"outputs", value);
    }

    @Nullable
    public Object getSourceFailoverConfig() {
        return Kernel.get((Object)this, (String)"sourceFailoverConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSourceFailoverConfig(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"sourceFailoverConfig", (Object)value);
    }

    public void setSourceFailoverConfig(@Nullable FailoverConfigProperty value) {
        Kernel.set((Object)this, (String)"sourceFailoverConfig", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BridgeSourceProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFlowSource() {
            return null;
        }

        @Nullable
        default public Object getNetworkSource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BridgeSourceProperty> {
            Object flowSource;
            Object networkSource;

            public Builder flowSource(IResolvable flowSource) {
                this.flowSource = flowSource;
                return this;
            }

            public Builder flowSource(BridgeFlowSourceProperty flowSource) {
                this.flowSource = flowSource;
                return this;
            }

            public Builder networkSource(IResolvable networkSource) {
                this.networkSource = networkSource;
                return this;
            }

            public Builder networkSource(BridgeNetworkSourceProperty networkSource) {
                this.networkSource = networkSource;
                return this;
            }

            public BridgeSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BridgeOutputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getNetworkOutput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BridgeOutputProperty> {
            Object networkOutput;

            public Builder networkOutput(IResolvable networkOutput) {
                this.networkOutput = networkOutput;
                return this;
            }

            public Builder networkOutput(BridgeNetworkOutputProperty networkOutput) {
                this.networkOutput = networkOutput;
                return this;
            }

            public BridgeOutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnBridge> {
        private final Construct scope;
        private final String id;
        private final CfnBridgeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnBridgeProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder placementArn(String placementArn) {
            this.props.placementArn(placementArn);
            return this;
        }

        public Builder sources(IResolvable sources) {
            this.props.sources(sources);
            return this;
        }

        public Builder sources(List<? extends Object> sources) {
            this.props.sources(sources);
            return this;
        }

        public Builder egressGatewayBridge(IResolvable egressGatewayBridge) {
            this.props.egressGatewayBridge(egressGatewayBridge);
            return this;
        }

        public Builder egressGatewayBridge(EgressGatewayBridgeProperty egressGatewayBridge) {
            this.props.egressGatewayBridge(egressGatewayBridge);
            return this;
        }

        public Builder ingressGatewayBridge(IResolvable ingressGatewayBridge) {
            this.props.ingressGatewayBridge(ingressGatewayBridge);
            return this;
        }

        public Builder ingressGatewayBridge(IngressGatewayBridgeProperty ingressGatewayBridge) {
            this.props.ingressGatewayBridge(ingressGatewayBridge);
            return this;
        }

        public Builder outputs(IResolvable outputs) {
            this.props.outputs(outputs);
            return this;
        }

        public Builder outputs(List<? extends Object> outputs) {
            this.props.outputs(outputs);
            return this;
        }

        public Builder sourceFailoverConfig(IResolvable sourceFailoverConfig) {
            this.props.sourceFailoverConfig(sourceFailoverConfig);
            return this;
        }

        public Builder sourceFailoverConfig(FailoverConfigProperty sourceFailoverConfig) {
            this.props.sourceFailoverConfig(sourceFailoverConfig);
            return this;
        }

        public CfnBridge build() {
            return new CfnBridge(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.VpcInterfaceAttachmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcInterfaceAttachmentProperty
    extends JsiiSerializable {
        @Nullable
        default public String getVpcInterfaceName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcInterfaceAttachmentProperty> {
            String vpcInterfaceName;

            public Builder vpcInterfaceName(String vpcInterfaceName) {
                this.vpcInterfaceName = vpcInterfaceName;
                return this;
            }

            public VpcInterfaceAttachmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.SourcePriorityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourcePriorityProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPrimarySource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourcePriorityProperty> {
            String primarySource;

            public Builder primarySource(String primarySource) {
                this.primarySource = primarySource;
                return this;
            }

            public SourcePriorityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.IngressGatewayBridgeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IngressGatewayBridgeProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxBitrate();

        @NotNull
        public Number getMaxOutputs();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IngressGatewayBridgeProperty> {
            Number maxBitrate;
            Number maxOutputs;

            public Builder maxBitrate(Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            public Builder maxOutputs(Number maxOutputs) {
                this.maxOutputs = maxOutputs;
                return this;
            }

            public IngressGatewayBridgeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.FailoverConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FailoverConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getFailoverMode();

        @Nullable
        default public Object getSourcePriority() {
            return null;
        }

        @Nullable
        default public String getState() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FailoverConfigProperty> {
            String failoverMode;
            Object sourcePriority;
            String state;

            public Builder failoverMode(String failoverMode) {
                this.failoverMode = failoverMode;
                return this;
            }

            public Builder sourcePriority(IResolvable sourcePriority) {
                this.sourcePriority = sourcePriority;
                return this;
            }

            public Builder sourcePriority(SourcePriorityProperty sourcePriority) {
                this.sourcePriority = sourcePriority;
                return this;
            }

            public Builder state(String state) {
                this.state = state;
                return this;
            }

            public FailoverConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.EgressGatewayBridgeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EgressGatewayBridgeProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxBitrate();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EgressGatewayBridgeProperty> {
            Number maxBitrate;

            public Builder maxBitrate(Number maxBitrate) {
                this.maxBitrate = maxBitrate;
                return this;
            }

            public EgressGatewayBridgeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeNetworkSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BridgeNetworkSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getMulticastIp();

        @NotNull
        public String getName();

        @NotNull
        public String getNetworkName();

        @NotNull
        public Number getPort();

        @NotNull
        public String getProtocol();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BridgeNetworkSourceProperty> {
            String multicastIp;
            String name;
            String networkName;
            Number port;
            String protocol;

            public Builder multicastIp(String multicastIp) {
                this.multicastIp = multicastIp;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder networkName(String networkName) {
                this.networkName = networkName;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public BridgeNetworkSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeNetworkOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BridgeNetworkOutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getIpAddress();

        @NotNull
        public String getName();

        @NotNull
        public String getNetworkName();

        @NotNull
        public Number getPort();

        @NotNull
        public String getProtocol();

        @NotNull
        public Number getTtl();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BridgeNetworkOutputProperty> {
            String ipAddress;
            String name;
            String networkName;
            Number port;
            String protocol;
            Number ttl;

            public Builder ipAddress(String ipAddress) {
                this.ipAddress = ipAddress;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder networkName(String networkName) {
                this.networkName = networkName;
                return this;
            }

            public Builder port(Number port) {
                this.port = port;
                return this;
            }

            public Builder protocol(String protocol) {
                this.protocol = protocol;
                return this;
            }

            public Builder ttl(Number ttl) {
                this.ttl = ttl;
                return this;
            }

            public BridgeNetworkOutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mediaconnect.CfnBridge.BridgeFlowSourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BridgeFlowSourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getFlowArn();

        @NotNull
        public String getName();

        @Nullable
        default public Object getFlowVpcInterfaceAttachment() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BridgeFlowSourceProperty> {
            String flowArn;
            String name;
            Object flowVpcInterfaceAttachment;

            public Builder flowArn(String flowArn) {
                this.flowArn = flowArn;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder flowVpcInterfaceAttachment(IResolvable flowVpcInterfaceAttachment) {
                this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment;
                return this;
            }

            public Builder flowVpcInterfaceAttachment(VpcInterfaceAttachmentProperty flowVpcInterfaceAttachment) {
                this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment;
                return this;
            }

            public BridgeFlowSourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

