/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.medialive;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.medialive.CfnNetwork;
import software.amazon.awscdk.services.medialive.CfnNetworkProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_medialive.CfnNetwork")
public class CfnNetwork
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnNetwork.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnNetwork(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnNetwork(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnNetwork(@NotNull Construct scope, @NotNull String id, @NotNull CfnNetworkProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public List<String> getAttrAssociatedClusterIds() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"attrAssociatedClusterIds", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrState() {
        return (String)Kernel.get((Object)this, (String)"attrState", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getIpPools() {
        return Kernel.get((Object)this, (String)"ipPools", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIpPools(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"ipPools", (Object)Objects.requireNonNull(value, "ipPools is required"));
    }

    public void setIpPools(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof IpPoolProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.medialive.CfnNetwork.IpPoolProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"ipPools", Objects.requireNonNull(value, "ipPools is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getRoutes() {
        return Kernel.get((Object)this, (String)"routes", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRoutes(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"routes", (Object)value);
    }

    public void setRoutes(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof RouteProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.medialive.CfnNetwork.RouteProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"routes", value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_medialive.CfnNetwork.IpPoolProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IpPoolProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCidr() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IpPoolProperty> {
            String cidr;

            public Builder cidr(String cidr) {
                this.cidr = cidr;
                return this;
            }

            public IpPoolProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_medialive.CfnNetwork.RouteProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RouteProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCidr() {
            return null;
        }

        @Nullable
        default public String getGateway() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RouteProperty> {
            String cidr;
            String gateway;

            public Builder cidr(String cidr) {
                this.cidr = cidr;
                return this;
            }

            public Builder gateway(String gateway) {
                this.gateway = gateway;
                return this;
            }

            public RouteProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnNetwork> {
        private final Construct scope;
        private final String id;
        private final CfnNetworkProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnNetworkProps.Builder();
        }

        public Builder ipPools(IResolvable ipPools) {
            this.props.ipPools(ipPools);
            return this;
        }

        public Builder ipPools(List<? extends Object> ipPools) {
            this.props.ipPools(ipPools);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder routes(IResolvable routes) {
            this.props.routes(routes);
            return this;
        }

        public Builder routes(List<? extends Object> routes) {
            this.props.routes(routes);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnNetwork build() {
            return new CfnNetwork(this.scope, this.id, this.props.build());
        }
    }
}

