/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.securityhub;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.securityhub.CfnInsight;
import software.amazon.awscdk.services.securityhub.CfnInsightProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight")
public class CfnInsight
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnInsight.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnInsight(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInsight(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnInsight(@NotNull Construct scope, @NotNull String id, @NotNull CfnInsightProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrInsightArn() {
        return (String)Kernel.get((Object)this, (String)"attrInsightArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getFilters() {
        return Kernel.get((Object)this, (String)"filters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFilters(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"filters", (Object)Objects.requireNonNull(value, "filters is required"));
    }

    public void setFilters(@NotNull AwsSecurityFindingFiltersProperty value) {
        Kernel.set((Object)this, (String)"filters", (Object)Objects.requireNonNull(value, "filters is required"));
    }

    @NotNull
    public String getGroupByAttribute() {
        return (String)Kernel.get((Object)this, (String)"groupByAttribute", (NativeType)NativeType.forClass(String.class));
    }

    public void setGroupByAttribute(@NotNull String value) {
        Kernel.set((Object)this, (String)"groupByAttribute", (Object)Objects.requireNonNull(value, "groupByAttribute is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnInsight> {
        private final Construct scope;
        private final String id;
        private final CfnInsightProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnInsightProps.Builder();
        }

        public Builder filters(IResolvable filters) {
            this.props.filters(filters);
            return this;
        }

        public Builder filters(AwsSecurityFindingFiltersProperty filters) {
            this.props.filters(filters);
            return this;
        }

        public Builder groupByAttribute(String groupByAttribute) {
            this.props.groupByAttribute(groupByAttribute);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public CfnInsight build() {
            return new CfnInsight(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.StringFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StringFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparison();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StringFilterProperty> {
            String comparison;
            String value;

            public Builder comparison(String comparison) {
                this.comparison = comparison;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public StringFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.NumberFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumberFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getEq() {
            return null;
        }

        @Nullable
        default public Number getGte() {
            return null;
        }

        @Nullable
        default public Number getLte() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumberFilterProperty> {
            Number eq;
            Number gte;
            Number lte;

            public Builder eq(Number eq) {
                this.eq = eq;
                return this;
            }

            public Builder gte(Number gte) {
                this.gte = gte;
                return this;
            }

            public Builder lte(Number lte) {
                this.lte = lte;
                return this;
            }

            public NumberFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.MapFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MapFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparison();

        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MapFilterProperty> {
            String comparison;
            String key;
            String value;

            public Builder comparison(String comparison) {
                this.comparison = comparison;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MapFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.KeywordFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KeywordFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KeywordFilterProperty> {
            String value;

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public KeywordFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.IpFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IpFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getCidr();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IpFilterProperty> {
            String cidr;

            public Builder cidr(String cidr) {
                this.cidr = cidr;
                return this;
            }

            public IpFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.DateRangeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateRangeProperty
    extends JsiiSerializable {
        @NotNull
        public String getUnit();

        @NotNull
        public Number getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateRangeProperty> {
            String unit;
            Number value;

            public Builder unit(String unit) {
                this.unit = unit;
                return this;
            }

            public Builder value(Number value) {
                this.value = value;
                return this;
            }

            public DateRangeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.DateFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDateRange() {
            return null;
        }

        @Nullable
        default public String getEnd() {
            return null;
        }

        @Nullable
        default public String getStart() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateFilterProperty> {
            Object dateRange;
            String end;
            String start;

            public Builder dateRange(IResolvable dateRange) {
                this.dateRange = dateRange;
                return this;
            }

            public Builder dateRange(DateRangeProperty dateRange) {
                this.dateRange = dateRange;
                return this;
            }

            public Builder end(String end) {
                this.end = end;
                return this;
            }

            public Builder start(String start) {
                this.start = start;
                return this;
            }

            public DateFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.BooleanFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BooleanFilterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BooleanFilterProperty> {
            Object value;

            public Builder value(Boolean value) {
                this.value = value;
                return this;
            }

            public Builder value(IResolvable value) {
                this.value = value;
                return this;
            }

            public BooleanFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_securityhub.CfnInsight.AwsSecurityFindingFiltersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsSecurityFindingFiltersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAwsAccountId() {
            return null;
        }

        @Nullable
        default public Object getAwsAccountName() {
            return null;
        }

        @Nullable
        default public Object getCompanyName() {
            return null;
        }

        @Nullable
        default public Object getComplianceAssociatedStandardsId() {
            return null;
        }

        @Nullable
        default public Object getComplianceSecurityControlId() {
            return null;
        }

        @Nullable
        default public Object getComplianceSecurityControlParametersName() {
            return null;
        }

        @Nullable
        default public Object getComplianceSecurityControlParametersValue() {
            return null;
        }

        @Nullable
        default public Object getComplianceStatus() {
            return null;
        }

        @Nullable
        default public Object getConfidence() {
            return null;
        }

        @Nullable
        default public Object getCreatedAt() {
            return null;
        }

        @Nullable
        default public Object getCriticality() {
            return null;
        }

        @Nullable
        default public Object getDescription() {
            return null;
        }

        @Nullable
        default public Object getFindingProviderFieldsConfidence() {
            return null;
        }

        @Nullable
        default public Object getFindingProviderFieldsCriticality() {
            return null;
        }

        @Nullable
        default public Object getFindingProviderFieldsRelatedFindingsId() {
            return null;
        }

        @Nullable
        default public Object getFindingProviderFieldsRelatedFindingsProductArn() {
            return null;
        }

        @Nullable
        default public Object getFindingProviderFieldsSeverityLabel() {
            return null;
        }

        @Nullable
        default public Object getFindingProviderFieldsSeverityOriginal() {
            return null;
        }

        @Nullable
        default public Object getFindingProviderFieldsTypes() {
            return null;
        }

        @Nullable
        default public Object getFirstObservedAt() {
            return null;
        }

        @Nullable
        default public Object getGeneratorId() {
            return null;
        }

        @Nullable
        default public Object getId() {
            return null;
        }

        @Nullable
        default public Object getKeyword() {
            return null;
        }

        @Nullable
        default public Object getLastObservedAt() {
            return null;
        }

        @Nullable
        default public Object getMalwareName() {
            return null;
        }

        @Nullable
        default public Object getMalwarePath() {
            return null;
        }

        @Nullable
        default public Object getMalwareState() {
            return null;
        }

        @Nullable
        default public Object getMalwareType() {
            return null;
        }

        @Nullable
        default public Object getNetworkDestinationDomain() {
            return null;
        }

        @Nullable
        default public Object getNetworkDestinationIpV4() {
            return null;
        }

        @Nullable
        default public Object getNetworkDestinationIpV6() {
            return null;
        }

        @Nullable
        default public Object getNetworkDestinationPort() {
            return null;
        }

        @Nullable
        default public Object getNetworkDirection() {
            return null;
        }

        @Nullable
        default public Object getNetworkProtocol() {
            return null;
        }

        @Nullable
        default public Object getNetworkSourceDomain() {
            return null;
        }

        @Nullable
        default public Object getNetworkSourceIpV4() {
            return null;
        }

        @Nullable
        default public Object getNetworkSourceIpV6() {
            return null;
        }

        @Nullable
        default public Object getNetworkSourceMac() {
            return null;
        }

        @Nullable
        default public Object getNetworkSourcePort() {
            return null;
        }

        @Nullable
        default public Object getNoteText() {
            return null;
        }

        @Nullable
        default public Object getNoteUpdatedAt() {
            return null;
        }

        @Nullable
        default public Object getNoteUpdatedBy() {
            return null;
        }

        @Nullable
        default public Object getProcessLaunchedAt() {
            return null;
        }

        @Nullable
        default public Object getProcessName() {
            return null;
        }

        @Nullable
        default public Object getProcessParentPid() {
            return null;
        }

        @Nullable
        default public Object getProcessPath() {
            return null;
        }

        @Nullable
        default public Object getProcessPid() {
            return null;
        }

        @Nullable
        default public Object getProcessTerminatedAt() {
            return null;
        }

        @Nullable
        default public Object getProductArn() {
            return null;
        }

        @Nullable
        default public Object getProductFields() {
            return null;
        }

        @Nullable
        default public Object getProductName() {
            return null;
        }

        @Nullable
        default public Object getRecommendationText() {
            return null;
        }

        @Nullable
        default public Object getRecordState() {
            return null;
        }

        @Nullable
        default public Object getRegion() {
            return null;
        }

        @Nullable
        default public Object getRelatedFindingsId() {
            return null;
        }

        @Nullable
        default public Object getRelatedFindingsProductArn() {
            return null;
        }

        @Nullable
        default public Object getResourceApplicationArn() {
            return null;
        }

        @Nullable
        default public Object getResourceApplicationName() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceIamInstanceProfileArn() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceImageId() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceIpV4Addresses() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceIpV6Addresses() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceKeyName() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceLaunchedAt() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceSubnetId() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceType() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsEc2InstanceVpcId() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsIamAccessKeyCreatedAt() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsIamAccessKeyPrincipalName() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsIamAccessKeyStatus() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsIamAccessKeyUserName() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsIamUserUserName() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsS3BucketOwnerId() {
            return null;
        }

        @Nullable
        default public Object getResourceAwsS3BucketOwnerName() {
            return null;
        }

        @Nullable
        default public Object getResourceContainerImageId() {
            return null;
        }

        @Nullable
        default public Object getResourceContainerImageName() {
            return null;
        }

        @Nullable
        default public Object getResourceContainerLaunchedAt() {
            return null;
        }

        @Nullable
        default public Object getResourceContainerName() {
            return null;
        }

        @Nullable
        default public Object getResourceDetailsOther() {
            return null;
        }

        @Nullable
        default public Object getResourceId() {
            return null;
        }

        @Nullable
        default public Object getResourcePartition() {
            return null;
        }

        @Nullable
        default public Object getResourceRegion() {
            return null;
        }

        @Nullable
        default public Object getResourceTags() {
            return null;
        }

        @Nullable
        default public Object getResourceType() {
            return null;
        }

        @Nullable
        default public Object getSample() {
            return null;
        }

        @Nullable
        default public Object getSeverityLabel() {
            return null;
        }

        @Nullable
        default public Object getSeverityNormalized() {
            return null;
        }

        @Nullable
        default public Object getSeverityProduct() {
            return null;
        }

        @Nullable
        default public Object getSourceUrl() {
            return null;
        }

        @Nullable
        default public Object getThreatIntelIndicatorCategory() {
            return null;
        }

        @Nullable
        default public Object getThreatIntelIndicatorLastObservedAt() {
            return null;
        }

        @Nullable
        default public Object getThreatIntelIndicatorSource() {
            return null;
        }

        @Nullable
        default public Object getThreatIntelIndicatorSourceUrl() {
            return null;
        }

        @Nullable
        default public Object getThreatIntelIndicatorType() {
            return null;
        }

        @Nullable
        default public Object getThreatIntelIndicatorValue() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        @Nullable
        default public Object getType() {
            return null;
        }

        @Nullable
        default public Object getUpdatedAt() {
            return null;
        }

        @Nullable
        default public Object getUserDefinedFields() {
            return null;
        }

        @Nullable
        default public Object getVerificationState() {
            return null;
        }

        @Nullable
        default public Object getVulnerabilitiesExploitAvailable() {
            return null;
        }

        @Nullable
        default public Object getVulnerabilitiesFixAvailable() {
            return null;
        }

        @Nullable
        default public Object getWorkflowState() {
            return null;
        }

        @Nullable
        default public Object getWorkflowStatus() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsSecurityFindingFiltersProperty> {
            Object awsAccountId;
            Object awsAccountName;
            Object companyName;
            Object complianceAssociatedStandardsId;
            Object complianceSecurityControlId;
            Object complianceSecurityControlParametersName;
            Object complianceSecurityControlParametersValue;
            Object complianceStatus;
            Object confidence;
            Object createdAt;
            Object criticality;
            Object description;
            Object findingProviderFieldsConfidence;
            Object findingProviderFieldsCriticality;
            Object findingProviderFieldsRelatedFindingsId;
            Object findingProviderFieldsRelatedFindingsProductArn;
            Object findingProviderFieldsSeverityLabel;
            Object findingProviderFieldsSeverityOriginal;
            Object findingProviderFieldsTypes;
            Object firstObservedAt;
            Object generatorId;
            Object id;
            Object keyword;
            Object lastObservedAt;
            Object malwareName;
            Object malwarePath;
            Object malwareState;
            Object malwareType;
            Object networkDestinationDomain;
            Object networkDestinationIpV4;
            Object networkDestinationIpV6;
            Object networkDestinationPort;
            Object networkDirection;
            Object networkProtocol;
            Object networkSourceDomain;
            Object networkSourceIpV4;
            Object networkSourceIpV6;
            Object networkSourceMac;
            Object networkSourcePort;
            Object noteText;
            Object noteUpdatedAt;
            Object noteUpdatedBy;
            Object processLaunchedAt;
            Object processName;
            Object processParentPid;
            Object processPath;
            Object processPid;
            Object processTerminatedAt;
            Object productArn;
            Object productFields;
            Object productName;
            Object recommendationText;
            Object recordState;
            Object region;
            Object relatedFindingsId;
            Object relatedFindingsProductArn;
            Object resourceApplicationArn;
            Object resourceApplicationName;
            Object resourceAwsEc2InstanceIamInstanceProfileArn;
            Object resourceAwsEc2InstanceImageId;
            Object resourceAwsEc2InstanceIpV4Addresses;
            Object resourceAwsEc2InstanceIpV6Addresses;
            Object resourceAwsEc2InstanceKeyName;
            Object resourceAwsEc2InstanceLaunchedAt;
            Object resourceAwsEc2InstanceSubnetId;
            Object resourceAwsEc2InstanceType;
            Object resourceAwsEc2InstanceVpcId;
            Object resourceAwsIamAccessKeyCreatedAt;
            Object resourceAwsIamAccessKeyPrincipalName;
            Object resourceAwsIamAccessKeyStatus;
            Object resourceAwsIamAccessKeyUserName;
            Object resourceAwsIamUserUserName;
            Object resourceAwsS3BucketOwnerId;
            Object resourceAwsS3BucketOwnerName;
            Object resourceContainerImageId;
            Object resourceContainerImageName;
            Object resourceContainerLaunchedAt;
            Object resourceContainerName;
            Object resourceDetailsOther;
            Object resourceId;
            Object resourcePartition;
            Object resourceRegion;
            Object resourceTags;
            Object resourceType;
            Object sample;
            Object severityLabel;
            Object severityNormalized;
            Object severityProduct;
            Object sourceUrl;
            Object threatIntelIndicatorCategory;
            Object threatIntelIndicatorLastObservedAt;
            Object threatIntelIndicatorSource;
            Object threatIntelIndicatorSourceUrl;
            Object threatIntelIndicatorType;
            Object threatIntelIndicatorValue;
            Object title;
            Object type;
            Object updatedAt;
            Object userDefinedFields;
            Object verificationState;
            Object vulnerabilitiesExploitAvailable;
            Object vulnerabilitiesFixAvailable;
            Object workflowState;
            Object workflowStatus;

            public Builder awsAccountId(IResolvable awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            public Builder awsAccountId(List<? extends Object> awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            public Builder awsAccountName(IResolvable awsAccountName) {
                this.awsAccountName = awsAccountName;
                return this;
            }

            public Builder awsAccountName(List<? extends Object> awsAccountName) {
                this.awsAccountName = awsAccountName;
                return this;
            }

            public Builder companyName(IResolvable companyName) {
                this.companyName = companyName;
                return this;
            }

            public Builder companyName(List<? extends Object> companyName) {
                this.companyName = companyName;
                return this;
            }

            public Builder complianceAssociatedStandardsId(IResolvable complianceAssociatedStandardsId) {
                this.complianceAssociatedStandardsId = complianceAssociatedStandardsId;
                return this;
            }

            public Builder complianceAssociatedStandardsId(List<? extends Object> complianceAssociatedStandardsId) {
                this.complianceAssociatedStandardsId = complianceAssociatedStandardsId;
                return this;
            }

            public Builder complianceSecurityControlId(IResolvable complianceSecurityControlId) {
                this.complianceSecurityControlId = complianceSecurityControlId;
                return this;
            }

            public Builder complianceSecurityControlId(List<? extends Object> complianceSecurityControlId) {
                this.complianceSecurityControlId = complianceSecurityControlId;
                return this;
            }

            public Builder complianceSecurityControlParametersName(IResolvable complianceSecurityControlParametersName) {
                this.complianceSecurityControlParametersName = complianceSecurityControlParametersName;
                return this;
            }

            public Builder complianceSecurityControlParametersName(List<? extends Object> complianceSecurityControlParametersName) {
                this.complianceSecurityControlParametersName = complianceSecurityControlParametersName;
                return this;
            }

            public Builder complianceSecurityControlParametersValue(IResolvable complianceSecurityControlParametersValue) {
                this.complianceSecurityControlParametersValue = complianceSecurityControlParametersValue;
                return this;
            }

            public Builder complianceSecurityControlParametersValue(List<? extends Object> complianceSecurityControlParametersValue) {
                this.complianceSecurityControlParametersValue = complianceSecurityControlParametersValue;
                return this;
            }

            public Builder complianceStatus(IResolvable complianceStatus) {
                this.complianceStatus = complianceStatus;
                return this;
            }

            public Builder complianceStatus(List<? extends Object> complianceStatus) {
                this.complianceStatus = complianceStatus;
                return this;
            }

            public Builder confidence(IResolvable confidence) {
                this.confidence = confidence;
                return this;
            }

            public Builder confidence(List<? extends Object> confidence) {
                this.confidence = confidence;
                return this;
            }

            public Builder createdAt(IResolvable createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public Builder createdAt(List<? extends Object> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            public Builder criticality(IResolvable criticality) {
                this.criticality = criticality;
                return this;
            }

            public Builder criticality(List<? extends Object> criticality) {
                this.criticality = criticality;
                return this;
            }

            public Builder description(IResolvable description) {
                this.description = description;
                return this;
            }

            public Builder description(List<? extends Object> description) {
                this.description = description;
                return this;
            }

            public Builder findingProviderFieldsConfidence(IResolvable findingProviderFieldsConfidence) {
                this.findingProviderFieldsConfidence = findingProviderFieldsConfidence;
                return this;
            }

            public Builder findingProviderFieldsConfidence(List<? extends Object> findingProviderFieldsConfidence) {
                this.findingProviderFieldsConfidence = findingProviderFieldsConfidence;
                return this;
            }

            public Builder findingProviderFieldsCriticality(IResolvable findingProviderFieldsCriticality) {
                this.findingProviderFieldsCriticality = findingProviderFieldsCriticality;
                return this;
            }

            public Builder findingProviderFieldsCriticality(List<? extends Object> findingProviderFieldsCriticality) {
                this.findingProviderFieldsCriticality = findingProviderFieldsCriticality;
                return this;
            }

            public Builder findingProviderFieldsRelatedFindingsId(IResolvable findingProviderFieldsRelatedFindingsId) {
                this.findingProviderFieldsRelatedFindingsId = findingProviderFieldsRelatedFindingsId;
                return this;
            }

            public Builder findingProviderFieldsRelatedFindingsId(List<? extends Object> findingProviderFieldsRelatedFindingsId) {
                this.findingProviderFieldsRelatedFindingsId = findingProviderFieldsRelatedFindingsId;
                return this;
            }

            public Builder findingProviderFieldsRelatedFindingsProductArn(IResolvable findingProviderFieldsRelatedFindingsProductArn) {
                this.findingProviderFieldsRelatedFindingsProductArn = findingProviderFieldsRelatedFindingsProductArn;
                return this;
            }

            public Builder findingProviderFieldsRelatedFindingsProductArn(List<? extends Object> findingProviderFieldsRelatedFindingsProductArn) {
                this.findingProviderFieldsRelatedFindingsProductArn = findingProviderFieldsRelatedFindingsProductArn;
                return this;
            }

            public Builder findingProviderFieldsSeverityLabel(IResolvable findingProviderFieldsSeverityLabel) {
                this.findingProviderFieldsSeverityLabel = findingProviderFieldsSeverityLabel;
                return this;
            }

            public Builder findingProviderFieldsSeverityLabel(List<? extends Object> findingProviderFieldsSeverityLabel) {
                this.findingProviderFieldsSeverityLabel = findingProviderFieldsSeverityLabel;
                return this;
            }

            public Builder findingProviderFieldsSeverityOriginal(IResolvable findingProviderFieldsSeverityOriginal) {
                this.findingProviderFieldsSeverityOriginal = findingProviderFieldsSeverityOriginal;
                return this;
            }

            public Builder findingProviderFieldsSeverityOriginal(List<? extends Object> findingProviderFieldsSeverityOriginal) {
                this.findingProviderFieldsSeverityOriginal = findingProviderFieldsSeverityOriginal;
                return this;
            }

            public Builder findingProviderFieldsTypes(IResolvable findingProviderFieldsTypes) {
                this.findingProviderFieldsTypes = findingProviderFieldsTypes;
                return this;
            }

            public Builder findingProviderFieldsTypes(List<? extends Object> findingProviderFieldsTypes) {
                this.findingProviderFieldsTypes = findingProviderFieldsTypes;
                return this;
            }

            public Builder firstObservedAt(IResolvable firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            public Builder firstObservedAt(List<? extends Object> firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            public Builder generatorId(IResolvable generatorId) {
                this.generatorId = generatorId;
                return this;
            }

            public Builder generatorId(List<? extends Object> generatorId) {
                this.generatorId = generatorId;
                return this;
            }

            public Builder id(IResolvable id) {
                this.id = id;
                return this;
            }

            public Builder id(List<? extends Object> id) {
                this.id = id;
                return this;
            }

            public Builder keyword(IResolvable keyword) {
                this.keyword = keyword;
                return this;
            }

            public Builder keyword(List<? extends Object> keyword) {
                this.keyword = keyword;
                return this;
            }

            public Builder lastObservedAt(IResolvable lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            public Builder lastObservedAt(List<? extends Object> lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            public Builder malwareName(IResolvable malwareName) {
                this.malwareName = malwareName;
                return this;
            }

            public Builder malwareName(List<? extends Object> malwareName) {
                this.malwareName = malwareName;
                return this;
            }

            public Builder malwarePath(IResolvable malwarePath) {
                this.malwarePath = malwarePath;
                return this;
            }

            public Builder malwarePath(List<? extends Object> malwarePath) {
                this.malwarePath = malwarePath;
                return this;
            }

            public Builder malwareState(IResolvable malwareState) {
                this.malwareState = malwareState;
                return this;
            }

            public Builder malwareState(List<? extends Object> malwareState) {
                this.malwareState = malwareState;
                return this;
            }

            public Builder malwareType(IResolvable malwareType) {
                this.malwareType = malwareType;
                return this;
            }

            public Builder malwareType(List<? extends Object> malwareType) {
                this.malwareType = malwareType;
                return this;
            }

            public Builder networkDestinationDomain(IResolvable networkDestinationDomain) {
                this.networkDestinationDomain = networkDestinationDomain;
                return this;
            }

            public Builder networkDestinationDomain(List<? extends Object> networkDestinationDomain) {
                this.networkDestinationDomain = networkDestinationDomain;
                return this;
            }

            public Builder networkDestinationIpV4(IResolvable networkDestinationIpV4) {
                this.networkDestinationIpV4 = networkDestinationIpV4;
                return this;
            }

            public Builder networkDestinationIpV4(List<? extends Object> networkDestinationIpV4) {
                this.networkDestinationIpV4 = networkDestinationIpV4;
                return this;
            }

            public Builder networkDestinationIpV6(IResolvable networkDestinationIpV6) {
                this.networkDestinationIpV6 = networkDestinationIpV6;
                return this;
            }

            public Builder networkDestinationIpV6(List<? extends Object> networkDestinationIpV6) {
                this.networkDestinationIpV6 = networkDestinationIpV6;
                return this;
            }

            public Builder networkDestinationPort(IResolvable networkDestinationPort) {
                this.networkDestinationPort = networkDestinationPort;
                return this;
            }

            public Builder networkDestinationPort(List<? extends Object> networkDestinationPort) {
                this.networkDestinationPort = networkDestinationPort;
                return this;
            }

            public Builder networkDirection(IResolvable networkDirection) {
                this.networkDirection = networkDirection;
                return this;
            }

            public Builder networkDirection(List<? extends Object> networkDirection) {
                this.networkDirection = networkDirection;
                return this;
            }

            public Builder networkProtocol(IResolvable networkProtocol) {
                this.networkProtocol = networkProtocol;
                return this;
            }

            public Builder networkProtocol(List<? extends Object> networkProtocol) {
                this.networkProtocol = networkProtocol;
                return this;
            }

            public Builder networkSourceDomain(IResolvable networkSourceDomain) {
                this.networkSourceDomain = networkSourceDomain;
                return this;
            }

            public Builder networkSourceDomain(List<? extends Object> networkSourceDomain) {
                this.networkSourceDomain = networkSourceDomain;
                return this;
            }

            public Builder networkSourceIpV4(IResolvable networkSourceIpV4) {
                this.networkSourceIpV4 = networkSourceIpV4;
                return this;
            }

            public Builder networkSourceIpV4(List<? extends Object> networkSourceIpV4) {
                this.networkSourceIpV4 = networkSourceIpV4;
                return this;
            }

            public Builder networkSourceIpV6(IResolvable networkSourceIpV6) {
                this.networkSourceIpV6 = networkSourceIpV6;
                return this;
            }

            public Builder networkSourceIpV6(List<? extends Object> networkSourceIpV6) {
                this.networkSourceIpV6 = networkSourceIpV6;
                return this;
            }

            public Builder networkSourceMac(IResolvable networkSourceMac) {
                this.networkSourceMac = networkSourceMac;
                return this;
            }

            public Builder networkSourceMac(List<? extends Object> networkSourceMac) {
                this.networkSourceMac = networkSourceMac;
                return this;
            }

            public Builder networkSourcePort(IResolvable networkSourcePort) {
                this.networkSourcePort = networkSourcePort;
                return this;
            }

            public Builder networkSourcePort(List<? extends Object> networkSourcePort) {
                this.networkSourcePort = networkSourcePort;
                return this;
            }

            public Builder noteText(IResolvable noteText) {
                this.noteText = noteText;
                return this;
            }

            public Builder noteText(List<? extends Object> noteText) {
                this.noteText = noteText;
                return this;
            }

            public Builder noteUpdatedAt(IResolvable noteUpdatedAt) {
                this.noteUpdatedAt = noteUpdatedAt;
                return this;
            }

            public Builder noteUpdatedAt(List<? extends Object> noteUpdatedAt) {
                this.noteUpdatedAt = noteUpdatedAt;
                return this;
            }

            public Builder noteUpdatedBy(IResolvable noteUpdatedBy) {
                this.noteUpdatedBy = noteUpdatedBy;
                return this;
            }

            public Builder noteUpdatedBy(List<? extends Object> noteUpdatedBy) {
                this.noteUpdatedBy = noteUpdatedBy;
                return this;
            }

            public Builder processLaunchedAt(IResolvable processLaunchedAt) {
                this.processLaunchedAt = processLaunchedAt;
                return this;
            }

            public Builder processLaunchedAt(List<? extends Object> processLaunchedAt) {
                this.processLaunchedAt = processLaunchedAt;
                return this;
            }

            public Builder processName(IResolvable processName) {
                this.processName = processName;
                return this;
            }

            public Builder processName(List<? extends Object> processName) {
                this.processName = processName;
                return this;
            }

            public Builder processParentPid(IResolvable processParentPid) {
                this.processParentPid = processParentPid;
                return this;
            }

            public Builder processParentPid(List<? extends Object> processParentPid) {
                this.processParentPid = processParentPid;
                return this;
            }

            public Builder processPath(IResolvable processPath) {
                this.processPath = processPath;
                return this;
            }

            public Builder processPath(List<? extends Object> processPath) {
                this.processPath = processPath;
                return this;
            }

            public Builder processPid(IResolvable processPid) {
                this.processPid = processPid;
                return this;
            }

            public Builder processPid(List<? extends Object> processPid) {
                this.processPid = processPid;
                return this;
            }

            public Builder processTerminatedAt(IResolvable processTerminatedAt) {
                this.processTerminatedAt = processTerminatedAt;
                return this;
            }

            public Builder processTerminatedAt(List<? extends Object> processTerminatedAt) {
                this.processTerminatedAt = processTerminatedAt;
                return this;
            }

            public Builder productArn(IResolvable productArn) {
                this.productArn = productArn;
                return this;
            }

            public Builder productArn(List<? extends Object> productArn) {
                this.productArn = productArn;
                return this;
            }

            public Builder productFields(IResolvable productFields) {
                this.productFields = productFields;
                return this;
            }

            public Builder productFields(List<? extends Object> productFields) {
                this.productFields = productFields;
                return this;
            }

            public Builder productName(IResolvable productName) {
                this.productName = productName;
                return this;
            }

            public Builder productName(List<? extends Object> productName) {
                this.productName = productName;
                return this;
            }

            public Builder recommendationText(IResolvable recommendationText) {
                this.recommendationText = recommendationText;
                return this;
            }

            public Builder recommendationText(List<? extends Object> recommendationText) {
                this.recommendationText = recommendationText;
                return this;
            }

            public Builder recordState(IResolvable recordState) {
                this.recordState = recordState;
                return this;
            }

            public Builder recordState(List<? extends Object> recordState) {
                this.recordState = recordState;
                return this;
            }

            public Builder region(IResolvable region) {
                this.region = region;
                return this;
            }

            public Builder region(List<? extends Object> region) {
                this.region = region;
                return this;
            }

            public Builder relatedFindingsId(IResolvable relatedFindingsId) {
                this.relatedFindingsId = relatedFindingsId;
                return this;
            }

            public Builder relatedFindingsId(List<? extends Object> relatedFindingsId) {
                this.relatedFindingsId = relatedFindingsId;
                return this;
            }

            public Builder relatedFindingsProductArn(IResolvable relatedFindingsProductArn) {
                this.relatedFindingsProductArn = relatedFindingsProductArn;
                return this;
            }

            public Builder relatedFindingsProductArn(List<? extends Object> relatedFindingsProductArn) {
                this.relatedFindingsProductArn = relatedFindingsProductArn;
                return this;
            }

            public Builder resourceApplicationArn(IResolvable resourceApplicationArn) {
                this.resourceApplicationArn = resourceApplicationArn;
                return this;
            }

            public Builder resourceApplicationArn(List<? extends Object> resourceApplicationArn) {
                this.resourceApplicationArn = resourceApplicationArn;
                return this;
            }

            public Builder resourceApplicationName(IResolvable resourceApplicationName) {
                this.resourceApplicationName = resourceApplicationName;
                return this;
            }

            public Builder resourceApplicationName(List<? extends Object> resourceApplicationName) {
                this.resourceApplicationName = resourceApplicationName;
                return this;
            }

            public Builder resourceAwsEc2InstanceIamInstanceProfileArn(IResolvable resourceAwsEc2InstanceIamInstanceProfileArn) {
                this.resourceAwsEc2InstanceIamInstanceProfileArn = resourceAwsEc2InstanceIamInstanceProfileArn;
                return this;
            }

            public Builder resourceAwsEc2InstanceIamInstanceProfileArn(List<? extends Object> resourceAwsEc2InstanceIamInstanceProfileArn) {
                this.resourceAwsEc2InstanceIamInstanceProfileArn = resourceAwsEc2InstanceIamInstanceProfileArn;
                return this;
            }

            public Builder resourceAwsEc2InstanceImageId(IResolvable resourceAwsEc2InstanceImageId) {
                this.resourceAwsEc2InstanceImageId = resourceAwsEc2InstanceImageId;
                return this;
            }

            public Builder resourceAwsEc2InstanceImageId(List<? extends Object> resourceAwsEc2InstanceImageId) {
                this.resourceAwsEc2InstanceImageId = resourceAwsEc2InstanceImageId;
                return this;
            }

            public Builder resourceAwsEc2InstanceIpV4Addresses(IResolvable resourceAwsEc2InstanceIpV4Addresses) {
                this.resourceAwsEc2InstanceIpV4Addresses = resourceAwsEc2InstanceIpV4Addresses;
                return this;
            }

            public Builder resourceAwsEc2InstanceIpV4Addresses(List<? extends Object> resourceAwsEc2InstanceIpV4Addresses) {
                this.resourceAwsEc2InstanceIpV4Addresses = resourceAwsEc2InstanceIpV4Addresses;
                return this;
            }

            public Builder resourceAwsEc2InstanceIpV6Addresses(IResolvable resourceAwsEc2InstanceIpV6Addresses) {
                this.resourceAwsEc2InstanceIpV6Addresses = resourceAwsEc2InstanceIpV6Addresses;
                return this;
            }

            public Builder resourceAwsEc2InstanceIpV6Addresses(List<? extends Object> resourceAwsEc2InstanceIpV6Addresses) {
                this.resourceAwsEc2InstanceIpV6Addresses = resourceAwsEc2InstanceIpV6Addresses;
                return this;
            }

            public Builder resourceAwsEc2InstanceKeyName(IResolvable resourceAwsEc2InstanceKeyName) {
                this.resourceAwsEc2InstanceKeyName = resourceAwsEc2InstanceKeyName;
                return this;
            }

            public Builder resourceAwsEc2InstanceKeyName(List<? extends Object> resourceAwsEc2InstanceKeyName) {
                this.resourceAwsEc2InstanceKeyName = resourceAwsEc2InstanceKeyName;
                return this;
            }

            public Builder resourceAwsEc2InstanceLaunchedAt(IResolvable resourceAwsEc2InstanceLaunchedAt) {
                this.resourceAwsEc2InstanceLaunchedAt = resourceAwsEc2InstanceLaunchedAt;
                return this;
            }

            public Builder resourceAwsEc2InstanceLaunchedAt(List<? extends Object> resourceAwsEc2InstanceLaunchedAt) {
                this.resourceAwsEc2InstanceLaunchedAt = resourceAwsEc2InstanceLaunchedAt;
                return this;
            }

            public Builder resourceAwsEc2InstanceSubnetId(IResolvable resourceAwsEc2InstanceSubnetId) {
                this.resourceAwsEc2InstanceSubnetId = resourceAwsEc2InstanceSubnetId;
                return this;
            }

            public Builder resourceAwsEc2InstanceSubnetId(List<? extends Object> resourceAwsEc2InstanceSubnetId) {
                this.resourceAwsEc2InstanceSubnetId = resourceAwsEc2InstanceSubnetId;
                return this;
            }

            public Builder resourceAwsEc2InstanceType(IResolvable resourceAwsEc2InstanceType) {
                this.resourceAwsEc2InstanceType = resourceAwsEc2InstanceType;
                return this;
            }

            public Builder resourceAwsEc2InstanceType(List<? extends Object> resourceAwsEc2InstanceType) {
                this.resourceAwsEc2InstanceType = resourceAwsEc2InstanceType;
                return this;
            }

            public Builder resourceAwsEc2InstanceVpcId(IResolvable resourceAwsEc2InstanceVpcId) {
                this.resourceAwsEc2InstanceVpcId = resourceAwsEc2InstanceVpcId;
                return this;
            }

            public Builder resourceAwsEc2InstanceVpcId(List<? extends Object> resourceAwsEc2InstanceVpcId) {
                this.resourceAwsEc2InstanceVpcId = resourceAwsEc2InstanceVpcId;
                return this;
            }

            public Builder resourceAwsIamAccessKeyCreatedAt(IResolvable resourceAwsIamAccessKeyCreatedAt) {
                this.resourceAwsIamAccessKeyCreatedAt = resourceAwsIamAccessKeyCreatedAt;
                return this;
            }

            public Builder resourceAwsIamAccessKeyCreatedAt(List<? extends Object> resourceAwsIamAccessKeyCreatedAt) {
                this.resourceAwsIamAccessKeyCreatedAt = resourceAwsIamAccessKeyCreatedAt;
                return this;
            }

            public Builder resourceAwsIamAccessKeyPrincipalName(IResolvable resourceAwsIamAccessKeyPrincipalName) {
                this.resourceAwsIamAccessKeyPrincipalName = resourceAwsIamAccessKeyPrincipalName;
                return this;
            }

            public Builder resourceAwsIamAccessKeyPrincipalName(List<? extends Object> resourceAwsIamAccessKeyPrincipalName) {
                this.resourceAwsIamAccessKeyPrincipalName = resourceAwsIamAccessKeyPrincipalName;
                return this;
            }

            public Builder resourceAwsIamAccessKeyStatus(IResolvable resourceAwsIamAccessKeyStatus) {
                this.resourceAwsIamAccessKeyStatus = resourceAwsIamAccessKeyStatus;
                return this;
            }

            public Builder resourceAwsIamAccessKeyStatus(List<? extends Object> resourceAwsIamAccessKeyStatus) {
                this.resourceAwsIamAccessKeyStatus = resourceAwsIamAccessKeyStatus;
                return this;
            }

            public Builder resourceAwsIamAccessKeyUserName(IResolvable resourceAwsIamAccessKeyUserName) {
                this.resourceAwsIamAccessKeyUserName = resourceAwsIamAccessKeyUserName;
                return this;
            }

            public Builder resourceAwsIamAccessKeyUserName(List<? extends Object> resourceAwsIamAccessKeyUserName) {
                this.resourceAwsIamAccessKeyUserName = resourceAwsIamAccessKeyUserName;
                return this;
            }

            public Builder resourceAwsIamUserUserName(IResolvable resourceAwsIamUserUserName) {
                this.resourceAwsIamUserUserName = resourceAwsIamUserUserName;
                return this;
            }

            public Builder resourceAwsIamUserUserName(List<? extends Object> resourceAwsIamUserUserName) {
                this.resourceAwsIamUserUserName = resourceAwsIamUserUserName;
                return this;
            }

            public Builder resourceAwsS3BucketOwnerId(IResolvable resourceAwsS3BucketOwnerId) {
                this.resourceAwsS3BucketOwnerId = resourceAwsS3BucketOwnerId;
                return this;
            }

            public Builder resourceAwsS3BucketOwnerId(List<? extends Object> resourceAwsS3BucketOwnerId) {
                this.resourceAwsS3BucketOwnerId = resourceAwsS3BucketOwnerId;
                return this;
            }

            public Builder resourceAwsS3BucketOwnerName(IResolvable resourceAwsS3BucketOwnerName) {
                this.resourceAwsS3BucketOwnerName = resourceAwsS3BucketOwnerName;
                return this;
            }

            public Builder resourceAwsS3BucketOwnerName(List<? extends Object> resourceAwsS3BucketOwnerName) {
                this.resourceAwsS3BucketOwnerName = resourceAwsS3BucketOwnerName;
                return this;
            }

            public Builder resourceContainerImageId(IResolvable resourceContainerImageId) {
                this.resourceContainerImageId = resourceContainerImageId;
                return this;
            }

            public Builder resourceContainerImageId(List<? extends Object> resourceContainerImageId) {
                this.resourceContainerImageId = resourceContainerImageId;
                return this;
            }

            public Builder resourceContainerImageName(IResolvable resourceContainerImageName) {
                this.resourceContainerImageName = resourceContainerImageName;
                return this;
            }

            public Builder resourceContainerImageName(List<? extends Object> resourceContainerImageName) {
                this.resourceContainerImageName = resourceContainerImageName;
                return this;
            }

            public Builder resourceContainerLaunchedAt(IResolvable resourceContainerLaunchedAt) {
                this.resourceContainerLaunchedAt = resourceContainerLaunchedAt;
                return this;
            }

            public Builder resourceContainerLaunchedAt(List<? extends Object> resourceContainerLaunchedAt) {
                this.resourceContainerLaunchedAt = resourceContainerLaunchedAt;
                return this;
            }

            public Builder resourceContainerName(IResolvable resourceContainerName) {
                this.resourceContainerName = resourceContainerName;
                return this;
            }

            public Builder resourceContainerName(List<? extends Object> resourceContainerName) {
                this.resourceContainerName = resourceContainerName;
                return this;
            }

            public Builder resourceDetailsOther(IResolvable resourceDetailsOther) {
                this.resourceDetailsOther = resourceDetailsOther;
                return this;
            }

            public Builder resourceDetailsOther(List<? extends Object> resourceDetailsOther) {
                this.resourceDetailsOther = resourceDetailsOther;
                return this;
            }

            public Builder resourceId(IResolvable resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder resourceId(List<? extends Object> resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder resourcePartition(IResolvable resourcePartition) {
                this.resourcePartition = resourcePartition;
                return this;
            }

            public Builder resourcePartition(List<? extends Object> resourcePartition) {
                this.resourcePartition = resourcePartition;
                return this;
            }

            public Builder resourceRegion(IResolvable resourceRegion) {
                this.resourceRegion = resourceRegion;
                return this;
            }

            public Builder resourceRegion(List<? extends Object> resourceRegion) {
                this.resourceRegion = resourceRegion;
                return this;
            }

            public Builder resourceTags(IResolvable resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            public Builder resourceTags(List<? extends Object> resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            public Builder resourceType(IResolvable resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder resourceType(List<? extends Object> resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder sample(IResolvable sample) {
                this.sample = sample;
                return this;
            }

            public Builder sample(List<? extends Object> sample) {
                this.sample = sample;
                return this;
            }

            public Builder severityLabel(IResolvable severityLabel) {
                this.severityLabel = severityLabel;
                return this;
            }

            public Builder severityLabel(List<? extends Object> severityLabel) {
                this.severityLabel = severityLabel;
                return this;
            }

            public Builder severityNormalized(IResolvable severityNormalized) {
                this.severityNormalized = severityNormalized;
                return this;
            }

            public Builder severityNormalized(List<? extends Object> severityNormalized) {
                this.severityNormalized = severityNormalized;
                return this;
            }

            public Builder severityProduct(IResolvable severityProduct) {
                this.severityProduct = severityProduct;
                return this;
            }

            public Builder severityProduct(List<? extends Object> severityProduct) {
                this.severityProduct = severityProduct;
                return this;
            }

            public Builder sourceUrl(IResolvable sourceUrl) {
                this.sourceUrl = sourceUrl;
                return this;
            }

            public Builder sourceUrl(List<? extends Object> sourceUrl) {
                this.sourceUrl = sourceUrl;
                return this;
            }

            public Builder threatIntelIndicatorCategory(IResolvable threatIntelIndicatorCategory) {
                this.threatIntelIndicatorCategory = threatIntelIndicatorCategory;
                return this;
            }

            public Builder threatIntelIndicatorCategory(List<? extends Object> threatIntelIndicatorCategory) {
                this.threatIntelIndicatorCategory = threatIntelIndicatorCategory;
                return this;
            }

            public Builder threatIntelIndicatorLastObservedAt(IResolvable threatIntelIndicatorLastObservedAt) {
                this.threatIntelIndicatorLastObservedAt = threatIntelIndicatorLastObservedAt;
                return this;
            }

            public Builder threatIntelIndicatorLastObservedAt(List<? extends Object> threatIntelIndicatorLastObservedAt) {
                this.threatIntelIndicatorLastObservedAt = threatIntelIndicatorLastObservedAt;
                return this;
            }

            public Builder threatIntelIndicatorSource(IResolvable threatIntelIndicatorSource) {
                this.threatIntelIndicatorSource = threatIntelIndicatorSource;
                return this;
            }

            public Builder threatIntelIndicatorSource(List<? extends Object> threatIntelIndicatorSource) {
                this.threatIntelIndicatorSource = threatIntelIndicatorSource;
                return this;
            }

            public Builder threatIntelIndicatorSourceUrl(IResolvable threatIntelIndicatorSourceUrl) {
                this.threatIntelIndicatorSourceUrl = threatIntelIndicatorSourceUrl;
                return this;
            }

            public Builder threatIntelIndicatorSourceUrl(List<? extends Object> threatIntelIndicatorSourceUrl) {
                this.threatIntelIndicatorSourceUrl = threatIntelIndicatorSourceUrl;
                return this;
            }

            public Builder threatIntelIndicatorType(IResolvable threatIntelIndicatorType) {
                this.threatIntelIndicatorType = threatIntelIndicatorType;
                return this;
            }

            public Builder threatIntelIndicatorType(List<? extends Object> threatIntelIndicatorType) {
                this.threatIntelIndicatorType = threatIntelIndicatorType;
                return this;
            }

            public Builder threatIntelIndicatorValue(IResolvable threatIntelIndicatorValue) {
                this.threatIntelIndicatorValue = threatIntelIndicatorValue;
                return this;
            }

            public Builder threatIntelIndicatorValue(List<? extends Object> threatIntelIndicatorValue) {
                this.threatIntelIndicatorValue = threatIntelIndicatorValue;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(List<? extends Object> title) {
                this.title = title;
                return this;
            }

            public Builder type(IResolvable type) {
                this.type = type;
                return this;
            }

            public Builder type(List<? extends Object> type) {
                this.type = type;
                return this;
            }

            public Builder updatedAt(IResolvable updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Builder updatedAt(List<? extends Object> updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Builder userDefinedFields(IResolvable userDefinedFields) {
                this.userDefinedFields = userDefinedFields;
                return this;
            }

            public Builder userDefinedFields(List<? extends Object> userDefinedFields) {
                this.userDefinedFields = userDefinedFields;
                return this;
            }

            public Builder verificationState(IResolvable verificationState) {
                this.verificationState = verificationState;
                return this;
            }

            public Builder verificationState(List<? extends Object> verificationState) {
                this.verificationState = verificationState;
                return this;
            }

            public Builder vulnerabilitiesExploitAvailable(IResolvable vulnerabilitiesExploitAvailable) {
                this.vulnerabilitiesExploitAvailable = vulnerabilitiesExploitAvailable;
                return this;
            }

            public Builder vulnerabilitiesExploitAvailable(List<? extends Object> vulnerabilitiesExploitAvailable) {
                this.vulnerabilitiesExploitAvailable = vulnerabilitiesExploitAvailable;
                return this;
            }

            public Builder vulnerabilitiesFixAvailable(IResolvable vulnerabilitiesFixAvailable) {
                this.vulnerabilitiesFixAvailable = vulnerabilitiesFixAvailable;
                return this;
            }

            public Builder vulnerabilitiesFixAvailable(List<? extends Object> vulnerabilitiesFixAvailable) {
                this.vulnerabilitiesFixAvailable = vulnerabilitiesFixAvailable;
                return this;
            }

            public Builder workflowState(IResolvable workflowState) {
                this.workflowState = workflowState;
                return this;
            }

            public Builder workflowState(List<? extends Object> workflowState) {
                this.workflowState = workflowState;
                return this;
            }

            public Builder workflowStatus(IResolvable workflowStatus) {
                this.workflowStatus = workflowStatus;
                return this;
            }

            public Builder workflowStatus(List<? extends Object> workflowStatus) {
                this.workflowStatus = workflowStatus;
                return this;
            }

            public AwsSecurityFindingFiltersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

