package software.amazon.awscdk;

/**
 * Specifies whether an Auto Scaling group and the instances it contains are replaced during an update.
 * <p>
 * During replacement,
 * AWS CloudFormation retains the old group until it finishes creating the new one. If the update fails, AWS CloudFormation
 * can roll back to the old Auto Scaling group and delete the new Auto Scaling group.
 * <p>
 * While AWS CloudFormation creates the new group, it doesn't detach or attach any instances. After successfully creating
 * the new Auto Scaling group, AWS CloudFormation deletes the old Auto Scaling group during the cleanup process.
 * <p>
 * When you set the WillReplace parameter, remember to specify a matching CreationPolicy. If the minimum number of
 * instances (specified by the MinSuccessfulInstancesPercent property) don't signal success within the Timeout period
 * (specified in the CreationPolicy policy), the replacement update fails and AWS CloudFormation rolls back to the old
 * Auto Scaling group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnAutoScalingReplacingUpdate cfnAutoScalingReplacingUpdate = CfnAutoScalingReplacingUpdate.builder()
 *         .willReplace(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:39.975Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnAutoScalingReplacingUpdate")
@software.amazon.jsii.Jsii.Proxy(CfnAutoScalingReplacingUpdate.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutoScalingReplacingUpdate extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWillReplace() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAutoScalingReplacingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAutoScalingReplacingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAutoScalingReplacingUpdate> {
        java.lang.Boolean willReplace;

        /**
         * Sets the value of {@link CfnAutoScalingReplacingUpdate#getWillReplace}
         * @param willReplace the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder willReplace(java.lang.Boolean willReplace) {
            this.willReplace = willReplace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutoScalingReplacingUpdate}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAutoScalingReplacingUpdate build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAutoScalingReplacingUpdate}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAutoScalingReplacingUpdate {
        private final java.lang.Boolean willReplace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.willReplace = software.amazon.jsii.Kernel.get(this, "willReplace", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.willReplace = builder.willReplace;
        }

        @Override
        public final java.lang.Boolean getWillReplace() {
            return this.willReplace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getWillReplace() != null) {
                data.set("willReplace", om.valueToTree(this.getWillReplace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnAutoScalingReplacingUpdate"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAutoScalingReplacingUpdate.Jsii$Proxy that = (CfnAutoScalingReplacingUpdate.Jsii$Proxy) o;

            return this.willReplace != null ? this.willReplace.equals(that.willReplace) : that.willReplace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.willReplace != null ? this.willReplace.hashCode() : 0;
            return result;
        }
    }
}
