package software.amazon.awscdk;

/**
 * The application actually being deployed.
 * <p>
 * Type of the {&#64;link CfnCodeDeployBlueGreenHookProps.applications} property.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * CfnCodeDeployBlueGreenApplication cfnCodeDeployBlueGreenApplication = CfnCodeDeployBlueGreenApplication.builder()
 *         .ecsAttributes(CfnCodeDeployBlueGreenEcsAttributes.builder()
 *                 .taskDefinitions(List.of("taskDefinitions"))
 *                 .taskSets(List.of("taskSets"))
 *                 .trafficRouting(CfnTrafficRouting.builder()
 *                         .prodTrafficRoute(CfnTrafficRoute.builder()
 *                                 .logicalId("logicalId")
 *                                 .type("type")
 *                                 .build())
 *                         .targetGroups(List.of("targetGroups"))
 *                         .testTrafficRoute(CfnTrafficRoute.builder()
 *                                 .logicalId("logicalId")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .target(CfnCodeDeployBlueGreenApplicationTarget.builder()
 *                 .logicalId("logicalId")
 *                 .type("type")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:39.977Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.CfnCodeDeployBlueGreenApplication")
@software.amazon.jsii.Jsii.Proxy(CfnCodeDeployBlueGreenApplication.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCodeDeployBlueGreenApplication extends software.amazon.jsii.JsiiSerializable {

    /**
     * The detailed attributes of the deployed target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnCodeDeployBlueGreenEcsAttributes getEcsAttributes();

    /**
     * The target that is being deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnCodeDeployBlueGreenApplicationTarget getTarget();

    /**
     * @return a {@link Builder} of {@link CfnCodeDeployBlueGreenApplication}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCodeDeployBlueGreenApplication}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCodeDeployBlueGreenApplication> {
        software.amazon.awscdk.CfnCodeDeployBlueGreenEcsAttributes ecsAttributes;
        software.amazon.awscdk.CfnCodeDeployBlueGreenApplicationTarget target;

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenApplication#getEcsAttributes}
         * @param ecsAttributes The detailed attributes of the deployed target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ecsAttributes(software.amazon.awscdk.CfnCodeDeployBlueGreenEcsAttributes ecsAttributes) {
            this.ecsAttributes = ecsAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnCodeDeployBlueGreenApplication#getTarget}
         * @param target The target that is being deployed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(software.amazon.awscdk.CfnCodeDeployBlueGreenApplicationTarget target) {
            this.target = target;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCodeDeployBlueGreenApplication}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCodeDeployBlueGreenApplication build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCodeDeployBlueGreenApplication}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCodeDeployBlueGreenApplication {
        private final software.amazon.awscdk.CfnCodeDeployBlueGreenEcsAttributes ecsAttributes;
        private final software.amazon.awscdk.CfnCodeDeployBlueGreenApplicationTarget target;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.ecsAttributes = software.amazon.jsii.Kernel.get(this, "ecsAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnCodeDeployBlueGreenEcsAttributes.class));
            this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnCodeDeployBlueGreenApplicationTarget.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.ecsAttributes = java.util.Objects.requireNonNull(builder.ecsAttributes, "ecsAttributes is required");
            this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
        }

        @Override
        public final software.amazon.awscdk.CfnCodeDeployBlueGreenEcsAttributes getEcsAttributes() {
            return this.ecsAttributes;
        }

        @Override
        public final software.amazon.awscdk.CfnCodeDeployBlueGreenApplicationTarget getTarget() {
            return this.target;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("ecsAttributes", om.valueToTree(this.getEcsAttributes()));
            data.set("target", om.valueToTree(this.getTarget()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.CfnCodeDeployBlueGreenApplication"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCodeDeployBlueGreenApplication.Jsii$Proxy that = (CfnCodeDeployBlueGreenApplication.Jsii$Proxy) o;

            if (!ecsAttributes.equals(that.ecsAttributes)) return false;
            return this.target.equals(that.target);
        }

        @Override
        public final int hashCode() {
            int result = this.ecsAttributes.hashCode();
            result = 31 * result + (this.target.hashCode());
            return result;
        }
    }
}
