package software.amazon.awscdk;

/**
 * Initialization props for a stage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline;
 * public class MyOutputStage extends Stage {
 *     public final CfnOutput loadBalancerAddress;
 *     public MyOutputStage(Construct scope, String id) {
 *         this(scope, id, null);
 *     }
 *     public MyOutputStage(Construct scope, String id, StageProps props) {
 *         super(scope, id, props);
 *         this.loadBalancerAddress = CfnOutput.Builder.create(this, "Output").value("value").build();
 *     }
 * }
 * MyOutputStage lbApp = new MyOutputStage(this, "MyApp");
 * pipeline.addStage(lbApp, AddStageOpts.builder()
 *         .post(List.of(
 *             ShellStep.Builder.create("HitEndpoint")
 *                     .envFromCfnOutputs(Map.of(
 *                             // Make the load balancer address available as $URL inside the commands
 *                             "URL", lbApp.getLoadBalancerAddress()))
 *                     .commands(List.of("curl -Ssf $URL"))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.121Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.StageProps")
@software.amazon.jsii.Jsii.Proxy(StageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Default AWS environment (account/region) for `Stack`s in this `Stage`.
     * <p>
     * Stacks defined inside this <code>Stage</code> with either <code>region</code> or <code>account</code> missing
     * from its env will use the corresponding field given here.
     * <p>
     * If either <code>region</code> or <code>account</code>is is not configured for <code>Stack</code> (either on
     * the <code>Stack</code> itself or on the containing <code>Stage</code>), the Stack will be
     * <em>environment-agnostic</em>.
     * <p>
     * Environment-agnostic stacks can be deployed to any environment, may not be
     * able to take advantage of all features of the CDK. For example, they will
     * not be able to use environmental context lookups, will not automatically
     * translate Service Principals to the right format based on the environment's
     * AWS partition, and other such enhancements.
     * <p>
     * Default: - The environments should be configured on the `Stack`s.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // Example automatically generated from non-compiling source. May contain errors.
     * // Use a concrete account and region to deploy this Stage to
     * // Use a concrete account and region to deploy this Stage to
     * Stage.Builder.create(app, "Stage1")
     *         .env(Environment.builder().account("123456789012").region("us-east-1").build())
     *         .build();
     * // Use the CLI's current credentials to determine the target environment
     * // Use the CLI's current credentials to determine the target environment
     * Stage.Builder.create(app, "Stage2")
     *         .env(Environment.builder().account(process.getEnv().getCDK_DEFAULT_ACCOUNT()).region(process.getEnv().getCDK_DEFAULT_REGION()).build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Environment getEnv() {
        return null;
    }

    /**
     * The output directory into which to emit synthesized artifacts.
     * <p>
     * Can only be specified if this stage is the root stage (the app). If this is
     * specified and this stage is nested within another stage, an error will be
     * thrown.
     * <p>
     * Default: - for nested stages, outdir will be determined as a relative
     * directory to the outdir of the app. For apps, if outdir is not specified, a
     * temporary directory will be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutdir() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StageProps> {
        software.amazon.awscdk.Environment env;
        java.lang.String outdir;

        /**
         * Sets the value of {@link StageProps#getEnv}
         * @param env Default AWS environment (account/region) for `Stack`s in this `Stage`.
         *            Stacks defined inside this <code>Stage</code> with either <code>region</code> or <code>account</code> missing
         *            from its env will use the corresponding field given here.
         *            <p>
         *            If either <code>region</code> or <code>account</code>is is not configured for <code>Stack</code> (either on
         *            the <code>Stack</code> itself or on the containing <code>Stage</code>), the Stack will be
         *            <em>environment-agnostic</em>.
         *            <p>
         *            Environment-agnostic stacks can be deployed to any environment, may not be
         *            able to take advantage of all features of the CDK. For example, they will
         *            not be able to use environmental context lookups, will not automatically
         *            translate Service Principals to the right format based on the environment's
         *            AWS partition, and other such enhancements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(software.amazon.awscdk.Environment env) {
            this.env = env;
            return this;
        }

        /**
         * Sets the value of {@link StageProps#getOutdir}
         * @param outdir The output directory into which to emit synthesized artifacts.
         *               Can only be specified if this stage is the root stage (the app). If this is
         *               specified and this stage is nested within another stage, an error will be
         *               thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outdir(java.lang.String outdir) {
            this.outdir = outdir;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageProps {
        private final software.amazon.awscdk.Environment env;
        private final java.lang.String outdir;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.env = software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Environment.class));
            this.outdir = software.amazon.jsii.Kernel.get(this, "outdir", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.env = builder.env;
            this.outdir = builder.outdir;
        }

        @Override
        public final software.amazon.awscdk.Environment getEnv() {
            return this.env;
        }

        @Override
        public final java.lang.String getOutdir() {
            return this.outdir;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEnv() != null) {
                data.set("env", om.valueToTree(this.getEnv()));
            }
            if (this.getOutdir() != null) {
                data.set("outdir", om.valueToTree(this.getOutdir()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.StageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StageProps.Jsii$Proxy that = (StageProps.Jsii$Proxy) o;

            if (this.env != null ? !this.env.equals(that.env) : that.env != null) return false;
            return this.outdir != null ? this.outdir.equals(that.outdir) : that.outdir == null;
        }

        @Override
        public final int hashCode() {
            int result = this.env != null ? this.env.hashCode() : 0;
            result = 31 * result + (this.outdir != null ? this.outdir.hashCode() : 0);
            return result;
        }
    }
}
