package software.amazon.awscdk.cloudassembly.schema;

/**
 * Represents a cdk destroy command.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloudassembly.schema.*;
 * DestroyCommand destroyCommand = DestroyCommand.builder()
 *         .args(DestroyOptions.builder()
 *                 .all(false)
 *                 .app("app")
 *                 .assetMetadata(false)
 *                 .caBundlePath("caBundlePath")
 *                 .color(false)
 *                 .context(Map.of(
 *                         "contextKey", "context"))
 *                 .debug(false)
 *                 .ec2Creds(false)
 *                 .exclusively(false)
 *                 .force(false)
 *                 .ignoreErrors(false)
 *                 .json(false)
 *                 .lookups(false)
 *                 .notices(false)
 *                 .output("output")
 *                 .pathMetadata(false)
 *                 .profile("profile")
 *                 .proxy("proxy")
 *                 .roleArn("roleArn")
 *                 .stacks(List.of("stacks"))
 *                 .staging(false)
 *                 .strict(false)
 *                 .trace(false)
 *                 .verbose(false)
 *                 .versionReporting(false)
 *                 .build())
 *         .enabled(false)
 *         .expectedMessage("expectedMessage")
 *         .expectError(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:46.644Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.DestroyCommand")
@software.amazon.jsii.Jsii.Proxy(DestroyCommand.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DestroyCommand extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloudassembly.schema.CdkCommand {

    /**
     * Additional arguments to pass to the command This can be used to test specific CLI functionality.
     * <p>
     * Default: - only default args are used
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloudassembly.schema.DestroyOptions getArgs() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DestroyCommand}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DestroyCommand}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DestroyCommand> {
        software.amazon.awscdk.cloudassembly.schema.DestroyOptions args;
        java.lang.Boolean enabled;
        java.lang.String expectedMessage;
        java.lang.Boolean expectError;

        /**
         * Sets the value of {@link DestroyCommand#getArgs}
         * @param args Additional arguments to pass to the command This can be used to test specific CLI functionality.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder args(software.amazon.awscdk.cloudassembly.schema.DestroyOptions args) {
            this.args = args;
            return this;
        }

        /**
         * Sets the value of {@link DestroyCommand#getEnabled}
         * @param enabled Whether or not to run this command as part of the workflow This can be used if you only want to test some of the workflow for example enable `synth` and disable `deploy` & `destroy` in order to limit the test to synthesis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link DestroyCommand#getExpectedMessage}
         * @param expectedMessage This can be used in combination with `expectedError` to validate that a specific message is returned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expectedMessage(java.lang.String expectedMessage) {
            this.expectedMessage = expectedMessage;
            return this;
        }

        /**
         * Sets the value of {@link DestroyCommand#getExpectError}
         * @param expectError If the runner should expect this command to fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expectError(java.lang.Boolean expectError) {
            this.expectError = expectError;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DestroyCommand}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DestroyCommand build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DestroyCommand}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestroyCommand {
        private final software.amazon.awscdk.cloudassembly.schema.DestroyOptions args;
        private final java.lang.Boolean enabled;
        private final java.lang.String expectedMessage;
        private final java.lang.Boolean expectError;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloudassembly.schema.DestroyOptions.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.expectedMessage = software.amazon.jsii.Kernel.get(this, "expectedMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.expectError = software.amazon.jsii.Kernel.get(this, "expectError", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.args = builder.args;
            this.enabled = builder.enabled;
            this.expectedMessage = builder.expectedMessage;
            this.expectError = builder.expectError;
        }

        @Override
        public final software.amazon.awscdk.cloudassembly.schema.DestroyOptions getArgs() {
            return this.args;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getExpectedMessage() {
            return this.expectedMessage;
        }

        @Override
        public final java.lang.Boolean getExpectError() {
            return this.expectError;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getExpectedMessage() != null) {
                data.set("expectedMessage", om.valueToTree(this.getExpectedMessage()));
            }
            if (this.getExpectError() != null) {
                data.set("expectError", om.valueToTree(this.getExpectError()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.DestroyCommand"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DestroyCommand.Jsii$Proxy that = (DestroyCommand.Jsii$Proxy) o;

            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.expectedMessage != null ? !this.expectedMessage.equals(that.expectedMessage) : that.expectedMessage != null) return false;
            return this.expectError != null ? this.expectError.equals(that.expectError) : that.expectError == null;
        }

        @Override
        public final int hashCode() {
            int result = this.args != null ? this.args.hashCode() : 0;
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.expectedMessage != null ? this.expectedMessage.hashCode() : 0);
            result = 31 * result + (this.expectError != null ? this.expectError.hashCode() : 0);
            return result;
        }
    }
}
