/**
 * <h1>Cloud Assembly Schema</h1>
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Cloud Assembly</h2>
 * <p>
 * The <em>Cloud Assembly</em> is the output of the synthesis operation. It is produced as part of the
 * <a href="https://github.com/aws/aws-cdk/tree/master/packages/aws-cdk#cdk-synthesize"><code>cdk synth</code></a>
 * command, or the <a href="https://github.com/aws/aws-cdk/blob/master/packages/&#64;aws-cdk/core/lib/app.ts#L135"><code>app.synth()</code></a> method invocation.
 * <p>
 * Its essentially a set of files and directories, one of which is the <code>manifest.json</code> file. It defines the set of instructions that are
 * needed in order to deploy the assembly directory.
 * <p>
 * <blockquote>
 * <p>
 * For example, when <code>cdk deploy</code> is executed, the CLI reads this file and performs its instructions:
 * <p>
 * <ul>
 * <li>Build container images.</li>
 * <li>Upload assets.</li>
 * <li>Deploy CloudFormation templates.</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Therefore, the assembly is how the CDK class library and CDK CLI (or any other consumer) communicate. To ensure compatibility
 * between the assembly and its consumers, we treat the manifest file as a well defined, versioned schema.
 * <p>
 * <h2>Schema</h2>
 * <p>
 * This module contains the typescript structs that comprise the <code>manifest.json</code> file, as well as the
 * generated <a href="./schema/cloud-assembly.schema.json"><em>json-schema</em></a>.
 * <p>
 * <h2>Versioning</h2>
 * <p>
 * The schema version is specified in the <a href="./schema/cloud-assembly.schema.json"><code>cloud-assembly.version.json</code></a> file, under the <code>version</code> property.
 * It follows semantic versioning, but with a small twist.
 * <p>
 * When we add instructions to the assembly, they are reflected in the manifest file and the <em>json-schema</em> accordingly.
 * Every such instruction, is crucial for ensuring the correct deployment behavior. This means that to properly deploy a cloud assembly,
 * consumers must be aware of every such instruction modification.
 * <p>
 * For this reason, every change to the schema, even though it might not strictly break validation of the <em>json-schema</em> format,
 * is considered <code>major</code> version bump.
 * <p>
 * <h2>How to consume</h2>
 * <p>
 * If you'd like to consume the <a href="./schema/cloud-assembly.schema.json">schema file</a> in order to do validations on <code>manifest.json</code> files,
 * simply download it from this repo and run it against standard <em>json-schema</em> validators, such as <a href="https://www.npmjs.com/package/jsonschema">jsonschema</a>.
 * <p>
 * Consumers must take into account the <code>major</code> version of the schema they are consuming. They should reject cloud assemblies
 * with a <code>major</code> version that is higher than what they expect. While schema validation might pass on such assemblies, the deployment integrity
 * cannot be guaranteed because some instructions will be ignored.
 * <p>
 * <blockquote>
 * <p>
 * For example, if your consumer was built when the schema version was 2.0.0, you should reject deploying cloud assemblies with a
 * manifest version of 3.0.0.
 * <p>
 * </blockquote>
 * <p>
 * <h2>Contributing</h2>
 * <p>
 * See <a href="./CONTRIBUTING.md">Contribution Guide</a>
 */
package software.amazon.awscdk.cloudassembly.schema;
