package software.amazon.awscdk.services.acmpca;

/**
 * Properties for defining a `CfnCertificate`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.acmpca.*;
 * CfnCertificateProps cfnCertificateProps = CfnCertificateProps.builder()
 *         .certificateAuthorityArn("certificateAuthorityArn")
 *         .certificateSigningRequest("certificateSigningRequest")
 *         .signingAlgorithm("signingAlgorithm")
 *         .validity(ValidityProperty.builder()
 *                 .type("type")
 *                 .value(123)
 *                 .build())
 *         // the properties below are optional
 *         .apiPassthrough(ApiPassthroughProperty.builder()
 *                 .extensions(ExtensionsProperty.builder()
 *                         .certificatePolicies(List.of(PolicyInformationProperty.builder()
 *                                 .certPolicyId("certPolicyId")
 *                                 // the properties below are optional
 *                                 .policyQualifiers(List.of(PolicyQualifierInfoProperty.builder()
 *                                         .policyQualifierId("policyQualifierId")
 *                                         .qualifier(QualifierProperty.builder()
 *                                                 .cpsUri("cpsUri")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .customExtensions(List.of(CustomExtensionProperty.builder()
 *                                 .objectIdentifier("objectIdentifier")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .critical(false)
 *                                 .build()))
 *                         .extendedKeyUsage(List.of(ExtendedKeyUsageProperty.builder()
 *                                 .extendedKeyUsageObjectIdentifier("extendedKeyUsageObjectIdentifier")
 *                                 .extendedKeyUsageType("extendedKeyUsageType")
 *                                 .build()))
 *                         .keyUsage(KeyUsageProperty.builder()
 *                                 .crlSign(false)
 *                                 .dataEncipherment(false)
 *                                 .decipherOnly(false)
 *                                 .digitalSignature(false)
 *                                 .encipherOnly(false)
 *                                 .keyAgreement(false)
 *                                 .keyCertSign(false)
 *                                 .keyEncipherment(false)
 *                                 .nonRepudiation(false)
 *                                 .build())
 *                         .subjectAlternativeNames(List.of(GeneralNameProperty.builder()
 *                                 .directoryName(SubjectProperty.builder()
 *                                         .commonName("commonName")
 *                                         .country("country")
 *                                         .customAttributes(List.of(CustomAttributeProperty.builder()
 *                                                 .objectIdentifier("objectIdentifier")
 *                                                 .value("value")
 *                                                 .build()))
 *                                         .distinguishedNameQualifier("distinguishedNameQualifier")
 *                                         .generationQualifier("generationQualifier")
 *                                         .givenName("givenName")
 *                                         .initials("initials")
 *                                         .locality("locality")
 *                                         .organization("organization")
 *                                         .organizationalUnit("organizationalUnit")
 *                                         .pseudonym("pseudonym")
 *                                         .serialNumber("serialNumber")
 *                                         .state("state")
 *                                         .surname("surname")
 *                                         .title("title")
 *                                         .build())
 *                                 .dnsName("dnsName")
 *                                 .ediPartyName(EdiPartyNameProperty.builder()
 *                                         .nameAssigner("nameAssigner")
 *                                         .partyName("partyName")
 *                                         .build())
 *                                 .ipAddress("ipAddress")
 *                                 .otherName(OtherNameProperty.builder()
 *                                         .typeId("typeId")
 *                                         .value("value")
 *                                         .build())
 *                                 .registeredId("registeredId")
 *                                 .rfc822Name("rfc822Name")
 *                                 .uniformResourceIdentifier("uniformResourceIdentifier")
 *                                 .build()))
 *                         .build())
 *                 .subject(SubjectProperty.builder()
 *                         .commonName("commonName")
 *                         .country("country")
 *                         .customAttributes(List.of(CustomAttributeProperty.builder()
 *                                 .objectIdentifier("objectIdentifier")
 *                                 .value("value")
 *                                 .build()))
 *                         .distinguishedNameQualifier("distinguishedNameQualifier")
 *                         .generationQualifier("generationQualifier")
 *                         .givenName("givenName")
 *                         .initials("initials")
 *                         .locality("locality")
 *                         .organization("organization")
 *                         .organizationalUnit("organizationalUnit")
 *                         .pseudonym("pseudonym")
 *                         .serialNumber("serialNumber")
 *                         .state("state")
 *                         .surname("surname")
 *                         .title("title")
 *                         .build())
 *                 .build())
 *         .templateArn("templateArn")
 *         .validityNotBefore(ValidityProperty.builder()
 *                 .type("type")
 *                 .value(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.170Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_acmpca.CfnCertificateProps")
@software.amazon.jsii.Jsii.Proxy(CfnCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCertificateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) for the private CA issues the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCertificateAuthorityArn();

    /**
     * The certificate signing request (CSR) for the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCertificateSigningRequest();

    /**
     * The name of the algorithm that will be used to sign the certificate to be issued.
     * <p>
     * This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.
     * <p>
     * <blockquote>
     * <p>
     * The specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA's secret key.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSigningAlgorithm();

    /**
     * The period of time during which the certificate will be valid.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getValidity();

    /**
     * Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApiPassthrough() {
        return null;
    }

    /**
     * Specifies a custom configuration template to use when issuing a certificate.
     * <p>
     * If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For more information about ACM Private CA templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateArn() {
        return null;
    }

    /**
     * Information describing the start of the validity period of the certificate.
     * <p>
     * This parameter sets the “Not Before" date for the certificate.
     * <p>
     * By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value.
     * <p>
     * Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.
     * <p>
     * The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getValidityNotBefore() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCertificateProps> {
        java.lang.String certificateAuthorityArn;
        java.lang.String certificateSigningRequest;
        java.lang.String signingAlgorithm;
        java.lang.Object validity;
        java.lang.Object apiPassthrough;
        java.lang.String templateArn;
        java.lang.Object validityNotBefore;

        /**
         * Sets the value of {@link CfnCertificateProps#getCertificateAuthorityArn}
         * @param certificateAuthorityArn The Amazon Resource Name (ARN) for the private CA issues the certificate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateAuthorityArn(java.lang.String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getCertificateSigningRequest}
         * @param certificateSigningRequest The certificate signing request (CSR) for the certificate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateSigningRequest(java.lang.String certificateSigningRequest) {
            this.certificateSigningRequest = certificateSigningRequest;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getSigningAlgorithm}
         * @param signingAlgorithm The name of the algorithm that will be used to sign the certificate to be issued. This parameter is required.
         *                         This parameter should not be confused with the <code>SigningAlgorithm</code> parameter used to sign a CSR in the <code>CreateCertificateAuthority</code> action.
         *                         <p>
         *                         <blockquote>
         *                         <p>
         *                         The specified signing algorithm family (RSA or ECDSA) must match the algorithm family of the CA's secret key.
         *                         <p>
         *                         </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signingAlgorithm(java.lang.String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getValidity}
         * @param validity The period of time during which the certificate will be valid. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validity(software.amazon.awscdk.services.acmpca.CfnCertificate.ValidityProperty validity) {
            this.validity = validity;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getValidity}
         * @param validity The period of time during which the certificate will be valid. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validity(software.amazon.awscdk.IResolvable validity) {
            this.validity = validity;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getApiPassthrough}
         * @param apiPassthrough Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiPassthrough(software.amazon.awscdk.services.acmpca.CfnCertificate.ApiPassthroughProperty apiPassthrough) {
            this.apiPassthrough = apiPassthrough;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getApiPassthrough}
         * @param apiPassthrough Specifies X.509 certificate information to be included in the issued certificate. An `APIPassthrough` or `APICSRPassthrough` template variant must be selected, or else this parameter is ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiPassthrough(software.amazon.awscdk.IResolvable apiPassthrough) {
            this.apiPassthrough = apiPassthrough;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getTemplateArn}
         * @param templateArn Specifies a custom configuration template to use when issuing a certificate.
         *                    If this parameter is not provided, ACM Private CA defaults to the <code>EndEntityCertificate/V1</code> template. For more information about ACM Private CA templates, see <a href="https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html">Using Templates</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateArn(java.lang.String templateArn) {
            this.templateArn = templateArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getValidityNotBefore}
         * @param validityNotBefore Information describing the start of the validity period of the certificate.
         *                          This parameter sets the “Not Before" date for the certificate.
         *                          <p>
         *                          By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value.
         *                          <p>
         *                          Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.
         *                          <p>
         *                          The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validityNotBefore(software.amazon.awscdk.services.acmpca.CfnCertificate.ValidityProperty validityNotBefore) {
            this.validityNotBefore = validityNotBefore;
            return this;
        }

        /**
         * Sets the value of {@link CfnCertificateProps#getValidityNotBefore}
         * @param validityNotBefore Information describing the start of the validity period of the certificate.
         *                          This parameter sets the “Not Before" date for the certificate.
         *                          <p>
         *                          By default, when issuing a certificate, ACM Private CA sets the "Not Before" date to the issuance time minus 60 minutes. This compensates for clock inconsistencies across computer systems. The <code>ValidityNotBefore</code> parameter can be used to customize the “Not Before” value.
         *                          <p>
         *                          Unlike the <code>Validity</code> parameter, the <code>ValidityNotBefore</code> parameter is optional.
         *                          <p>
         *                          The <code>ValidityNotBefore</code> value is expressed as an explicit date and time, using the <code>Validity</code> type value <code>ABSOLUTE</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validityNotBefore(software.amazon.awscdk.IResolvable validityNotBefore) {
            this.validityNotBefore = validityNotBefore;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCertificateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCertificateProps {
        private final java.lang.String certificateAuthorityArn;
        private final java.lang.String certificateSigningRequest;
        private final java.lang.String signingAlgorithm;
        private final java.lang.Object validity;
        private final java.lang.Object apiPassthrough;
        private final java.lang.String templateArn;
        private final java.lang.Object validityNotBefore;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.certificateAuthorityArn = software.amazon.jsii.Kernel.get(this, "certificateAuthorityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateSigningRequest = software.amazon.jsii.Kernel.get(this, "certificateSigningRequest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signingAlgorithm = software.amazon.jsii.Kernel.get(this, "signingAlgorithm", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validity = software.amazon.jsii.Kernel.get(this, "validity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.apiPassthrough = software.amazon.jsii.Kernel.get(this, "apiPassthrough", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.templateArn = software.amazon.jsii.Kernel.get(this, "templateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.validityNotBefore = software.amazon.jsii.Kernel.get(this, "validityNotBefore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.certificateAuthorityArn = java.util.Objects.requireNonNull(builder.certificateAuthorityArn, "certificateAuthorityArn is required");
            this.certificateSigningRequest = java.util.Objects.requireNonNull(builder.certificateSigningRequest, "certificateSigningRequest is required");
            this.signingAlgorithm = java.util.Objects.requireNonNull(builder.signingAlgorithm, "signingAlgorithm is required");
            this.validity = java.util.Objects.requireNonNull(builder.validity, "validity is required");
            this.apiPassthrough = builder.apiPassthrough;
            this.templateArn = builder.templateArn;
            this.validityNotBefore = builder.validityNotBefore;
        }

        @Override
        public final java.lang.String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final java.lang.String getCertificateSigningRequest() {
            return this.certificateSigningRequest;
        }

        @Override
        public final java.lang.String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        @Override
        public final java.lang.Object getValidity() {
            return this.validity;
        }

        @Override
        public final java.lang.Object getApiPassthrough() {
            return this.apiPassthrough;
        }

        @Override
        public final java.lang.String getTemplateArn() {
            return this.templateArn;
        }

        @Override
        public final java.lang.Object getValidityNotBefore() {
            return this.validityNotBefore;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("certificateAuthorityArn", om.valueToTree(this.getCertificateAuthorityArn()));
            data.set("certificateSigningRequest", om.valueToTree(this.getCertificateSigningRequest()));
            data.set("signingAlgorithm", om.valueToTree(this.getSigningAlgorithm()));
            data.set("validity", om.valueToTree(this.getValidity()));
            if (this.getApiPassthrough() != null) {
                data.set("apiPassthrough", om.valueToTree(this.getApiPassthrough()));
            }
            if (this.getTemplateArn() != null) {
                data.set("templateArn", om.valueToTree(this.getTemplateArn()));
            }
            if (this.getValidityNotBefore() != null) {
                data.set("validityNotBefore", om.valueToTree(this.getValidityNotBefore()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_acmpca.CfnCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCertificateProps.Jsii$Proxy that = (CfnCertificateProps.Jsii$Proxy) o;

            if (!certificateAuthorityArn.equals(that.certificateAuthorityArn)) return false;
            if (!certificateSigningRequest.equals(that.certificateSigningRequest)) return false;
            if (!signingAlgorithm.equals(that.signingAlgorithm)) return false;
            if (!validity.equals(that.validity)) return false;
            if (this.apiPassthrough != null ? !this.apiPassthrough.equals(that.apiPassthrough) : that.apiPassthrough != null) return false;
            if (this.templateArn != null ? !this.templateArn.equals(that.templateArn) : that.templateArn != null) return false;
            return this.validityNotBefore != null ? this.validityNotBefore.equals(that.validityNotBefore) : that.validityNotBefore == null;
        }

        @Override
        public final int hashCode() {
            int result = this.certificateAuthorityArn.hashCode();
            result = 31 * result + (this.certificateSigningRequest.hashCode());
            result = 31 * result + (this.signingAlgorithm.hashCode());
            result = 31 * result + (this.validity.hashCode());
            result = 31 * result + (this.apiPassthrough != null ? this.apiPassthrough.hashCode() : 0);
            result = 31 * result + (this.templateArn != null ? this.templateArn.hashCode() : 0);
            result = 31 * result + (this.validityNotBefore != null ? this.validityNotBefore.hashCode() : 0);
            return result;
        }
    }
}
