package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `CfnMethod`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnMethodProps cfnMethodProps = CfnMethodProps.builder()
 *         .httpMethod("httpMethod")
 *         .resourceId("resourceId")
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .apiKeyRequired(false)
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizationType("authorizationType")
 *         .authorizerId("authorizerId")
 *         .integration(IntegrationProperty.builder()
 *                 .cacheKeyParameters(List.of("cacheKeyParameters"))
 *                 .cacheNamespace("cacheNamespace")
 *                 .connectionId("connectionId")
 *                 .connectionType("connectionType")
 *                 .contentHandling("contentHandling")
 *                 .credentials("credentials")
 *                 .integrationHttpMethod("integrationHttpMethod")
 *                 .integrationResponses(List.of(IntegrationResponseProperty.builder()
 *                         .statusCode("statusCode")
 *                         // the properties below are optional
 *                         .contentHandling("contentHandling")
 *                         .responseParameters(Map.of(
 *                                 "responseParametersKey", "responseParameters"))
 *                         .responseTemplates(Map.of(
 *                                 "responseTemplatesKey", "responseTemplates"))
 *                         .selectionPattern("selectionPattern")
 *                         .build()))
 *                 .passthroughBehavior("passthroughBehavior")
 *                 .requestParameters(Map.of(
 *                         "requestParametersKey", "requestParameters"))
 *                 .requestTemplates(Map.of(
 *                         "requestTemplatesKey", "requestTemplates"))
 *                 .timeoutInMillis(123)
 *                 .type("type")
 *                 .uri("uri")
 *                 .build())
 *         .methodResponses(List.of(MethodResponseProperty.builder()
 *                 .statusCode("statusCode")
 *                 // the properties below are optional
 *                 .responseModels(Map.of(
 *                         "responseModelsKey", "responseModels"))
 *                 .responseParameters(Map.of(
 *                         "responseParametersKey", false))
 *                 .build()))
 *         .operationName("operationName")
 *         .requestModels(Map.of(
 *                 "requestModelsKey", "requestModels"))
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", false))
 *         .requestValidatorId("requestValidatorId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.299Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnMethodProps")
@software.amazon.jsii.Jsii.Proxy(CfnMethodProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMethodProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The HTTP method that clients use to call this method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpMethod();

    /**
     * The ID of an API Gateway [resource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html) . For root resource methods, specify the `RestApi` root resource ID, such as `{ "Fn::GetAtt": ["MyRestApi", "RootResourceId"] }` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceId();

    /**
     * The ID of the [RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource in which API Gateway creates the method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestApiId();

    /**
     * Indicates whether the method requires clients to submit a valid API key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApiKeyRequired() {
        return null;
    }

    /**
     * A list of authorization scopes configured on the method.
     * <p>
     * The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes match a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return null;
    }

    /**
     * The method's authorization type.
     * <p>
     * This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/method/">Method</a> in the <em>API Gateway API Reference</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationType() {
        return null;
    }

    /**
     * The identifier of the [authorizer](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html) to use on this method. If you specify this property, specify `CUSTOM` or `COGNITO_USER_POOLS` for the `AuthorizationType` property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerId() {
        return null;
    }

    /**
     * The backend system that the method calls when it receives a request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIntegration() {
        return null;
    }

    /**
     * The responses that can be sent to the client who calls the method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMethodResponses() {
        return null;
    }

    /**
     * A friendly operation name for the method.
     * <p>
     * For example, you can assign the <code>OperationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOperationName() {
        return null;
    }

    /**
     * The resources that are used for the request's content type.
     * <p>
     * Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a <code>Model</code> resource name as the value. To use the same model regardless of the content type, specify <code>$default</code> as the key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequestModels() {
        return null;
    }

    /**
     * The request parameters that API Gateway accepts.
     * <p>
     * Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format <code>method.request. *location* . *name*</code> , where the location is querystring, path, or header, and <em>name</em> is a valid, unique parameter name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRequestParameters() {
        return null;
    }

    /**
     * The ID of the associated request validator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRequestValidatorId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMethodProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMethodProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMethodProps> {
        java.lang.String httpMethod;
        java.lang.String resourceId;
        java.lang.String restApiId;
        java.lang.Object apiKeyRequired;
        java.util.List<java.lang.String> authorizationScopes;
        java.lang.String authorizationType;
        java.lang.String authorizerId;
        java.lang.Object integration;
        java.lang.Object methodResponses;
        java.lang.String operationName;
        java.lang.Object requestModels;
        java.lang.Object requestParameters;
        java.lang.String requestValidatorId;

        /**
         * Sets the value of {@link CfnMethodProps#getHttpMethod}
         * @param httpMethod The HTTP method that clients use to call this method. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpMethod(java.lang.String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getResourceId}
         * @param resourceId The ID of an API Gateway [resource](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-resource.html) . For root resource methods, specify the `RestApi` root resource ID, such as `{ "Fn::GetAtt": ["MyRestApi", "RootResourceId"] }` . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceId(java.lang.String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRestApiId}
         * @param restApiId The ID of the [RestApi](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html) resource in which API Gateway creates the method. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getApiKeyRequired}
         * @param apiKeyRequired Indicates whether the method requires clients to submit a valid API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(java.lang.Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getApiKeyRequired}
         * @param apiKeyRequired Indicates whether the method requires clients to submit a valid API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyRequired(software.amazon.awscdk.IResolvable apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getAuthorizationScopes}
         * @param authorizationScopes A list of authorization scopes configured on the method.
         *                            The scopes are used with a <code>COGNITO_USER_POOLS</code> authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes match a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
            this.authorizationScopes = authorizationScopes;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getAuthorizationType}
         * @param authorizationType The method's authorization type.
         *                          This parameter is required. For valid values, see <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/method/">Method</a> in the <em>API Gateway API Reference</em> .
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          If you specify the <code>AuthorizerId</code> property, specify <code>CUSTOM</code> or <code>COGNITO_USER_POOLS</code> for this property.
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(java.lang.String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getAuthorizerId}
         * @param authorizerId The identifier of the [authorizer](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html) to use on this method. If you specify this property, specify `CUSTOM` or `COGNITO_USER_POOLS` for the `AuthorizationType` property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerId(java.lang.String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getIntegration}
         * @param integration The backend system that the method calls when it receives a request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getIntegration}
         * @param integration The backend system that the method calls when it receives a request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.IResolvable integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getMethodResponses}
         * @param methodResponses The responses that can be sent to the client who calls the method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(software.amazon.awscdk.IResolvable methodResponses) {
            this.methodResponses = methodResponses;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getMethodResponses}
         * @param methodResponses The responses that can be sent to the client who calls the method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder methodResponses(java.util.List<? extends java.lang.Object> methodResponses) {
            this.methodResponses = methodResponses;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getOperationName}
         * @param operationName A friendly operation name for the method.
         *                      For example, you can assign the <code>OperationName</code> of <code>ListPets</code> for the <code>GET /pets</code> method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder operationName(java.lang.String operationName) {
            this.operationName = operationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestModels}
         * @param requestModels The resources that are used for the request's content type.
         *                      Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a <code>Model</code> resource name as the value. To use the same model regardless of the content type, specify <code>$default</code> as the key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(software.amazon.awscdk.IResolvable requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestModels}
         * @param requestModels The resources that are used for the request's content type.
         *                      Specify request models as key-value pairs (string-to-string mapping), with a content type as the key and a <code>Model</code> resource name as the value. To use the same model regardless of the content type, specify <code>$default</code> as the key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestModels(java.util.Map<java.lang.String, java.lang.String> requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestParameters}
         * @param requestParameters The request parameters that API Gateway accepts.
         *                          Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format <code>method.request. *location* . *name*</code> , where the location is querystring, path, or header, and <em>name</em> is a valid, unique parameter name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(software.amazon.awscdk.IResolvable requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestParameters}
         * @param requestParameters The request parameters that API Gateway accepts.
         *                          Specify request parameters as key-value pairs (string-to-Boolean mapping), with a source as the key and a Boolean as the value. The Boolean specifies whether a parameter is required. A source must match the format <code>method.request. *location* . *name*</code> , where the location is querystring, path, or header, and <em>name</em> is a valid, unique parameter name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.util.Map<java.lang.String, ? extends java.lang.Object> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnMethodProps#getRequestValidatorId}
         * @param requestValidatorId The ID of the associated request validator.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestValidatorId(java.lang.String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMethodProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMethodProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMethodProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMethodProps {
        private final java.lang.String httpMethod;
        private final java.lang.String resourceId;
        private final java.lang.String restApiId;
        private final java.lang.Object apiKeyRequired;
        private final java.util.List<java.lang.String> authorizationScopes;
        private final java.lang.String authorizationType;
        private final java.lang.String authorizerId;
        private final java.lang.Object integration;
        private final java.lang.Object methodResponses;
        private final java.lang.String operationName;
        private final java.lang.Object requestModels;
        private final java.lang.Object requestParameters;
        private final java.lang.String requestValidatorId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceId = software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restApiId = software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiKeyRequired = software.amazon.jsii.Kernel.get(this, "apiKeyRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authorizationType = software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizerId = software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.methodResponses = software.amazon.jsii.Kernel.get(this, "methodResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.operationName = software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestModels = software.amazon.jsii.Kernel.get(this, "requestModels", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requestValidatorId = software.amazon.jsii.Kernel.get(this, "requestValidatorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.httpMethod = java.util.Objects.requireNonNull(builder.httpMethod, "httpMethod is required");
            this.resourceId = java.util.Objects.requireNonNull(builder.resourceId, "resourceId is required");
            this.restApiId = java.util.Objects.requireNonNull(builder.restApiId, "restApiId is required");
            this.apiKeyRequired = builder.apiKeyRequired;
            this.authorizationScopes = builder.authorizationScopes;
            this.authorizationType = builder.authorizationType;
            this.authorizerId = builder.authorizerId;
            this.integration = builder.integration;
            this.methodResponses = builder.methodResponses;
            this.operationName = builder.operationName;
            this.requestModels = builder.requestModels;
            this.requestParameters = builder.requestParameters;
            this.requestValidatorId = builder.requestValidatorId;
        }

        @Override
        public final java.lang.String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.lang.String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final java.lang.Object getApiKeyRequired() {
            return this.apiKeyRequired;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthorizationScopes() {
            return this.authorizationScopes;
        }

        @Override
        public final java.lang.String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final java.lang.String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        public final java.lang.Object getIntegration() {
            return this.integration;
        }

        @Override
        public final java.lang.Object getMethodResponses() {
            return this.methodResponses;
        }

        @Override
        public final java.lang.String getOperationName() {
            return this.operationName;
        }

        @Override
        public final java.lang.Object getRequestModels() {
            return this.requestModels;
        }

        @Override
        public final java.lang.Object getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final java.lang.String getRequestValidatorId() {
            return this.requestValidatorId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            data.set("resourceId", om.valueToTree(this.getResourceId()));
            data.set("restApiId", om.valueToTree(this.getRestApiId()));
            if (this.getApiKeyRequired() != null) {
                data.set("apiKeyRequired", om.valueToTree(this.getApiKeyRequired()));
            }
            if (this.getAuthorizationScopes() != null) {
                data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
            }
            if (this.getAuthorizationType() != null) {
                data.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
            }
            if (this.getAuthorizerId() != null) {
                data.set("authorizerId", om.valueToTree(this.getAuthorizerId()));
            }
            if (this.getIntegration() != null) {
                data.set("integration", om.valueToTree(this.getIntegration()));
            }
            if (this.getMethodResponses() != null) {
                data.set("methodResponses", om.valueToTree(this.getMethodResponses()));
            }
            if (this.getOperationName() != null) {
                data.set("operationName", om.valueToTree(this.getOperationName()));
            }
            if (this.getRequestModels() != null) {
                data.set("requestModels", om.valueToTree(this.getRequestModels()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestValidatorId() != null) {
                data.set("requestValidatorId", om.valueToTree(this.getRequestValidatorId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnMethodProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMethodProps.Jsii$Proxy that = (CfnMethodProps.Jsii$Proxy) o;

            if (!httpMethod.equals(that.httpMethod)) return false;
            if (!resourceId.equals(that.resourceId)) return false;
            if (!restApiId.equals(that.restApiId)) return false;
            if (this.apiKeyRequired != null ? !this.apiKeyRequired.equals(that.apiKeyRequired) : that.apiKeyRequired != null) return false;
            if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
            if (this.authorizationType != null ? !this.authorizationType.equals(that.authorizationType) : that.authorizationType != null) return false;
            if (this.authorizerId != null ? !this.authorizerId.equals(that.authorizerId) : that.authorizerId != null) return false;
            if (this.integration != null ? !this.integration.equals(that.integration) : that.integration != null) return false;
            if (this.methodResponses != null ? !this.methodResponses.equals(that.methodResponses) : that.methodResponses != null) return false;
            if (this.operationName != null ? !this.operationName.equals(that.operationName) : that.operationName != null) return false;
            if (this.requestModels != null ? !this.requestModels.equals(that.requestModels) : that.requestModels != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            return this.requestValidatorId != null ? this.requestValidatorId.equals(that.requestValidatorId) : that.requestValidatorId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.httpMethod.hashCode();
            result = 31 * result + (this.resourceId.hashCode());
            result = 31 * result + (this.restApiId.hashCode());
            result = 31 * result + (this.apiKeyRequired != null ? this.apiKeyRequired.hashCode() : 0);
            result = 31 * result + (this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0);
            result = 31 * result + (this.authorizationType != null ? this.authorizationType.hashCode() : 0);
            result = 31 * result + (this.authorizerId != null ? this.authorizerId.hashCode() : 0);
            result = 31 * result + (this.integration != null ? this.integration.hashCode() : 0);
            result = 31 * result + (this.methodResponses != null ? this.methodResponses.hashCode() : 0);
            result = 31 * result + (this.operationName != null ? this.operationName.hashCode() : 0);
            result = 31 * result + (this.requestModels != null ? this.requestModels.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestValidatorId != null ? this.requestValidatorId.hashCode() : 0);
            return result;
        }
    }
}
