package software.amazon.awscdk.services.apigatewayv2;

/**
 * A CloudFormation `AWS::ApiGatewayV2::Integration`.
 * <p>
 * The <code>AWS::ApiGatewayV2::Integration</code> resource creates an integration for an API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object requestParameters;
 * Object requestTemplates;
 * Object responseParameters;
 * CfnIntegration cfnIntegration = CfnIntegration.Builder.create(this, "MyCfnIntegration")
 *         .apiId("apiId")
 *         .integrationType("integrationType")
 *         // the properties below are optional
 *         .connectionId("connectionId")
 *         .connectionType("connectionType")
 *         .contentHandlingStrategy("contentHandlingStrategy")
 *         .credentialsArn("credentialsArn")
 *         .description("description")
 *         .integrationMethod("integrationMethod")
 *         .integrationSubtype("integrationSubtype")
 *         .integrationUri("integrationUri")
 *         .passthroughBehavior("passthroughBehavior")
 *         .payloadFormatVersion("payloadFormatVersion")
 *         .requestParameters(requestParameters)
 *         .requestTemplates(requestTemplates)
 *         .responseParameters(responseParameters)
 *         .templateSelectionExpression("templateSelectionExpression")
 *         .timeoutInMillis(123)
 *         .tlsConfig(TlsConfigProperty.builder()
 *                 .serverNameToVerify("serverNameToVerify")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.433Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnIntegration")
public class CfnIntegration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.CfnIntegration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGatewayV2::Integration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIntegration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.CfnIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The API identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiId", java.util.Objects.requireNonNull(value, "apiId is required"));
    }

    /**
     * The integration type of an integration. One of the following:.
     * <p>
     * <code>AWS</code> : for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.
     * <p>
     * <code>AWS_PROXY</code> : for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.
     * <p>
     * <code>HTTP</code> : for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.
     * <p>
     * <code>HTTP_PROXY</code> : for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an <code>HTTP_PROXY</code> integration.
     * <p>
     * <code>MOCK</code> : for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIntegrationType() {
        return software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The integration type of an integration. One of the following:.
     * <p>
     * <code>AWS</code> : for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.
     * <p>
     * <code>AWS_PROXY</code> : for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.
     * <p>
     * <code>HTTP</code> : for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.
     * <p>
     * <code>HTTP_PROXY</code> : for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an <code>HTTP_PROXY</code> integration.
     * <p>
     * <code>MOCK</code> : for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegrationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "integrationType", java.util.Objects.requireNonNull(value, "integrationType is required"));
    }

    /**
     * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * <p>
     * The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of <code>method.request. {location} . {name}</code> , where <code>{location}</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> ; and <code>{name}</code> must be a valid and unique method request parameter name.
     * <p>
     * For HTTP API integrations with a specified <code>integrationSubtype</code> , request parameters are a key-value map specifying parameters that are passed to <code>AWS_PROXY</code> integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a> .
     * <p>
     * For HTTP API integrations without a specified <code>integrationSubtype</code> request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:&lt;header|querystring|path&gt;.<location> where action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRequestParameters() {
        return software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
     * <p>
     * The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of <code>method.request. {location} . {name}</code> , where <code>{location}</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> ; and <code>{name}</code> must be a valid and unique method request parameter name.
     * <p>
     * For HTTP API integrations with a specified <code>integrationSubtype</code> , request parameters are a key-value map specifying parameters that are passed to <code>AWS_PROXY</code> integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a> .
     * <p>
     * For HTTP API integrations without a specified <code>integrationSubtype</code> request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:&lt;header|querystring|path&gt;.<location> where action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestParameters(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "requestParameters", java.util.Objects.requireNonNull(value, "requestParameters is required"));
    }

    /**
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     * <p>
     * The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getRequestTemplates() {
        return software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
     * <p>
     * The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestTemplates(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "requestTemplates", java.util.Objects.requireNonNull(value, "requestTemplates is required"));
    }

    /**
     * Supported only for HTTP APIs.
     * <p>
     * You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. The value is of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-responseparameterlist.html"><code>ResponseParameterList</code></a> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResponseParameters() {
        return software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Supported only for HTTP APIs.
     * <p>
     * You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. The value is of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-responseparameterlist.html"><code>ResponseParameterList</code></a> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseParameters(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "responseParameters", java.util.Objects.requireNonNull(value, "responseParameters is required"));
    }

    /**
     * The ID of the VPC link for a private integration.
     * <p>
     * Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectionId() {
        return software.amazon.jsii.Kernel.get(this, "connectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the VPC link for a private integration.
     * <p>
     * Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectionId", value);
    }

    /**
     * The type of the network connection to the integration endpoint.
     * <p>
     * Specify <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and resources in a VPC. The default value is <code>INTERNET</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConnectionType() {
        return software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the network connection to the integration endpoint.
     * <p>
     * Specify <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and resources in a VPC. The default value is <code>INTERNET</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectionType", value);
    }

    /**
     * Supported only for WebSocket APIs.
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
     * <p>
     * <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * <p>
     * <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContentHandlingStrategy() {
        return software.amazon.jsii.Kernel.get(this, "contentHandlingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Supported only for WebSocket APIs.
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
     * <p>
     * <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * <p>
     * <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentHandlingStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "contentHandlingStrategy", value);
    }

    /**
     * Specifies the credentials required for the integration, if any.
     * <p>
     * For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, don't specify this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCredentialsArn() {
        return software.amazon.jsii.Kernel.get(this, "credentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the credentials required for the integration, if any.
     * <p>
     * For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, don't specify this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCredentialsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "credentialsArn", value);
    }

    /**
     * The description of the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies the integration's HTTP method type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIntegrationMethod() {
        return software.amazon.jsii.Kernel.get(this, "integrationMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the integration's HTTP method type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegrationMethod(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "integrationMethod", value);
    }

    /**
     * Supported only for HTTP API `AWS_PROXY` integrations.
     * <p>
     * Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIntegrationSubtype() {
        return software.amazon.jsii.Kernel.get(this, "integrationSubtype", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Supported only for HTTP API `AWS_PROXY` integrations.
     * <p>
     * Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegrationSubtype(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "integrationSubtype", value);
    }

    /**
     * For a Lambda integration, specify the URI of a Lambda function.
     * <p>
     * For an HTTP integration, specify a fully-qualified URL.
     * <p>
     * For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses <code>DiscoverInstances</code> to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a> . For private integrations, all resources must be owned by the same AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIntegrationUri() {
        return software.amazon.jsii.Kernel.get(this, "integrationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For a Lambda integration, specify the URI of a Lambda function.
     * <p>
     * For an HTTP integration, specify a fully-qualified URL.
     * <p>
     * For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses <code>DiscoverInstances</code> to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a> . For private integrations, all resources must be owned by the same AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegrationUri(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "integrationUri", value);
    }

    /**
     * Specifies the pass-through behavior for incoming requests based on the `Content-Type` header in the request, and the available mapping templates specified as the `requestTemplates` property on the `Integration` resource.
     * <p>
     * There are three valid values: <code>WHEN_NO_MATCH</code> , <code>WHEN_NO_TEMPLATES</code> , and <code>NEVER</code> . Supported only for WebSocket APIs.
     * <p>
     * <code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration backend without transformation.
     * <p>
     * <code>NEVER</code> rejects unmapped content types with an <code>HTTP 415 Unsupported Media Type</code> response.
     * <p>
     * <code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same <code>HTTP 415 Unsupported Media Type</code> response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPassthroughBehavior() {
        return software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the pass-through behavior for incoming requests based on the `Content-Type` header in the request, and the available mapping templates specified as the `requestTemplates` property on the `Integration` resource.
     * <p>
     * There are three valid values: <code>WHEN_NO_MATCH</code> , <code>WHEN_NO_TEMPLATES</code> , and <code>NEVER</code> . Supported only for WebSocket APIs.
     * <p>
     * <code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration backend without transformation.
     * <p>
     * <code>NEVER</code> rejects unmapped content types with an <code>HTTP 415 Unsupported Media Type</code> response.
     * <p>
     * <code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same <code>HTTP 415 Unsupported Media Type</code> response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPassthroughBehavior(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "passthroughBehavior", value);
    }

    /**
     * Specifies the format of the payload sent to an integration.
     * <p>
     * Required for HTTP APIs. For HTTP APIs, supported values for Lambda proxy integrations are <code>1.0</code> and <code>2.0</code> . For all other integrations, <code>1.0</code> is the only supported value. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">Working with AWS Lambda proxy integrations for HTTP APIs</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPayloadFormatVersion() {
        return software.amazon.jsii.Kernel.get(this, "payloadFormatVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the format of the payload sent to an integration.
     * <p>
     * Required for HTTP APIs. For HTTP APIs, supported values for Lambda proxy integrations are <code>1.0</code> and <code>2.0</code> . For all other integrations, <code>1.0</code> is the only supported value. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">Working with AWS Lambda proxy integrations for HTTP APIs</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPayloadFormatVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "payloadFormatVersion", value);
    }

    /**
     * The template selection expression for the integration.
     * <p>
     * Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateSelectionExpression() {
        return software.amazon.jsii.Kernel.get(this, "templateSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The template selection expression for the integration.
     * <p>
     * Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateSelectionExpression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateSelectionExpression", value);
    }

    /**
     * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
     * <p>
     * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMillis() {
        return software.amazon.jsii.Kernel.get(this, "timeoutInMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
     * <p>
     * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeoutInMillis(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "timeoutInMillis", value);
    }

    /**
     * The TLS configuration for a private integration.
     * <p>
     * If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTlsConfig() {
        return software.amazon.jsii.Kernel.get(this, "tlsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The TLS configuration for a private integration.
     * <p>
     * If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTlsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.CfnIntegration.TlsConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "tlsConfig", value);
    }

    /**
     * The TLS configuration for a private integration.
     * <p>
     * If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTlsConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tlsConfig", value);
    }
    /**
     * Specifies a list of response parameters for an HTTP API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * ResponseParameterListProperty responseParameterListProperty = ResponseParameterListProperty.builder()
     *         .responseParameters(List.of(ResponseParameterProperty.builder()
     *                 .destination("destination")
     *                 .source("source")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnIntegration.ResponseParameterListProperty")
    @software.amazon.jsii.Jsii.Proxy(ResponseParameterListProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResponseParameterListProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Supported only for HTTP APIs.
         * <p>
         * You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match the pattern <code>&lt;action&gt;:&lt;header&gt;.&lt;location&gt;</code> or <code>overwrite.statuscode</code> . The action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResponseParameterListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResponseParameterListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResponseParameterListProperty> {
            java.lang.Object responseParameters;

            /**
             * Sets the value of {@link ResponseParameterListProperty#getResponseParameters}
             * @param responseParameters Supported only for HTTP APIs.
             *                           You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match the pattern <code>&lt;action&gt;:&lt;header&gt;.&lt;location&gt;</code> or <code>overwrite.statuscode</code> . The action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(software.amazon.awscdk.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of {@link ResponseParameterListProperty#getResponseParameters}
             * @param responseParameters Supported only for HTTP APIs.
             *                           You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match the pattern <code>&lt;action&gt;:&lt;header&gt;.&lt;location&gt;</code> or <code>overwrite.statuscode</code> . The action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseParameters(java.util.List<? extends java.lang.Object> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResponseParameterListProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResponseParameterListProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResponseParameterListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseParameterListProperty {
            private final java.lang.Object responseParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.responseParameters = builder.responseParameters;
            }

            @Override
            public final java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResponseParameters() != null) {
                    data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnIntegration.ResponseParameterListProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResponseParameterListProperty.Jsii$Proxy that = (ResponseParameterListProperty.Jsii$Proxy) o;

                return this.responseParameters != null ? this.responseParameters.equals(that.responseParameters) : that.responseParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.responseParameters != null ? this.responseParameters.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Supported only for HTTP APIs.
     * <p>
     * You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match the pattern <code>&lt;action&gt;:&lt;header&gt;.&lt;location&gt;</code> or <code>overwrite.statuscode</code> . The action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * ResponseParameterProperty responseParameterProperty = ResponseParameterProperty.builder()
     *         .destination("destination")
     *         .source("source")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnIntegration.ResponseParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ResponseParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResponseParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the location of the response to modify, and how to modify it.
         * <p>
         * To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestination();

        /**
         * Specifies the data to update the parameter with.
         * <p>
         * To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * @return a {@link Builder} of {@link ResponseParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResponseParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResponseParameterProperty> {
            java.lang.String destination;
            java.lang.String source;

            /**
             * Sets the value of {@link ResponseParameterProperty#getDestination}
             * @param destination Specifies the location of the response to modify, and how to modify it. This parameter is required.
             *                    To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destination(java.lang.String destination) {
                this.destination = destination;
                return this;
            }

            /**
             * Sets the value of {@link ResponseParameterProperty#getSource}
             * @param source Specifies the data to update the parameter with. This parameter is required.
             *               To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResponseParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResponseParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResponseParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseParameterProperty {
            private final java.lang.String destination;
            private final java.lang.String source;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destination = software.amazon.jsii.Kernel.get(this, "destination", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destination = java.util.Objects.requireNonNull(builder.destination, "destination is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            }

            @Override
            public final java.lang.String getDestination() {
                return this.destination;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destination", om.valueToTree(this.getDestination()));
                data.set("source", om.valueToTree(this.getSource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnIntegration.ResponseParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResponseParameterProperty.Jsii$Proxy that = (ResponseParameterProperty.Jsii$Proxy) o;

                if (!destination.equals(that.destination)) return false;
                return this.source.equals(that.source);
            }

            @Override
            public final int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + (this.source.hashCode());
                return result;
            }
        }
    }
    /**
     * The `TlsConfig` property specifies the TLS configuration for a private integration.
     * <p>
     * If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apigatewayv2.*;
     * TlsConfigProperty tlsConfigProperty = TlsConfigProperty.builder()
     *         .serverNameToVerify("serverNameToVerify")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnIntegration.TlsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TlsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TlsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate.
         * <p>
         * The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServerNameToVerify() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TlsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TlsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TlsConfigProperty> {
            java.lang.String serverNameToVerify;

            /**
             * Sets the value of {@link TlsConfigProperty#getServerNameToVerify}
             * @param serverNameToVerify If you specify a server name, API Gateway uses it to verify the hostname on the integration's certificate.
             *                           The server name is also included in the TLS handshake to support Server Name Indication (SNI) or virtual hosting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serverNameToVerify(java.lang.String serverNameToVerify) {
                this.serverNameToVerify = serverNameToVerify;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TlsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TlsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TlsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsConfigProperty {
            private final java.lang.String serverNameToVerify;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serverNameToVerify = software.amazon.jsii.Kernel.get(this, "serverNameToVerify", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serverNameToVerify = builder.serverNameToVerify;
            }

            @Override
            public final java.lang.String getServerNameToVerify() {
                return this.serverNameToVerify;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getServerNameToVerify() != null) {
                    data.set("serverNameToVerify", om.valueToTree(this.getServerNameToVerify()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.CfnIntegration.TlsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TlsConfigProperty.Jsii$Proxy that = (TlsConfigProperty.Jsii$Proxy) o;

                return this.serverNameToVerify != null ? this.serverNameToVerify.equals(that.serverNameToVerify) : that.serverNameToVerify == null;
            }

            @Override
            public final int hashCode() {
                int result = this.serverNameToVerify != null ? this.serverNameToVerify.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.CfnIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.CfnIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.CfnIntegrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.CfnIntegrationProps.Builder();
        }

        /**
         * The API identifier.
         * <p>
         * @return {@code this}
         * @param apiId The API identifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * The integration type of an integration. One of the following:.
         * <p>
         * <code>AWS</code> : for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs.
         * <p>
         * <code>AWS_PROXY</code> : for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration.
         * <p>
         * <code>HTTP</code> : for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs.
         * <p>
         * <code>HTTP_PROXY</code> : for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an <code>HTTP_PROXY</code> integration.
         * <p>
         * <code>MOCK</code> : for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.
         * <p>
         * @return {@code this}
         * @param integrationType The integration type of an integration. One of the following:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationType(final java.lang.String integrationType) {
            this.props.integrationType(integrationType);
            return this;
        }

        /**
         * The ID of the VPC link for a private integration.
         * <p>
         * Supported only for HTTP APIs.
         * <p>
         * @return {@code this}
         * @param connectionId The ID of the VPC link for a private integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionId(final java.lang.String connectionId) {
            this.props.connectionId(connectionId);
            return this;
        }

        /**
         * The type of the network connection to the integration endpoint.
         * <p>
         * Specify <code>INTERNET</code> for connections through the public routable internet or <code>VPC_LINK</code> for private connections between API Gateway and resources in a VPC. The default value is <code>INTERNET</code> .
         * <p>
         * @return {@code this}
         * @param connectionType The type of the network connection to the integration endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(final java.lang.String connectionType) {
            this.props.connectionType(connectionType);
            return this;
        }

        /**
         * Supported only for WebSocket APIs.
         * <p>
         * Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
         * <p>
         * <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * <p>
         * <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
         * <p>
         * @return {@code this}
         * @param contentHandlingStrategy Supported only for WebSocket APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandlingStrategy(final java.lang.String contentHandlingStrategy) {
            this.props.contentHandlingStrategy(contentHandlingStrategy);
            return this;
        }

        /**
         * Specifies the credentials required for the integration, if any.
         * <p>
         * For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string <code>arn:aws:iam::*:user/*</code> . To use resource-based permissions on supported AWS services, don't specify this parameter.
         * <p>
         * @return {@code this}
         * @param credentialsArn Specifies the credentials required for the integration, if any. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsArn(final java.lang.String credentialsArn) {
            this.props.credentialsArn(credentialsArn);
            return this;
        }

        /**
         * The description of the integration.
         * <p>
         * @return {@code this}
         * @param description The description of the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies the integration's HTTP method type.
         * <p>
         * @return {@code this}
         * @param integrationMethod Specifies the integration's HTTP method type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationMethod(final java.lang.String integrationMethod) {
            this.props.integrationMethod(integrationMethod);
            return this;
        }

        /**
         * Supported only for HTTP API `AWS_PROXY` integrations.
         * <p>
         * Specifies the AWS service action to invoke. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">Integration subtype reference</a> .
         * <p>
         * @return {@code this}
         * @param integrationSubtype Supported only for HTTP API `AWS_PROXY` integrations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationSubtype(final java.lang.String integrationSubtype) {
            this.props.integrationSubtype(integrationSubtype);
            return this;
        }

        /**
         * For a Lambda integration, specify the URI of a Lambda function.
         * <p>
         * For an HTTP integration, specify a fully-qualified URL.
         * <p>
         * For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses <code>DiscoverInstances</code> to identify resources. You can use query parameters to target specific resources. To learn more, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html">DiscoverInstances</a> . For private integrations, all resources must be owned by the same AWS account .
         * <p>
         * @return {@code this}
         * @param integrationUri For a Lambda integration, specify the URI of a Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationUri(final java.lang.String integrationUri) {
            this.props.integrationUri(integrationUri);
            return this;
        }

        /**
         * Specifies the pass-through behavior for incoming requests based on the `Content-Type` header in the request, and the available mapping templates specified as the `requestTemplates` property on the `Integration` resource.
         * <p>
         * There are three valid values: <code>WHEN_NO_MATCH</code> , <code>WHEN_NO_TEMPLATES</code> , and <code>NEVER</code> . Supported only for WebSocket APIs.
         * <p>
         * <code>WHEN_NO_MATCH</code> passes the request body for unmapped content types through to the integration backend without transformation.
         * <p>
         * <code>NEVER</code> rejects unmapped content types with an <code>HTTP 415 Unsupported Media Type</code> response.
         * <p>
         * <code>WHEN_NO_TEMPLATES</code> allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same <code>HTTP 415 Unsupported Media Type</code> response.
         * <p>
         * @return {@code this}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the `Content-Type` header in the request, and the available mapping templates specified as the `requestTemplates` property on the `Integration` resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(final java.lang.String passthroughBehavior) {
            this.props.passthroughBehavior(passthroughBehavior);
            return this;
        }

        /**
         * Specifies the format of the payload sent to an integration.
         * <p>
         * Required for HTTP APIs. For HTTP APIs, supported values for Lambda proxy integrations are <code>1.0</code> and <code>2.0</code> . For all other integrations, <code>1.0</code> is the only supported value. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html">Working with AWS Lambda proxy integrations for HTTP APIs</a> .
         * <p>
         * @return {@code this}
         * @param payloadFormatVersion Specifies the format of the payload sent to an integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder payloadFormatVersion(final java.lang.String payloadFormatVersion) {
            this.props.payloadFormatVersion(payloadFormatVersion);
            return this;
        }

        /**
         * For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend.
         * <p>
         * The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of <code>method.request. {location} . {name}</code> , where <code>{location}</code> is <code>querystring</code> , <code>path</code> , or <code>header</code> ; and <code>{name}</code> must be a valid and unique method request parameter name.
         * <p>
         * For HTTP API integrations with a specified <code>integrationSubtype</code> , request parameters are a key-value map specifying parameters that are passed to <code>AWS_PROXY</code> integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services.html">Working with AWS service integrations for HTTP APIs</a> .
         * <p>
         * For HTTP API integrations without a specified <code>integrationSubtype</code> request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:&lt;header|querystring|path&gt;.<location> where action can be <code>append</code> , <code>overwrite</code> or <code>remove</code> . For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
         * <p>
         * @return {@code this}
         * @param requestParameters For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.lang.Object requestParameters) {
            this.props.requestParameters(requestParameters);
            return this;
        }

        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client.
         * <p>
         * The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs.
         * <p>
         * @return {@code this}
         * @param requestTemplates Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(final java.lang.Object requestTemplates) {
            this.props.requestTemplates(requestTemplates);
            return this;
        }

        /**
         * Supported only for HTTP APIs.
         * <p>
         * You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. The value is of type <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-integration-responseparameterlist.html"><code>ResponseParameterList</code></a> . To learn more, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-parameter-mapping.html">Transforming API requests and responses</a> .
         * <p>
         * @return {@code this}
         * @param responseParameters Supported only for HTTP APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseParameters(final java.lang.Object responseParameters) {
            this.props.responseParameters(responseParameters);
            return this;
        }

        /**
         * The template selection expression for the integration.
         * <p>
         * Supported only for WebSocket APIs.
         * <p>
         * @return {@code this}
         * @param templateSelectionExpression The template selection expression for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSelectionExpression(final java.lang.String templateSelectionExpression) {
            this.props.templateSelectionExpression(templateSelectionExpression);
            return this;
        }

        /**
         * Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs.
         * <p>
         * The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs.
         * <p>
         * @return {@code this}
         * @param timeoutInMillis Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutInMillis(final java.lang.Number timeoutInMillis) {
            this.props.timeoutInMillis(timeoutInMillis);
            return this;
        }

        /**
         * The TLS configuration for a private integration.
         * <p>
         * If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
         * <p>
         * @return {@code this}
         * @param tlsConfig The TLS configuration for a private integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsConfig(final software.amazon.awscdk.services.apigatewayv2.CfnIntegration.TlsConfigProperty tlsConfig) {
            this.props.tlsConfig(tlsConfig);
            return this;
        }
        /**
         * The TLS configuration for a private integration.
         * <p>
         * If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs.
         * <p>
         * @return {@code this}
         * @param tlsConfig The TLS configuration for a private integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tlsConfig(final software.amazon.awscdk.IResolvable tlsConfig) {
            this.props.tlsConfig(tlsConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.CfnIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.CfnIntegration build() {
            return new software.amazon.awscdk.services.apigatewayv2.CfnIntegration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
