package software.amazon.awscdk.services.apigatewayv2;

/**
 * A CloudFormation `AWS::ApiGatewayV2::IntegrationResponse`.
 * <p>
 * The <code>AWS::ApiGatewayV2::IntegrationResponse</code> resource updates an integration response for an WebSocket API. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-integration-responses.html">Set up WebSocket API Integration Responses in API Gateway</a> in the <em>API Gateway Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * Object responseParameters;
 * Object responseTemplates;
 * CfnIntegrationResponse cfnIntegrationResponse = CfnIntegrationResponse.Builder.create(this, "MyCfnIntegrationResponse")
 *         .apiId("apiId")
 *         .integrationId("integrationId")
 *         .integrationResponseKey("integrationResponseKey")
 *         // the properties below are optional
 *         .contentHandlingStrategy("contentHandlingStrategy")
 *         .responseParameters(responseParameters)
 *         .responseTemplates(responseTemplates)
 *         .templateSelectionExpression("templateSelectionExpression")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.452Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.CfnIntegrationResponse")
public class CfnIntegrationResponse extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnIntegrationResponse(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIntegrationResponse(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponse.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGatewayV2::IntegrationResponse`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIntegrationResponse(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The API identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The API identifier.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiId", java.util.Objects.requireNonNull(value, "apiId is required"));
    }

    /**
     * The integration ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIntegrationId() {
        return software.amazon.jsii.Kernel.get(this, "integrationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The integration ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegrationId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "integrationId", java.util.Objects.requireNonNull(value, "integrationId is required"));
    }

    /**
     * The integration response key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIntegrationResponseKey() {
        return software.amazon.jsii.Kernel.get(this, "integrationResponseKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The integration response key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegrationResponseKey(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "integrationResponseKey", java.util.Objects.requireNonNull(value, "integrationResponseKey is required"));
    }

    /**
     * A key-value map specifying response parameters that are passed to the method response from the backend.
     * <p>
     * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header. *{name}*</code> , where name is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header. *{name}*</code> or <code>integration.response.body. *{JSON-expression}*</code> , where <code>*{name}*</code> is a valid and unique response header name and <code>*{JSON-expression}*</code> is a valid JSON expression without the <code>$</code> prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResponseParameters() {
        return software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A key-value map specifying response parameters that are passed to the method response from the backend.
     * <p>
     * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header. *{name}*</code> , where name is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header. *{name}*</code> or <code>integration.response.body. *{JSON-expression}*</code> , where <code>*{name}*</code> is a valid and unique response header name and <code>*{JSON-expression}*</code> is a valid JSON expression without the <code>$</code> prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseParameters(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "responseParameters", java.util.Objects.requireNonNull(value, "responseParameters is required"));
    }

    /**
     * The collection of response templates for the integration response as a string-to-string map of key-value pairs.
     * <p>
     * Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResponseTemplates() {
        return software.amazon.jsii.Kernel.get(this, "responseTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The collection of response templates for the integration response as a string-to-string map of key-value pairs.
     * <p>
     * Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseTemplates(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "responseTemplates", java.util.Objects.requireNonNull(value, "responseTemplates is required"));
    }

    /**
     * Supported only for WebSocket APIs.
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
     * <p>
     * <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * <p>
     * <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContentHandlingStrategy() {
        return software.amazon.jsii.Kernel.get(this, "contentHandlingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Supported only for WebSocket APIs.
     * <p>
     * Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
     * <p>
     * <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
     * <p>
     * <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
     * <p>
     * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentHandlingStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "contentHandlingStrategy", value);
    }

    /**
     * The template selection expression for the integration response.
     * <p>
     * Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateSelectionExpression() {
        return software.amazon.jsii.Kernel.get(this, "templateSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The template selection expression for the integration response.
     * <p>
     * Supported only for WebSocket APIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateSelectionExpression(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateSelectionExpression", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponse}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponse> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponseProps.Builder();
        }

        /**
         * The API identifier.
         * <p>
         * @return {@code this}
         * @param apiId The API identifier. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * The integration ID.
         * <p>
         * @return {@code this}
         * @param integrationId The integration ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationId(final java.lang.String integrationId) {
            this.props.integrationId(integrationId);
            return this;
        }

        /**
         * The integration response key.
         * <p>
         * @return {@code this}
         * @param integrationResponseKey The integration response key. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponseKey(final java.lang.String integrationResponseKey) {
            this.props.integrationResponseKey(integrationResponseKey);
            return this;
        }

        /**
         * Supported only for WebSocket APIs.
         * <p>
         * Specifies how to handle response payload content type conversions. Supported values are <code>CONVERT_TO_BINARY</code> and <code>CONVERT_TO_TEXT</code> , with the following behaviors:
         * <p>
         * <code>CONVERT_TO_BINARY</code> : Converts a response payload from a Base64-encoded string to the corresponding binary blob.
         * <p>
         * <code>CONVERT_TO_TEXT</code> : Converts a response payload from a binary blob to a Base64-encoded string.
         * <p>
         * If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification.
         * <p>
         * @return {@code this}
         * @param contentHandlingStrategy Supported only for WebSocket APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandlingStrategy(final java.lang.String contentHandlingStrategy) {
            this.props.contentHandlingStrategy(contentHandlingStrategy);
            return this;
        }

        /**
         * A key-value map specifying response parameters that are passed to the method response from the backend.
         * <p>
         * The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of <code>method.response.header. *{name}*</code> , where name is a valid and unique header name. The mapped non-static value must match the pattern of <code>integration.response.header. *{name}*</code> or <code>integration.response.body. *{JSON-expression}*</code> , where <code>*{name}*</code> is a valid and unique response header name and <code>*{JSON-expression}*</code> is a valid JSON expression without the <code>$</code> prefix.
         * <p>
         * @return {@code this}
         * @param responseParameters A key-value map specifying response parameters that are passed to the method response from the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseParameters(final java.lang.Object responseParameters) {
            this.props.responseParameters(responseParameters);
            return this;
        }

        /**
         * The collection of response templates for the integration response as a string-to-string map of key-value pairs.
         * <p>
         * Response templates are represented as a key/value map, with a content-type as the key and a template as the value.
         * <p>
         * @return {@code this}
         * @param responseTemplates The collection of response templates for the integration response as a string-to-string map of key-value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseTemplates(final java.lang.Object responseTemplates) {
            this.props.responseTemplates(responseTemplates);
            return this;
        }

        /**
         * The template selection expression for the integration response.
         * <p>
         * Supported only for WebSocket APIs.
         * <p>
         * @return {@code this}
         * @param templateSelectionExpression The template selection expression for the integration response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSelectionExpression(final java.lang.String templateSelectionExpression) {
            this.props.templateSelectionExpression(templateSelectionExpression);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponse}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponse build() {
            return new software.amazon.awscdk.services.apigatewayv2.CfnIntegrationResponse(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
