package software.amazon.awscdk.services.appflow;

/**
 * A CloudFormation `AWS::AppFlow::ConnectorProfile`.
 * <p>
 * The <code>AWS::AppFlow::ConnectorProfile</code> resource is an Amazon AppFlow resource type that specifies the configuration profile for an instance of a connector. This includes the provided name, credentials ARN, connection-mode, and so on. The fields that are common to all types of connector profiles are explicitly specified under the <code>Properties</code> field. The rest of the connector-specific properties are specified under <code>Properties/ConnectorProfileConfig</code> .
 * <p>
 * <blockquote>
 * <p>
 * If you want to use AWS CloudFormation to create a connector profile for connectors that implement OAuth (such as Salesforce, Slack, Zendesk, and Google Analytics), you must fetch the access and refresh tokens. You can do this by implementing your own UI for OAuth, or by retrieving the tokens from elsewhere. Alternatively, you can use the Amazon AppFlow console to create the connector profile, and then use that connector profile in the flow creation CloudFormation template.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appflow.*;
 * Object basicAuthCredentials;
 * Object oAuthCredentials;
 * CfnConnectorProfile cfnConnectorProfile = CfnConnectorProfile.Builder.create(this, "MyCfnConnectorProfile")
 *         .connectionMode("connectionMode")
 *         .connectorProfileName("connectorProfileName")
 *         .connectorType("connectorType")
 *         // the properties below are optional
 *         .connectorProfileConfig(ConnectorProfileConfigProperty.builder()
 *                 .connectorProfileCredentials(ConnectorProfileCredentialsProperty.builder()
 *                         .amplitude(AmplitudeConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .secretKey("secretKey")
 *                                 .build())
 *                         .datadog(DatadogConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .applicationKey("applicationKey")
 *                                 .build())
 *                         .dynatrace(DynatraceConnectorProfileCredentialsProperty.builder()
 *                                 .apiToken("apiToken")
 *                                 .build())
 *                         .googleAnalytics(GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .refreshToken("refreshToken")
 *                                 .build())
 *                         .inforNexus(InforNexusConnectorProfileCredentialsProperty.builder()
 *                                 .accessKeyId("accessKeyId")
 *                                 .datakey("datakey")
 *                                 .secretAccessKey("secretAccessKey")
 *                                 .userId("userId")
 *                                 .build())
 *                         .marketo(MarketoConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .redshift(RedshiftConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .salesforce(SalesforceConnectorProfileCredentialsProperty.builder()
 *                                 .accessToken("accessToken")
 *                                 .clientCredentialsArn("clientCredentialsArn")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .refreshToken("refreshToken")
 *                                 .build())
 *                         .sapoData(SAPODataConnectorProfileCredentialsProperty.builder()
 *                                 .basicAuthCredentials(basicAuthCredentials)
 *                                 .oAuthCredentials(oAuthCredentials)
 *                                 .build())
 *                         .serviceNow(ServiceNowConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .singular(SingularConnectorProfileCredentialsProperty.builder()
 *                                 .apiKey("apiKey")
 *                                 .build())
 *                         .slack(SlackConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .snowflake(SnowflakeConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .trendmicro(TrendmicroConnectorProfileCredentialsProperty.builder()
 *                                 .apiSecretKey("apiSecretKey")
 *                                 .build())
 *                         .veeva(VeevaConnectorProfileCredentialsProperty.builder()
 *                                 .password("password")
 *                                 .username("username")
 *                                 .build())
 *                         .zendesk(ZendeskConnectorProfileCredentialsProperty.builder()
 *                                 .clientId("clientId")
 *                                 .clientSecret("clientSecret")
 *                                 // the properties below are optional
 *                                 .accessToken("accessToken")
 *                                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
 *                                         .authCode("authCode")
 *                                         .redirectUri("redirectUri")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .connectorProfileProperties(ConnectorProfilePropertiesProperty.builder()
 *                         .datadog(DatadogConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .dynatrace(DynatraceConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .inforNexus(InforNexusConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .marketo(MarketoConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .redshift(RedshiftConnectorProfilePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .databaseUrl("databaseUrl")
 *                                 .roleArn("roleArn")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .build())
 *                         .salesforce(SalesforceConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .isSandboxEnvironment(false)
 *                                 .build())
 *                         .sapoData(SAPODataConnectorProfilePropertiesProperty.builder()
 *                                 .applicationHostUrl("applicationHostUrl")
 *                                 .applicationServicePath("applicationServicePath")
 *                                 .clientNumber("clientNumber")
 *                                 .logonLanguage("logonLanguage")
 *                                 .oAuthProperties(OAuthPropertiesProperty.builder()
 *                                         .authCodeUrl("authCodeUrl")
 *                                         .oAuthScopes(List.of("oAuthScopes"))
 *                                         .tokenUrl("tokenUrl")
 *                                         .build())
 *                                 .portNumber(123)
 *                                 .privateLinkServiceName("privateLinkServiceName")
 *                                 .build())
 *                         .serviceNow(ServiceNowConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .slack(SlackConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .snowflake(SnowflakeConnectorProfilePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .stage("stage")
 *                                 .warehouse("warehouse")
 *                                 // the properties below are optional
 *                                 .accountName("accountName")
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .privateLinkServiceName("privateLinkServiceName")
 *                                 .region("region")
 *                                 .build())
 *                         .veeva(VeevaConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .zendesk(ZendeskConnectorProfilePropertiesProperty.builder()
 *                                 .instanceUrl("instanceUrl")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .kmsArn("kmsArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.496Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile")
public class CfnConnectorProfile extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConnectorProfile(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnectorProfile(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appflow.CfnConnectorProfile.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppFlow::ConnectorProfile`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnectorProfile(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appflow.CfnConnectorProfileProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the connector profile.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConnectorProfileArn() {
        return software.amazon.jsii.Kernel.get(this, "attrConnectorProfileArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the connector profile credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCredentialsArn() {
        return software.amazon.jsii.Kernel.get(this, "attrCredentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Indicates the connection mode and if it is public or private.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectionMode() {
        return software.amazon.jsii.Kernel.get(this, "connectionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates the connection mode and if it is public or private.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionMode(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectionMode", java.util.Objects.requireNonNull(value, "connectionMode is required"));
    }

    /**
     * The name of the connector profile.
     * <p>
     * The name is unique for each <code>ConnectorProfile</code> in the AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectorProfileName() {
        return software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the connector profile.
     * <p>
     * The name is unique for each <code>ConnectorProfile</code> in the AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorProfileName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorProfileName", java.util.Objects.requireNonNull(value, "connectorProfileName is required"));
    }

    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConnectorType() {
        return software.amazon.jsii.Kernel.get(this, "connectorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "connectorType", java.util.Objects.requireNonNull(value, "connectorType is required"));
    }

    /**
     * Defines the connector-specific configuration and credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConnectorProfileConfig() {
        return software.amazon.jsii.Kernel.get(this, "connectorProfileConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines the connector-specific configuration and credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorProfileConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectorProfileConfig", value);
    }

    /**
     * Defines the connector-specific configuration and credentials.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectorProfileConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectorProfileConfig", value);
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     * <p>
     * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     * <p>
     * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsArn", value);
    }
    /**
     * The `AmplitudeConnectorProfileCredentials` property type specifies the connector-specific credentials required when using Amplitude.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * AmplitudeConnectorProfileCredentialsProperty amplitudeConnectorProfileCredentialsProperty = AmplitudeConnectorProfileCredentialsProperty.builder()
     *         .apiKey("apiKey")
     *         .secretKey("secretKey")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(AmplitudeConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmplitudeConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKey();

        /**
         * The Secret Access Key portion of the credentials.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretKey();

        /**
         * @return a {@link Builder} of {@link AmplitudeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmplitudeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmplitudeConnectorProfileCredentialsProperty> {
            java.lang.String apiKey;
            java.lang.String secretKey;

            /**
             * Sets the value of {@link AmplitudeConnectorProfileCredentialsProperty#getApiKey}
             * @param apiKey A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(java.lang.String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Sets the value of {@link AmplitudeConnectorProfileCredentialsProperty#getSecretKey}
             * @param secretKey The Secret Access Key portion of the credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretKey(java.lang.String secretKey) {
                this.secretKey = secretKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmplitudeConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmplitudeConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmplitudeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmplitudeConnectorProfileCredentialsProperty {
            private final java.lang.String apiKey;
            private final java.lang.String secretKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretKey = software.amazon.jsii.Kernel.get(this, "secretKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKey = java.util.Objects.requireNonNull(builder.apiKey, "apiKey is required");
                this.secretKey = java.util.Objects.requireNonNull(builder.secretKey, "secretKey is required");
            }

            @Override
            public final java.lang.String getApiKey() {
                return this.apiKey;
            }

            @Override
            public final java.lang.String getSecretKey() {
                return this.secretKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiKey", om.valueToTree(this.getApiKey()));
                data.set("secretKey", om.valueToTree(this.getSecretKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmplitudeConnectorProfileCredentialsProperty.Jsii$Proxy that = (AmplitudeConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!apiKey.equals(that.apiKey)) return false;
                return this.secretKey.equals(that.secretKey);
            }

            @Override
            public final int hashCode() {
                int result = this.apiKey.hashCode();
                result = 31 * result + (this.secretKey.hashCode());
                return result;
            }
        }
    }
    /**
     * The `ConnectorOAuthRequest` property type specifies the select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ConnectorOAuthRequestProperty connectorOAuthRequestProperty = ConnectorOAuthRequestProperty.builder()
     *         .authCode("authCode")
     *         .redirectUri("redirectUri")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorOAuthRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorOAuthRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The code provided by the connector when it has been authenticated via the connected app.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthCode() {
            return null;
        }

        /**
         * The URL to which the authentication server redirects the browser after authorization has been granted.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRedirectUri() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorOAuthRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorOAuthRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorOAuthRequestProperty> {
            java.lang.String authCode;
            java.lang.String redirectUri;

            /**
             * Sets the value of {@link ConnectorOAuthRequestProperty#getAuthCode}
             * @param authCode The code provided by the connector when it has been authenticated via the connected app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authCode(java.lang.String authCode) {
                this.authCode = authCode;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOAuthRequestProperty#getRedirectUri}
             * @param redirectUri The URL to which the authentication server redirects the browser after authorization has been granted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redirectUri(java.lang.String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorOAuthRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorOAuthRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorOAuthRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorOAuthRequestProperty {
            private final java.lang.String authCode;
            private final java.lang.String redirectUri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authCode = software.amazon.jsii.Kernel.get(this, "authCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.redirectUri = software.amazon.jsii.Kernel.get(this, "redirectUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authCode = builder.authCode;
                this.redirectUri = builder.redirectUri;
            }

            @Override
            public final java.lang.String getAuthCode() {
                return this.authCode;
            }

            @Override
            public final java.lang.String getRedirectUri() {
                return this.redirectUri;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthCode() != null) {
                    data.set("authCode", om.valueToTree(this.getAuthCode()));
                }
                if (this.getRedirectUri() != null) {
                    data.set("redirectUri", om.valueToTree(this.getRedirectUri()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorOAuthRequestProperty.Jsii$Proxy that = (ConnectorOAuthRequestProperty.Jsii$Proxy) o;

                if (this.authCode != null ? !this.authCode.equals(that.authCode) : that.authCode != null) return false;
                return this.redirectUri != null ? this.redirectUri.equals(that.redirectUri) : that.redirectUri == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authCode != null ? this.authCode.hashCode() : 0;
                result = 31 * result + (this.redirectUri != null ? this.redirectUri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the connector-specific configuration and credentials for the connector profile.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object basicAuthCredentials;
     * Object oAuthCredentials;
     * ConnectorProfileConfigProperty connectorProfileConfigProperty = ConnectorProfileConfigProperty.builder()
     *         .connectorProfileCredentials(ConnectorProfileCredentialsProperty.builder()
     *                 .amplitude(AmplitudeConnectorProfileCredentialsProperty.builder()
     *                         .apiKey("apiKey")
     *                         .secretKey("secretKey")
     *                         .build())
     *                 .datadog(DatadogConnectorProfileCredentialsProperty.builder()
     *                         .apiKey("apiKey")
     *                         .applicationKey("applicationKey")
     *                         .build())
     *                 .dynatrace(DynatraceConnectorProfileCredentialsProperty.builder()
     *                         .apiToken("apiToken")
     *                         .build())
     *                 .googleAnalytics(GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         // the properties below are optional
     *                         .accessToken("accessToken")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .refreshToken("refreshToken")
     *                         .build())
     *                 .inforNexus(InforNexusConnectorProfileCredentialsProperty.builder()
     *                         .accessKeyId("accessKeyId")
     *                         .datakey("datakey")
     *                         .secretAccessKey("secretAccessKey")
     *                         .userId("userId")
     *                         .build())
     *                 .marketo(MarketoConnectorProfileCredentialsProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         // the properties below are optional
     *                         .accessToken("accessToken")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .build())
     *                 .redshift(RedshiftConnectorProfileCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .salesforce(SalesforceConnectorProfileCredentialsProperty.builder()
     *                         .accessToken("accessToken")
     *                         .clientCredentialsArn("clientCredentialsArn")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .refreshToken("refreshToken")
     *                         .build())
     *                 .sapoData(SAPODataConnectorProfileCredentialsProperty.builder()
     *                         .basicAuthCredentials(basicAuthCredentials)
     *                         .oAuthCredentials(oAuthCredentials)
     *                         .build())
     *                 .serviceNow(ServiceNowConnectorProfileCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .singular(SingularConnectorProfileCredentialsProperty.builder()
     *                         .apiKey("apiKey")
     *                         .build())
     *                 .slack(SlackConnectorProfileCredentialsProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         // the properties below are optional
     *                         .accessToken("accessToken")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .build())
     *                 .snowflake(SnowflakeConnectorProfileCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .trendmicro(TrendmicroConnectorProfileCredentialsProperty.builder()
     *                         .apiSecretKey("apiSecretKey")
     *                         .build())
     *                 .veeva(VeevaConnectorProfileCredentialsProperty.builder()
     *                         .password("password")
     *                         .username("username")
     *                         .build())
     *                 .zendesk(ZendeskConnectorProfileCredentialsProperty.builder()
     *                         .clientId("clientId")
     *                         .clientSecret("clientSecret")
     *                         // the properties below are optional
     *                         .accessToken("accessToken")
     *                         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                                 .authCode("authCode")
     *                                 .redirectUri("redirectUri")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .connectorProfileProperties(ConnectorProfilePropertiesProperty.builder()
     *                 .datadog(DatadogConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .dynatrace(DynatraceConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .inforNexus(InforNexusConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .marketo(MarketoConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .redshift(RedshiftConnectorProfilePropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         .databaseUrl("databaseUrl")
     *                         .roleArn("roleArn")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .build())
     *                 .salesforce(SalesforceConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .isSandboxEnvironment(false)
     *                         .build())
     *                 .sapoData(SAPODataConnectorProfilePropertiesProperty.builder()
     *                         .applicationHostUrl("applicationHostUrl")
     *                         .applicationServicePath("applicationServicePath")
     *                         .clientNumber("clientNumber")
     *                         .logonLanguage("logonLanguage")
     *                         .oAuthProperties(OAuthPropertiesProperty.builder()
     *                                 .authCodeUrl("authCodeUrl")
     *                                 .oAuthScopes(List.of("oAuthScopes"))
     *                                 .tokenUrl("tokenUrl")
     *                                 .build())
     *                         .portNumber(123)
     *                         .privateLinkServiceName("privateLinkServiceName")
     *                         .build())
     *                 .serviceNow(ServiceNowConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .slack(SlackConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .snowflake(SnowflakeConnectorProfilePropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         .stage("stage")
     *                         .warehouse("warehouse")
     *                         // the properties below are optional
     *                         .accountName("accountName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .privateLinkServiceName("privateLinkServiceName")
     *                         .region("region")
     *                         .build())
     *                 .veeva(VeevaConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .zendesk(ZendeskConnectorProfilePropertiesProperty.builder()
     *                         .instanceUrl("instanceUrl")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorProfileConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorProfileConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connector-specific credentials required by each connector.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConnectorProfileCredentials();

        /**
         * The connector-specific properties of the profile configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorProfileProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorProfileConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorProfileConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorProfileConfigProperty> {
            java.lang.Object connectorProfileCredentials;
            java.lang.Object connectorProfileProperties;

            /**
             * Sets the value of {@link ConnectorProfileConfigProperty#getConnectorProfileCredentials}
             * @param connectorProfileCredentials The connector-specific credentials required by each connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileCredentials(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileCredentialsProperty connectorProfileCredentials) {
                this.connectorProfileCredentials = connectorProfileCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileConfigProperty#getConnectorProfileCredentials}
             * @param connectorProfileCredentials The connector-specific credentials required by each connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileCredentials(software.amazon.awscdk.IResolvable connectorProfileCredentials) {
                this.connectorProfileCredentials = connectorProfileCredentials;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileConfigProperty#getConnectorProfileProperties}
             * @param connectorProfileProperties The connector-specific properties of the profile configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileProperties(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfilePropertiesProperty connectorProfileProperties) {
                this.connectorProfileProperties = connectorProfileProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileConfigProperty#getConnectorProfileProperties}
             * @param connectorProfileProperties The connector-specific properties of the profile configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileProperties(software.amazon.awscdk.IResolvable connectorProfileProperties) {
                this.connectorProfileProperties = connectorProfileProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorProfileConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorProfileConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorProfileConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorProfileConfigProperty {
            private final java.lang.Object connectorProfileCredentials;
            private final java.lang.Object connectorProfileProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorProfileCredentials = software.amazon.jsii.Kernel.get(this, "connectorProfileCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.connectorProfileProperties = software.amazon.jsii.Kernel.get(this, "connectorProfileProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorProfileCredentials = java.util.Objects.requireNonNull(builder.connectorProfileCredentials, "connectorProfileCredentials is required");
                this.connectorProfileProperties = builder.connectorProfileProperties;
            }

            @Override
            public final java.lang.Object getConnectorProfileCredentials() {
                return this.connectorProfileCredentials;
            }

            @Override
            public final java.lang.Object getConnectorProfileProperties() {
                return this.connectorProfileProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectorProfileCredentials", om.valueToTree(this.getConnectorProfileCredentials()));
                if (this.getConnectorProfileProperties() != null) {
                    data.set("connectorProfileProperties", om.valueToTree(this.getConnectorProfileProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorProfileConfigProperty.Jsii$Proxy that = (ConnectorProfileConfigProperty.Jsii$Proxy) o;

                if (!connectorProfileCredentials.equals(that.connectorProfileCredentials)) return false;
                return this.connectorProfileProperties != null ? this.connectorProfileProperties.equals(that.connectorProfileProperties) : that.connectorProfileProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorProfileCredentials.hashCode();
                result = 31 * result + (this.connectorProfileProperties != null ? this.connectorProfileProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ConnectorProfileCredentials` property type specifies the connector-specific credentials required by a given connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object basicAuthCredentials;
     * Object oAuthCredentials;
     * ConnectorProfileCredentialsProperty connectorProfileCredentialsProperty = ConnectorProfileCredentialsProperty.builder()
     *         .amplitude(AmplitudeConnectorProfileCredentialsProperty.builder()
     *                 .apiKey("apiKey")
     *                 .secretKey("secretKey")
     *                 .build())
     *         .datadog(DatadogConnectorProfileCredentialsProperty.builder()
     *                 .apiKey("apiKey")
     *                 .applicationKey("applicationKey")
     *                 .build())
     *         .dynatrace(DynatraceConnectorProfileCredentialsProperty.builder()
     *                 .apiToken("apiToken")
     *                 .build())
     *         .googleAnalytics(GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 // the properties below are optional
     *                 .accessToken("accessToken")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .refreshToken("refreshToken")
     *                 .build())
     *         .inforNexus(InforNexusConnectorProfileCredentialsProperty.builder()
     *                 .accessKeyId("accessKeyId")
     *                 .datakey("datakey")
     *                 .secretAccessKey("secretAccessKey")
     *                 .userId("userId")
     *                 .build())
     *         .marketo(MarketoConnectorProfileCredentialsProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 // the properties below are optional
     *                 .accessToken("accessToken")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .build())
     *         .redshift(RedshiftConnectorProfileCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .salesforce(SalesforceConnectorProfileCredentialsProperty.builder()
     *                 .accessToken("accessToken")
     *                 .clientCredentialsArn("clientCredentialsArn")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .refreshToken("refreshToken")
     *                 .build())
     *         .sapoData(SAPODataConnectorProfileCredentialsProperty.builder()
     *                 .basicAuthCredentials(basicAuthCredentials)
     *                 .oAuthCredentials(oAuthCredentials)
     *                 .build())
     *         .serviceNow(ServiceNowConnectorProfileCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .singular(SingularConnectorProfileCredentialsProperty.builder()
     *                 .apiKey("apiKey")
     *                 .build())
     *         .slack(SlackConnectorProfileCredentialsProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 // the properties below are optional
     *                 .accessToken("accessToken")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .build())
     *         .snowflake(SnowflakeConnectorProfileCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .trendmicro(TrendmicroConnectorProfileCredentialsProperty.builder()
     *                 .apiSecretKey("apiSecretKey")
     *                 .build())
     *         .veeva(VeevaConnectorProfileCredentialsProperty.builder()
     *                 .password("password")
     *                 .username("username")
     *                 .build())
     *         .zendesk(ZendeskConnectorProfileCredentialsProperty.builder()
     *                 .clientId("clientId")
     *                 .clientSecret("clientSecret")
     *                 // the properties below are optional
     *                 .accessToken("accessToken")
     *                 .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                         .authCode("authCode")
     *                         .redirectUri("redirectUri")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connector-specific credentials required when using Amplitude.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmplitude() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Datadog.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatadog() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Dynatrace.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynatrace() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Google Analytics.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGoogleAnalytics() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Infor Nexus.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInforNexus() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Marketo.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Amazon Redshift.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshift() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Salesforce.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * `CfnConnectorProfile.ConnectorProfileCredentialsProperty.SAPOData`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSapoData() {
            return null;
        }

        /**
         * The connector-specific credentials required when using ServiceNow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNow() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Singular.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingular() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Slack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlack() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Snowflake.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflake() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Trend Micro.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrendmicro() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Veeva.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVeeva() {
            return null;
        }

        /**
         * The connector-specific credentials required when using Zendesk.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorProfileCredentialsProperty> {
            java.lang.Object amplitude;
            java.lang.Object datadog;
            java.lang.Object dynatrace;
            java.lang.Object googleAnalytics;
            java.lang.Object inforNexus;
            java.lang.Object marketo;
            java.lang.Object redshift;
            java.lang.Object salesforce;
            java.lang.Object sapoData;
            java.lang.Object serviceNow;
            java.lang.Object singular;
            java.lang.Object slack;
            java.lang.Object snowflake;
            java.lang.Object trendmicro;
            java.lang.Object veeva;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getAmplitude}
             * @param amplitude The connector-specific credentials required when using Amplitude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(software.amazon.awscdk.services.appflow.CfnConnectorProfile.AmplitudeConnectorProfileCredentialsProperty amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getAmplitude}
             * @param amplitude The connector-specific credentials required when using Amplitude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(software.amazon.awscdk.IResolvable amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getDatadog}
             * @param datadog The connector-specific credentials required when using Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.services.appflow.CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getDatadog}
             * @param datadog The connector-specific credentials required when using Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.IResolvable datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getDynatrace}
             * @param dynatrace The connector-specific credentials required when using Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.services.appflow.CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getDynatrace}
             * @param dynatrace The connector-specific credentials required when using Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.IResolvable dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getGoogleAnalytics}
             * @param googleAnalytics The connector-specific credentials required when using Google Analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(software.amazon.awscdk.services.appflow.CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getGoogleAnalytics}
             * @param googleAnalytics The connector-specific credentials required when using Google Analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(software.amazon.awscdk.IResolvable googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getInforNexus}
             * @param inforNexus The connector-specific credentials required when using Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.services.appflow.CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getInforNexus}
             * @param inforNexus The connector-specific credentials required when using Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.IResolvable inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getMarketo}
             * @param marketo The connector-specific credentials required when using Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getMarketo}
             * @param marketo The connector-specific credentials required when using Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getRedshift}
             * @param redshift The connector-specific credentials required when using Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.services.appflow.CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getRedshift}
             * @param redshift The connector-specific credentials required when using Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.IResolvable redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSalesforce}
             * @param salesforce The connector-specific credentials required when using Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSalesforce}
             * @param salesforce The connector-specific credentials required when using Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSapoData}
             * @param sapoData `CfnConnectorProfile.ConnectorProfileCredentialsProperty.SAPOData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSapoData}
             * @param sapoData `CfnConnectorProfile.ConnectorProfileCredentialsProperty.SAPOData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.IResolvable sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getServiceNow}
             * @param serviceNow The connector-specific credentials required when using ServiceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getServiceNow}
             * @param serviceNow The connector-specific credentials required when using ServiceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSingular}
             * @param singular The connector-specific credentials required when using Singular.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SingularConnectorProfileCredentialsProperty singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSingular}
             * @param singular The connector-specific credentials required when using Singular.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(software.amazon.awscdk.IResolvable singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSlack}
             * @param slack The connector-specific credentials required when using Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SlackConnectorProfileCredentialsProperty slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSlack}
             * @param slack The connector-specific credentials required when using Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.IResolvable slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSnowflake}
             * @param snowflake The connector-specific credentials required when using Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getSnowflake}
             * @param snowflake The connector-specific credentials required when using Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.IResolvable snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getTrendmicro}
             * @param trendmicro The connector-specific credentials required when using Trend Micro.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(software.amazon.awscdk.services.appflow.CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getTrendmicro}
             * @param trendmicro The connector-specific credentials required when using Trend Micro.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(software.amazon.awscdk.IResolvable trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getVeeva}
             * @param veeva The connector-specific credentials required when using Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.services.appflow.CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getVeeva}
             * @param veeva The connector-specific credentials required when using Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.IResolvable veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getZendesk}
             * @param zendesk The connector-specific credentials required when using Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfileCredentialsProperty#getZendesk}
             * @param zendesk The connector-specific credentials required when using Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorProfileCredentialsProperty {
            private final java.lang.Object amplitude;
            private final java.lang.Object datadog;
            private final java.lang.Object dynatrace;
            private final java.lang.Object googleAnalytics;
            private final java.lang.Object inforNexus;
            private final java.lang.Object marketo;
            private final java.lang.Object redshift;
            private final java.lang.Object salesforce;
            private final java.lang.Object sapoData;
            private final java.lang.Object serviceNow;
            private final java.lang.Object singular;
            private final java.lang.Object slack;
            private final java.lang.Object snowflake;
            private final java.lang.Object trendmicro;
            private final java.lang.Object veeva;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amplitude = software.amazon.jsii.Kernel.get(this, "amplitude", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datadog = software.amazon.jsii.Kernel.get(this, "datadog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynatrace = software.amazon.jsii.Kernel.get(this, "dynatrace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.googleAnalytics = software.amazon.jsii.Kernel.get(this, "googleAnalytics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inforNexus = software.amazon.jsii.Kernel.get(this, "inforNexus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshift = software.amazon.jsii.Kernel.get(this, "redshift", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singular = software.amazon.jsii.Kernel.get(this, "singular", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slack = software.amazon.jsii.Kernel.get(this, "slack", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflake = software.amazon.jsii.Kernel.get(this, "snowflake", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trendmicro = software.amazon.jsii.Kernel.get(this, "trendmicro", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.veeva = software.amazon.jsii.Kernel.get(this, "veeva", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amplitude = builder.amplitude;
                this.datadog = builder.datadog;
                this.dynatrace = builder.dynatrace;
                this.googleAnalytics = builder.googleAnalytics;
                this.inforNexus = builder.inforNexus;
                this.marketo = builder.marketo;
                this.redshift = builder.redshift;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.serviceNow = builder.serviceNow;
                this.singular = builder.singular;
                this.slack = builder.slack;
                this.snowflake = builder.snowflake;
                this.trendmicro = builder.trendmicro;
                this.veeva = builder.veeva;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getAmplitude() {
                return this.amplitude;
            }

            @Override
            public final java.lang.Object getDatadog() {
                return this.datadog;
            }

            @Override
            public final java.lang.Object getDynatrace() {
                return this.dynatrace;
            }

            @Override
            public final java.lang.Object getGoogleAnalytics() {
                return this.googleAnalytics;
            }

            @Override
            public final java.lang.Object getInforNexus() {
                return this.inforNexus;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getRedshift() {
                return this.redshift;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.Object getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.Object getSingular() {
                return this.singular;
            }

            @Override
            public final java.lang.Object getSlack() {
                return this.slack;
            }

            @Override
            public final java.lang.Object getSnowflake() {
                return this.snowflake;
            }

            @Override
            public final java.lang.Object getTrendmicro() {
                return this.trendmicro;
            }

            @Override
            public final java.lang.Object getVeeva() {
                return this.veeva;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmplitude() != null) {
                    data.set("amplitude", om.valueToTree(this.getAmplitude()));
                }
                if (this.getDatadog() != null) {
                    data.set("datadog", om.valueToTree(this.getDatadog()));
                }
                if (this.getDynatrace() != null) {
                    data.set("dynatrace", om.valueToTree(this.getDynatrace()));
                }
                if (this.getGoogleAnalytics() != null) {
                    data.set("googleAnalytics", om.valueToTree(this.getGoogleAnalytics()));
                }
                if (this.getInforNexus() != null) {
                    data.set("inforNexus", om.valueToTree(this.getInforNexus()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getRedshift() != null) {
                    data.set("redshift", om.valueToTree(this.getRedshift()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getSingular() != null) {
                    data.set("singular", om.valueToTree(this.getSingular()));
                }
                if (this.getSlack() != null) {
                    data.set("slack", om.valueToTree(this.getSlack()));
                }
                if (this.getSnowflake() != null) {
                    data.set("snowflake", om.valueToTree(this.getSnowflake()));
                }
                if (this.getTrendmicro() != null) {
                    data.set("trendmicro", om.valueToTree(this.getTrendmicro()));
                }
                if (this.getVeeva() != null) {
                    data.set("veeva", om.valueToTree(this.getVeeva()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorProfileCredentialsProperty.Jsii$Proxy that = (ConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.amplitude != null ? !this.amplitude.equals(that.amplitude) : that.amplitude != null) return false;
                if (this.datadog != null ? !this.datadog.equals(that.datadog) : that.datadog != null) return false;
                if (this.dynatrace != null ? !this.dynatrace.equals(that.dynatrace) : that.dynatrace != null) return false;
                if (this.googleAnalytics != null ? !this.googleAnalytics.equals(that.googleAnalytics) : that.googleAnalytics != null) return false;
                if (this.inforNexus != null ? !this.inforNexus.equals(that.inforNexus) : that.inforNexus != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.redshift != null ? !this.redshift.equals(that.redshift) : that.redshift != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                if (this.singular != null ? !this.singular.equals(that.singular) : that.singular != null) return false;
                if (this.slack != null ? !this.slack.equals(that.slack) : that.slack != null) return false;
                if (this.snowflake != null ? !this.snowflake.equals(that.snowflake) : that.snowflake != null) return false;
                if (this.trendmicro != null ? !this.trendmicro.equals(that.trendmicro) : that.trendmicro != null) return false;
                if (this.veeva != null ? !this.veeva.equals(that.veeva) : that.veeva != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amplitude != null ? this.amplitude.hashCode() : 0;
                result = 31 * result + (this.datadog != null ? this.datadog.hashCode() : 0);
                result = 31 * result + (this.dynatrace != null ? this.dynatrace.hashCode() : 0);
                result = 31 * result + (this.googleAnalytics != null ? this.googleAnalytics.hashCode() : 0);
                result = 31 * result + (this.inforNexus != null ? this.inforNexus.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.redshift != null ? this.redshift.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.singular != null ? this.singular.hashCode() : 0);
                result = 31 * result + (this.slack != null ? this.slack.hashCode() : 0);
                result = 31 * result + (this.snowflake != null ? this.snowflake.hashCode() : 0);
                result = 31 * result + (this.trendmicro != null ? this.trendmicro.hashCode() : 0);
                result = 31 * result + (this.veeva != null ? this.veeva.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ConnectorProfileProperties` property type specifies the connector-specific profile properties required by each connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ConnectorProfilePropertiesProperty connectorProfilePropertiesProperty = ConnectorProfilePropertiesProperty.builder()
     *         .datadog(DatadogConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .dynatrace(DynatraceConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .inforNexus(InforNexusConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .marketo(MarketoConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .redshift(RedshiftConnectorProfilePropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 .databaseUrl("databaseUrl")
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .build())
     *         .salesforce(SalesforceConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .isSandboxEnvironment(false)
     *                 .build())
     *         .sapoData(SAPODataConnectorProfilePropertiesProperty.builder()
     *                 .applicationHostUrl("applicationHostUrl")
     *                 .applicationServicePath("applicationServicePath")
     *                 .clientNumber("clientNumber")
     *                 .logonLanguage("logonLanguage")
     *                 .oAuthProperties(OAuthPropertiesProperty.builder()
     *                         .authCodeUrl("authCodeUrl")
     *                         .oAuthScopes(List.of("oAuthScopes"))
     *                         .tokenUrl("tokenUrl")
     *                         .build())
     *                 .portNumber(123)
     *                 .privateLinkServiceName("privateLinkServiceName")
     *                 .build())
     *         .serviceNow(ServiceNowConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .slack(SlackConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .snowflake(SnowflakeConnectorProfilePropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 .stage("stage")
     *                 .warehouse("warehouse")
     *                 // the properties below are optional
     *                 .accountName("accountName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .privateLinkServiceName("privateLinkServiceName")
     *                 .region("region")
     *                 .build())
     *         .veeva(VeevaConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .zendesk(ZendeskConnectorProfilePropertiesProperty.builder()
     *                 .instanceUrl("instanceUrl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connector-specific properties required by Datadog.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatadog() {
            return null;
        }

        /**
         * The connector-specific properties required by Dynatrace.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynatrace() {
            return null;
        }

        /**
         * The connector-specific properties required by Infor Nexus.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInforNexus() {
            return null;
        }

        /**
         * The connector-specific properties required by Marketo.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * The connector-specific properties required by Amazon Redshift.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshift() {
            return null;
        }

        /**
         * The connector-specific properties required by Salesforce.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * `CfnConnectorProfile.ConnectorProfilePropertiesProperty.SAPOData`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSapoData() {
            return null;
        }

        /**
         * The connector-specific properties required by serviceNow.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNow() {
            return null;
        }

        /**
         * The connector-specific properties required by Slack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlack() {
            return null;
        }

        /**
         * The connector-specific properties required by Snowflake.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflake() {
            return null;
        }

        /**
         * The connector-specific properties required by Veeva.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVeeva() {
            return null;
        }

        /**
         * The connector-specific properties required by Zendesk.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorProfilePropertiesProperty> {
            java.lang.Object datadog;
            java.lang.Object dynatrace;
            java.lang.Object inforNexus;
            java.lang.Object marketo;
            java.lang.Object redshift;
            java.lang.Object salesforce;
            java.lang.Object sapoData;
            java.lang.Object serviceNow;
            java.lang.Object slack;
            java.lang.Object snowflake;
            java.lang.Object veeva;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getDatadog}
             * @param datadog The connector-specific properties required by Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.services.appflow.CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getDatadog}
             * @param datadog The connector-specific properties required by Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.IResolvable datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getDynatrace}
             * @param dynatrace The connector-specific properties required by Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.services.appflow.CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getDynatrace}
             * @param dynatrace The connector-specific properties required by Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.IResolvable dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getInforNexus}
             * @param inforNexus The connector-specific properties required by Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.services.appflow.CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getInforNexus}
             * @param inforNexus The connector-specific properties required by Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.IResolvable inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getMarketo}
             * @param marketo The connector-specific properties required by Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.appflow.CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getMarketo}
             * @param marketo The connector-specific properties required by Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getRedshift}
             * @param redshift The connector-specific properties required by Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.services.appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getRedshift}
             * @param redshift The connector-specific properties required by Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.IResolvable redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSalesforce}
             * @param salesforce The connector-specific properties required by Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSalesforce}
             * @param salesforce The connector-specific properties required by Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSapoData}
             * @param sapoData `CfnConnectorProfile.ConnectorProfilePropertiesProperty.SAPOData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSapoData}
             * @param sapoData `CfnConnectorProfile.ConnectorProfilePropertiesProperty.SAPOData`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.IResolvable sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getServiceNow}
             * @param serviceNow The connector-specific properties required by serviceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getServiceNow}
             * @param serviceNow The connector-specific properties required by serviceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSlack}
             * @param slack The connector-specific properties required by Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SlackConnectorProfilePropertiesProperty slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSlack}
             * @param slack The connector-specific properties required by Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.IResolvable slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSnowflake}
             * @param snowflake The connector-specific properties required by Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.services.appflow.CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getSnowflake}
             * @param snowflake The connector-specific properties required by Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.IResolvable snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getVeeva}
             * @param veeva The connector-specific properties required by Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.services.appflow.CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getVeeva}
             * @param veeva The connector-specific properties required by Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.IResolvable veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getZendesk}
             * @param zendesk The connector-specific properties required by Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorProfilePropertiesProperty#getZendesk}
             * @param zendesk The connector-specific properties required by Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorProfilePropertiesProperty {
            private final java.lang.Object datadog;
            private final java.lang.Object dynatrace;
            private final java.lang.Object inforNexus;
            private final java.lang.Object marketo;
            private final java.lang.Object redshift;
            private final java.lang.Object salesforce;
            private final java.lang.Object sapoData;
            private final java.lang.Object serviceNow;
            private final java.lang.Object slack;
            private final java.lang.Object snowflake;
            private final java.lang.Object veeva;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datadog = software.amazon.jsii.Kernel.get(this, "datadog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynatrace = software.amazon.jsii.Kernel.get(this, "dynatrace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inforNexus = software.amazon.jsii.Kernel.get(this, "inforNexus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshift = software.amazon.jsii.Kernel.get(this, "redshift", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slack = software.amazon.jsii.Kernel.get(this, "slack", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflake = software.amazon.jsii.Kernel.get(this, "snowflake", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.veeva = software.amazon.jsii.Kernel.get(this, "veeva", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datadog = builder.datadog;
                this.dynatrace = builder.dynatrace;
                this.inforNexus = builder.inforNexus;
                this.marketo = builder.marketo;
                this.redshift = builder.redshift;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.serviceNow = builder.serviceNow;
                this.slack = builder.slack;
                this.snowflake = builder.snowflake;
                this.veeva = builder.veeva;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getDatadog() {
                return this.datadog;
            }

            @Override
            public final java.lang.Object getDynatrace() {
                return this.dynatrace;
            }

            @Override
            public final java.lang.Object getInforNexus() {
                return this.inforNexus;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getRedshift() {
                return this.redshift;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.Object getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.Object getSlack() {
                return this.slack;
            }

            @Override
            public final java.lang.Object getSnowflake() {
                return this.snowflake;
            }

            @Override
            public final java.lang.Object getVeeva() {
                return this.veeva;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatadog() != null) {
                    data.set("datadog", om.valueToTree(this.getDatadog()));
                }
                if (this.getDynatrace() != null) {
                    data.set("dynatrace", om.valueToTree(this.getDynatrace()));
                }
                if (this.getInforNexus() != null) {
                    data.set("inforNexus", om.valueToTree(this.getInforNexus()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getRedshift() != null) {
                    data.set("redshift", om.valueToTree(this.getRedshift()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getSlack() != null) {
                    data.set("slack", om.valueToTree(this.getSlack()));
                }
                if (this.getSnowflake() != null) {
                    data.set("snowflake", om.valueToTree(this.getSnowflake()));
                }
                if (this.getVeeva() != null) {
                    data.set("veeva", om.valueToTree(this.getVeeva()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorProfilePropertiesProperty.Jsii$Proxy that = (ConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (this.datadog != null ? !this.datadog.equals(that.datadog) : that.datadog != null) return false;
                if (this.dynatrace != null ? !this.dynatrace.equals(that.dynatrace) : that.dynatrace != null) return false;
                if (this.inforNexus != null ? !this.inforNexus.equals(that.inforNexus) : that.inforNexus != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.redshift != null ? !this.redshift.equals(that.redshift) : that.redshift != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                if (this.slack != null ? !this.slack.equals(that.slack) : that.slack != null) return false;
                if (this.snowflake != null ? !this.snowflake.equals(that.snowflake) : that.snowflake != null) return false;
                if (this.veeva != null ? !this.veeva.equals(that.veeva) : that.veeva != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.datadog != null ? this.datadog.hashCode() : 0;
                result = 31 * result + (this.dynatrace != null ? this.dynatrace.hashCode() : 0);
                result = 31 * result + (this.inforNexus != null ? this.inforNexus.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.redshift != null ? this.redshift.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.slack != null ? this.slack.hashCode() : 0);
                result = 31 * result + (this.snowflake != null ? this.snowflake.hashCode() : 0);
                result = 31 * result + (this.veeva != null ? this.veeva.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `DatadogConnectorProfileCredentials` property type specifies the connector-specific credentials required by Datadog.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DatadogConnectorProfileCredentialsProperty datadogConnectorProfileCredentialsProperty = DatadogConnectorProfileCredentialsProperty.builder()
     *         .apiKey("apiKey")
     *         .applicationKey("applicationKey")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(DatadogConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatadogConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKey();

        /**
         * Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API.
         * <p>
         * Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApplicationKey();

        /**
         * @return a {@link Builder} of {@link DatadogConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatadogConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatadogConnectorProfileCredentialsProperty> {
            java.lang.String apiKey;
            java.lang.String applicationKey;

            /**
             * Sets the value of {@link DatadogConnectorProfileCredentialsProperty#getApiKey}
             * @param apiKey A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(java.lang.String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Sets the value of {@link DatadogConnectorProfileCredentialsProperty#getApplicationKey}
             * @param applicationKey Application keys, in conjunction with your API key, give you full access to Datadog’s programmatic API. This parameter is required.
             *                       Application keys are associated with the user account that created them. The application key is used to log all requests made to the API.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationKey(java.lang.String applicationKey) {
                this.applicationKey = applicationKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatadogConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatadogConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatadogConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatadogConnectorProfileCredentialsProperty {
            private final java.lang.String apiKey;
            private final java.lang.String applicationKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applicationKey = software.amazon.jsii.Kernel.get(this, "applicationKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKey = java.util.Objects.requireNonNull(builder.apiKey, "apiKey is required");
                this.applicationKey = java.util.Objects.requireNonNull(builder.applicationKey, "applicationKey is required");
            }

            @Override
            public final java.lang.String getApiKey() {
                return this.apiKey;
            }

            @Override
            public final java.lang.String getApplicationKey() {
                return this.applicationKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiKey", om.valueToTree(this.getApiKey()));
                data.set("applicationKey", om.valueToTree(this.getApplicationKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatadogConnectorProfileCredentialsProperty.Jsii$Proxy that = (DatadogConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!apiKey.equals(that.apiKey)) return false;
                return this.applicationKey.equals(that.applicationKey);
            }

            @Override
            public final int hashCode() {
                int result = this.apiKey.hashCode();
                result = 31 * result + (this.applicationKey.hashCode());
                return result;
            }
        }
    }
    /**
     * The `DatadogConnectorProfileProperties` property type specifies the connector-specific profile properties required by Datadog.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DatadogConnectorProfilePropertiesProperty datadogConnectorProfilePropertiesProperty = DatadogConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DatadogConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatadogConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Datadog resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link DatadogConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatadogConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatadogConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link DatadogConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Datadog resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatadogConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatadogConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatadogConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatadogConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.DatadogConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatadogConnectorProfilePropertiesProperty.Jsii$Proxy that = (DatadogConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The `DynatraceConnectorProfileCredentials` property type specifies the connector-specific profile credentials required by Dynatrace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DynatraceConnectorProfileCredentialsProperty dynatraceConnectorProfileCredentialsProperty = DynatraceConnectorProfileCredentialsProperty.builder()
     *         .apiToken("apiToken")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(DynatraceConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynatraceConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The API tokens used by Dynatrace API to authenticate various API calls.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiToken();

        /**
         * @return a {@link Builder} of {@link DynatraceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynatraceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynatraceConnectorProfileCredentialsProperty> {
            java.lang.String apiToken;

            /**
             * Sets the value of {@link DynatraceConnectorProfileCredentialsProperty#getApiToken}
             * @param apiToken The API tokens used by Dynatrace API to authenticate various API calls. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiToken(java.lang.String apiToken) {
                this.apiToken = apiToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynatraceConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynatraceConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynatraceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynatraceConnectorProfileCredentialsProperty {
            private final java.lang.String apiToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiToken = software.amazon.jsii.Kernel.get(this, "apiToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiToken = java.util.Objects.requireNonNull(builder.apiToken, "apiToken is required");
            }

            @Override
            public final java.lang.String getApiToken() {
                return this.apiToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiToken", om.valueToTree(this.getApiToken()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynatraceConnectorProfileCredentialsProperty.Jsii$Proxy that = (DynatraceConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                return this.apiToken.equals(that.apiToken);
            }

            @Override
            public final int hashCode() {
                int result = this.apiToken.hashCode();
                return result;
            }
        }
    }
    /**
     * The `DynatraceConnectorProfileProperties` property type specifies the connector-specific profile properties required by Dynatrace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DynatraceConnectorProfilePropertiesProperty dynatraceConnectorProfilePropertiesProperty = DynatraceConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DynatraceConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynatraceConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Dynatrace resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link DynatraceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynatraceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynatraceConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link DynatraceConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Dynatrace resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynatraceConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynatraceConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynatraceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynatraceConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.DynatraceConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynatraceConnectorProfilePropertiesProperty.Jsii$Proxy that = (DynatraceConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The `GoogleAnalyticsConnectorProfileCredentials` property type specifies the connector-specific profile credentials required by Google Analytics.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * GoogleAnalyticsConnectorProfileCredentialsProperty googleAnalyticsConnectorProfileCredentialsProperty = GoogleAnalyticsConnectorProfileCredentialsProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         // the properties below are optional
     *         .accessToken("accessToken")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(GoogleAnalyticsConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GoogleAnalyticsConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the desired client.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * The credentials used to access protected Google Analytics resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * The credentials used to acquire new access tokens.
         * <p>
         * This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GoogleAnalyticsConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GoogleAnalyticsConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GoogleAnalyticsConnectorProfileCredentialsProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String accessToken;
            java.lang.Object connectorOAuthRequest;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getClientId}
             * @param clientId The identifier for the desired client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Google Analytics resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link GoogleAnalyticsConnectorProfileCredentialsProperty#getRefreshToken}
             * @param refreshToken The credentials used to acquire new access tokens.
             *                     This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GoogleAnalyticsConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GoogleAnalyticsConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GoogleAnalyticsConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GoogleAnalyticsConnectorProfileCredentialsProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String accessToken;
            private final java.lang.Object connectorOAuthRequest;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.accessToken = builder.accessToken;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.GoogleAnalyticsConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GoogleAnalyticsConnectorProfileCredentialsProperty.Jsii$Proxy that = (GoogleAnalyticsConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.connectorOAuthRequest != null ? !this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `InforNexusConnectorProfileCredentials` property type specifies the connector-specific profile credentials required by Infor Nexus.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * InforNexusConnectorProfileCredentialsProperty inforNexusConnectorProfileCredentialsProperty = InforNexusConnectorProfileCredentialsProperty.builder()
     *         .accessKeyId("accessKeyId")
     *         .datakey("datakey")
     *         .secretAccessKey("secretAccessKey")
     *         .userId("userId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(InforNexusConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InforNexusConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Access Key portion of the credentials.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccessKeyId();

        /**
         * The encryption keys used to encrypt data.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatakey();

        /**
         * The secret key used to sign requests.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretAccessKey();

        /**
         * The identifier for the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserId();

        /**
         * @return a {@link Builder} of {@link InforNexusConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InforNexusConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InforNexusConnectorProfileCredentialsProperty> {
            java.lang.String accessKeyId;
            java.lang.String datakey;
            java.lang.String secretAccessKey;
            java.lang.String userId;

            /**
             * Sets the value of {@link InforNexusConnectorProfileCredentialsProperty#getAccessKeyId}
             * @param accessKeyId The Access Key portion of the credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessKeyId(java.lang.String accessKeyId) {
                this.accessKeyId = accessKeyId;
                return this;
            }

            /**
             * Sets the value of {@link InforNexusConnectorProfileCredentialsProperty#getDatakey}
             * @param datakey The encryption keys used to encrypt data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datakey(java.lang.String datakey) {
                this.datakey = datakey;
                return this;
            }

            /**
             * Sets the value of {@link InforNexusConnectorProfileCredentialsProperty#getSecretAccessKey}
             * @param secretAccessKey The secret key used to sign requests. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretAccessKey(java.lang.String secretAccessKey) {
                this.secretAccessKey = secretAccessKey;
                return this;
            }

            /**
             * Sets the value of {@link InforNexusConnectorProfileCredentialsProperty#getUserId}
             * @param userId The identifier for the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userId(java.lang.String userId) {
                this.userId = userId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InforNexusConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InforNexusConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InforNexusConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InforNexusConnectorProfileCredentialsProperty {
            private final java.lang.String accessKeyId;
            private final java.lang.String datakey;
            private final java.lang.String secretAccessKey;
            private final java.lang.String userId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessKeyId = software.amazon.jsii.Kernel.get(this, "accessKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datakey = software.amazon.jsii.Kernel.get(this, "datakey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretAccessKey = software.amazon.jsii.Kernel.get(this, "secretAccessKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userId = software.amazon.jsii.Kernel.get(this, "userId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessKeyId = java.util.Objects.requireNonNull(builder.accessKeyId, "accessKeyId is required");
                this.datakey = java.util.Objects.requireNonNull(builder.datakey, "datakey is required");
                this.secretAccessKey = java.util.Objects.requireNonNull(builder.secretAccessKey, "secretAccessKey is required");
                this.userId = java.util.Objects.requireNonNull(builder.userId, "userId is required");
            }

            @Override
            public final java.lang.String getAccessKeyId() {
                return this.accessKeyId;
            }

            @Override
            public final java.lang.String getDatakey() {
                return this.datakey;
            }

            @Override
            public final java.lang.String getSecretAccessKey() {
                return this.secretAccessKey;
            }

            @Override
            public final java.lang.String getUserId() {
                return this.userId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accessKeyId", om.valueToTree(this.getAccessKeyId()));
                data.set("datakey", om.valueToTree(this.getDatakey()));
                data.set("secretAccessKey", om.valueToTree(this.getSecretAccessKey()));
                data.set("userId", om.valueToTree(this.getUserId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InforNexusConnectorProfileCredentialsProperty.Jsii$Proxy that = (InforNexusConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!accessKeyId.equals(that.accessKeyId)) return false;
                if (!datakey.equals(that.datakey)) return false;
                if (!secretAccessKey.equals(that.secretAccessKey)) return false;
                return this.userId.equals(that.userId);
            }

            @Override
            public final int hashCode() {
                int result = this.accessKeyId.hashCode();
                result = 31 * result + (this.datakey.hashCode());
                result = 31 * result + (this.secretAccessKey.hashCode());
                result = 31 * result + (this.userId.hashCode());
                return result;
            }
        }
    }
    /**
     * The `InforNexusConnectorProfileProperties` property type specifies the connector-specific profile properties required by Infor Nexus.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * InforNexusConnectorProfilePropertiesProperty inforNexusConnectorProfilePropertiesProperty = InforNexusConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(InforNexusConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InforNexusConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Infor Nexus resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link InforNexusConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InforNexusConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InforNexusConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link InforNexusConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Infor Nexus resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InforNexusConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InforNexusConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InforNexusConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InforNexusConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.InforNexusConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InforNexusConnectorProfilePropertiesProperty.Jsii$Proxy that = (InforNexusConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The `MarketoConnectorProfileCredentials` property type specifies the connector-specific profile credentials required by Marketo.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MarketoConnectorProfileCredentialsProperty marketoConnectorProfileCredentialsProperty = MarketoConnectorProfileCredentialsProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         // the properties below are optional
     *         .accessToken("accessToken")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the desired client.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * The credentials used to access protected Marketo resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MarketoConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoConnectorProfileCredentialsProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String accessToken;
            java.lang.Object connectorOAuthRequest;

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getClientId}
             * @param clientId The identifier for the desired client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Marketo resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link MarketoConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoConnectorProfileCredentialsProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String accessToken;
            private final java.lang.Object connectorOAuthRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.accessToken = builder.accessToken;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoConnectorProfileCredentialsProperty.Jsii$Proxy that = (MarketoConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                return this.connectorOAuthRequest != null ? this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `MarketoConnectorProfileProperties` property type specifies the connector-specific profile properties required when using Marketo.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MarketoConnectorProfilePropertiesProperty marketoConnectorProfilePropertiesProperty = MarketoConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Marketo resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link MarketoConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link MarketoConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Marketo resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.MarketoConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoConnectorProfilePropertiesProperty.Jsii$Proxy that = (MarketoConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * OAuthPropertiesProperty oAuthPropertiesProperty = OAuthPropertiesProperty.builder()
     *         .authCodeUrl("authCodeUrl")
     *         .oAuthScopes(List.of("oAuthScopes"))
     *         .tokenUrl("tokenUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuthPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuthPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuthPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConnectorProfile.OAuthPropertiesProperty.AuthCodeUrl`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthCodeUrl() {
            return null;
        }

        /**
         * `CfnConnectorProfile.OAuthPropertiesProperty.OAuthScopes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOAuthScopes() {
            return null;
        }

        /**
         * `CfnConnectorProfile.OAuthPropertiesProperty.TokenUrl`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuthPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuthPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuthPropertiesProperty> {
            java.lang.String authCodeUrl;
            java.util.List<java.lang.String> oAuthScopes;
            java.lang.String tokenUrl;

            /**
             * Sets the value of {@link OAuthPropertiesProperty#getAuthCodeUrl}
             * @param authCodeUrl `CfnConnectorProfile.OAuthPropertiesProperty.AuthCodeUrl`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authCodeUrl(java.lang.String authCodeUrl) {
                this.authCodeUrl = authCodeUrl;
                return this;
            }

            /**
             * Sets the value of {@link OAuthPropertiesProperty#getOAuthScopes}
             * @param oAuthScopes `CfnConnectorProfile.OAuthPropertiesProperty.OAuthScopes`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthScopes(java.util.List<java.lang.String> oAuthScopes) {
                this.oAuthScopes = oAuthScopes;
                return this;
            }

            /**
             * Sets the value of {@link OAuthPropertiesProperty#getTokenUrl}
             * @param tokenUrl `CfnConnectorProfile.OAuthPropertiesProperty.TokenUrl`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrl(java.lang.String tokenUrl) {
                this.tokenUrl = tokenUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuthPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuthPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuthPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuthPropertiesProperty {
            private final java.lang.String authCodeUrl;
            private final java.util.List<java.lang.String> oAuthScopes;
            private final java.lang.String tokenUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.authCodeUrl = software.amazon.jsii.Kernel.get(this, "authCodeUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuthScopes = software.amazon.jsii.Kernel.get(this, "oAuthScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tokenUrl = software.amazon.jsii.Kernel.get(this, "tokenUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.authCodeUrl = builder.authCodeUrl;
                this.oAuthScopes = builder.oAuthScopes;
                this.tokenUrl = builder.tokenUrl;
            }

            @Override
            public final java.lang.String getAuthCodeUrl() {
                return this.authCodeUrl;
            }

            @Override
            public final java.util.List<java.lang.String> getOAuthScopes() {
                return this.oAuthScopes;
            }

            @Override
            public final java.lang.String getTokenUrl() {
                return this.tokenUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAuthCodeUrl() != null) {
                    data.set("authCodeUrl", om.valueToTree(this.getAuthCodeUrl()));
                }
                if (this.getOAuthScopes() != null) {
                    data.set("oAuthScopes", om.valueToTree(this.getOAuthScopes()));
                }
                if (this.getTokenUrl() != null) {
                    data.set("tokenUrl", om.valueToTree(this.getTokenUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.OAuthPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuthPropertiesProperty.Jsii$Proxy that = (OAuthPropertiesProperty.Jsii$Proxy) o;

                if (this.authCodeUrl != null ? !this.authCodeUrl.equals(that.authCodeUrl) : that.authCodeUrl != null) return false;
                if (this.oAuthScopes != null ? !this.oAuthScopes.equals(that.oAuthScopes) : that.oAuthScopes != null) return false;
                return this.tokenUrl != null ? this.tokenUrl.equals(that.tokenUrl) : that.tokenUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.authCodeUrl != null ? this.authCodeUrl.hashCode() : 0;
                result = 31 * result + (this.oAuthScopes != null ? this.oAuthScopes.hashCode() : 0);
                result = 31 * result + (this.tokenUrl != null ? this.tokenUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `RedshiftConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using Amazon Redshift.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * RedshiftConnectorProfileCredentialsProperty redshiftConnectorProfileCredentialsProperty = RedshiftConnectorProfileCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password that corresponds to the user name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The name of the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link RedshiftConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftConnectorProfileCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link RedshiftConnectorProfileCredentialsProperty#getPassword}
             * @param password The password that corresponds to the user name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfileCredentialsProperty#getUsername}
             * @param username The name of the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftConnectorProfileCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftConnectorProfileCredentialsProperty.Jsii$Proxy that = (RedshiftConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }
    /**
     * The `RedshiftConnectorProfileProperties` property type specifies the connector-specific profile properties when using Amazon Redshift.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * RedshiftConnectorProfilePropertiesProperty redshiftConnectorProfilePropertiesProperty = RedshiftConnectorProfilePropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         .databaseUrl("databaseUrl")
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the associated Amazon S3 bucket.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The JDBC URL of the Amazon Redshift cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseUrl();

        /**
         * The Amazon Resource Name (ARN) of the IAM role.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftConnectorProfilePropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String databaseUrl;
            java.lang.String roleArn;
            java.lang.String bucketPrefix;

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getBucketName}
             * @param bucketName A name for the associated Amazon S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getDatabaseUrl}
             * @param databaseUrl The JDBC URL of the Amazon Redshift cluster. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseUrl(java.lang.String databaseUrl) {
                this.databaseUrl = databaseUrl;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftConnectorProfilePropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the destination bucket in which Amazon AppFlow places the files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftConnectorProfilePropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String databaseUrl;
            private final java.lang.String roleArn;
            private final java.lang.String bucketPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.databaseUrl = software.amazon.jsii.Kernel.get(this, "databaseUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.databaseUrl = java.util.Objects.requireNonNull(builder.databaseUrl, "databaseUrl is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.bucketPrefix = builder.bucketPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getDatabaseUrl() {
                return this.databaseUrl;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("databaseUrl", om.valueToTree(this.getDatabaseUrl()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.RedshiftConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftConnectorProfilePropertiesProperty.Jsii$Proxy that = (RedshiftConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!databaseUrl.equals(that.databaseUrl)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.bucketPrefix != null ? this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.databaseUrl.hashCode());
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * Object basicAuthCredentials;
     * Object oAuthCredentials;
     * SAPODataConnectorProfileCredentialsProperty sAPODataConnectorProfileCredentialsProperty = SAPODataConnectorProfileCredentialsProperty.builder()
     *         .basicAuthCredentials(basicAuthCredentials)
     *         .oAuthCredentials(oAuthCredentials)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty.BasicAuthCredentials`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthCredentials() {
            return null;
        }

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty.OAuthCredentials`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthCredentials() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAPODataConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataConnectorProfileCredentialsProperty> {
            java.lang.Object basicAuthCredentials;
            java.lang.Object oAuthCredentials;

            /**
             * Sets the value of {@link SAPODataConnectorProfileCredentialsProperty#getBasicAuthCredentials}
             * @param basicAuthCredentials `CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty.BasicAuthCredentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthCredentials(java.lang.Object basicAuthCredentials) {
                this.basicAuthCredentials = basicAuthCredentials;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfileCredentialsProperty#getOAuthCredentials}
             * @param oAuthCredentials `CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty.OAuthCredentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthCredentials(java.lang.Object oAuthCredentials) {
                this.oAuthCredentials = oAuthCredentials;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataConnectorProfileCredentialsProperty {
            private final java.lang.Object basicAuthCredentials;
            private final java.lang.Object oAuthCredentials;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.basicAuthCredentials = software.amazon.jsii.Kernel.get(this, "basicAuthCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuthCredentials = software.amazon.jsii.Kernel.get(this, "oAuthCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.basicAuthCredentials = builder.basicAuthCredentials;
                this.oAuthCredentials = builder.oAuthCredentials;
            }

            @Override
            public final java.lang.Object getBasicAuthCredentials() {
                return this.basicAuthCredentials;
            }

            @Override
            public final java.lang.Object getOAuthCredentials() {
                return this.oAuthCredentials;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBasicAuthCredentials() != null) {
                    data.set("basicAuthCredentials", om.valueToTree(this.getBasicAuthCredentials()));
                }
                if (this.getOAuthCredentials() != null) {
                    data.set("oAuthCredentials", om.valueToTree(this.getOAuthCredentials()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SAPODataConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataConnectorProfileCredentialsProperty.Jsii$Proxy that = (SAPODataConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.basicAuthCredentials != null ? !this.basicAuthCredentials.equals(that.basicAuthCredentials) : that.basicAuthCredentials != null) return false;
                return this.oAuthCredentials != null ? this.oAuthCredentials.equals(that.oAuthCredentials) : that.oAuthCredentials == null;
            }

            @Override
            public final int hashCode() {
                int result = this.basicAuthCredentials != null ? this.basicAuthCredentials.hashCode() : 0;
                result = 31 * result + (this.oAuthCredentials != null ? this.oAuthCredentials.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataConnectorProfilePropertiesProperty sAPODataConnectorProfilePropertiesProperty = SAPODataConnectorProfilePropertiesProperty.builder()
     *         .applicationHostUrl("applicationHostUrl")
     *         .applicationServicePath("applicationServicePath")
     *         .clientNumber("clientNumber")
     *         .logonLanguage("logonLanguage")
     *         .oAuthProperties(OAuthPropertiesProperty.builder()
     *                 .authCodeUrl("authCodeUrl")
     *                 .oAuthScopes(List.of("oAuthScopes"))
     *                 .tokenUrl("tokenUrl")
     *                 .build())
     *         .portNumber(123)
     *         .privateLinkServiceName("privateLinkServiceName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.ApplicationHostUrl`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationHostUrl() {
            return null;
        }

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.ApplicationServicePath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationServicePath() {
            return null;
        }

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.ClientNumber`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientNumber() {
            return null;
        }

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.LogonLanguage`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogonLanguage() {
            return null;
        }

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.OAuthProperties`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuthProperties() {
            return null;
        }

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.PortNumber`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPortNumber() {
            return null;
        }

        /**
         * `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.PrivateLinkServiceName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateLinkServiceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAPODataConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataConnectorProfilePropertiesProperty> {
            java.lang.String applicationHostUrl;
            java.lang.String applicationServicePath;
            java.lang.String clientNumber;
            java.lang.String logonLanguage;
            java.lang.Object oAuthProperties;
            java.lang.Number portNumber;
            java.lang.String privateLinkServiceName;

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getApplicationHostUrl}
             * @param applicationHostUrl `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.ApplicationHostUrl`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationHostUrl(java.lang.String applicationHostUrl) {
                this.applicationHostUrl = applicationHostUrl;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getApplicationServicePath}
             * @param applicationServicePath `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.ApplicationServicePath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationServicePath(java.lang.String applicationServicePath) {
                this.applicationServicePath = applicationServicePath;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getClientNumber}
             * @param clientNumber `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.ClientNumber`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientNumber(java.lang.String clientNumber) {
                this.clientNumber = clientNumber;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getLogonLanguage}
             * @param logonLanguage `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.LogonLanguage`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logonLanguage(java.lang.String logonLanguage) {
                this.logonLanguage = logonLanguage;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getOAuthProperties}
             * @param oAuthProperties `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.OAuthProperties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthProperties(software.amazon.awscdk.services.appflow.CfnConnectorProfile.OAuthPropertiesProperty oAuthProperties) {
                this.oAuthProperties = oAuthProperties;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getOAuthProperties}
             * @param oAuthProperties `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.OAuthProperties`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuthProperties(software.amazon.awscdk.IResolvable oAuthProperties) {
                this.oAuthProperties = oAuthProperties;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getPortNumber}
             * @param portNumber `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.PortNumber`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portNumber(java.lang.Number portNumber) {
                this.portNumber = portNumber;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataConnectorProfilePropertiesProperty#getPrivateLinkServiceName}
             * @param privateLinkServiceName `CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty.PrivateLinkServiceName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateLinkServiceName(java.lang.String privateLinkServiceName) {
                this.privateLinkServiceName = privateLinkServiceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataConnectorProfilePropertiesProperty {
            private final java.lang.String applicationHostUrl;
            private final java.lang.String applicationServicePath;
            private final java.lang.String clientNumber;
            private final java.lang.String logonLanguage;
            private final java.lang.Object oAuthProperties;
            private final java.lang.Number portNumber;
            private final java.lang.String privateLinkServiceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.applicationHostUrl = software.amazon.jsii.Kernel.get(this, "applicationHostUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applicationServicePath = software.amazon.jsii.Kernel.get(this, "applicationServicePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientNumber = software.amazon.jsii.Kernel.get(this, "clientNumber", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logonLanguage = software.amazon.jsii.Kernel.get(this, "logonLanguage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oAuthProperties = software.amazon.jsii.Kernel.get(this, "oAuthProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.portNumber = software.amazon.jsii.Kernel.get(this, "portNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.privateLinkServiceName = software.amazon.jsii.Kernel.get(this, "privateLinkServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.applicationHostUrl = builder.applicationHostUrl;
                this.applicationServicePath = builder.applicationServicePath;
                this.clientNumber = builder.clientNumber;
                this.logonLanguage = builder.logonLanguage;
                this.oAuthProperties = builder.oAuthProperties;
                this.portNumber = builder.portNumber;
                this.privateLinkServiceName = builder.privateLinkServiceName;
            }

            @Override
            public final java.lang.String getApplicationHostUrl() {
                return this.applicationHostUrl;
            }

            @Override
            public final java.lang.String getApplicationServicePath() {
                return this.applicationServicePath;
            }

            @Override
            public final java.lang.String getClientNumber() {
                return this.clientNumber;
            }

            @Override
            public final java.lang.String getLogonLanguage() {
                return this.logonLanguage;
            }

            @Override
            public final java.lang.Object getOAuthProperties() {
                return this.oAuthProperties;
            }

            @Override
            public final java.lang.Number getPortNumber() {
                return this.portNumber;
            }

            @Override
            public final java.lang.String getPrivateLinkServiceName() {
                return this.privateLinkServiceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getApplicationHostUrl() != null) {
                    data.set("applicationHostUrl", om.valueToTree(this.getApplicationHostUrl()));
                }
                if (this.getApplicationServicePath() != null) {
                    data.set("applicationServicePath", om.valueToTree(this.getApplicationServicePath()));
                }
                if (this.getClientNumber() != null) {
                    data.set("clientNumber", om.valueToTree(this.getClientNumber()));
                }
                if (this.getLogonLanguage() != null) {
                    data.set("logonLanguage", om.valueToTree(this.getLogonLanguage()));
                }
                if (this.getOAuthProperties() != null) {
                    data.set("oAuthProperties", om.valueToTree(this.getOAuthProperties()));
                }
                if (this.getPortNumber() != null) {
                    data.set("portNumber", om.valueToTree(this.getPortNumber()));
                }
                if (this.getPrivateLinkServiceName() != null) {
                    data.set("privateLinkServiceName", om.valueToTree(this.getPrivateLinkServiceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SAPODataConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataConnectorProfilePropertiesProperty.Jsii$Proxy that = (SAPODataConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (this.applicationHostUrl != null ? !this.applicationHostUrl.equals(that.applicationHostUrl) : that.applicationHostUrl != null) return false;
                if (this.applicationServicePath != null ? !this.applicationServicePath.equals(that.applicationServicePath) : that.applicationServicePath != null) return false;
                if (this.clientNumber != null ? !this.clientNumber.equals(that.clientNumber) : that.clientNumber != null) return false;
                if (this.logonLanguage != null ? !this.logonLanguage.equals(that.logonLanguage) : that.logonLanguage != null) return false;
                if (this.oAuthProperties != null ? !this.oAuthProperties.equals(that.oAuthProperties) : that.oAuthProperties != null) return false;
                if (this.portNumber != null ? !this.portNumber.equals(that.portNumber) : that.portNumber != null) return false;
                return this.privateLinkServiceName != null ? this.privateLinkServiceName.equals(that.privateLinkServiceName) : that.privateLinkServiceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.applicationHostUrl != null ? this.applicationHostUrl.hashCode() : 0;
                result = 31 * result + (this.applicationServicePath != null ? this.applicationServicePath.hashCode() : 0);
                result = 31 * result + (this.clientNumber != null ? this.clientNumber.hashCode() : 0);
                result = 31 * result + (this.logonLanguage != null ? this.logonLanguage.hashCode() : 0);
                result = 31 * result + (this.oAuthProperties != null ? this.oAuthProperties.hashCode() : 0);
                result = 31 * result + (this.portNumber != null ? this.portNumber.hashCode() : 0);
                result = 31 * result + (this.privateLinkServiceName != null ? this.privateLinkServiceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `SalesforceConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using Salesforce.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SalesforceConnectorProfileCredentialsProperty salesforceConnectorProfileCredentialsProperty = SalesforceConnectorProfileCredentialsProperty.builder()
     *         .accessToken("accessToken")
     *         .clientCredentialsArn("clientCredentialsArn")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The credentials used to access protected Salesforce resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * The secret manager ARN, which contains the client ID and client secret of the connected app.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientCredentialsArn() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * The credentials used to acquire new access tokens.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRefreshToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceConnectorProfileCredentialsProperty> {
            java.lang.String accessToken;
            java.lang.String clientCredentialsArn;
            java.lang.Object connectorOAuthRequest;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Salesforce resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getClientCredentialsArn}
             * @param clientCredentialsArn The secret manager ARN, which contains the client ID and client secret of the connected app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientCredentialsArn(java.lang.String clientCredentialsArn) {
                this.clientCredentialsArn = clientCredentialsArn;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfileCredentialsProperty#getRefreshToken}
             * @param refreshToken The credentials used to acquire new access tokens.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceConnectorProfileCredentialsProperty {
            private final java.lang.String accessToken;
            private final java.lang.String clientCredentialsArn;
            private final java.lang.Object connectorOAuthRequest;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientCredentialsArn = software.amazon.jsii.Kernel.get(this, "clientCredentialsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accessToken = builder.accessToken;
                this.clientCredentialsArn = builder.clientCredentialsArn;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
                this.refreshToken = builder.refreshToken;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.String getClientCredentialsArn() {
                return this.clientCredentialsArn;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getClientCredentialsArn() != null) {
                    data.set("clientCredentialsArn", om.valueToTree(this.getClientCredentialsArn()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }
                if (this.getRefreshToken() != null) {
                    data.set("refreshToken", om.valueToTree(this.getRefreshToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceConnectorProfileCredentialsProperty.Jsii$Proxy that = (SalesforceConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                if (this.clientCredentialsArn != null ? !this.clientCredentialsArn.equals(that.clientCredentialsArn) : that.clientCredentialsArn != null) return false;
                if (this.connectorOAuthRequest != null ? !this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest != null) return false;
                return this.refreshToken != null ? this.refreshToken.equals(that.refreshToken) : that.refreshToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
                result = 31 * result + (this.clientCredentialsArn != null ? this.clientCredentialsArn.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `SalesforceConnectorProfileProperties` property type specifies the connector-specific profile properties required when using Salesforce.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SalesforceConnectorProfilePropertiesProperty salesforceConnectorProfilePropertiesProperty = SalesforceConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .isSandboxEnvironment(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Salesforce resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceUrl() {
            return null;
        }

        /**
         * Indicates whether the connector profile applies to a sandbox or production environment.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsSandboxEnvironment() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;
            java.lang.Object isSandboxEnvironment;

            /**
             * Sets the value of {@link SalesforceConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Salesforce resource.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfilePropertiesProperty#getIsSandboxEnvironment}
             * @param isSandboxEnvironment Indicates whether the connector profile applies to a sandbox or production environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSandboxEnvironment(java.lang.Boolean isSandboxEnvironment) {
                this.isSandboxEnvironment = isSandboxEnvironment;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceConnectorProfilePropertiesProperty#getIsSandboxEnvironment}
             * @param isSandboxEnvironment Indicates whether the connector profile applies to a sandbox or production environment.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isSandboxEnvironment(software.amazon.awscdk.IResolvable isSandboxEnvironment) {
                this.isSandboxEnvironment = isSandboxEnvironment;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;
            private final java.lang.Object isSandboxEnvironment;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.isSandboxEnvironment = software.amazon.jsii.Kernel.get(this, "isSandboxEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = builder.instanceUrl;
                this.isSandboxEnvironment = builder.isSandboxEnvironment;
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            public final java.lang.Object getIsSandboxEnvironment() {
                return this.isSandboxEnvironment;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInstanceUrl() != null) {
                    data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));
                }
                if (this.getIsSandboxEnvironment() != null) {
                    data.set("isSandboxEnvironment", om.valueToTree(this.getIsSandboxEnvironment()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SalesforceConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceConnectorProfilePropertiesProperty.Jsii$Proxy that = (SalesforceConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (this.instanceUrl != null ? !this.instanceUrl.equals(that.instanceUrl) : that.instanceUrl != null) return false;
                return this.isSandboxEnvironment != null ? this.isSandboxEnvironment.equals(that.isSandboxEnvironment) : that.isSandboxEnvironment == null;
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl != null ? this.instanceUrl.hashCode() : 0;
                result = 31 * result + (this.isSandboxEnvironment != null ? this.isSandboxEnvironment.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ServiceNowConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using ServiceNow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ServiceNowConnectorProfileCredentialsProperty serviceNowConnectorProfileCredentialsProperty = ServiceNowConnectorProfileCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password that corresponds to the user name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The name of the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link ServiceNowConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowConnectorProfileCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link ServiceNowConnectorProfileCredentialsProperty#getPassword}
             * @param password The password that corresponds to the user name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link ServiceNowConnectorProfileCredentialsProperty#getUsername}
             * @param username The name of the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowConnectorProfileCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowConnectorProfileCredentialsProperty.Jsii$Proxy that = (ServiceNowConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }
    /**
     * The `ServiceNowConnectorProfileProperties` property type specifies the connector-specific profile properties required when using ServiceNow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ServiceNowConnectorProfilePropertiesProperty serviceNowConnectorProfilePropertiesProperty = ServiceNowConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the ServiceNow resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link ServiceNowConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link ServiceNowConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the ServiceNow resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ServiceNowConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowConnectorProfilePropertiesProperty.Jsii$Proxy that = (ServiceNowConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The `SingularConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using Singular.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SingularConnectorProfileCredentialsProperty singularConnectorProfileCredentialsProperty = SingularConnectorProfileCredentialsProperty.builder()
     *         .apiKey("apiKey")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SingularConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SingularConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingularConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiKey();

        /**
         * @return a {@link Builder} of {@link SingularConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingularConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingularConnectorProfileCredentialsProperty> {
            java.lang.String apiKey;

            /**
             * Sets the value of {@link SingularConnectorProfileCredentialsProperty#getApiKey}
             * @param apiKey A unique alphanumeric identifier used to authenticate a user, developer, or calling program to your API. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiKey(java.lang.String apiKey) {
                this.apiKey = apiKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingularConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingularConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingularConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingularConnectorProfileCredentialsProperty {
            private final java.lang.String apiKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiKey = software.amazon.jsii.Kernel.get(this, "apiKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiKey = java.util.Objects.requireNonNull(builder.apiKey, "apiKey is required");
            }

            @Override
            public final java.lang.String getApiKey() {
                return this.apiKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiKey", om.valueToTree(this.getApiKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SingularConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingularConnectorProfileCredentialsProperty.Jsii$Proxy that = (SingularConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                return this.apiKey.equals(that.apiKey);
            }

            @Override
            public final int hashCode() {
                int result = this.apiKey.hashCode();
                return result;
            }
        }
    }
    /**
     * The `SlackConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using Slack.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SlackConnectorProfileCredentialsProperty slackConnectorProfileCredentialsProperty = SlackConnectorProfileCredentialsProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         // the properties below are optional
     *         .accessToken("accessToken")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SlackConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlackConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the client.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * The credentials used to access protected Slack resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SlackConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlackConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlackConnectorProfileCredentialsProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String accessToken;
            java.lang.Object connectorOAuthRequest;

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getClientId}
             * @param clientId The identifier for the client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Slack resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link SlackConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlackConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlackConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlackConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlackConnectorProfileCredentialsProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String accessToken;
            private final java.lang.Object connectorOAuthRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.accessToken = builder.accessToken;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlackConnectorProfileCredentialsProperty.Jsii$Proxy that = (SlackConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                return this.connectorOAuthRequest != null ? this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `SlackConnectorProfileProperties` property type specifies the connector-specific profile properties required when using Slack.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SlackConnectorProfilePropertiesProperty slackConnectorProfilePropertiesProperty = SlackConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SlackConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlackConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Slack resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link SlackConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlackConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlackConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link SlackConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Slack resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlackConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlackConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlackConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlackConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SlackConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlackConnectorProfilePropertiesProperty.Jsii$Proxy that = (SlackConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The `SnowflakeConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using Snowflake.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SnowflakeConnectorProfileCredentialsProperty snowflakeConnectorProfileCredentialsProperty = SnowflakeConnectorProfileCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password that corresponds to the user name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The name of the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link SnowflakeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeConnectorProfileCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link SnowflakeConnectorProfileCredentialsProperty#getPassword}
             * @param password The password that corresponds to the user name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfileCredentialsProperty#getUsername}
             * @param username The name of the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeConnectorProfileCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeConnectorProfileCredentialsProperty.Jsii$Proxy that = (SnowflakeConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }
    /**
     * The `SnowflakeConnectorProfileProperties` property type specifies the connector-specific profile properties required when using Snowflake.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SnowflakeConnectorProfilePropertiesProperty snowflakeConnectorProfilePropertiesProperty = SnowflakeConnectorProfilePropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         .stage("stage")
     *         .warehouse("warehouse")
     *         // the properties below are optional
     *         .accountName("accountName")
     *         .bucketPrefix("bucketPrefix")
     *         .privateLinkServiceName("privateLinkServiceName")
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket associated with Snowflake.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account.
         * <p>
         * This is written in the following format: &lt; Database&gt;&lt; Schema&gt;<Stage Name>.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStage();

        /**
         * The name of the Snowflake warehouse.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getWarehouse();

        /**
         * The name of the account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccountName() {
            return null;
        }

        /**
         * The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The Snowflake Private Link service name to be used for private data transfers.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateLinkServiceName() {
            return null;
        }

        /**
         * The AWS Region of the Snowflake account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeConnectorProfilePropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String stage;
            java.lang.String warehouse;
            java.lang.String accountName;
            java.lang.String bucketPrefix;
            java.lang.String privateLinkServiceName;
            java.lang.String region;

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket associated with Snowflake. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getStage}
             * @param stage The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This parameter is required.
             *              This is written in the following format: &lt; Database&gt;&lt; Schema&gt;<Stage Name>.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stage(java.lang.String stage) {
                this.stage = stage;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getWarehouse}
             * @param warehouse The name of the Snowflake warehouse. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warehouse(java.lang.String warehouse) {
                this.warehouse = warehouse;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getAccountName}
             * @param accountName The name of the account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountName(java.lang.String accountName) {
                this.accountName = accountName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getPrivateLinkServiceName}
             * @param privateLinkServiceName The Snowflake Private Link service name to be used for private data transfers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateLinkServiceName(java.lang.String privateLinkServiceName) {
                this.privateLinkServiceName = privateLinkServiceName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeConnectorProfilePropertiesProperty#getRegion}
             * @param region The AWS Region of the Snowflake account.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeConnectorProfilePropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String stage;
            private final java.lang.String warehouse;
            private final java.lang.String accountName;
            private final java.lang.String bucketPrefix;
            private final java.lang.String privateLinkServiceName;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stage = software.amazon.jsii.Kernel.get(this, "stage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.warehouse = software.amazon.jsii.Kernel.get(this, "warehouse", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accountName = software.amazon.jsii.Kernel.get(this, "accountName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateLinkServiceName = software.amazon.jsii.Kernel.get(this, "privateLinkServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.stage = java.util.Objects.requireNonNull(builder.stage, "stage is required");
                this.warehouse = java.util.Objects.requireNonNull(builder.warehouse, "warehouse is required");
                this.accountName = builder.accountName;
                this.bucketPrefix = builder.bucketPrefix;
                this.privateLinkServiceName = builder.privateLinkServiceName;
                this.region = builder.region;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getStage() {
                return this.stage;
            }

            @Override
            public final java.lang.String getWarehouse() {
                return this.warehouse;
            }

            @Override
            public final java.lang.String getAccountName() {
                return this.accountName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.String getPrivateLinkServiceName() {
                return this.privateLinkServiceName;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("stage", om.valueToTree(this.getStage()));
                data.set("warehouse", om.valueToTree(this.getWarehouse()));
                if (this.getAccountName() != null) {
                    data.set("accountName", om.valueToTree(this.getAccountName()));
                }
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getPrivateLinkServiceName() != null) {
                    data.set("privateLinkServiceName", om.valueToTree(this.getPrivateLinkServiceName()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.SnowflakeConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeConnectorProfilePropertiesProperty.Jsii$Proxy that = (SnowflakeConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!stage.equals(that.stage)) return false;
                if (!warehouse.equals(that.warehouse)) return false;
                if (this.accountName != null ? !this.accountName.equals(that.accountName) : that.accountName != null) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                if (this.privateLinkServiceName != null ? !this.privateLinkServiceName.equals(that.privateLinkServiceName) : that.privateLinkServiceName != null) return false;
                return this.region != null ? this.region.equals(that.region) : that.region == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.stage.hashCode());
                result = 31 * result + (this.warehouse.hashCode());
                result = 31 * result + (this.accountName != null ? this.accountName.hashCode() : 0);
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.privateLinkServiceName != null ? this.privateLinkServiceName.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `TrendmicroConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using Trend Micro.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TrendmicroConnectorProfileCredentialsProperty trendmicroConnectorProfileCredentialsProperty = TrendmicroConnectorProfileCredentialsProperty.builder()
     *         .apiSecretKey("apiSecretKey")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(TrendmicroConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrendmicroConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Secret Access Key portion of the credentials.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiSecretKey();

        /**
         * @return a {@link Builder} of {@link TrendmicroConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrendmicroConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrendmicroConnectorProfileCredentialsProperty> {
            java.lang.String apiSecretKey;

            /**
             * Sets the value of {@link TrendmicroConnectorProfileCredentialsProperty#getApiSecretKey}
             * @param apiSecretKey The Secret Access Key portion of the credentials. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiSecretKey(java.lang.String apiSecretKey) {
                this.apiSecretKey = apiSecretKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrendmicroConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrendmicroConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrendmicroConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrendmicroConnectorProfileCredentialsProperty {
            private final java.lang.String apiSecretKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiSecretKey = software.amazon.jsii.Kernel.get(this, "apiSecretKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiSecretKey = java.util.Objects.requireNonNull(builder.apiSecretKey, "apiSecretKey is required");
            }

            @Override
            public final java.lang.String getApiSecretKey() {
                return this.apiSecretKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiSecretKey", om.valueToTree(this.getApiSecretKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.TrendmicroConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrendmicroConnectorProfileCredentialsProperty.Jsii$Proxy that = (TrendmicroConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                return this.apiSecretKey.equals(that.apiSecretKey);
            }

            @Override
            public final int hashCode() {
                int result = this.apiSecretKey.hashCode();
                return result;
            }
        }
    }
    /**
     * The `VeevaConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using Veeva.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * VeevaConnectorProfileCredentialsProperty veevaConnectorProfileCredentialsProperty = VeevaConnectorProfileCredentialsProperty.builder()
     *         .password("password")
     *         .username("username")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(VeevaConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VeevaConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password that corresponds to the user name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The name of the user.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * @return a {@link Builder} of {@link VeevaConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VeevaConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VeevaConnectorProfileCredentialsProperty> {
            java.lang.String password;
            java.lang.String username;

            /**
             * Sets the value of {@link VeevaConnectorProfileCredentialsProperty#getPassword}
             * @param password The password that corresponds to the user name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link VeevaConnectorProfileCredentialsProperty#getUsername}
             * @param username The name of the user. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VeevaConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VeevaConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VeevaConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VeevaConnectorProfileCredentialsProperty {
            private final java.lang.String password;
            private final java.lang.String username;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VeevaConnectorProfileCredentialsProperty.Jsii$Proxy that = (VeevaConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                return this.username.equals(that.username);
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                return result;
            }
        }
    }
    /**
     * The `VeevaConnectorProfileProperties` property type specifies the connector-specific profile properties required when using Veeva.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * VeevaConnectorProfilePropertiesProperty veevaConnectorProfilePropertiesProperty = VeevaConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(VeevaConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VeevaConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Veeva resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link VeevaConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VeevaConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VeevaConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link VeevaConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Veeva resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VeevaConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VeevaConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VeevaConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VeevaConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.VeevaConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VeevaConnectorProfilePropertiesProperty.Jsii$Proxy that = (VeevaConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }
    /**
     * The `ZendeskConnectorProfileCredentials` property type specifies the connector-specific profile credentials required when using Zendesk.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ZendeskConnectorProfileCredentialsProperty zendeskConnectorProfileCredentialsProperty = ZendeskConnectorProfileCredentialsProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         // the properties below are optional
     *         .accessToken("accessToken")
     *         .connectorOAuthRequest(ConnectorOAuthRequestProperty.builder()
     *                 .authCode("authCode")
     *                 .redirectUri("redirectUri")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskConnectorProfileCredentialsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskConnectorProfileCredentialsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the desired client.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * The credentials used to access protected Zendesk resources.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAccessToken() {
            return null;
        }

        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOAuthRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZendeskConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskConnectorProfileCredentialsProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String accessToken;
            java.lang.Object connectorOAuthRequest;

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getClientId}
             * @param clientId The identifier for the desired client. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getClientSecret}
             * @param clientSecret The client secret used by the OAuth client to authenticate to the authorization server. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getAccessToken}
             * @param accessToken The credentials used to access protected Zendesk resources.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accessToken(java.lang.String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskConnectorProfileCredentialsProperty#getConnectorOAuthRequest}
             * @param connectorOAuthRequest Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOAuthRequest(software.amazon.awscdk.IResolvable connectorOAuthRequest) {
                this.connectorOAuthRequest = connectorOAuthRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskConnectorProfileCredentialsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskConnectorProfileCredentialsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskConnectorProfileCredentialsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskConnectorProfileCredentialsProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String accessToken;
            private final java.lang.Object connectorOAuthRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.accessToken = software.amazon.jsii.Kernel.get(this, "accessToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOAuthRequest = software.amazon.jsii.Kernel.get(this, "connectorOAuthRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.accessToken = builder.accessToken;
                this.connectorOAuthRequest = builder.connectorOAuthRequest;
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getAccessToken() {
                return this.accessToken;
            }

            @Override
            public final java.lang.Object getConnectorOAuthRequest() {
                return this.connectorOAuthRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                if (this.getAccessToken() != null) {
                    data.set("accessToken", om.valueToTree(this.getAccessToken()));
                }
                if (this.getConnectorOAuthRequest() != null) {
                    data.set("connectorOAuthRequest", om.valueToTree(this.getConnectorOAuthRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskConnectorProfileCredentialsProperty.Jsii$Proxy that = (ZendeskConnectorProfileCredentialsProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) return false;
                return this.connectorOAuthRequest != null ? this.connectorOAuthRequest.equals(that.connectorOAuthRequest) : that.connectorOAuthRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
                result = 31 * result + (this.connectorOAuthRequest != null ? this.connectorOAuthRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `ZendeskConnectorProfileProperties` property type specifies the connector-specific profile properties required when using Zendesk.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ZendeskConnectorProfilePropertiesProperty zendeskConnectorProfilePropertiesProperty = ZendeskConnectorProfilePropertiesProperty.builder()
     *         .instanceUrl("instanceUrl")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskConnectorProfilePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskConnectorProfilePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location of the Zendesk resource.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceUrl();

        /**
         * @return a {@link Builder} of {@link ZendeskConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskConnectorProfilePropertiesProperty> {
            java.lang.String instanceUrl;

            /**
             * Sets the value of {@link ZendeskConnectorProfilePropertiesProperty#getInstanceUrl}
             * @param instanceUrl The location of the Zendesk resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceUrl(java.lang.String instanceUrl) {
                this.instanceUrl = instanceUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskConnectorProfilePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskConnectorProfilePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskConnectorProfilePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskConnectorProfilePropertiesProperty {
            private final java.lang.String instanceUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.instanceUrl = software.amazon.jsii.Kernel.get(this, "instanceUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.instanceUrl = java.util.Objects.requireNonNull(builder.instanceUrl, "instanceUrl is required");
            }

            @Override
            public final java.lang.String getInstanceUrl() {
                return this.instanceUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("instanceUrl", om.valueToTree(this.getInstanceUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnConnectorProfile.ZendeskConnectorProfilePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskConnectorProfilePropertiesProperty.Jsii$Proxy that = (ZendeskConnectorProfilePropertiesProperty.Jsii$Proxy) o;

                return this.instanceUrl.equals(that.instanceUrl);
            }

            @Override
            public final int hashCode() {
                int result = this.instanceUrl.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appflow.CfnConnectorProfile}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appflow.CfnConnectorProfile> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appflow.CfnConnectorProfileProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appflow.CfnConnectorProfileProps.Builder();
        }

        /**
         * Indicates the connection mode and if it is public or private.
         * <p>
         * @return {@code this}
         * @param connectionMode Indicates the connection mode and if it is public or private. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionMode(final java.lang.String connectionMode) {
            this.props.connectionMode(connectionMode);
            return this;
        }

        /**
         * The name of the connector profile.
         * <p>
         * The name is unique for each <code>ConnectorProfile</code> in the AWS account .
         * <p>
         * @return {@code this}
         * @param connectorProfileName The name of the connector profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileName(final java.lang.String connectorProfileName) {
            this.props.connectorProfileName(connectorProfileName);
            return this;
        }

        /**
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * <p>
         * @return {@code this}
         * @param connectorType The type of connector, such as Salesforce, Amplitude, and so on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorType(final java.lang.String connectorType) {
            this.props.connectorType(connectorType);
            return this;
        }

        /**
         * Defines the connector-specific configuration and credentials.
         * <p>
         * @return {@code this}
         * @param connectorProfileConfig Defines the connector-specific configuration and credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileConfig(final software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorProfileConfigProperty connectorProfileConfig) {
            this.props.connectorProfileConfig(connectorProfileConfig);
            return this;
        }
        /**
         * Defines the connector-specific configuration and credentials.
         * <p>
         * @return {@code this}
         * @param connectorProfileConfig Defines the connector-specific configuration and credentials. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorProfileConfig(final software.amazon.awscdk.IResolvable connectorProfileConfig) {
            this.props.connectorProfileConfig(connectorProfileConfig);
            return this;
        }

        /**
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         * <p>
         * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * <p>
         * @return {@code this}
         * @param kmsArn The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsArn(final java.lang.String kmsArn) {
            this.props.kmsArn(kmsArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appflow.CfnConnectorProfile}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appflow.CfnConnectorProfile build() {
            return new software.amazon.awscdk.services.appflow.CfnConnectorProfile(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
