package software.amazon.awscdk.services.appmesh;

/**
 * Supported values for matching routes based on the HTTP request method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-http2", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.http2(HttpRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder()
 *                         .virtualNode(node)
 *                         .build()))
 *                 .match(HttpRouteMatch.builder()
 *                         .path(HttpRoutePathMatch.exactly("/exact"))
 *                         .method(HttpRouteMethod.POST)
 *                         .protocol(HttpRouteProtocol.HTTPS)
 *                         .headers(List.of(HeaderMatch.valueIs("Content-Type", "application/json"), HeaderMatch.valueIsNot("Content-Type", "application/json")))
 *                         .queryParameters(List.of(QueryParameterMatch.valueIs("query-field", "value")))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.733Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpRouteMethod")
public enum HttpRouteMethod {
    /**
     * GET request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GET,
    /**
     * HEAD request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HEAD,
    /**
     * POST request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    POST,
    /**
     * PUT request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PUT,
    /**
     * DELETE request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELETE,
    /**
     * CONNECT request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONNECT,
    /**
     * OPTIONS request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONS,
    /**
     * TRACE request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRACE,
    /**
     * PATCH request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PATCH,
}
