package software.amazon.awscdk.services.appmesh;

/**
 * Defines the TLS Validation Context Trust.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Mesh mesh;
 * Service service;
 * VirtualNode node = VirtualNode.Builder.create(this, "node")
 *         .mesh(mesh)
 *         .serviceDiscovery(ServiceDiscovery.cloudMap(service))
 *         .listeners(List.of(VirtualNodeListener.http(HttpVirtualNodeListenerOptions.builder()
 *                 .port(8080)
 *                 .healthCheck(HealthCheck.http(HttpHealthCheckOptions.builder()
 *                         .healthyThreshold(3)
 *                         .interval(Duration.seconds(5))
 *                         .path("/ping")
 *                         .timeout(Duration.seconds(2))
 *                         .unhealthyThreshold(2)
 *                         .build()))
 *                 .timeout(HttpTimeout.builder()
 *                         .idle(Duration.seconds(5))
 *                         .build())
 *                 .build())))
 *         .backendDefaults(BackendDefaults.builder()
 *                 .tlsClientPolicy(TlsClientPolicy.builder()
 *                         .validation(TlsValidation.builder()
 *                                 .trust(TlsValidationTrust.file("/keys/local_cert_chain.pem"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .accessLog(AccessLog.fromFilePath("/dev/stdout"))
 *         .build();
 * Tags.of(node).add("Environment", "Dev");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.754Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.TlsValidationTrust")
public abstract class TlsValidationTrust extends software.amazon.jsii.JsiiObject {

    protected TlsValidationTrust(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TlsValidationTrust(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected TlsValidationTrust() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * TLS Validation Context Trust for ACM Private Certificate Authority (CA).
     * <p>
     * @param certificateAuthorities This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsValidationTrust acm(final @org.jetbrains.annotations.NotNull java.util.List<? extends software.amazon.awscdk.services.acmpca.ICertificateAuthority> certificateAuthorities) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.TlsValidationTrust.class, "acm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsValidationTrust.class), new Object[] { java.util.Objects.requireNonNull(certificateAuthorities, "certificateAuthorities is required") });
    }

    /**
     * Tells envoy where to fetch the validation context from.
     * <p>
     * @param certificateChain This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.MutualTlsValidationTrust file(final @org.jetbrains.annotations.NotNull java.lang.String certificateChain) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.TlsValidationTrust.class, "file", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.MutualTlsValidationTrust.class), new Object[] { java.util.Objects.requireNonNull(certificateChain, "certificateChain is required") });
    }

    /**
     * TLS Validation Context Trust for Envoy' service discovery service.
     * <p>
     * @param secretName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.MutualTlsValidationTrust sds(final @org.jetbrains.annotations.NotNull java.lang.String secretName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.TlsValidationTrust.class, "sds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.MutualTlsValidationTrust.class), new Object[] { java.util.Objects.requireNonNull(secretName, "secretName is required") });
    }

    /**
     * Returns Trust context based on trust type.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsValidationTrustConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.TlsValidationTrust {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns Trust context based on trust type.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.TlsValidationTrustConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TlsValidationTrustConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
