package software.amazon.awscdk.services.appsync;

/**
 * A CloudFormation `AWS::AppSync::FunctionConfiguration`.
 * <p>
 * The <code>AWS::AppSync::FunctionConfiguration</code> resource defines the functions in GraphQL APIs to perform certain operations. You can use pipeline resolvers to attach functions. For more information, see <a href="https://docs.aws.amazon.com/appsync/latest/devguide/pipeline-resolvers.html">Pipeline Resolvers</a> in the <em>AWS AppSync Developer Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * When you submit an update, AWS CloudFormation updates resources based on differences between what you submit and the stack's current template. To cause this resource to be updated you must change a property value for this resource in the AWS CloudFormation template. Changing the Amazon S3 file content without changing a property value will not result in an update operation.
 * <p>
 * See <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html">Update Behaviors of Stack Resources</a> in the <em>AWS CloudFormation User Guide</em> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnFunctionConfiguration cfnFunctionConfiguration = CfnFunctionConfiguration.Builder.create(this, "MyCfnFunctionConfiguration")
 *         .apiId("apiId")
 *         .dataSourceName("dataSourceName")
 *         .functionVersion("functionVersion")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .maxBatchSize(123)
 *         .requestMappingTemplate("requestMappingTemplate")
 *         .requestMappingTemplateS3Location("requestMappingTemplateS3Location")
 *         .responseMappingTemplate("responseMappingTemplate")
 *         .responseMappingTemplateS3Location("responseMappingTemplateS3Location")
 *         .syncConfig(SyncConfigProperty.builder()
 *                 .conflictDetection("conflictDetection")
 *                 // the properties below are optional
 *                 .conflictHandler("conflictHandler")
 *                 .lambdaConflictHandlerConfig(LambdaConflictHandlerConfigProperty.builder()
 *                         .lambdaConflictHandlerArn("lambdaConflictHandlerArn")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.833Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnFunctionConfiguration")
public class CfnFunctionConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnFunctionConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFunctionConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appsync.CfnFunctionConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AppSync::FunctionConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFunctionConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CfnFunctionConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The name of data source this function will attach.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDataSourceName() {
        return software.amazon.jsii.Kernel.get(this, "attrDataSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * ARN of the function, such as `arn:aws:appsync:us-east-1:123456789012:apis/graphqlapiid/functions/functionId` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of this function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFunctionId() {
        return software.amazon.jsii.Kernel.get(this, "attrFunctionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The AWS AppSync GraphQL API that you want to attach using this function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS AppSync GraphQL API that you want to attach using this function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "apiId", java.util.Objects.requireNonNull(value, "apiId is required"));
    }

    /**
     * The name of data source this function will attach.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataSourceName() {
        return software.amazon.jsii.Kernel.get(this, "dataSourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of data source this function will attach.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSourceName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataSourceName", java.util.Objects.requireNonNull(value, "dataSourceName is required"));
    }

    /**
     * The version of the request mapping template.
     * <p>
     * Currently, only the 2018-05-29 version of the template is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionVersion() {
        return software.amazon.jsii.Kernel.get(this, "functionVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the request mapping template.
     * <p>
     * Currently, only the 2018-05-29 version of the template is supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "functionVersion", java.util.Objects.requireNonNull(value, "functionVersion is required"));
    }

    /**
     * The name of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The `Function` description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The `Function` description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a `BatchInvoke` operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxBatchSize() {
        return software.amazon.jsii.Kernel.get(this, "maxBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a `BatchInvoke` operation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxBatchSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxBatchSize", value);
    }

    /**
     * The `Function` request mapping template.
     * <p>
     * Functions support only the 2018-05-29 version of the request mapping template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRequestMappingTemplate() {
        return software.amazon.jsii.Kernel.get(this, "requestMappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The `Function` request mapping template.
     * <p>
     * Functions support only the 2018-05-29 version of the request mapping template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestMappingTemplate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "requestMappingTemplate", value);
    }

    /**
     * Describes a Sync configuration for a resolver.
     * <p>
     * Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRequestMappingTemplateS3Location() {
        return software.amazon.jsii.Kernel.get(this, "requestMappingTemplateS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Describes a Sync configuration for a resolver.
     * <p>
     * Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestMappingTemplateS3Location(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "requestMappingTemplateS3Location", value);
    }

    /**
     * The `Function` response mapping template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResponseMappingTemplate() {
        return software.amazon.jsii.Kernel.get(this, "responseMappingTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The `Function` response mapping template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseMappingTemplate(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "responseMappingTemplate", value);
    }

    /**
     * The location of a response mapping template in an Amazon S3 bucket.
     * <p>
     * Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getResponseMappingTemplateS3Location() {
        return software.amazon.jsii.Kernel.get(this, "responseMappingTemplateS3Location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location of a response mapping template in an Amazon S3 bucket.
     * <p>
     * Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseMappingTemplateS3Location(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "responseMappingTemplateS3Location", value);
    }

    /**
     * Describes a Sync configuration for a resolver.
     * <p>
     * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSyncConfig() {
        return software.amazon.jsii.Kernel.get(this, "syncConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes a Sync configuration for a resolver.
     * <p>
     * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.CfnFunctionConfiguration.SyncConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "syncConfig", value);
    }

    /**
     * Describes a Sync configuration for a resolver.
     * <p>
     * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSyncConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "syncConfig", value);
    }
    /**
     * The `LambdaConflictHandlerConfig` object when configuring `LAMBDA` as the Conflict Handler.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * LambdaConflictHandlerConfigProperty lambdaConflictHandlerConfigProperty = LambdaConflictHandlerConfigProperty.builder()
     *         .lambdaConflictHandlerArn("lambdaConflictHandlerArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnFunctionConfiguration.LambdaConflictHandlerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaConflictHandlerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaConflictHandlerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaConflictHandlerArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaConflictHandlerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaConflictHandlerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaConflictHandlerConfigProperty> {
            java.lang.String lambdaConflictHandlerArn;

            /**
             * Sets the value of {@link LambdaConflictHandlerConfigProperty#getLambdaConflictHandlerArn}
             * @param lambdaConflictHandlerArn The Amazon Resource Name (ARN) for the Lambda function to use as the Conflict Handler.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaConflictHandlerArn(java.lang.String lambdaConflictHandlerArn) {
                this.lambdaConflictHandlerArn = lambdaConflictHandlerArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaConflictHandlerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaConflictHandlerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaConflictHandlerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaConflictHandlerConfigProperty {
            private final java.lang.String lambdaConflictHandlerArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaConflictHandlerArn = software.amazon.jsii.Kernel.get(this, "lambdaConflictHandlerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaConflictHandlerArn = builder.lambdaConflictHandlerArn;
            }

            @Override
            public final java.lang.String getLambdaConflictHandlerArn() {
                return this.lambdaConflictHandlerArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLambdaConflictHandlerArn() != null) {
                    data.set("lambdaConflictHandlerArn", om.valueToTree(this.getLambdaConflictHandlerArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnFunctionConfiguration.LambdaConflictHandlerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaConflictHandlerConfigProperty.Jsii$Proxy that = (LambdaConflictHandlerConfigProperty.Jsii$Proxy) o;

                return this.lambdaConflictHandlerArn != null ? this.lambdaConflictHandlerArn.equals(that.lambdaConflictHandlerArn) : that.lambdaConflictHandlerArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaConflictHandlerArn != null ? this.lambdaConflictHandlerArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Describes a Sync configuration for a resolver.
     * <p>
     * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appsync.*;
     * SyncConfigProperty syncConfigProperty = SyncConfigProperty.builder()
     *         .conflictDetection("conflictDetection")
     *         // the properties below are optional
     *         .conflictHandler("conflictHandler")
     *         .lambdaConflictHandlerConfig(LambdaConflictHandlerConfigProperty.builder()
     *                 .lambdaConflictHandlerArn("lambdaConflictHandlerArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.CfnFunctionConfiguration.SyncConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SyncConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SyncConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Conflict Detection strategy to use.
         * <p>
         * <ul>
         * <li><em>VERSION</em> : Detect conflicts based on object versions for this resolver.</li>
         * <li><em>NONE</em> : Do not detect conflicts when invoking this resolver.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConflictDetection();

        /**
         * The Conflict Resolution strategy to perform in the event of a conflict.
         * <p>
         * <ul>
         * <li><em>OPTIMISTIC_CONCURRENCY</em> : Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.</li>
         * <li><em>AUTOMERGE</em> : Resolve conflicts with the Automerge conflict resolution strategy.</li>
         * <li><em>LAMBDA</em> : Resolve conflicts with an AWS Lambda function supplied in the <code>LambdaConflictHandlerConfig</code> .</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConflictHandler() {
            return null;
        }

        /**
         * The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConflictHandlerConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SyncConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SyncConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SyncConfigProperty> {
            java.lang.String conflictDetection;
            java.lang.String conflictHandler;
            java.lang.Object lambdaConflictHandlerConfig;

            /**
             * Sets the value of {@link SyncConfigProperty#getConflictDetection}
             * @param conflictDetection The Conflict Detection strategy to use. This parameter is required.
             *                          <ul>
             *                          <li><em>VERSION</em> : Detect conflicts based on object versions for this resolver.</li>
             *                          <li><em>NONE</em> : Do not detect conflicts when invoking this resolver.</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conflictDetection(java.lang.String conflictDetection) {
                this.conflictDetection = conflictDetection;
                return this;
            }

            /**
             * Sets the value of {@link SyncConfigProperty#getConflictHandler}
             * @param conflictHandler The Conflict Resolution strategy to perform in the event of a conflict.
             *                        <ul>
             *                        <li><em>OPTIMISTIC_CONCURRENCY</em> : Resolve conflicts by rejecting mutations when versions don't match the latest version at the server.</li>
             *                        <li><em>AUTOMERGE</em> : Resolve conflicts with the Automerge conflict resolution strategy.</li>
             *                        <li><em>LAMBDA</em> : Resolve conflicts with an AWS Lambda function supplied in the <code>LambdaConflictHandlerConfig</code> .</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conflictHandler(java.lang.String conflictHandler) {
                this.conflictHandler = conflictHandler;
                return this;
            }

            /**
             * Sets the value of {@link SyncConfigProperty#getLambdaConflictHandlerConfig}
             * @param lambdaConflictHandlerConfig The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaConflictHandlerConfig(software.amazon.awscdk.services.appsync.CfnFunctionConfiguration.LambdaConflictHandlerConfigProperty lambdaConflictHandlerConfig) {
                this.lambdaConflictHandlerConfig = lambdaConflictHandlerConfig;
                return this;
            }

            /**
             * Sets the value of {@link SyncConfigProperty#getLambdaConflictHandlerConfig}
             * @param lambdaConflictHandlerConfig The `LambdaConflictHandlerConfig` when configuring `LAMBDA` as the Conflict Handler.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaConflictHandlerConfig(software.amazon.awscdk.IResolvable lambdaConflictHandlerConfig) {
                this.lambdaConflictHandlerConfig = lambdaConflictHandlerConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SyncConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SyncConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SyncConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SyncConfigProperty {
            private final java.lang.String conflictDetection;
            private final java.lang.String conflictHandler;
            private final java.lang.Object lambdaConflictHandlerConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conflictDetection = software.amazon.jsii.Kernel.get(this, "conflictDetection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.conflictHandler = software.amazon.jsii.Kernel.get(this, "conflictHandler", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.lambdaConflictHandlerConfig = software.amazon.jsii.Kernel.get(this, "lambdaConflictHandlerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conflictDetection = java.util.Objects.requireNonNull(builder.conflictDetection, "conflictDetection is required");
                this.conflictHandler = builder.conflictHandler;
                this.lambdaConflictHandlerConfig = builder.lambdaConflictHandlerConfig;
            }

            @Override
            public final java.lang.String getConflictDetection() {
                return this.conflictDetection;
            }

            @Override
            public final java.lang.String getConflictHandler() {
                return this.conflictHandler;
            }

            @Override
            public final java.lang.Object getLambdaConflictHandlerConfig() {
                return this.lambdaConflictHandlerConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("conflictDetection", om.valueToTree(this.getConflictDetection()));
                if (this.getConflictHandler() != null) {
                    data.set("conflictHandler", om.valueToTree(this.getConflictHandler()));
                }
                if (this.getLambdaConflictHandlerConfig() != null) {
                    data.set("lambdaConflictHandlerConfig", om.valueToTree(this.getLambdaConflictHandlerConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.CfnFunctionConfiguration.SyncConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SyncConfigProperty.Jsii$Proxy that = (SyncConfigProperty.Jsii$Proxy) o;

                if (!conflictDetection.equals(that.conflictDetection)) return false;
                if (this.conflictHandler != null ? !this.conflictHandler.equals(that.conflictHandler) : that.conflictHandler != null) return false;
                return this.lambdaConflictHandlerConfig != null ? this.lambdaConflictHandlerConfig.equals(that.lambdaConflictHandlerConfig) : that.lambdaConflictHandlerConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conflictDetection.hashCode();
                result = 31 * result + (this.conflictHandler != null ? this.conflictHandler.hashCode() : 0);
                result = 31 * result + (this.lambdaConflictHandlerConfig != null ? this.lambdaConflictHandlerConfig.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.CfnFunctionConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.CfnFunctionConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.CfnFunctionConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.CfnFunctionConfigurationProps.Builder();
        }

        /**
         * The AWS AppSync GraphQL API that you want to attach using this function.
         * <p>
         * @return {@code this}
         * @param apiId The AWS AppSync GraphQL API that you want to attach using this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(final java.lang.String apiId) {
            this.props.apiId(apiId);
            return this;
        }

        /**
         * The name of data source this function will attach.
         * <p>
         * @return {@code this}
         * @param dataSourceName The name of data source this function will attach. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceName(final java.lang.String dataSourceName) {
            this.props.dataSourceName(dataSourceName);
            return this;
        }

        /**
         * The version of the request mapping template.
         * <p>
         * Currently, only the 2018-05-29 version of the template is supported.
         * <p>
         * @return {@code this}
         * @param functionVersion The version of the request mapping template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionVersion(final java.lang.String functionVersion) {
            this.props.functionVersion(functionVersion);
            return this;
        }

        /**
         * The name of the function.
         * <p>
         * @return {@code this}
         * @param name The name of the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The `Function` description.
         * <p>
         * @return {@code this}
         * @param description The `Function` description. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a `BatchInvoke` operation.
         * <p>
         * @return {@code this}
         * @param maxBatchSize The maximum number of resolver request inputs that will be sent to a single AWS Lambda function in a `BatchInvoke` operation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchSize(final java.lang.Number maxBatchSize) {
            this.props.maxBatchSize(maxBatchSize);
            return this;
        }

        /**
         * The `Function` request mapping template.
         * <p>
         * Functions support only the 2018-05-29 version of the request mapping template.
         * <p>
         * @return {@code this}
         * @param requestMappingTemplate The `Function` request mapping template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplate(final java.lang.String requestMappingTemplate) {
            this.props.requestMappingTemplate(requestMappingTemplate);
            return this;
        }

        /**
         * Describes a Sync configuration for a resolver.
         * <p>
         * Contains information on which Conflict Detection, as well as Resolution strategy, should be performed when the resolver is invoked.
         * <p>
         * @return {@code this}
         * @param requestMappingTemplateS3Location Describes a Sync configuration for a resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestMappingTemplateS3Location(final java.lang.String requestMappingTemplateS3Location) {
            this.props.requestMappingTemplateS3Location(requestMappingTemplateS3Location);
            return this;
        }

        /**
         * The `Function` response mapping template.
         * <p>
         * @return {@code this}
         * @param responseMappingTemplate The `Function` response mapping template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplate(final java.lang.String responseMappingTemplate) {
            this.props.responseMappingTemplate(responseMappingTemplate);
            return this;
        }

        /**
         * The location of a response mapping template in an Amazon S3 bucket.
         * <p>
         * Use this if you want to provision with a template file in Amazon S3 rather than embedding it in your CloudFormation template.
         * <p>
         * @return {@code this}
         * @param responseMappingTemplateS3Location The location of a response mapping template in an Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseMappingTemplateS3Location(final java.lang.String responseMappingTemplateS3Location) {
            this.props.responseMappingTemplateS3Location(responseMappingTemplateS3Location);
            return this;
        }

        /**
         * Describes a Sync configuration for a resolver.
         * <p>
         * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
         * <p>
         * @return {@code this}
         * @param syncConfig Describes a Sync configuration for a resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncConfig(final software.amazon.awscdk.services.appsync.CfnFunctionConfiguration.SyncConfigProperty syncConfig) {
            this.props.syncConfig(syncConfig);
            return this;
        }
        /**
         * Describes a Sync configuration for a resolver.
         * <p>
         * Specifies which Conflict Detection strategy and Resolution strategy to use when the resolver is invoked.
         * <p>
         * @return {@code this}
         * @param syncConfig Describes a Sync configuration for a resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder syncConfig(final software.amazon.awscdk.IResolvable syncConfig) {
            this.props.syncConfig(syncConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.CfnFunctionConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.CfnFunctionConfiguration build() {
            return new software.amazon.awscdk.services.appsync.CfnFunctionConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
