package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for defining a `CfnAutoScalingGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * CfnAutoScalingGroupProps cfnAutoScalingGroupProps = CfnAutoScalingGroupProps.builder()
 *         .maxSize("maxSize")
 *         .minSize("minSize")
 *         // the properties below are optional
 *         .autoScalingGroupName("autoScalingGroupName")
 *         .availabilityZones(List.of("availabilityZones"))
 *         .capacityRebalance(false)
 *         .context("context")
 *         .cooldown("cooldown")
 *         .desiredCapacity("desiredCapacity")
 *         .desiredCapacityType("desiredCapacityType")
 *         .healthCheckGracePeriod(123)
 *         .healthCheckType("healthCheckType")
 *         .instanceId("instanceId")
 *         .launchConfigurationName("launchConfigurationName")
 *         .launchTemplate(LaunchTemplateSpecificationProperty.builder()
 *                 .version("version")
 *                 // the properties below are optional
 *                 .launchTemplateId("launchTemplateId")
 *                 .launchTemplateName("launchTemplateName")
 *                 .build())
 *         .lifecycleHookSpecificationList(List.of(LifecycleHookSpecificationProperty.builder()
 *                 .lifecycleHookName("lifecycleHookName")
 *                 .lifecycleTransition("lifecycleTransition")
 *                 // the properties below are optional
 *                 .defaultResult("defaultResult")
 *                 .heartbeatTimeout(123)
 *                 .notificationMetadata("notificationMetadata")
 *                 .notificationTargetArn("notificationTargetArn")
 *                 .roleArn("roleArn")
 *                 .build()))
 *         .loadBalancerNames(List.of("loadBalancerNames"))
 *         .maxInstanceLifetime(123)
 *         .metricsCollection(List.of(MetricsCollectionProperty.builder()
 *                 .granularity("granularity")
 *                 // the properties below are optional
 *                 .metrics(List.of("metrics"))
 *                 .build()))
 *         .mixedInstancesPolicy(MixedInstancesPolicyProperty.builder()
 *                 .launchTemplate(LaunchTemplateProperty.builder()
 *                         .launchTemplateSpecification(LaunchTemplateSpecificationProperty.builder()
 *                                 .version("version")
 *                                 // the properties below are optional
 *                                 .launchTemplateId("launchTemplateId")
 *                                 .launchTemplateName("launchTemplateName")
 *                                 .build())
 *                         // the properties below are optional
 *                         .overrides(List.of(LaunchTemplateOverridesProperty.builder()
 *                                 .instanceRequirements(InstanceRequirementsProperty.builder()
 *                                         .acceleratorCount(AcceleratorCountRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .acceleratorManufacturers(List.of("acceleratorManufacturers"))
 *                                         .acceleratorNames(List.of("acceleratorNames"))
 *                                         .acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .acceleratorTypes(List.of("acceleratorTypes"))
 *                                         .bareMetal("bareMetal")
 *                                         .baselineEbsBandwidthMbps(BaselineEbsBandwidthMbpsRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .burstablePerformance("burstablePerformance")
 *                                         .cpuManufacturers(List.of("cpuManufacturers"))
 *                                         .excludedInstanceTypes(List.of("excludedInstanceTypes"))
 *                                         .instanceGenerations(List.of("instanceGenerations"))
 *                                         .localStorage("localStorage")
 *                                         .localStorageTypes(List.of("localStorageTypes"))
 *                                         .memoryGiBPerVCpu(MemoryGiBPerVCpuRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .memoryMiB(MemoryMiBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .networkInterfaceCount(NetworkInterfaceCountRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .onDemandMaxPricePercentageOverLowestPrice(123)
 *                                         .requireHibernateSupport(false)
 *                                         .spotMaxPricePercentageOverLowestPrice(123)
 *                                         .totalLocalStorageGb(TotalLocalStorageGBRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .vCpuCount(VCpuCountRequestProperty.builder()
 *                                                 .max(123)
 *                                                 .min(123)
 *                                                 .build())
 *                                         .build())
 *                                 .instanceType("instanceType")
 *                                 .launchTemplateSpecification(LaunchTemplateSpecificationProperty.builder()
 *                                         .version("version")
 *                                         // the properties below are optional
 *                                         .launchTemplateId("launchTemplateId")
 *                                         .launchTemplateName("launchTemplateName")
 *                                         .build())
 *                                 .weightedCapacity("weightedCapacity")
 *                                 .build()))
 *                         .build())
 *                 // the properties below are optional
 *                 .instancesDistribution(InstancesDistributionProperty.builder()
 *                         .onDemandAllocationStrategy("onDemandAllocationStrategy")
 *                         .onDemandBaseCapacity(123)
 *                         .onDemandPercentageAboveBaseCapacity(123)
 *                         .spotAllocationStrategy("spotAllocationStrategy")
 *                         .spotInstancePools(123)
 *                         .spotMaxPrice("spotMaxPrice")
 *                         .build())
 *                 .build())
 *         .newInstancesProtectedFromScaleIn(false)
 *         .notificationConfigurations(List.of(NotificationConfigurationProperty.builder()
 *                 .topicArn("topicArn")
 *                 // the properties below are optional
 *                 .notificationTypes(List.of("notificationTypes"))
 *                 .build()))
 *         .placementGroup("placementGroup")
 *         .serviceLinkedRoleArn("serviceLinkedRoleArn")
 *         .tags(List.of(TagPropertyProperty.builder()
 *                 .key("key")
 *                 .propagateAtLaunch(false)
 *                 .value("value")
 *                 .build()))
 *         .targetGroupArns(List.of("targetGroupArns"))
 *         .terminationPolicies(List.of("terminationPolicies"))
 *         .vpcZoneIdentifier(List.of("vpcZoneIdentifier"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.926Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnAutoScalingGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutoScalingGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The maximum size of the group.
     * <p>
     * <blockquote>
     * <p>
     * With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMaxSize();

    /**
     * The minimum size of the group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMinSize();

    /**
     * The name of the Auto Scaling group.
     * <p>
     * This name must be unique per Region per account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingGroupName() {
        return null;
    }

    /**
     * A list of Availability Zones where instances in the Auto Scaling group can be created.
     * <p>
     * You must specify one of the following properties: <code>VPCZoneIdentifier</code> or <code>AvailabilityZones</code> . If your account supports EC2-Classic and VPC, this property is required to create an Auto Scaling group that launches instances into EC2-Classic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return null;
    }

    /**
     * Indicates whether Capacity Rebalancing is enabled.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCapacityRebalance() {
        return null;
    }

    /**
     * Reserved.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContext() {
        return null;
    }

    /**
     * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
     * <p>
     * The default value is <code>300</code> . This setting applies when using simple scaling policies, but not when using other scaling policies or scheduled scaling. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCooldown() {
        return null;
    }

    /**
     * The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain.
     * <p>
     * It can scale beyond this capacity if you configure automatic scaling.
     * <p>
     * The number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity when creating the stack, the default is the minimum size of the group.
     * <p>
     * CloudFormation marks the Auto Scaling group as successful (by setting its status to CREATE_COMPLETE) when the desired capacity is reached. However, if a maximum Spot price is set in the launch template or launch configuration that you specified, then desired capacity is not used as a criteria for success. Whether your request is fulfilled depends on Spot Instance capacity and your maximum price.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDesiredCapacity() {
        return null;
    }

    /**
     * The unit of measurement for the value specified for desired capacity.
     * <p>
     * Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * By default, Amazon EC2 Auto Scaling specifies <code>units</code> , which translates into number of instances.
     * <p>
     * Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDesiredCapacityType() {
        return null;
    }

    /**
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check.
     * <p>
     * The default value is <code>0</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * If you are adding an <code>ELB</code> health check, you must specify this property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHealthCheckGracePeriod() {
        return null;
    }

    /**
     * The service to use for the health checks.
     * <p>
     * The valid values are <code>EC2</code> (default) and <code>ELB</code> . If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHealthCheckType() {
        return null;
    }

    /**
     * The ID of the instance used to base the launch configuration on.
     * <p>
     * If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto Scaling group using an EC2 instance</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * To get the instance ID, use the EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> API operation.
     * <p>
     * If you specify <code>LaunchTemplate</code> , <code>MixedInstancesPolicy</code> , or <code>LaunchConfigurationName</code> , don't specify <code>InstanceId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return null;
    }

    /**
     * The name of the [launch configuration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html) to use to launch instances.
     * <p>
     * If you specify <code>LaunchTemplate</code> , <code>MixedInstancesPolicy</code> , or <code>InstanceId</code> , don't specify <code>LaunchConfigurationName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLaunchConfigurationName() {
        return null;
    }

    /**
     * Properties used to specify the [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) and version to use to launch instances. You can alternatively associate a launch template to the Auto Scaling group by specifying a `MixedInstancesPolicy` .
     * <p>
     * If you omit this property, you must specify <code>MixedInstancesPolicy</code> , <code>LaunchConfigurationName</code> , or <code>InstanceId</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchTemplate() {
        return null;
    }

    /**
     * One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLifecycleHookSpecificationList() {
        return null;
    }

    /**
     * A list of Classic Load Balancers associated with this Auto Scaling group.
     * <p>
     * For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLoadBalancerNames() {
        return null;
    }

    /**
     * The maximum amount of time, in seconds, that an instance can be in service.
     * <p>
     * The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxInstanceLifetime() {
        return null;
    }

    /**
     * Enables the monitoring of group metrics of an Auto Scaling group.
     * <p>
     * By default, these metrics are disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetricsCollection() {
        return null;
    }

    /**
     * An embedded object that specifies a mixed instances policy.
     * <p>
     * The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances (optional), and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * If you specify <code>LaunchTemplate</code> , <code>InstanceId</code> , or <code>LaunchConfigurationName</code> , don't specify <code>MixedInstancesPolicy</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMixedInstancesPolicy() {
        return null;
    }

    /**
     * Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
     * <p>
     * For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNewInstancesProtectedFromScaleIn() {
        return null;
    }

    /**
     * Configures an Auto Scaling group to send notifications when specified events take place.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotificationConfigurations() {
        return null;
    }

    /**
     * The name of the placement group into which you want to launch your instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
     * <p>
     * <blockquote>
     * <p>
     * A <em>cluster</em> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlacementGroup() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS services on your behalf.
     * <p>
     * By default, Amazon EC2 Auto Scaling uses a service-linked role named <code>AWSServiceRoleForAutoScaling</code> , which it creates if it does not exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceLinkedRoleArn() {
        return null;
    }

    /**
     * One or more tags.
     * <p>
     * You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.TagPropertyProperty> getTags() {
        return null;
    }

    /**
     * One or more Amazon Resource Names (ARN) of load balancer target groups to associate with the Auto Scaling group.
     * <p>
     * Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTargetGroupArns() {
        return null;
    }

    /**
     * A policy or a list of policies that are used to select the instances to terminate.
     * <p>
     * The policies are executed in the order that you list them. The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code> , <code>OldestLaunchConfiguration</code> , <code>NewestInstance</code> , <code>ClosestToNextInstanceHour</code> , <code>Default</code> , <code>OldestLaunchTemplate</code> , and <code>AllocationStrategy</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTerminationPolicies() {
        return null;
    }

    /**
     * A list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created.
     * <p>
     * If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code> , the subnets that you specify for this property must reside in those Availability Zones.
     * <p>
     * If this resource specifies public subnets and is also in a VPC that is defined in the same stack template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn attribute</a> to declare a dependency on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html">VPC-gateway attachment</a> .
     * <p>
     * <blockquote>
     * <p>
     * When you update <code>VPCZoneIdentifier</code> , this retains the same Auto Scaling group and replaces old instances with new ones, according to the specified subnets. You can optionally specify how CloudFormation handles these updates by using an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html">UpdatePolicy attribute</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcZoneIdentifier() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAutoScalingGroupProps> {
        java.lang.String maxSize;
        java.lang.String minSize;
        java.lang.String autoScalingGroupName;
        java.util.List<java.lang.String> availabilityZones;
        java.lang.Object capacityRebalance;
        java.lang.String context;
        java.lang.String cooldown;
        java.lang.String desiredCapacity;
        java.lang.String desiredCapacityType;
        java.lang.Number healthCheckGracePeriod;
        java.lang.String healthCheckType;
        java.lang.String instanceId;
        java.lang.String launchConfigurationName;
        java.lang.Object launchTemplate;
        java.lang.Object lifecycleHookSpecificationList;
        java.util.List<java.lang.String> loadBalancerNames;
        java.lang.Number maxInstanceLifetime;
        java.lang.Object metricsCollection;
        java.lang.Object mixedInstancesPolicy;
        java.lang.Object newInstancesProtectedFromScaleIn;
        java.lang.Object notificationConfigurations;
        java.lang.String placementGroup;
        java.lang.String serviceLinkedRoleArn;
        java.util.List<software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.TagPropertyProperty> tags;
        java.util.List<java.lang.String> targetGroupArns;
        java.util.List<java.lang.String> terminationPolicies;
        java.util.List<java.lang.String> vpcZoneIdentifier;

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getMaxSize}
         * @param maxSize The maximum size of the group. This parameter is required.
         *                <blockquote>
         *                <p>
         *                With a mixed instances policy that uses instance weighting, Amazon EC2 Auto Scaling may need to go above <code>MaxSize</code> to meet your capacity requirements. In this event, Amazon EC2 Auto Scaling will never go above <code>MaxSize</code> by more than your largest instance weight (weights that define how many units each instance contributes to the desired capacity of the group).
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(java.lang.String maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getMinSize}
         * @param minSize The minimum size of the group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(java.lang.String minSize) {
            this.minSize = minSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getAutoScalingGroupName}
         * @param autoScalingGroupName The name of the Auto Scaling group.
         *                             This name must be unique per Region per account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getAvailabilityZones}
         * @param availabilityZones A list of Availability Zones where instances in the Auto Scaling group can be created.
         *                          You must specify one of the following properties: <code>VPCZoneIdentifier</code> or <code>AvailabilityZones</code> . If your account supports EC2-Classic and VPC, this property is required to create an Auto Scaling group that launches instances into EC2-Classic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getCapacityRebalance}
         * @param capacityRebalance Indicates whether Capacity Rebalancing is enabled.
         *                          For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityRebalance(java.lang.Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getCapacityRebalance}
         * @param capacityRebalance Indicates whether Capacity Rebalancing is enabled.
         *                          For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-capacity-rebalancing.html">Amazon EC2 Auto Scaling Capacity Rebalancing</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityRebalance(software.amazon.awscdk.IResolvable capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getContext}
         * @param context Reserved.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(java.lang.String context) {
            this.context = context;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getCooldown}
         * @param cooldown The amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
         *                 The default value is <code>300</code> . This setting applies when using simple scaling policies, but not when using other scaling policies or scheduled scaling. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(java.lang.String cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getDesiredCapacity}
         * @param desiredCapacity The desired capacity is the initial capacity of the Auto Scaling group at the time of its creation and the capacity it attempts to maintain.
         *                        It can scale beyond this capacity if you configure automatic scaling.
         *                        <p>
         *                        The number must be greater than or equal to the minimum size of the group and less than or equal to the maximum size of the group. If you do not specify a desired capacity when creating the stack, the default is the minimum size of the group.
         *                        <p>
         *                        CloudFormation marks the Auto Scaling group as successful (by setting its status to CREATE_COMPLETE) when the desired capacity is reached. However, if a maximum Spot price is set in the launch template or launch configuration that you specified, then desired capacity is not used as a criteria for success. Whether your request is fulfilled depends on Spot Instance capacity and your maximum price.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(java.lang.String desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getDesiredCapacityType}
         * @param desiredCapacityType The unit of measurement for the value specified for desired capacity.
         *                            Amazon EC2 Auto Scaling supports <code>DesiredCapacityType</code> for attribute-based instance type selection only. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html">Creating an Auto Scaling group using attribute-based instance type selection</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                            <p>
         *                            By default, Amazon EC2 Auto Scaling specifies <code>units</code> , which translates into number of instances.
         *                            <p>
         *                            Valid values: <code>units</code> | <code>vcpu</code> | <code>memory-mib</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacityType(java.lang.String desiredCapacityType) {
            this.desiredCapacityType = desiredCapacityType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getHealthCheckGracePeriod}
         * @param healthCheckGracePeriod The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check.
         *                               The default value is <code>0</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                               <p>
         *                               If you are adding an <code>ELB</code> health check, you must specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriod(java.lang.Number healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getHealthCheckType}
         * @param healthCheckType The service to use for the health checks.
         *                        The valid values are <code>EC2</code> (default) and <code>ELB</code> . If you configure an Auto Scaling group to use load balancer (ELB) health checks, it considers the instance unhealthy if it fails either the EC2 status checks or the load balancer health checks. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html">Health checks for Auto Scaling instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckType(java.lang.String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getInstanceId}
         * @param instanceId The ID of the instance used to base the launch configuration on.
         *                   If specified, Amazon EC2 Auto Scaling uses the configuration values from the specified instance to create a new launch configuration. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-from-instance.html">Creating an Auto Scaling group using an EC2 instance</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                   <p>
         *                   To get the instance ID, use the EC2 <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> API operation.
         *                   <p>
         *                   If you specify <code>LaunchTemplate</code> , <code>MixedInstancesPolicy</code> , or <code>LaunchConfigurationName</code> , don't specify <code>InstanceId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getLaunchConfigurationName}
         * @param launchConfigurationName The name of the [launch configuration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html) to use to launch instances.
         *                                If you specify <code>LaunchTemplate</code> , <code>MixedInstancesPolicy</code> , or <code>InstanceId</code> , don't specify <code>LaunchConfigurationName</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchConfigurationName(java.lang.String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getLaunchTemplate}
         * @param launchTemplate Properties used to specify the [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) and version to use to launch instances. You can alternatively associate a launch template to the Auto Scaling group by specifying a `MixedInstancesPolicy` .
         *                       If you omit this property, you must specify <code>MixedInstancesPolicy</code> , <code>LaunchConfigurationName</code> , or <code>InstanceId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.LaunchTemplateSpecificationProperty launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getLaunchTemplate}
         * @param launchTemplate Properties used to specify the [launch template](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-launchtemplate.html) and version to use to launch instances. You can alternatively associate a launch template to the Auto Scaling group by specifying a `MixedInstancesPolicy` .
         *                       If you omit this property, you must specify <code>MixedInstancesPolicy</code> , <code>LaunchConfigurationName</code> , or <code>InstanceId</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.IResolvable launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getLifecycleHookSpecificationList}
         * @param lifecycleHookSpecificationList One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleHookSpecificationList(software.amazon.awscdk.IResolvable lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = lifecycleHookSpecificationList;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getLifecycleHookSpecificationList}
         * @param lifecycleHookSpecificationList One or more lifecycle hooks for the group, which specify actions to perform when Amazon EC2 Auto Scaling launches or terminates instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleHookSpecificationList(java.util.List<? extends java.lang.Object> lifecycleHookSpecificationList) {
            this.lifecycleHookSpecificationList = lifecycleHookSpecificationList;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getLoadBalancerNames}
         * @param loadBalancerNames A list of Classic Load Balancers associated with this Auto Scaling group.
         *                          For Application Load Balancers, Network Load Balancers, and Gateway Load Balancers, specify the <code>TargetGroupARNs</code> property instead.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerNames(java.util.List<java.lang.String> loadBalancerNames) {
            this.loadBalancerNames = loadBalancerNames;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getMaxInstanceLifetime}
         * @param maxInstanceLifetime The maximum amount of time, in seconds, that an instance can be in service.
         *                            The default is null. If specified, the value must be either 0 or a number equal to or greater than 86,400 seconds (1 day). For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html">Replacing Auto Scaling instances based on maximum instance lifetime</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInstanceLifetime(java.lang.Number maxInstanceLifetime) {
            this.maxInstanceLifetime = maxInstanceLifetime;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getMetricsCollection}
         * @param metricsCollection Enables the monitoring of group metrics of an Auto Scaling group.
         *                          By default, these metrics are disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsCollection(software.amazon.awscdk.IResolvable metricsCollection) {
            this.metricsCollection = metricsCollection;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getMetricsCollection}
         * @param metricsCollection Enables the monitoring of group metrics of an Auto Scaling group.
         *                          By default, these metrics are disabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsCollection(java.util.List<? extends java.lang.Object> metricsCollection) {
            this.metricsCollection = metricsCollection;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getMixedInstancesPolicy}
         * @param mixedInstancesPolicy An embedded object that specifies a mixed instances policy.
         *                             The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances (optional), and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types.
         *                             <p>
         *                             For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                             <p>
         *                             If you specify <code>LaunchTemplate</code> , <code>InstanceId</code> , or <code>LaunchConfigurationName</code> , don't specify <code>MixedInstancesPolicy</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mixedInstancesPolicy(software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.MixedInstancesPolicyProperty mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getMixedInstancesPolicy}
         * @param mixedInstancesPolicy An embedded object that specifies a mixed instances policy.
         *                             The policy includes properties that not only define the distribution of On-Demand Instances and Spot Instances, the maximum price to pay for Spot Instances (optional), and how the Auto Scaling group allocates instance types to fulfill On-Demand and Spot capacities, but also the properties that specify the instance configuration information—the launch template and instance types. The policy can also include a weight for each instance type and different launch templates for individual instance types.
         *                             <p>
         *                             For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html">Auto Scaling groups with multiple instance types and purchase options</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                             <p>
         *                             If you specify <code>LaunchTemplate</code> , <code>InstanceId</code> , or <code>LaunchConfigurationName</code> , don't specify <code>MixedInstancesPolicy</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mixedInstancesPolicy(software.amazon.awscdk.IResolvable mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getNewInstancesProtectedFromScaleIn}
         * @param newInstancesProtectedFromScaleIn Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
         *                                         For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newInstancesProtectedFromScaleIn(java.lang.Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getNewInstancesProtectedFromScaleIn}
         * @param newInstancesProtectedFromScaleIn Indicates whether newly launched instances are protected from termination by Amazon EC2 Auto Scaling when scaling in.
         *                                         For more information about preventing instances from terminating on scale in, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection">Instance Protection</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newInstancesProtectedFromScaleIn(software.amazon.awscdk.IResolvable newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getNotificationConfigurations}
         * @param notificationConfigurations Configures an Auto Scaling group to send notifications when specified events take place.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfigurations(software.amazon.awscdk.IResolvable notificationConfigurations) {
            this.notificationConfigurations = notificationConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getNotificationConfigurations}
         * @param notificationConfigurations Configures an Auto Scaling group to send notifications when specified events take place.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfigurations(java.util.List<? extends java.lang.Object> notificationConfigurations) {
            this.notificationConfigurations = notificationConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getPlacementGroup}
         * @param placementGroup The name of the placement group into which you want to launch your instances.
         *                       For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement groups</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       A <em>cluster</em> placement group is a logical grouping of instances within a single Availability Zone. You cannot specify multiple Availability Zones and a cluster placement group.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroup(java.lang.String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getServiceLinkedRoleArn}
         * @param serviceLinkedRoleArn The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling group uses to call other AWS services on your behalf.
         *                             By default, Amazon EC2 Auto Scaling uses a service-linked role named <code>AWSServiceRoleForAutoScaling</code> , which it creates if it does not exist. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html">Service-linked roles for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceLinkedRoleArn(java.lang.String serviceLinkedRoleArn) {
            this.serviceLinkedRoleArn = serviceLinkedRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getTags}
         * @param tags One or more tags.
         *             You can tag your Auto Scaling group and propagate the tags to the Amazon EC2 instances it launches. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html">Tagging Auto Scaling groups and instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.TagPropertyProperty> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.TagPropertyProperty>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getTargetGroupArns}
         * @param targetGroupArns One or more Amazon Resource Names (ARN) of load balancer target groups to associate with the Auto Scaling group.
         *                        Instances are registered as targets in a target group, and traffic is routed to the target group. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html">Elastic Load Balancing and Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetGroupArns(java.util.List<java.lang.String> targetGroupArns) {
            this.targetGroupArns = targetGroupArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getTerminationPolicies}
         * @param terminationPolicies A policy or a list of policies that are used to select the instances to terminate.
         *                            The policies are executed in the order that you list them. The termination policies supported by Amazon EC2 Auto Scaling: <code>OldestInstance</code> , <code>OldestLaunchConfiguration</code> , <code>NewestInstance</code> , <code>ClosestToNextInstanceHour</code> , <code>Default</code> , <code>OldestLaunchTemplate</code> , and <code>AllocationStrategy</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html">Controlling which Auto Scaling instances terminate during scale in</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminationPolicies(java.util.List<java.lang.String> terminationPolicies) {
            this.terminationPolicies = terminationPolicies;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutoScalingGroupProps#getVpcZoneIdentifier}
         * @param vpcZoneIdentifier A list of subnet IDs for a virtual private cloud (VPC) where instances in the Auto Scaling group can be created.
         *                          If you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code> , the subnets that you specify for this property must reside in those Availability Zones.
         *                          <p>
         *                          If this resource specifies public subnets and is also in a VPC that is defined in the same stack template, you must use the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn attribute</a> to declare a dependency on the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpc-gateway-attachment.html">VPC-gateway attachment</a> .
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          When you update <code>VPCZoneIdentifier</code> , this retains the same Auto Scaling group and replaces old instances with new ones, according to the specified subnets. You can optionally specify how CloudFormation handles these updates by using an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html">UpdatePolicy attribute</a> .
         *                          <p>
         *                          </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcZoneIdentifier(java.util.List<java.lang.String> vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutoScalingGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAutoScalingGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAutoScalingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAutoScalingGroupProps {
        private final java.lang.String maxSize;
        private final java.lang.String minSize;
        private final java.lang.String autoScalingGroupName;
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Object capacityRebalance;
        private final java.lang.String context;
        private final java.lang.String cooldown;
        private final java.lang.String desiredCapacity;
        private final java.lang.String desiredCapacityType;
        private final java.lang.Number healthCheckGracePeriod;
        private final java.lang.String healthCheckType;
        private final java.lang.String instanceId;
        private final java.lang.String launchConfigurationName;
        private final java.lang.Object launchTemplate;
        private final java.lang.Object lifecycleHookSpecificationList;
        private final java.util.List<java.lang.String> loadBalancerNames;
        private final java.lang.Number maxInstanceLifetime;
        private final java.lang.Object metricsCollection;
        private final java.lang.Object mixedInstancesPolicy;
        private final java.lang.Object newInstancesProtectedFromScaleIn;
        private final java.lang.Object notificationConfigurations;
        private final java.lang.String placementGroup;
        private final java.lang.String serviceLinkedRoleArn;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.TagPropertyProperty> tags;
        private final java.util.List<java.lang.String> targetGroupArns;
        private final java.util.List<java.lang.String> terminationPolicies;
        private final java.util.List<java.lang.String> vpcZoneIdentifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxSize = software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoScalingGroupName = software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.capacityRebalance = software.amazon.jsii.Kernel.get(this, "capacityRebalance", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.context = software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.desiredCapacity = software.amazon.jsii.Kernel.get(this, "desiredCapacity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.desiredCapacityType = software.amazon.jsii.Kernel.get(this, "desiredCapacityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.healthCheckGracePeriod = software.amazon.jsii.Kernel.get(this, "healthCheckGracePeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.healthCheckType = software.amazon.jsii.Kernel.get(this, "healthCheckType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.launchConfigurationName = software.amazon.jsii.Kernel.get(this, "launchConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lifecycleHookSpecificationList = software.amazon.jsii.Kernel.get(this, "lifecycleHookSpecificationList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loadBalancerNames = software.amazon.jsii.Kernel.get(this, "loadBalancerNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maxInstanceLifetime = software.amazon.jsii.Kernel.get(this, "maxInstanceLifetime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricsCollection = software.amazon.jsii.Kernel.get(this, "metricsCollection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.mixedInstancesPolicy = software.amazon.jsii.Kernel.get(this, "mixedInstancesPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.newInstancesProtectedFromScaleIn = software.amazon.jsii.Kernel.get(this, "newInstancesProtectedFromScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notificationConfigurations = software.amazon.jsii.Kernel.get(this, "notificationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.placementGroup = software.amazon.jsii.Kernel.get(this, "placementGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serviceLinkedRoleArn = software.amazon.jsii.Kernel.get(this, "serviceLinkedRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.TagPropertyProperty.class)));
            this.targetGroupArns = software.amazon.jsii.Kernel.get(this, "targetGroupArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.terminationPolicies = software.amazon.jsii.Kernel.get(this, "terminationPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.vpcZoneIdentifier = software.amazon.jsii.Kernel.get(this, "vpcZoneIdentifier", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxSize = java.util.Objects.requireNonNull(builder.maxSize, "maxSize is required");
            this.minSize = java.util.Objects.requireNonNull(builder.minSize, "minSize is required");
            this.autoScalingGroupName = builder.autoScalingGroupName;
            this.availabilityZones = builder.availabilityZones;
            this.capacityRebalance = builder.capacityRebalance;
            this.context = builder.context;
            this.cooldown = builder.cooldown;
            this.desiredCapacity = builder.desiredCapacity;
            this.desiredCapacityType = builder.desiredCapacityType;
            this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
            this.healthCheckType = builder.healthCheckType;
            this.instanceId = builder.instanceId;
            this.launchConfigurationName = builder.launchConfigurationName;
            this.launchTemplate = builder.launchTemplate;
            this.lifecycleHookSpecificationList = builder.lifecycleHookSpecificationList;
            this.loadBalancerNames = builder.loadBalancerNames;
            this.maxInstanceLifetime = builder.maxInstanceLifetime;
            this.metricsCollection = builder.metricsCollection;
            this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
            this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
            this.notificationConfigurations = builder.notificationConfigurations;
            this.placementGroup = builder.placementGroup;
            this.serviceLinkedRoleArn = builder.serviceLinkedRoleArn;
            this.tags = (java.util.List<software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.TagPropertyProperty>)builder.tags;
            this.targetGroupArns = builder.targetGroupArns;
            this.terminationPolicies = builder.terminationPolicies;
            this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        }

        @Override
        public final java.lang.String getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final java.lang.String getMinSize() {
            return this.minSize;
        }

        @Override
        public final java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.Object getCapacityRebalance() {
            return this.capacityRebalance;
        }

        @Override
        public final java.lang.String getContext() {
            return this.context;
        }

        @Override
        public final java.lang.String getCooldown() {
            return this.cooldown;
        }

        @Override
        public final java.lang.String getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final java.lang.String getDesiredCapacityType() {
            return this.desiredCapacityType;
        }

        @Override
        public final java.lang.Number getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final java.lang.String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final java.lang.String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final java.lang.Object getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public final java.lang.Object getLifecycleHookSpecificationList() {
            return this.lifecycleHookSpecificationList;
        }

        @Override
        public final java.util.List<java.lang.String> getLoadBalancerNames() {
            return this.loadBalancerNames;
        }

        @Override
        public final java.lang.Number getMaxInstanceLifetime() {
            return this.maxInstanceLifetime;
        }

        @Override
        public final java.lang.Object getMetricsCollection() {
            return this.metricsCollection;
        }

        @Override
        public final java.lang.Object getMixedInstancesPolicy() {
            return this.mixedInstancesPolicy;
        }

        @Override
        public final java.lang.Object getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final java.lang.Object getNotificationConfigurations() {
            return this.notificationConfigurations;
        }

        @Override
        public final java.lang.String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final java.lang.String getServiceLinkedRoleArn() {
            return this.serviceLinkedRoleArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.CfnAutoScalingGroup.TagPropertyProperty> getTags() {
            return this.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getTargetGroupArns() {
            return this.targetGroupArns;
        }

        @Override
        public final java.util.List<java.lang.String> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final java.util.List<java.lang.String> getVpcZoneIdentifier() {
            return this.vpcZoneIdentifier;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxSize", om.valueToTree(this.getMaxSize()));
            data.set("minSize", om.valueToTree(this.getMinSize()));
            if (this.getAutoScalingGroupName() != null) {
                data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            }
            if (this.getAvailabilityZones() != null) {
                data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            }
            if (this.getCapacityRebalance() != null) {
                data.set("capacityRebalance", om.valueToTree(this.getCapacityRebalance()));
            }
            if (this.getContext() != null) {
                data.set("context", om.valueToTree(this.getContext()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getDesiredCapacity() != null) {
                data.set("desiredCapacity", om.valueToTree(this.getDesiredCapacity()));
            }
            if (this.getDesiredCapacityType() != null) {
                data.set("desiredCapacityType", om.valueToTree(this.getDesiredCapacityType()));
            }
            if (this.getHealthCheckGracePeriod() != null) {
                data.set("healthCheckGracePeriod", om.valueToTree(this.getHealthCheckGracePeriod()));
            }
            if (this.getHealthCheckType() != null) {
                data.set("healthCheckType", om.valueToTree(this.getHealthCheckType()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getLaunchConfigurationName() != null) {
                data.set("launchConfigurationName", om.valueToTree(this.getLaunchConfigurationName()));
            }
            if (this.getLaunchTemplate() != null) {
                data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            }
            if (this.getLifecycleHookSpecificationList() != null) {
                data.set("lifecycleHookSpecificationList", om.valueToTree(this.getLifecycleHookSpecificationList()));
            }
            if (this.getLoadBalancerNames() != null) {
                data.set("loadBalancerNames", om.valueToTree(this.getLoadBalancerNames()));
            }
            if (this.getMaxInstanceLifetime() != null) {
                data.set("maxInstanceLifetime", om.valueToTree(this.getMaxInstanceLifetime()));
            }
            if (this.getMetricsCollection() != null) {
                data.set("metricsCollection", om.valueToTree(this.getMetricsCollection()));
            }
            if (this.getMixedInstancesPolicy() != null) {
                data.set("mixedInstancesPolicy", om.valueToTree(this.getMixedInstancesPolicy()));
            }
            if (this.getNewInstancesProtectedFromScaleIn() != null) {
                data.set("newInstancesProtectedFromScaleIn", om.valueToTree(this.getNewInstancesProtectedFromScaleIn()));
            }
            if (this.getNotificationConfigurations() != null) {
                data.set("notificationConfigurations", om.valueToTree(this.getNotificationConfigurations()));
            }
            if (this.getPlacementGroup() != null) {
                data.set("placementGroup", om.valueToTree(this.getPlacementGroup()));
            }
            if (this.getServiceLinkedRoleArn() != null) {
                data.set("serviceLinkedRoleArn", om.valueToTree(this.getServiceLinkedRoleArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTargetGroupArns() != null) {
                data.set("targetGroupArns", om.valueToTree(this.getTargetGroupArns()));
            }
            if (this.getTerminationPolicies() != null) {
                data.set("terminationPolicies", om.valueToTree(this.getTerminationPolicies()));
            }
            if (this.getVpcZoneIdentifier() != null) {
                data.set("vpcZoneIdentifier", om.valueToTree(this.getVpcZoneIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnAutoScalingGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAutoScalingGroupProps.Jsii$Proxy that = (CfnAutoScalingGroupProps.Jsii$Proxy) o;

            if (!maxSize.equals(that.maxSize)) return false;
            if (!minSize.equals(that.minSize)) return false;
            if (this.autoScalingGroupName != null ? !this.autoScalingGroupName.equals(that.autoScalingGroupName) : that.autoScalingGroupName != null) return false;
            if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
            if (this.capacityRebalance != null ? !this.capacityRebalance.equals(that.capacityRebalance) : that.capacityRebalance != null) return false;
            if (this.context != null ? !this.context.equals(that.context) : that.context != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.desiredCapacity != null ? !this.desiredCapacity.equals(that.desiredCapacity) : that.desiredCapacity != null) return false;
            if (this.desiredCapacityType != null ? !this.desiredCapacityType.equals(that.desiredCapacityType) : that.desiredCapacityType != null) return false;
            if (this.healthCheckGracePeriod != null ? !this.healthCheckGracePeriod.equals(that.healthCheckGracePeriod) : that.healthCheckGracePeriod != null) return false;
            if (this.healthCheckType != null ? !this.healthCheckType.equals(that.healthCheckType) : that.healthCheckType != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            if (this.launchConfigurationName != null ? !this.launchConfigurationName.equals(that.launchConfigurationName) : that.launchConfigurationName != null) return false;
            if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
            if (this.lifecycleHookSpecificationList != null ? !this.lifecycleHookSpecificationList.equals(that.lifecycleHookSpecificationList) : that.lifecycleHookSpecificationList != null) return false;
            if (this.loadBalancerNames != null ? !this.loadBalancerNames.equals(that.loadBalancerNames) : that.loadBalancerNames != null) return false;
            if (this.maxInstanceLifetime != null ? !this.maxInstanceLifetime.equals(that.maxInstanceLifetime) : that.maxInstanceLifetime != null) return false;
            if (this.metricsCollection != null ? !this.metricsCollection.equals(that.metricsCollection) : that.metricsCollection != null) return false;
            if (this.mixedInstancesPolicy != null ? !this.mixedInstancesPolicy.equals(that.mixedInstancesPolicy) : that.mixedInstancesPolicy != null) return false;
            if (this.newInstancesProtectedFromScaleIn != null ? !this.newInstancesProtectedFromScaleIn.equals(that.newInstancesProtectedFromScaleIn) : that.newInstancesProtectedFromScaleIn != null) return false;
            if (this.notificationConfigurations != null ? !this.notificationConfigurations.equals(that.notificationConfigurations) : that.notificationConfigurations != null) return false;
            if (this.placementGroup != null ? !this.placementGroup.equals(that.placementGroup) : that.placementGroup != null) return false;
            if (this.serviceLinkedRoleArn != null ? !this.serviceLinkedRoleArn.equals(that.serviceLinkedRoleArn) : that.serviceLinkedRoleArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.targetGroupArns != null ? !this.targetGroupArns.equals(that.targetGroupArns) : that.targetGroupArns != null) return false;
            if (this.terminationPolicies != null ? !this.terminationPolicies.equals(that.terminationPolicies) : that.terminationPolicies != null) return false;
            return this.vpcZoneIdentifier != null ? this.vpcZoneIdentifier.equals(that.vpcZoneIdentifier) : that.vpcZoneIdentifier == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxSize.hashCode();
            result = 31 * result + (this.minSize.hashCode());
            result = 31 * result + (this.autoScalingGroupName != null ? this.autoScalingGroupName.hashCode() : 0);
            result = 31 * result + (this.availabilityZones != null ? this.availabilityZones.hashCode() : 0);
            result = 31 * result + (this.capacityRebalance != null ? this.capacityRebalance.hashCode() : 0);
            result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.desiredCapacity != null ? this.desiredCapacity.hashCode() : 0);
            result = 31 * result + (this.desiredCapacityType != null ? this.desiredCapacityType.hashCode() : 0);
            result = 31 * result + (this.healthCheckGracePeriod != null ? this.healthCheckGracePeriod.hashCode() : 0);
            result = 31 * result + (this.healthCheckType != null ? this.healthCheckType.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.launchConfigurationName != null ? this.launchConfigurationName.hashCode() : 0);
            result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
            result = 31 * result + (this.lifecycleHookSpecificationList != null ? this.lifecycleHookSpecificationList.hashCode() : 0);
            result = 31 * result + (this.loadBalancerNames != null ? this.loadBalancerNames.hashCode() : 0);
            result = 31 * result + (this.maxInstanceLifetime != null ? this.maxInstanceLifetime.hashCode() : 0);
            result = 31 * result + (this.metricsCollection != null ? this.metricsCollection.hashCode() : 0);
            result = 31 * result + (this.mixedInstancesPolicy != null ? this.mixedInstancesPolicy.hashCode() : 0);
            result = 31 * result + (this.newInstancesProtectedFromScaleIn != null ? this.newInstancesProtectedFromScaleIn.hashCode() : 0);
            result = 31 * result + (this.notificationConfigurations != null ? this.notificationConfigurations.hashCode() : 0);
            result = 31 * result + (this.placementGroup != null ? this.placementGroup.hashCode() : 0);
            result = 31 * result + (this.serviceLinkedRoleArn != null ? this.serviceLinkedRoleArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.targetGroupArns != null ? this.targetGroupArns.hashCode() : 0);
            result = 31 * result + (this.terminationPolicies != null ? this.terminationPolicies.hashCode() : 0);
            result = 31 * result + (this.vpcZoneIdentifier != null ? this.vpcZoneIdentifier.hashCode() : 0);
            return result;
        }
    }
}
